/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.util;

import it.sogei.utilities.log4j.LogUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RCPHandlerUtil {
    ExecutionEvent event;
    IWorkbenchWindow window;
    IWorkbenchPage page;
    String commandName;
    String commandId;

    public RCPHandlerUtil(ExecutionEvent event) {
        this.event = event;
        if (event != null) {
            LogUtil.log((Object)this, (int)1, (String)("commandId:" + this.getCommandId()));
        }
    }

    public static IWorkbenchWindow getWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getPage() {
        return RCPHandlerUtil.getWindow().getActivePage();
    }

    public String getCommandName() {
        try {
            return this.event.getCommand().getName();
        }
        catch (NotDefinedException notDefinedException) {
            return "undefined";
        }
    }

    public String getCommandId() {
        return this.event.getCommand().getId();
    }

    public static String getActivePerspectiveId() {
        return RCPHandlerUtil.getPage().getPerspective().getId();
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static String getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().addTrailingSeparator().toPortableString();
    }

    public static Menu getMenu() {
        return RCPHandlerUtil.getShell().getMenuBar();
    }

    public static MenuItem[] getMenuItems() {
        return RCPHandlerUtil.getMenu().getItems();
    }

    public static IActionBars getActionBars() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        IWorkbenchPartSite site = part.getSite();
        IViewSite vSite = (IViewSite)site;
        IActionBars actionBars = vSite.getActionBars();
        return actionBars;
    }

    public static IStatusLineManager getStatusLineManager() {
        if (RCPHandlerUtil.getActionBars() == null) {
            return null;
        }
        return RCPHandlerUtil.getActionBars().getStatusLineManager();
    }

    public static IAction getActionById(IEditorSite site, String id) {
        IActionBars actionBars = site.getActionBars();
        IContributionItem[] items = actionBars.getToolBarManager().getItems();
        int i = 0;
        while (i < items.length) {
            if (id.equals(items[i].getId())) {
                return ((ActionContributionItem)items[i]).getAction();
            }
            ++i;
        }
        return null;
    }
}

