/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.DoubleProperties;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.db.DatabaseContextImpl;
import org.apache.derby.impl.db.StoreClassFactoryContext;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.io.StorageFile;

public class BasicDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    protected boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    private DataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;

    public boolean canSupport(Properties properties) {
        String string;
        boolean bl = Monitor.isDesiredCreateType(properties, this.getEngineType());
        if (bl && (string = properties.getProperty("replication.slave.mode")) != null && !string.equals("slavepremode")) {
            bl = false;
        }
        return bl;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object;
        ModuleFactory moduleFactory = Monitor.getMonitor();
        if (bl) {
            if (properties.getProperty("derby.__rt.storage.createWithNoLog") == null) {
                properties.put("derby.__rt.storage.createWithNoLog", "true");
            }
            if ((object = properties.getProperty("territory")) == null) {
                object = Locale.getDefault().toString();
            }
            this.databaseLocale = moduleFactory.setLocale(properties, (String)object);
        } else {
            this.databaseLocale = moduleFactory.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.bootValidation(bl, properties);
        object = (DataValueFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.bootStore(bl, properties);
        this.myUUID = this.makeDatabaseID(bl, properties);
        DoubleProperties doubleProperties = new DoubleProperties(this.getAllDatabaseProperties(), properties);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(bl, doubleProperties);
        this.dd = (DataDictionary)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.dictionary.DataDictionary", doubleProperties);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", doubleProperties);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.LanguageFactory", doubleProperties);
        this.bootResourceAdapter(bl, doubleProperties);
        this.authenticationService = this.bootAuthenticationService(bl, doubleProperties);
        if (bl && this.lastToBoot && properties.getProperty("derby.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public int getEngineType() {
        return 2;
    }

    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    public LanguageConnectionContext setupConnection(ContextManager contextManager, String string, String string2, String string3) throws StandardException {
        TransactionController transactionController = this.getConnectionTransaction(contextManager);
        contextManager.setLocaleFinder(this);
        this.pushDbContext(contextManager);
        LanguageConnectionContext languageConnectionContext = this.lcf.newLanguageConnectionContext(contextManager, transactionController, this.lf, this, string, string2, string3);
        this.pushClassFactoryContext(contextManager, this.lcf.getClassFactory());
        ExecutionFactory executionFactory = this.lcf.getExecutionFactory();
        executionFactory.newExecutionContext(contextManager);
        languageConnectionContext.initialize();
        languageConnectionContext.internalCommitNoSync(5);
        return languageConnectionContext;
    }

    public final DataDictionary getDataDictionary() {
        return this.dd;
    }

    public void pushDbContext(ContextManager contextManager) {
        DatabaseContextImpl databaseContextImpl = new DatabaseContextImpl(contextManager, this);
    }

    public AuthenticationService getAuthenticationService() throws StandardException {
        return this.authenticationService;
    }

    public void startReplicationMaster(String string, String string2, int n, String string3) throws SQLException {
        try {
            this.af.startReplicationMaster(string, string2, n, string3);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void stopReplicationMaster() throws SQLException {
        try {
            this.af.stopReplicationMaster();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void stopReplicationSlave() throws SQLException {
        StandardException standardException = StandardException.newException("XRE40");
        throw PublicAPI.wrapStandardException(standardException);
    }

    public boolean isInSlaveMode() {
        return false;
    }

    public void failover(String string) throws StandardException {
        this.af.failover(string);
    }

    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backup(String string, boolean bl) throws SQLException {
        try {
            this.af.backup(string, bl);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backupAndEnableLogArchiveMode(String string, boolean bl, boolean bl2) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(string, bl, bl2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void disableLogArchiveMode(boolean bl) throws SQLException {
        try {
            this.af.disableLogArchiveMode(bl);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public Locale getLocale() {
        return this.databaseLocale;
    }

    public final UUID getId() {
        return this.myUUID;
    }

    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean bl, Properties properties) throws StandardException {
        TransactionController transactionController = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        String string = null;
        UUID uUID = (UUID)transactionController.getProperty("derby.databaseID");
        if (uUID == null) {
            UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
            string = properties.getProperty("derby.databaseID");
            uUID = string == null ? uUIDFactory.createUUID() : uUIDFactory.recreateUUID(string);
            transactionController.setProperty("derby.databaseID", uUID, true);
        }
        if (string != null) {
            properties.remove("derby.databaseID");
        }
        transactionController.commit();
        transactionController.destroy();
        return uUID;
    }

    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("derby.engineType")) {
            throw StandardException.newException("XCY02.S", (Object)string, (Object)serializable);
        }
        if (!string.equals("derby.database.classpath")) {
            return false;
        }
        String string2 = (String)((Object)serializable);
        String[][] stringArray = null;
        if (string2 != null) {
            stringArray = IdUtil.parseDbClassPath(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(stringArray[i][0], null, false);
                FileInfoDescriptor fileInfoDescriptor = null;
                if (schemaDescriptor != null) {
                    fileInfoDescriptor = this.dd.getFileInfoDescriptor(schemaDescriptor, stringArray[i][1]);
                }
                if (fileInfoDescriptor != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(stringArray[i]));
            }
        }
        return true;
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.equals("derby.database.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String string2 = (String)((Object)serializable);
            if (string2 == null) {
                string2 = "";
            }
            this.cfDB.notifyModifyClasspath(string2);
        }
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.database.classpath");
        if (string == null) {
            string = PropertyUtil.getSystemProperty("derby.database.classpath", "");
        }
        return string;
    }

    protected void bootClassFactory(boolean bl, Properties properties) throws StandardException {
        String string = this.getClasspath(properties);
        IdUtil.parseDbClassPath(string);
        properties.put("derby.__rt.database.classpath", string);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.loader.ClassFactory", properties);
    }

    protected TransactionController getConnectionTransaction(ContextManager contextManager) throws StandardException {
        return this.af.getTransaction(contextManager);
    }

    protected AuthenticationService bootAuthenticationService(boolean bl, Properties properties) throws StandardException {
        return (AuthenticationService)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.jdbc.AuthenticationService", properties);
    }

    protected void bootValidation(boolean bl, Properties properties) throws StandardException {
        this.pf = (PropertyFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.property.PropertyFactory", properties);
    }

    protected void bootStore(boolean bl, Properties properties) throws StandardException {
        this.af = (AccessFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.store.access.AccessFactory", properties);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController transactionController = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        Properties properties = transactionController.getProperties();
        transactionController.commit();
        transactionController.destroy();
        return properties;
    }

    protected void bootResourceAdapter(boolean bl, Properties properties) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.jdbc.ResourceAdapter", properties);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager contextManager, ClassFactory classFactory) {
        new StoreClassFactoryContext(contextManager, classFactory, this.af, this);
    }

    public StorageFile getJarFile(String string, String string2) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(string, null, true);
        FileInfoDescriptor fileInfoDescriptor = this.dd.getFileInfoDescriptor(schemaDescriptor, string2);
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", (Object)string2, (Object)string);
        }
        long l = fileInfoDescriptor.getGenerationId();
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        FileResource fileResource = this.af.getTransaction(contextManager).getFileHandler();
        String string3 = JarUtil.mkExternalName(string, string2, fileResource.getSeparatorChar());
        return fileResource.getAsFile(string3, l);
    }
}

