/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Block;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class CatchClause
extends AstNode {
    private Name varName;
    private AstNode catchCondition;
    private Block body;
    private int ifPosition = -1;
    private int lp = -1;
    private int rp = -1;

    public CatchClause() {
        this.type = 124;
    }

    public CatchClause(int n) {
        super(n);
        this.type = 124;
    }

    public CatchClause(int n, int n2) {
        super(n, n2);
        this.type = 124;
    }

    public Name getVarName() {
        return this.varName;
    }

    public void setVarName(Name name) {
        this.assertNotNull(name);
        this.varName = name;
        name.setParent(this);
    }

    public AstNode getCatchCondition() {
        return this.catchCondition;
    }

    public void setCatchCondition(AstNode astNode) {
        this.catchCondition = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block block) {
        this.assertNotNull(block);
        this.body = block;
        block.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    public int getIfPosition() {
        return this.ifPosition;
    }

    public void setIfPosition(int n) {
        this.ifPosition = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("catch (");
        stringBuilder.append(this.varName.toSource(0));
        if (this.catchCondition != null) {
            stringBuilder.append(" if ");
            stringBuilder.append(this.catchCondition.toSource(0));
        }
        stringBuilder.append(") ");
        stringBuilder.append(this.body.toSource(0));
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.varName.visit(nodeVisitor);
            if (this.catchCondition != null) {
                this.catchCondition.visit(nodeVisitor);
            }
            this.body.visit(nodeVisitor);
        }
    }
}

