/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.stream;

import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.x509.RevokedCertificate;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.stream.CRLListener;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class RevokedCertificatesCRLListener
implements CRLListener {
    private byte[][] n;
    private boolean b;
    private byte[] e;
    private AlgorithmID d;
    private X509Extensions m;
    private Hashtable g;
    private boolean l;
    private Date h;
    private Date c;
    private Name o;
    private Name i;
    private AlgorithmID f;
    private int a;
    private Hashtable j;
    private PublicKey k;
    private X509Certificate[] p;

    public void signature(AlgorithmID algorithmID, byte[] byArray, boolean bl) throws CRLException {
        this.d = algorithmID;
        this.e = byArray;
        this.b = bl;
    }

    public void revokedCertificate(byte[] byArray, int n2, int n3, int n4, int n5) throws X509ExtensionException, CRLException {
        try {
            int n6 = 0;
            while (n6 < this.n.length) {
                if (this.n[n6].length == n5 && CryptoUtils.equalsBlock(this.n[n6], 0, byArray, n4, n5)) {
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                    RevokedCertificate revokedCertificate = new RevokedCertificate(DerCoder.decode(byArray2));
                    this.revokedCertificate(revokedCertificate);
                    return;
                }
                ++n6;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new CRLException("CRL entry decoding error: " + codingException);
        }
    }

    public void revokedCertificate(RevokedCertificate revokedCertificate) throws X509ExtensionException, CRLException {
        ASN1Type aSN1Type;
        Object object;
        CertificateIssuer certificateIssuer = (CertificateIssuer)revokedCertificate.getExtension(CertificateIssuer.oid);
        if (certificateIssuer != null) {
            object = null;
            aSN1Type = certificateIssuer.getIssuer();
            Enumeration enumeration = aSN1Type.getNames();
            while (enumeration.hasMoreElements()) {
                GeneralName generalName = (GeneralName)enumeration.nextElement();
                if (generalName.getType() != 4) continue;
                object = (Name)generalName.getName();
                break;
            }
            if (object == null) {
                throw new X509ExtensionException("CertificateIssuer extension does not contain a directoryName.");
            }
            this.o = object;
            this.l = true;
        }
        if ((object = (Hashtable)this.j.get(this.o)) != null && (aSN1Type = (X509Certificate)((Hashtable)object).get(revokedCertificate.getSerialNumber())) != null) {
            this.g.put(aSN1Type, revokedCertificate);
        }
    }

    public boolean isVerified() {
        return this.b;
    }

    public boolean isIndirect() {
        return this.l;
    }

    public void header(int n2, Name name, Date date, Date date2) {
        this.a = n2;
        this.o = this.i = name;
        this.c = date;
        this.h = date2;
    }

    public int getVersion() {
        return this.a;
    }

    public Date getThisUpdate() {
        return this.c;
    }

    public byte[] getSignatureValue() {
        return this.e;
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.f;
    }

    public Signature getSignature(AlgorithmID algorithmID) throws InvalidKeyException, NoSuchAlgorithmException {
        Signature signature;
        if (this.k != null) {
            signature = algorithmID.getSignatureInstance("IAIK");
            signature.initVerify(this.k);
            this.f = algorithmID;
        } else {
            signature = null;
        }
        return signature;
    }

    public AlgorithmID getSignature() {
        return this.d;
    }

    public Hashtable getRevokedCertificates() {
        return this.g;
    }

    public Date getNextUpdate() {
        return this.h;
    }

    public PublicKey getIssuerKey() {
        return this.k;
    }

    public Name getIssuer() {
        return this.i;
    }

    public X509Extensions getExtensions() {
        return this.m;
    }

    public X509Certificate[] getConsideredCertificates() {
        return this.p;
    }

    public void extensions(X509Extensions x509Extensions) {
        this.m = x509Extensions;
    }

    public RevokedCertificatesCRLListener(X509Certificate[] x509CertificateArray, PublicKey publicKey) {
        this.p = x509CertificateArray;
        this.j = new Hashtable(2);
        this.n = new byte[x509CertificateArray.length][];
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            Name name = (Name)x509CertificateArray[n2].getIssuerDN();
            Hashtable<BigInteger, X509Certificate> hashtable = (Hashtable<BigInteger, X509Certificate>)this.j.get(name);
            if (hashtable == null) {
                hashtable = new Hashtable<BigInteger, X509Certificate>(256);
                this.j.put(name, hashtable);
            }
            BigInteger bigInteger = x509CertificateArray[n2].getSerialNumber();
            hashtable.put(bigInteger, x509CertificateArray[n2]);
            this.n[n2] = bigInteger.toByteArray();
            ++n2;
        }
        this.k = publicKey;
        this.g = new Hashtable();
    }
}

