/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

abstract class DropAgent {
    protected DnDManager dndManager;

    public DropAgent(DnDManager manager) {
        this.dndManager = manager;
    }

    public void reactivatePart(MUIElement dragElement) {
        IEclipseContext context = this.dndManager.getModelService().getContainingContext(dragElement);
        if (context == null) {
            return;
        }
        EPartService ps = (EPartService)context.get(EPartService.class);
        if (ps == null) {
            return;
        }
        MPart partToActivate = null;
        if (dragElement instanceof MPart) {
            partToActivate = (MPart)dragElement;
        } else if (dragElement instanceof MPlaceholder) {
            MPlaceholder ph = (MPlaceholder)dragElement;
            if (ph.getRef() instanceof MPart) {
                partToActivate = (MPart)ph.getRef();
            }
        } else if (dragElement instanceof MPartStack) {
            MPlaceholder ph;
            MPartStack stack = (MPartStack)dragElement;
            if (stack.getSelectedElement() instanceof MPart) {
                partToActivate = (MPart)stack.getSelectedElement();
            } else if (stack.getSelectedElement() instanceof MPlaceholder && (ph = (MPlaceholder)stack.getSelectedElement()).getRef() instanceof MPart) {
                partToActivate = (MPart)ph.getRef();
            }
        }
        if (partToActivate != null) {
            ps.activate(null);
            ps.activate(partToActivate);
        }
    }

    public abstract boolean canDrop(MUIElement var1, DnDInfo var2);

    public abstract boolean drop(MUIElement var1, DnDInfo var2);

    public abstract boolean track(MUIElement var1, DnDInfo var2);

    public Cursor getCursor(Display display, MUIElement dragElement, DnDInfo info) {
        return display.getSystemCursor(21);
    }

    public Rectangle getRectangle(MUIElement dragElement, DnDInfo info) {
        return null;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
    }
}

