// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/chromeos/uidetection/v1/ui_detection.proto

package uidetection

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for UI detection.
type UiDetectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Required field that represents a PNG image.
	ImagePng []byte `protobuf:"bytes,1,opt,name=image_png,json=imagePng,proto3" json:"image_png,omitempty"`
	// Required. Required field that indicates the detection type.
	Request *DetectionRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
	// Indicates whether to fall back to resizing the image if no elements are
	// detected.
	ResizeImage *bool `protobuf:"varint,3,opt,name=resize_image,json=resizeImage,proto3,oneof" json:"resize_image,omitempty"`
	// Deprecated as of 2023-03-29. Use test_metadata instead.
	//
	// Deprecated: Do not use.
	TestId string `protobuf:"bytes,4,opt,name=test_id,json=testId,proto3" json:"test_id,omitempty"`
	// Optional. Metadata about the client for analytics.
	TestMetadata *TestMetadata `protobuf:"bytes,5,opt,name=test_metadata,json=testMetadata,proto3" json:"test_metadata,omitempty"`
	// Optional. Indicates whether to always start by resizing the image.
	ForceImageResizing bool `protobuf:"varint,6,opt,name=force_image_resizing,json=forceImageResizing,proto3" json:"force_image_resizing,omitempty"`
	// Optional. Indicates whether to respond with the transformed image png.
	ReturnTransformedImage bool `protobuf:"varint,7,opt,name=return_transformed_image,json=returnTransformedImage,proto3" json:"return_transformed_image,omitempty"`
}

func (x *UiDetectionRequest) Reset() {
	*x = UiDetectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UiDetectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UiDetectionRequest) ProtoMessage() {}

func (x *UiDetectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UiDetectionRequest.ProtoReflect.Descriptor instead.
func (*UiDetectionRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{0}
}

func (x *UiDetectionRequest) GetImagePng() []byte {
	if x != nil {
		return x.ImagePng
	}
	return nil
}

func (x *UiDetectionRequest) GetRequest() *DetectionRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *UiDetectionRequest) GetResizeImage() bool {
	if x != nil && x.ResizeImage != nil {
		return *x.ResizeImage
	}
	return false
}

// Deprecated: Do not use.
func (x *UiDetectionRequest) GetTestId() string {
	if x != nil {
		return x.TestId
	}
	return ""
}

func (x *UiDetectionRequest) GetTestMetadata() *TestMetadata {
	if x != nil {
		return x.TestMetadata
	}
	return nil
}

func (x *UiDetectionRequest) GetForceImageResizing() bool {
	if x != nil {
		return x.ForceImageResizing
	}
	return false
}

func (x *UiDetectionRequest) GetReturnTransformedImage() bool {
	if x != nil {
		return x.ReturnTransformedImage
	}
	return false
}

// Detection type specifies what to detect in the image.
type DetectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DetectionRequestType:
	//
	//	*DetectionRequest_WordDetectionRequest
	//	*DetectionRequest_TextBlockDetectionRequest
	//	*DetectionRequest_CustomIconDetectionRequest
	DetectionRequestType isDetectionRequest_DetectionRequestType `protobuf_oneof:"detection_request_type"`
}

func (x *DetectionRequest) Reset() {
	*x = DetectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectionRequest) ProtoMessage() {}

func (x *DetectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectionRequest.ProtoReflect.Descriptor instead.
func (*DetectionRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{1}
}

func (m *DetectionRequest) GetDetectionRequestType() isDetectionRequest_DetectionRequestType {
	if m != nil {
		return m.DetectionRequestType
	}
	return nil
}

func (x *DetectionRequest) GetWordDetectionRequest() *WordDetectionRequest {
	if x, ok := x.GetDetectionRequestType().(*DetectionRequest_WordDetectionRequest); ok {
		return x.WordDetectionRequest
	}
	return nil
}

func (x *DetectionRequest) GetTextBlockDetectionRequest() *TextBlockDetectionRequest {
	if x, ok := x.GetDetectionRequestType().(*DetectionRequest_TextBlockDetectionRequest); ok {
		return x.TextBlockDetectionRequest
	}
	return nil
}

func (x *DetectionRequest) GetCustomIconDetectionRequest() *CustomIconDetectionRequest {
	if x, ok := x.GetDetectionRequestType().(*DetectionRequest_CustomIconDetectionRequest); ok {
		return x.CustomIconDetectionRequest
	}
	return nil
}

type isDetectionRequest_DetectionRequestType interface {
	isDetectionRequest_DetectionRequestType()
}

type DetectionRequest_WordDetectionRequest struct {
	// Detection type for word detection.
	WordDetectionRequest *WordDetectionRequest `protobuf:"bytes,1,opt,name=word_detection_request,json=wordDetectionRequest,proto3,oneof"`
}

type DetectionRequest_TextBlockDetectionRequest struct {
	// Detection type for text block detection.
	TextBlockDetectionRequest *TextBlockDetectionRequest `protobuf:"bytes,2,opt,name=text_block_detection_request,json=textBlockDetectionRequest,proto3,oneof"`
}

type DetectionRequest_CustomIconDetectionRequest struct {
	// Detection type for custom icon detection.
	CustomIconDetectionRequest *CustomIconDetectionRequest `protobuf:"bytes,3,opt,name=custom_icon_detection_request,json=customIconDetectionRequest,proto3,oneof"`
}

func (*DetectionRequest_WordDetectionRequest) isDetectionRequest_DetectionRequestType() {}

func (*DetectionRequest_TextBlockDetectionRequest) isDetectionRequest_DetectionRequestType() {}

func (*DetectionRequest_CustomIconDetectionRequest) isDetectionRequest_DetectionRequestType() {}

// Metadata about the client test and test device.
type TestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the calling test. For example, 'tast.uidetection.BasicDetections'.
	TestId string `protobuf:"bytes,1,opt,name=test_id,json=testId,proto3" json:"test_id,omitempty"`
	// Board name of the ChromeOS device under test. For example, 'volteer'.
	Board string `protobuf:"bytes,2,opt,name=board,proto3" json:"board,omitempty"`
	// Model name of the ChromeOS device under test. For example, 'volet'.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// ChromeOS build of the device under test.
	// For example, 'volteer-release/R110-15275.0.0-75031-8794956681263330561'.
	CrosBuild string `protobuf:"bytes,4,opt,name=cros_build,json=crosBuild,proto3" json:"cros_build,omitempty"`
}

func (x *TestMetadata) Reset() {
	*x = TestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestMetadata) ProtoMessage() {}

func (x *TestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestMetadata.ProtoReflect.Descriptor instead.
func (*TestMetadata) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{2}
}

func (x *TestMetadata) GetTestId() string {
	if x != nil {
		return x.TestId
	}
	return ""
}

func (x *TestMetadata) GetBoard() string {
	if x != nil {
		return x.Board
	}
	return ""
}

func (x *TestMetadata) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TestMetadata) GetCrosBuild() string {
	if x != nil {
		return x.CrosBuild
	}
	return ""
}

// Detection type for word detection.
type WordDetectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The word to locate in the image.
	Word string `protobuf:"bytes,1,opt,name=word,proto3" json:"word,omitempty"`
	// Indicating whether the query string is a regex or not.
	RegexMode bool `protobuf:"varint,2,opt,name=regex_mode,json=regexMode,proto3" json:"regex_mode,omitempty"`
	// Indicating whether the detection is an approximate match.
	DisableApproxMatch bool `protobuf:"varint,3,opt,name=disable_approx_match,json=disableApproxMatch,proto3" json:"disable_approx_match,omitempty"`
	// Levenshtein distance threshold.
	// Applicable only if regex_mode is False.
	MaxEditDistance *int32 `protobuf:"varint,4,opt,name=max_edit_distance,json=maxEditDistance,proto3,oneof" json:"max_edit_distance,omitempty"`
}

func (x *WordDetectionRequest) Reset() {
	*x = WordDetectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WordDetectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordDetectionRequest) ProtoMessage() {}

func (x *WordDetectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordDetectionRequest.ProtoReflect.Descriptor instead.
func (*WordDetectionRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{3}
}

func (x *WordDetectionRequest) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *WordDetectionRequest) GetRegexMode() bool {
	if x != nil {
		return x.RegexMode
	}
	return false
}

func (x *WordDetectionRequest) GetDisableApproxMatch() bool {
	if x != nil {
		return x.DisableApproxMatch
	}
	return false
}

func (x *WordDetectionRequest) GetMaxEditDistance() int32 {
	if x != nil && x.MaxEditDistance != nil {
		return *x.MaxEditDistance
	}
	return 0
}

// Detection type for text block detection.
type TextBlockDetectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text block consisting a list of words to locate in the image.
	Words []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
	// Indicating whether the query string is a regex or not.
	RegexMode bool `protobuf:"varint,2,opt,name=regex_mode,json=regexMode,proto3" json:"regex_mode,omitempty"`
	// Indicating whether the detection is an approximate match.
	DisableApproxMatch bool `protobuf:"varint,3,opt,name=disable_approx_match,json=disableApproxMatch,proto3" json:"disable_approx_match,omitempty"`
	// Levenshtein distance threshold.
	// Applicable only if regex_mode is False.
	MaxEditDistance *int32 `protobuf:"varint,4,opt,name=max_edit_distance,json=maxEditDistance,proto3,oneof" json:"max_edit_distance,omitempty"`
	// Indicating whether the detection result should only contain the specified
	// words.
	SpecifiedWordsOnly bool `protobuf:"varint,5,opt,name=specified_words_only,json=specifiedWordsOnly,proto3" json:"specified_words_only,omitempty"`
}

func (x *TextBlockDetectionRequest) Reset() {
	*x = TextBlockDetectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextBlockDetectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextBlockDetectionRequest) ProtoMessage() {}

func (x *TextBlockDetectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextBlockDetectionRequest.ProtoReflect.Descriptor instead.
func (*TextBlockDetectionRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{4}
}

func (x *TextBlockDetectionRequest) GetWords() []string {
	if x != nil {
		return x.Words
	}
	return nil
}

func (x *TextBlockDetectionRequest) GetRegexMode() bool {
	if x != nil {
		return x.RegexMode
	}
	return false
}

func (x *TextBlockDetectionRequest) GetDisableApproxMatch() bool {
	if x != nil {
		return x.DisableApproxMatch
	}
	return false
}

func (x *TextBlockDetectionRequest) GetMaxEditDistance() int32 {
	if x != nil && x.MaxEditDistance != nil {
		return *x.MaxEditDistance
	}
	return 0
}

func (x *TextBlockDetectionRequest) GetSpecifiedWordsOnly() bool {
	if x != nil {
		return x.SpecifiedWordsOnly
	}
	return false
}

// Detection type for custom icon detection.
type CustomIconDetectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Required field that represents an icon in PNG format.
	IconPng []byte `protobuf:"bytes,1,opt,name=icon_png,json=iconPng,proto3" json:"icon_png,omitempty"`
	// Set match_count to -1 to not limit the number of matches.
	MatchCount int32 `protobuf:"varint,2,opt,name=match_count,json=matchCount,proto3" json:"match_count,omitempty"`
	// Confidence threshold in the range [0.0, 1.0] below which the matches will
	// be considered as non-existent.
	MinConfidenceThreshold float64 `protobuf:"fixed64,3,opt,name=min_confidence_threshold,json=minConfidenceThreshold,proto3" json:"min_confidence_threshold,omitempty"`
}

func (x *CustomIconDetectionRequest) Reset() {
	*x = CustomIconDetectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomIconDetectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomIconDetectionRequest) ProtoMessage() {}

func (x *CustomIconDetectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomIconDetectionRequest.ProtoReflect.Descriptor instead.
func (*CustomIconDetectionRequest) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{5}
}

func (x *CustomIconDetectionRequest) GetIconPng() []byte {
	if x != nil {
		return x.IconPng
	}
	return nil
}

func (x *CustomIconDetectionRequest) GetMatchCount() int32 {
	if x != nil {
		return x.MatchCount
	}
	return 0
}

func (x *CustomIconDetectionRequest) GetMinConfidenceThreshold() float64 {
	if x != nil {
		return x.MinConfidenceThreshold
	}
	return 0
}

// Response message for UI detection.
type UiDetectionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Locations of matching UI elements.
	BoundingBoxes []*BoundingBox `protobuf:"bytes,1,rep,name=bounding_boxes,json=boundingBoxes,proto3" json:"bounding_boxes,omitempty"`
	// The transformed detection image PNG, if requested and transformations were
	// applied.
	TransformedImagePng []byte `protobuf:"bytes,2,opt,name=transformed_image_png,json=transformedImagePng,proto3" json:"transformed_image_png,omitempty"`
	// The amount the original image was scaled by to make the transformed image.
	// 1.0 if the detection result is not based on a resized image.
	ResizingScaleFactor float32 `protobuf:"fixed32,3,opt,name=resizing_scale_factor,json=resizingScaleFactor,proto3" json:"resizing_scale_factor,omitempty"`
}

func (x *UiDetectionResponse) Reset() {
	*x = UiDetectionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UiDetectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UiDetectionResponse) ProtoMessage() {}

func (x *UiDetectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UiDetectionResponse.ProtoReflect.Descriptor instead.
func (*UiDetectionResponse) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{6}
}

func (x *UiDetectionResponse) GetBoundingBoxes() []*BoundingBox {
	if x != nil {
		return x.BoundingBoxes
	}
	return nil
}

func (x *UiDetectionResponse) GetTransformedImagePng() []byte {
	if x != nil {
		return x.TransformedImagePng
	}
	return nil
}

func (x *UiDetectionResponse) GetResizingScaleFactor() float32 {
	if x != nil {
		return x.ResizingScaleFactor
	}
	return 0
}

// The location of a UI element.
// A bounding box is reprensented by its top-left point [left, top]
// and its bottom-right point [right, bottom].
type BoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text found in the bounding box.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The y-coordinate of the top-left point.
	Top int32 `protobuf:"varint,2,opt,name=top,proto3" json:"top,omitempty"`
	// The x-coordinate of the top-left point.
	Left int32 `protobuf:"varint,3,opt,name=left,proto3" json:"left,omitempty"`
	// The y-coordinate of the bottom-right point.
	Bottom int32 `protobuf:"varint,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	// The x-coordinate of the bottom-right point.
	Right int32 `protobuf:"varint,5,opt,name=right,proto3" json:"right,omitempty"`
}

func (x *BoundingBox) Reset() {
	*x = BoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingBox) ProtoMessage() {}

func (x *BoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingBox.ProtoReflect.Descriptor instead.
func (*BoundingBox) Descriptor() ([]byte, []int) {
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP(), []int{7}
}

func (x *BoundingBox) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *BoundingBox) GetTop() int32 {
	if x != nil {
		return x.Top
	}
	return 0
}

func (x *BoundingBox) GetLeft() int32 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *BoundingBox) GetBottom() int32 {
	if x != nil {
		return x.Bottom
	}
	return 0
}

func (x *BoundingBox) GetRight() int32 {
	if x != nil {
		return x.Right
	}
	return 0
}

var File_google_chromeos_uidetection_v1_ui_detection_proto protoreflect.FileDescriptor

var file_google_chromeos_uidetection_v1_ui_detection_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x2f, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31,
	0x2f, 0x75, 0x69, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xab, 0x03, 0x0a, 0x12,
	0x55, 0x69, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0b, 0x72,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a,
	0x07, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x06, 0x74, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0d, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x35, 0x0a, 0x14, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x12, 0x3d, 0x0a, 0x18, 0x72, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x16, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x72, 0x65, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0x99, 0x03, 0x0a, 0x10, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c,
	0x0a, 0x16, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x6f, 0x72, 0x64, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x64, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7c, 0x0a, 0x1c,
	0x74, 0x65, 0x78, 0x74, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x19, 0x74, 0x65, 0x78, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7f, 0x0a, 0x1d, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x63, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x63, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x18, 0x0a, 0x16, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x72, 0x0a, 0x0c, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x72,
	0x6f, 0x73, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x72, 0x6f, 0x73, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x22, 0xc7, 0x01, 0x0a, 0x14, 0x57, 0x6f,
	0x72, 0x64, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x72, 0x65, 0x67, 0x65, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2f, 0x0a, 0x11,
	0x6d, 0x61, 0x78, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x45, 0x64,
	0x69, 0x74, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a,
	0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x22, 0x80, 0x02, 0x0a, 0x19, 0x54, 0x65, 0x78, 0x74, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x67, 0x65, 0x78, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x72, 0x65, 0x67, 0x65, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2f, 0x0a,
	0x11, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x45,
	0x64, 0x69, 0x74, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x30,
	0x0a, 0x14, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x64,
	0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x64, 0x73, 0x4f, 0x6e, 0x6c, 0x79,
	0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x49, 0x63, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x70, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x69, 0x63,
	0x6f, 0x6e, 0x50, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x16, 0x6d, 0x69, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x22, 0xd1, 0x01, 0x0a, 0x13, 0x55, 0x69, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65,
	0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x0d, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x70, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x13, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x6e, 0x67,
	0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x61,
	0x6c, 0x65, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x13, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x46, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x22, 0x75, 0x0a, 0x0b, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x42, 0x6f, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x6f, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x74, 0x6f, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x65, 0x66,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x62,
	0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x32, 0xdf, 0x01, 0x0a, 0x12,
	0x55, 0x69, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xa1, 0x01, 0x0a, 0x10, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x69, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x69, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x1a, 0x25, 0xca, 0x41, 0x22, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x83, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x72,
	0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2e, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x55, 0x69, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x2f, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x3b, 0x75, 0x69, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescOnce sync.Once
	file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescData = file_google_chromeos_uidetection_v1_ui_detection_proto_rawDesc
)

func file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescGZIP() []byte {
	file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescOnce.Do(func() {
		file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescData)
	})
	return file_google_chromeos_uidetection_v1_ui_detection_proto_rawDescData
}

var file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_chromeos_uidetection_v1_ui_detection_proto_goTypes = []interface{}{
	(*UiDetectionRequest)(nil),         // 0: google.chromeos.uidetection.v1.UiDetectionRequest
	(*DetectionRequest)(nil),           // 1: google.chromeos.uidetection.v1.DetectionRequest
	(*TestMetadata)(nil),               // 2: google.chromeos.uidetection.v1.TestMetadata
	(*WordDetectionRequest)(nil),       // 3: google.chromeos.uidetection.v1.WordDetectionRequest
	(*TextBlockDetectionRequest)(nil),  // 4: google.chromeos.uidetection.v1.TextBlockDetectionRequest
	(*CustomIconDetectionRequest)(nil), // 5: google.chromeos.uidetection.v1.CustomIconDetectionRequest
	(*UiDetectionResponse)(nil),        // 6: google.chromeos.uidetection.v1.UiDetectionResponse
	(*BoundingBox)(nil),                // 7: google.chromeos.uidetection.v1.BoundingBox
}
var file_google_chromeos_uidetection_v1_ui_detection_proto_depIdxs = []int32{
	1, // 0: google.chromeos.uidetection.v1.UiDetectionRequest.request:type_name -> google.chromeos.uidetection.v1.DetectionRequest
	2, // 1: google.chromeos.uidetection.v1.UiDetectionRequest.test_metadata:type_name -> google.chromeos.uidetection.v1.TestMetadata
	3, // 2: google.chromeos.uidetection.v1.DetectionRequest.word_detection_request:type_name -> google.chromeos.uidetection.v1.WordDetectionRequest
	4, // 3: google.chromeos.uidetection.v1.DetectionRequest.text_block_detection_request:type_name -> google.chromeos.uidetection.v1.TextBlockDetectionRequest
	5, // 4: google.chromeos.uidetection.v1.DetectionRequest.custom_icon_detection_request:type_name -> google.chromeos.uidetection.v1.CustomIconDetectionRequest
	7, // 5: google.chromeos.uidetection.v1.UiDetectionResponse.bounding_boxes:type_name -> google.chromeos.uidetection.v1.BoundingBox
	0, // 6: google.chromeos.uidetection.v1.UiDetectionService.ExecuteDetection:input_type -> google.chromeos.uidetection.v1.UiDetectionRequest
	6, // 7: google.chromeos.uidetection.v1.UiDetectionService.ExecuteDetection:output_type -> google.chromeos.uidetection.v1.UiDetectionResponse
	7, // [7:8] is the sub-list for method output_type
	6, // [6:7] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_chromeos_uidetection_v1_ui_detection_proto_init() }
func file_google_chromeos_uidetection_v1_ui_detection_proto_init() {
	if File_google_chromeos_uidetection_v1_ui_detection_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UiDetectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WordDetectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextBlockDetectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomIconDetectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UiDetectionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*DetectionRequest_WordDetectionRequest)(nil),
		(*DetectionRequest_TextBlockDetectionRequest)(nil),
		(*DetectionRequest_CustomIconDetectionRequest)(nil),
	}
	file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes[4].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chromeos_uidetection_v1_ui_detection_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_chromeos_uidetection_v1_ui_detection_proto_goTypes,
		DependencyIndexes: file_google_chromeos_uidetection_v1_ui_detection_proto_depIdxs,
		MessageInfos:      file_google_chromeos_uidetection_v1_ui_detection_proto_msgTypes,
	}.Build()
	File_google_chromeos_uidetection_v1_ui_detection_proto = out.File
	file_google_chromeos_uidetection_v1_ui_detection_proto_rawDesc = nil
	file_google_chromeos_uidetection_v1_ui_detection_proto_goTypes = nil
	file_google_chromeos_uidetection_v1_ui_detection_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// UiDetectionServiceClient is the client API for UiDetectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UiDetectionServiceClient interface {
	// Runs the detection.
	ExecuteDetection(ctx context.Context, in *UiDetectionRequest, opts ...grpc.CallOption) (*UiDetectionResponse, error)
}

type uiDetectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewUiDetectionServiceClient(cc grpc.ClientConnInterface) UiDetectionServiceClient {
	return &uiDetectionServiceClient{cc}
}

func (c *uiDetectionServiceClient) ExecuteDetection(ctx context.Context, in *UiDetectionRequest, opts ...grpc.CallOption) (*UiDetectionResponse, error) {
	out := new(UiDetectionResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.uidetection.v1.UiDetectionService/ExecuteDetection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UiDetectionServiceServer is the server API for UiDetectionService service.
type UiDetectionServiceServer interface {
	// Runs the detection.
	ExecuteDetection(context.Context, *UiDetectionRequest) (*UiDetectionResponse, error)
}

// UnimplementedUiDetectionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUiDetectionServiceServer struct {
}

func (*UnimplementedUiDetectionServiceServer) ExecuteDetection(context.Context, *UiDetectionRequest) (*UiDetectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteDetection not implemented")
}

func RegisterUiDetectionServiceServer(s *grpc.Server, srv UiDetectionServiceServer) {
	s.RegisterService(&_UiDetectionService_serviceDesc, srv)
}

func _UiDetectionService_ExecuteDetection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UiDetectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UiDetectionServiceServer).ExecuteDetection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.uidetection.v1.UiDetectionService/ExecuteDetection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UiDetectionServiceServer).ExecuteDetection(ctx, req.(*UiDetectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UiDetectionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.chromeos.uidetection.v1.UiDetectionService",
	HandlerType: (*UiDetectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExecuteDetection",
			Handler:    _UiDetectionService_ExecuteDetection_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/chromeos/uidetection/v1/ui_detection.proto",
}
