// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package policyanalyzer provides access to the Policy Analyzer API.
//
// For product documentation, see: https://www.google.com
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/policyanalyzer/v1beta1"
//	...
//	ctx := context.Background()
//	policyanalyzerService, err := policyanalyzer.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	policyanalyzerService, err := policyanalyzer.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	policyanalyzerService, err := policyanalyzer.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package policyanalyzer // import "google.golang.org/api/policyanalyzer/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "policyanalyzer:v1beta1"
const apiName = "policyanalyzer"
const apiVersion = "v1beta1"
const basePath = "https://policyanalyzer.googleapis.com/"
const basePathTemplate = "https://policyanalyzer.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://policyanalyzer.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Locations = NewFoldersLocationsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Locations *FoldersLocationsService
}

func NewFoldersLocationsService(s *Service) *FoldersLocationsService {
	rs := &FoldersLocationsService{s: s}
	rs.ActivityTypes = NewFoldersLocationsActivityTypesService(s)
	return rs
}

type FoldersLocationsService struct {
	s *Service

	ActivityTypes *FoldersLocationsActivityTypesService
}

func NewFoldersLocationsActivityTypesService(s *Service) *FoldersLocationsActivityTypesService {
	rs := &FoldersLocationsActivityTypesService{s: s}
	rs.Activities = NewFoldersLocationsActivityTypesActivitiesService(s)
	return rs
}

type FoldersLocationsActivityTypesService struct {
	s *Service

	Activities *FoldersLocationsActivityTypesActivitiesService
}

func NewFoldersLocationsActivityTypesActivitiesService(s *Service) *FoldersLocationsActivityTypesActivitiesService {
	rs := &FoldersLocationsActivityTypesActivitiesService{s: s}
	return rs
}

type FoldersLocationsActivityTypesActivitiesService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.ActivityTypes = NewOrganizationsLocationsActivityTypesService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	ActivityTypes *OrganizationsLocationsActivityTypesService
}

func NewOrganizationsLocationsActivityTypesService(s *Service) *OrganizationsLocationsActivityTypesService {
	rs := &OrganizationsLocationsActivityTypesService{s: s}
	rs.Activities = NewOrganizationsLocationsActivityTypesActivitiesService(s)
	return rs
}

type OrganizationsLocationsActivityTypesService struct {
	s *Service

	Activities *OrganizationsLocationsActivityTypesActivitiesService
}

func NewOrganizationsLocationsActivityTypesActivitiesService(s *Service) *OrganizationsLocationsActivityTypesActivitiesService {
	rs := &OrganizationsLocationsActivityTypesActivitiesService{s: s}
	return rs
}

type OrganizationsLocationsActivityTypesActivitiesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.ActivityTypes = NewProjectsLocationsActivityTypesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	ActivityTypes *ProjectsLocationsActivityTypesService
}

func NewProjectsLocationsActivityTypesService(s *Service) *ProjectsLocationsActivityTypesService {
	rs := &ProjectsLocationsActivityTypesService{s: s}
	rs.Activities = NewProjectsLocationsActivityTypesActivitiesService(s)
	return rs
}

type ProjectsLocationsActivityTypesService struct {
	s *Service

	Activities *ProjectsLocationsActivityTypesActivitiesService
}

func NewProjectsLocationsActivityTypesActivitiesService(s *Service) *ProjectsLocationsActivityTypesActivitiesService {
	rs := &ProjectsLocationsActivityTypesActivitiesService{s: s}
	return rs
}

type ProjectsLocationsActivityTypesActivitiesService struct {
	s *Service
}

// GoogleCloudPolicyanalyzerV1beta1Activity: Represents Activity on a GCP
// resource over specific observation period.
type GoogleCloudPolicyanalyzerV1beta1Activity struct {
	// Activity: A struct of custom fields to explain the activity.
	Activity googleapi.RawMessage `json:"activity,omitempty"`
	// ActivityType: The type of the activity.
	ActivityType string `json:"activityType,omitempty"`
	// FullResourceName: The full resource name that identifies the resource. For
	// examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// ObservationPeriod: The data observation period to build the activity.
	ObservationPeriod *GoogleCloudPolicyanalyzerV1beta1ObservationPeriod `json:"observationPeriod,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Activity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Activity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicyanalyzerV1beta1Activity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicyanalyzerV1beta1Activity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicyanalyzerV1beta1ObservationPeriod: Represents data
// observation period.
type GoogleCloudPolicyanalyzerV1beta1ObservationPeriod struct {
	// EndTime: The observation end time.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: The observation start time.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicyanalyzerV1beta1ObservationPeriod) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicyanalyzerV1beta1ObservationPeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse: Response to the
// `QueryActivity` method.
type GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse struct {
	// Activities: The set of activities that match the filter included in the
	// request.
	Activities []*GoogleCloudPolicyanalyzerV1beta1Activity `json:"activities,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then `nextPageToken` is included. To get the next set of results,
	// call this method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Activities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Activities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FoldersLocationsActivityTypesActivitiesQueryCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Query: Queries policy activities on GCP resources.
//
//   - parent: The container resource on which to execute the request. Acceptable
//     formats:
//     `projects/[PROJECT_ID|PROJECT_NUMBER]/locations/[LOCATION]/activityTypes/[A
//     CTIVITY_TYPE]` LOCATION here refers to GCP Locations:
//     https://cloud.google.com/about/locations/.
func (r *FoldersLocationsActivityTypesActivitiesService) Query(parent string) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c := &FoldersLocationsActivityTypesActivitiesQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional filter expression to
// restrict the activities returned. Supported filters are: -
// service_account_last_authn.full_resource_name {=} -
// service_account_key_last_authn.full_resource_name {=}
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Filter(filter string) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Max limit is 1000. Non-positive values
// are ignored. The presence of `nextPageToken` in the response indicates that
// more results might be available.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) PageSize(pageSize int64) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method.
// `pageToken` must be the value of `nextPageToken` from the previous response.
// The values of other method parameters should be identical to those in the
// previous call.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) PageToken(pageToken string) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Fields(s ...googleapi.Field) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) IfNoneMatch(entityTag string) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Context(ctx context.Context) *FoldersLocationsActivityTypesActivitiesQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsActivityTypesActivitiesQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/activities:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policyanalyzer.folders.locations.activityTypes.activities.query", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policyanalyzer.folders.locations.activityTypes.activities.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policyanalyzer.folders.locations.activityTypes.activities.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsActivityTypesActivitiesQueryCall) Pages(ctx context.Context, f func(*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsActivityTypesActivitiesQueryCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Query: Queries policy activities on GCP resources.
//
//   - parent: The container resource on which to execute the request. Acceptable
//     formats:
//     `projects/[PROJECT_ID|PROJECT_NUMBER]/locations/[LOCATION]/activityTypes/[A
//     CTIVITY_TYPE]` LOCATION here refers to GCP Locations:
//     https://cloud.google.com/about/locations/.
func (r *OrganizationsLocationsActivityTypesActivitiesService) Query(parent string) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c := &OrganizationsLocationsActivityTypesActivitiesQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional filter expression to
// restrict the activities returned. Supported filters are: -
// service_account_last_authn.full_resource_name {=} -
// service_account_key_last_authn.full_resource_name {=}
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Filter(filter string) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Max limit is 1000. Non-positive values
// are ignored. The presence of `nextPageToken` in the response indicates that
// more results might be available.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) PageSize(pageSize int64) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method.
// `pageToken` must be the value of `nextPageToken` from the previous response.
// The values of other method parameters should be identical to those in the
// previous call.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) PageToken(pageToken string) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Fields(s ...googleapi.Field) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) IfNoneMatch(entityTag string) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Context(ctx context.Context) *OrganizationsLocationsActivityTypesActivitiesQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/activities:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policyanalyzer.organizations.locations.activityTypes.activities.query", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policyanalyzer.organizations.locations.activityTypes.activities.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policyanalyzer.organizations.locations.activityTypes.activities.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsActivityTypesActivitiesQueryCall) Pages(ctx context.Context, f func(*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsActivityTypesActivitiesQueryCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Query: Queries policy activities on GCP resources.
//
//   - parent: The container resource on which to execute the request. Acceptable
//     formats:
//     `projects/[PROJECT_ID|PROJECT_NUMBER]/locations/[LOCATION]/activityTypes/[A
//     CTIVITY_TYPE]` LOCATION here refers to GCP Locations:
//     https://cloud.google.com/about/locations/.
func (r *ProjectsLocationsActivityTypesActivitiesService) Query(parent string) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c := &ProjectsLocationsActivityTypesActivitiesQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Optional filter expression to
// restrict the activities returned. Supported filters are: -
// service_account_last_authn.full_resource_name {=} -
// service_account_key_last_authn.full_resource_name {=}
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Filter(filter string) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Max limit is 1000. Non-positive values
// are ignored. The presence of `nextPageToken` in the response indicates that
// more results might be available.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) PageSize(pageSize int64) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method.
// `pageToken` must be the value of `nextPageToken` from the previous response.
// The values of other method parameters should be identical to those in the
// previous call.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) PageToken(pageToken string) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Context(ctx context.Context) *ProjectsLocationsActivityTypesActivitiesQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/activities:query")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policyanalyzer.projects.locations.activityTypes.activities.query", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policyanalyzer.projects.locations.activityTypes.activities.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policyanalyzer.projects.locations.activityTypes.activities.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsActivityTypesActivitiesQueryCall) Pages(ctx context.Context, f func(*GoogleCloudPolicyanalyzerV1beta1QueryActivityResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
