package dictpool

import "sync"

var defaultPool = sync.Pool{
	New: func() interface{} {
		return New()
	},
}

// AcquireDict acquire new dict.
func AcquireDict() *Dict {
	return defaultPool.Get().(*Dict) // nolint:forcetypeassert
}

// ReleaseDict release dict.
func ReleaseDict(d *Dict) {
	d.Reset()
	defaultPool.Put(d)
}
