// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostCisBenchmarkScanResultScore A single CIS (Center for Internet Security) benchmark executed in a host scan
type HostCisBenchmarkScanResultScore struct {

	// Identifier for this CIS (Center for Internet Security) benchmark
	BenchmarkIdentifier *string `mandatory:"true" json:"benchmarkIdentifier"`

	// Details about what this CIS (Center for Internet Security) benchmark represents
	Description *string `mandatory:"true" json:"description"`

	// Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail)
	Score ScanResultScoreEnum `mandatory:"true" json:"score"`
}

func (m HostCisBenchmarkScanResultScore) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostCisBenchmarkScanResultScore) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingScanResultScoreEnum(string(m.Score)); !ok && m.Score != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Score: %s. Supported values are: %s.", m.Score, strings.Join(GetScanResultScoreEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
