// Code generated by go-swagger; DO NOT EDIT.

package consul_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-consul-service/stable/2021-02-04/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetClientConfigReader is a Reader for the GetClientConfig structure.
type GetClientConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetClientConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetClientConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetClientConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetClientConfigOK creates a GetClientConfigOK with default headers values
func NewGetClientConfigOK() *GetClientConfigOK {
	return &GetClientConfigOK{}
}

/*
GetClientConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetClientConfigOK struct {
	Payload *models.HashicorpCloudConsul20210204GetClientConfigResponse
}

// IsSuccess returns true when this get client config o k response has a 2xx status code
func (o *GetClientConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get client config o k response has a 3xx status code
func (o *GetClientConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get client config o k response has a 4xx status code
func (o *GetClientConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get client config o k response has a 5xx status code
func (o *GetClientConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get client config o k response a status code equal to that given
func (o *GetClientConfigOK) IsCode(code int) bool {
	return code == 200
}

func (o *GetClientConfigOK) Error() string {
	return fmt.Sprintf("[GET /consul/2021-02-04/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/client-config][%d] getClientConfigOK  %+v", 200, o.Payload)
}

func (o *GetClientConfigOK) String() string {
	return fmt.Sprintf("[GET /consul/2021-02-04/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/client-config][%d] getClientConfigOK  %+v", 200, o.Payload)
}

func (o *GetClientConfigOK) GetPayload() *models.HashicorpCloudConsul20210204GetClientConfigResponse {
	return o.Payload
}

func (o *GetClientConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsul20210204GetClientConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClientConfigDefault creates a GetClientConfigDefault with default headers values
func NewGetClientConfigDefault(code int) *GetClientConfigDefault {
	return &GetClientConfigDefault{
		_statusCode: code,
	}
}

/*
GetClientConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetClientConfigDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the get client config default response
func (o *GetClientConfigDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this get client config default response has a 2xx status code
func (o *GetClientConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get client config default response has a 3xx status code
func (o *GetClientConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get client config default response has a 4xx status code
func (o *GetClientConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get client config default response has a 5xx status code
func (o *GetClientConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get client config default response a status code equal to that given
func (o *GetClientConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *GetClientConfigDefault) Error() string {
	return fmt.Sprintf("[GET /consul/2021-02-04/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/client-config][%d] GetClientConfig default  %+v", o._statusCode, o.Payload)
}

func (o *GetClientConfigDefault) String() string {
	return fmt.Sprintf("[GET /consul/2021-02-04/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/client-config][%d] GetClientConfig default  %+v", o._statusCode, o.Payload)
}

func (o *GetClientConfigDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *GetClientConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
