// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/preview/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// SessionsReader is a Reader for the Sessions structure.
type SessionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SessionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSessionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSessionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSessionsOK creates a SessionsOK with default headers values
func NewSessionsOK() *SessionsOK {
	return &SessionsOK{}
}

/*
SessionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type SessionsOK struct {
	Payload *models.HashicorpCloudBoundary20211221SessionsResponse
}

// IsSuccess returns true when this sessions o k response has a 2xx status code
func (o *SessionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this sessions o k response has a 3xx status code
func (o *SessionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this sessions o k response has a 4xx status code
func (o *SessionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this sessions o k response has a 5xx status code
func (o *SessionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this sessions o k response a status code equal to that given
func (o *SessionsOK) IsCode(code int) bool {
	return code == 200
}

func (o *SessionsOK) Error() string {
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] sessionsOK  %+v", 200, o.Payload)
}

func (o *SessionsOK) String() string {
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] sessionsOK  %+v", 200, o.Payload)
}

func (o *SessionsOK) GetPayload() *models.HashicorpCloudBoundary20211221SessionsResponse {
	return o.Payload
}

func (o *SessionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221SessionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSessionsDefault creates a SessionsDefault with default headers values
func NewSessionsDefault(code int) *SessionsDefault {
	return &SessionsDefault{
		_statusCode: code,
	}
}

/*
SessionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type SessionsDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the sessions default response
func (o *SessionsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this sessions default response has a 2xx status code
func (o *SessionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this sessions default response has a 3xx status code
func (o *SessionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this sessions default response has a 4xx status code
func (o *SessionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this sessions default response has a 5xx status code
func (o *SessionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this sessions default response a status code equal to that given
func (o *SessionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *SessionsDefault) Error() string {
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] Sessions default  %+v", o._statusCode, o.Payload)
}

func (o *SessionsDefault) String() string {
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] Sessions default  %+v", o._statusCode, o.Payload)
}

func (o *SessionsDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *SessionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
