// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// CreateOrUpdateConfigCmd create or update config cmd
//
// swagger:model CreateOrUpdateConfigCmd
type CreateOrUpdateConfigCmd struct {

	// dashboard Id
	DashboardID int64 `json:"dashboardId,omitempty"`

	// dashboard Uid
	DashboardUID string `json:"dashboardUid,omitempty"`

	// dashboards
	Dashboards []*DashboardDTO `json:"dashboards"`

	// enable Csv
	EnableCSV bool `json:"enableCsv,omitempty"`

	// enable dashboard Url
	EnableDashboardURL bool `json:"enableDashboardUrl,omitempty"`

	// formats
	Formats []Type `json:"formats"`

	// message
	Message string `json:"message,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// options
	Options *ReportOptionsDTO `json:"options,omitempty"`

	// recipients
	Recipients string `json:"recipients,omitempty"`

	// reply to
	ReplyTo string `json:"replyTo,omitempty"`

	// scale factor
	ScaleFactor int64 `json:"scaleFactor,omitempty"`

	// schedule
	Schedule *ScheduleDTO `json:"schedule,omitempty"`

	// state
	State State `json:"state,omitempty"`

	// template vars
	TemplateVars interface{} `json:"templateVars,omitempty"`
}

// Validate validates this create or update config cmd
func (m *CreateOrUpdateConfigCmd) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDashboards(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFormats(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateOrUpdateConfigCmd) validateDashboards(formats strfmt.Registry) error {
	if swag.IsZero(m.Dashboards) { // not required
		return nil
	}

	for i := 0; i < len(m.Dashboards); i++ {
		if swag.IsZero(m.Dashboards[i]) { // not required
			continue
		}

		if m.Dashboards[i] != nil {
			if err := m.Dashboards[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dashboards" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dashboards" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) validateFormats(formats strfmt.Registry) error {
	if swag.IsZero(m.Formats) { // not required
		return nil
	}

	for i := 0; i < len(m.Formats); i++ {

		if err := m.Formats[i].Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("formats" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("formats" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) validateOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.Options) { // not required
		return nil
	}

	if m.Options != nil {
		if err := m.Options.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) validateSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.Schedule) { // not required
		return nil
	}

	if m.Schedule != nil {
		if err := m.Schedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("schedule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("schedule")
			}
			return err
		}
	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// ContextValidate validate this create or update config cmd based on the context it is used
func (m *CreateOrUpdateConfigCmd) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDashboards(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormats(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CreateOrUpdateConfigCmd) contextValidateDashboards(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Dashboards); i++ {

		if m.Dashboards[i] != nil {

			if swag.IsZero(m.Dashboards[i]) { // not required
				return nil
			}

			if err := m.Dashboards[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dashboards" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dashboards" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) contextValidateFormats(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Formats); i++ {

		if swag.IsZero(m.Formats[i]) { // not required
			return nil
		}

		if err := m.Formats[i].ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("formats" + "." + strconv.Itoa(i))
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("formats" + "." + strconv.Itoa(i))
			}
			return err
		}

	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) contextValidateOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.Options != nil {

		if swag.IsZero(m.Options) { // not required
			return nil
		}

		if err := m.Options.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.Schedule != nil {

		if swag.IsZero(m.Schedule) { // not required
			return nil
		}

		if err := m.Schedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("schedule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("schedule")
			}
			return err
		}
	}

	return nil
}

func (m *CreateOrUpdateConfigCmd) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.State) { // not required
		return nil
	}

	if err := m.State.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("state")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("state")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CreateOrUpdateConfigCmd) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateOrUpdateConfigCmd) UnmarshalBinary(b []byte) error {
	var res CreateOrUpdateConfigCmd
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
