<p align="center">
  <img alt="golangci-lint logo" src="assets/go.png" height="150" />
  <h3 align="center">golangci-lint</h3>
  <p align="center">Fast linters runner for Go</p>
</p>

---

`golangci-lint` is a fast Go linters runner.

It runs linters in parallel, uses caching, supports YAML configuration,
integrates with all major IDEs, and includes over a hundred linters.

## Install `golangci-lint`

- [On my machine](https://golangci-lint.run/welcome/install/#local-installation);
- [On CI/CD systems](https://golangci-lint.run/welcome/install/#ci-installation).

## Documentation

Documentation is hosted at https://golangci-lint.run.

## Social Networks

[![Join Slack](https://img.shields.io/badge/Slack-4285F4?logo=slack&logoColor=white)](https://gophers.slack.com/archives/CS0TBRKPC)
[![Follow on Mastodon](https://img.shields.io/badge/mastodon-6364FF?logo=mastodon&logoColor=white)](https://fosstodon.org/@golangcilint)
[![Follow on Twitter](https://img.shields.io/badge/twitter-1DA1F2?logo=twitter&logoColor=white)](https://twitter.com/golangci)

## Supporting Us

[![Open Collective backers and sponsors](https://img.shields.io/badge/OpenCollective-Donate-blue?logo=opencollective&style=for-the-badge)](https://opencollective.com/golangci-lint)
[![GitHub Sponsors](https://img.shields.io/badge/GitHub-Donate-blue?logo=github&style=for-the-badge)](https://github.com/sponsors/golangci)
[![Linter Authors](https://img.shields.io/badge/Linter_Authors-Donate-blue?style=for-the-badge)](https://golangci-lint.run/product/thanks/)

`golangci-lint` is a free and open-source project built by volunteers.

If you value it, consider supporting us, we appreciate it! :heart:

## Badges

![Build Status](https://github.com/golangci/golangci-lint/workflows/CI/badge.svg)
[![License](https://img.shields.io/github/license/golangci/golangci-lint)](/LICENSE)
[![Release](https://img.shields.io/github/release/golangci/golangci-lint.svg)](https://github.com/golangci/golangci-lint/releases/latest)
[![Docker](https://img.shields.io/docker/pulls/golangci/golangci-lint)](https://hub.docker.com/r/golangci/golangci-lint)
[![GitHub Releases Stats of golangci-lint](https://img.shields.io/github/downloads/golangci/golangci-lint/total.svg?logo=github)](https://somsubhra.github.io/github-release-stats/?username=golangci&repository=golangci-lint)

## Contributors

This project exists thanks to all the people who contribute. [How to contribute](https://golangci-lint.run/contributing/quick-start/).

<!-- BEGIN AUTOGENERATED CONTRIBUTORS -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
### Core Team

<details>
<summary>About core team</summary>

The GolangCI Core Team is a group of contributors who have demonstrated a lasting enthusiasm for the project and community.
The GolangCI Core Team has GitHub admin privileges on the repo.

#### Responsibilities

The Core Team has the following responsibilities:

1. Being available to answer high-level questions about vision and future.
2. Being available to review longstanding/forgotten pull requests.
3. Occasionally check issues, offer input, and categorize with GitHub issue labels.
4. Looking out for up-and-coming members of the GolangCI community who might want to serve as Core Team members.
5. Note that the Core Team – and all GolangCI contributors – are open-source volunteers; membership on the Core Team is expressly not an obligation. The Core Team is distinguished as leaders in the community and while they are a good group to turn to when someone needs an answer to a question, they are still volunteering their time, and may not be available to help immediately.

</details>

<table>
<tr>
  <td align="center"><a href="https://github.com/ldez?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5674651?u=45f0e097891f1e7e0c45c5224dcce11c867038af&v=4" width="100px;" alt=""/><br /><sub><b>Ludovic Fernandez</b></sub></a></td>
  <td align="center"><a href="https://disaev.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4648736?u=8c4976f3d4506b780533feacae77324505e8fa1c&v=4" width="100px;" alt=""/><br /><sub><b>Denis Isaev</b></sub></a></td>
  <td align="center"><a href="https://github.com/ernado?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/866677?u=d349f6974fbf43763fa0c8f37c230e2a7ed28071&v=4" width="100px;" alt=""/><br /><sub><b>Aleksandr Razumov</b></sub></a></td>
</tr>
</table>

### Team

<table>
<tr>
  <td align="center"><a href="https://sawert.se?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3248948?u=168a0256091039230b67689a2e41202edfc481a2&v=4" width="100px;" alt=""/><br /><sub><b>Simon Sawert</b></sub></a></td>
  <td align="center"><a href="https://vilgelm.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/523825?u=b6660194a9a09d522ac18d95a3b88b5028b4cb2a&v=4" width="100px;" alt=""/><br /><sub><b>Sergey Vilgelm</b></sub></a></td>
  <td align="center"><a href="https://alexandear.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3228886?u=32718b9e9f32138de5e8b2cc1893ba637434ccba&v=4" width="100px;" alt=""/><br /><sub><b>Oleksandr Redko</b></sub></a></td>
  <td align="center"><a href="https://tammach.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9019229?u=434a8656f0f0917d35fe56322c81811036ec0e0c&v=4" width="100px;" alt=""/><br /><sub><b>Tam Mach</b></sub></a></td>
  <td align="center"><a href="https://tpounds.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/195041?u=cab053161e59fece04c051169b59882b299ce97a&v=4" width="100px;" alt=""/><br /><sub><b>Trevor Pounds</b></sub></a></td>
  <td align="center"><a href="https://linkedin.com/in/antonboom?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17127404?u=2efa03fa4e2a40a8c122d25df96691841bff6c73&v=4" width="100px;" alt=""/><br /><sub><b>Anton Telyshev</b></sub></a></td>
  <td align="center"><a href="https://github.com/daixiang0?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/26538619?u=6261612ded324edb4ce57dce98e40413276aeb74&v=4" width="100px;" alt=""/><br /><sub><b>Loong Dai</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/butuzov?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/651824?v=4" width="100px;" alt=""/><br /><sub><b>Oleg Butuzov </b></sub></a></td>
  <td align="center"><a href="https://github.com/kamilsk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1165416?u=d51ba7a1b9c74802350ba5dab08d2f5de39cd09e&v=4" width="100px;" alt=""/><br /><sub><b>Kamil Samigullin</b></sub></a></td>
  <td align="center"><a href="http://saschagrunert.de?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/695473?u=6fff0b4de2eacfb3cb5ab49e6d11ed5c8608afd8&v=4" width="100px;" alt=""/><br /><sub><b>Sascha Grunert</b></sub></a></td>
  <td align="center"><a href="https://critical.today?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/939646?u=f5cf5eb221c9dee7232b6017346b212034bdbb18&v=4" width="100px;" alt=""/><br /><sub><b>@iwankgb</b></sub></a></td>
  <td align="center"><a href="https://github.com/ashanbrown?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1858046?u=4f976febbce75a684c0259d4587c8677e34593be&v=4" width="100px;" alt=""/><br /><sub><b>Andrew Shannon Brown</b></sub></a></td>
  <td align="center"><a href="https://github.com/maratori?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16486128?v=4" width="100px;" alt=""/><br /><sub><b>Marat Reymers</b></sub></a></td>
  <td align="center"><a href="https://twitter.com/sivchari?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/55221074?u=686bd64472b56ab29b42d9bc528e57120bfa9de5&v=4" width="100px;" alt=""/><br /><sub><b>sivchari</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/leonklingele?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5585491?u=2180da7be30906f61a3180efee129b50226f6d01&v=4" width="100px;" alt=""/><br /><sub><b>@leonklingele</b></sub></a></td>
  <td align="center"><a href="https://github.com/ryancurrah?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6209771?u=9d81ec835f9d3b4bc096422950567b213cea1098&v=4" width="100px;" alt=""/><br /><sub><b>Ryan Currah</b></sub></a></td>
  <td align="center"><a href="https://pierredurand.fr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/131535?v=4" width="100px;" alt=""/><br /><sub><b>Pierre Durand</b></sub></a></td>
  <td align="center"><a href="https://github.com/sebastien-rosset?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16657278?v=4" width="100px;" alt=""/><br /><sub><b>Sebastien Rosset</b></sub></a></td>
  <td align="center"><a href="https://t.me/sashamelentyev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/55826637?u=017d55a7e043331e28d5b95018ca67618c02815c&v=4" width="100px;" alt=""/><br /><sub><b>Sasha Melentyev</b></sub></a></td>
  <td align="center"><a href="https://github.com/denis-tingaikin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/49399980?u=f5f05175a10b12450028c49e1f98a76dec05f465&v=4" width="100px;" alt=""/><br /><sub><b>Denis Tingaikin</b></sub></a></td>
  <td align="center"><a href="http://www.estamos.de/blog/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22076?v=4" width="100px;" alt=""/><br /><sub><b>Patrick Ohly</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://about.me/alexey.palazhchenko?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11512?v=4" width="100px;" alt=""/><br /><sub><b>Alexey Palazhchenko</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/dlopbec/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5780637?u=383d756370b819233d3598b20d333b134ddbe294&v=4" width="100px;" alt=""/><br /><sub><b>David Lobe</b></sub></a></td>
  <td align="center"><a href="https://github.com/scop?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/109152?u=782addb4cabd3acc673e2595ba43377f88414b6b&v=4" width="100px;" alt=""/><br /><sub><b>Ville Skyttä</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/ducovanamstel?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/896592?u=d137ca0926c6e2a865f777053b8ade2e893ff80b&v=4" width="100px;" alt=""/><br /><sub><b>Duco van Amstel</b></sub></a></td>
  <td align="center"><a href="https://github.com/nishanths?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6028224?u=08e9d50bea01f28ae95d536217920a1267507410&v=4" width="100px;" alt=""/><br /><sub><b>Nishanth Shanmugham</b></sub></a></td>
  <td align="center"><a href="https://github.com/sanposhiho?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/44139130?u=d0a40ab2af9d5c6c5a1379b80d26a0e8361161e9&v=4" width="100px;" alt=""/><br /><sub><b>Kensei Nakada</b></sub></a></td>
  <td align="center"><a href="https://melvin.la?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/275508?u=3a59ef9c48589c16046a11cc98b570423718d540&v=4" width="100px;" alt=""/><br /><sub><b>Melvin</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://twitter.com/quasilyte?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6286655?u=11ccf136d6167205bbec1ed864e7306bb22a26d4&v=4" width="100px;" alt=""/><br /><sub><b>quasilyte</b></sub></a></td>
  <td align="center"><a href="https://dev.to/ccoveille?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3875889?u=06d04a6e2a03bbcca63e0c04fdf5ca36d1a1fad9&v=4" width="100px;" alt=""/><br /><sub><b>ccoVeille</b></sub></a></td>
  <td align="center"><a href="https://dkrv.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11755173?v=4" width="100px;" alt=""/><br /><sub><b>Denis Krivak</b></sub></a></td>
  <td align="center"><a href="http://swapoff.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/41767?v=4" width="100px;" alt=""/><br /><sub><b>Alec Thomas</b></sub></a></td>
  <td align="center"><a href="https://github.com/johejo?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25817501?u=3eb86cdb5c0fedb4f13602cd31db18b3c227df55&v=4" width="100px;" alt=""/><br /><sub><b>Mitsuo HEIJO</b></sub></a></td>
  <td align="center"><a href="https://hachyderm.io/@StevenACoffman?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1942608?u=c0452475649bfd1f5d08b9cb3584627b17f2bec5&v=4" width="100px;" alt=""/><br /><sub><b>Steve Coffman</b></sub></a></td>
  <td align="center"><a href="https://maik.schreiber.ms?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1207236?u=3de36ac4a235922a52ef917325b9b91b7cd79657&v=4" width="100px;" alt=""/><br /><sub><b>Maik Schreiber</b></sub></a></td>
</tr>
</table>

<details>
<summary>And 502 more our team members</summary>

<table>
<tr>
  <td align="center"><a href="https://github.com/nunnatsa?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/60659093?u=4f453c728cc9de784796783626cdd52b0bcc43e4&v=4" width="100px;" alt=""/><br /><sub><b>Nahshon Unna Tsameret</b></sub></a></td>
  <td align="center"><a href="https://sizeof.page?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/73077675?u=2e0a95650ef31e86c4b40b8d041794f6752aed3a&v=4" width="100px;" alt=""/><br /><sub><b>Tom</b></sub></a></td>
  <td align="center"><a href="http://dzx.cz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15747583?u=76a4ee9ac3f80fcbfcb5a77a736c467feea5cca6&v=4" width="100px;" alt=""/><br /><sub><b>Matouš Dzivjak</b></sub></a></td>
  <td align="center"><a href="https://github.com/uudashr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/166053?u=0ccd812adf8125062b674494a4c912894206d27c&v=4" width="100px;" alt=""/><br /><sub><b>Nuruddin Ashr</b></sub></a></td>
  <td align="center"><a href="https://willd.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6287275?u=58d7a50b67e7a04e26bcc85c670cf84230f9fe18&v=4" width="100px;" alt=""/><br /><sub><b>Will Dixon</b></sub></a></td>
  <td align="center"><a href="https://github.com/invidian?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16539896?v=4" width="100px;" alt=""/><br /><sub><b>Mateusz Gozdek</b></sub></a></td>
  <td align="center"><a href="https://mateusoliveira43.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/66965232?u=3ee8eb93f35e66abe4e8cf00a0324dde527db760&v=4" width="100px;" alt=""/><br /><sub><b>Mateus Oliveira</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="http://magnetikonline.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1818757?u=27ca8c53c66113faa67f6b48aeb8841717c0ee2f&v=4" width="100px;" alt=""/><br /><sub><b>Peter Mescalchin</b></sub></a></td>
  <td align="center"><a href="https://github.com/thebeline?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/130580?u=0b394efcf64ef327e17303f718d1f37a1c458584&v=4" width="100px;" alt=""/><br /><sub><b>Michael Mulligan</b></sub></a></td>
  <td align="center"><a href="https://github.com/jwilner?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1879661?u=d5fd87311dd118b3f6044f6d3644ebe6dbcc222c&v=4" width="100px;" alt=""/><br /><sub><b>Joe Wilner</b></sub></a></td>
  <td align="center"><a href="https://blog.ksoichiro.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/801987?v=4" width="100px;" alt=""/><br /><sub><b>Soichiro Kashima</b></sub></a></td>
  <td align="center"><a href="https://breml.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6205217?u=ddaccd56a7384572a1d80b85e204dad293d80c9d&v=4" width="100px;" alt=""/><br /><sub><b>Lucas Bremgartner</b></sub></a></td>
  <td align="center"><a href="https://github.com/alingse?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11423310?u=f43cba4b477fb591adf37e901ad1e8a642006838&v=4" width="100px;" alt=""/><br /><sub><b>@alingse</b></sub></a></td>
  <td align="center"><a href="https://github.com/stevenh?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/104239?v=4" width="100px;" alt=""/><br /><sub><b>Steven Hartland</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://olegk.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/366002?u=22b4115f9d411829bd5511490932bca8bd08fc6b&v=4" width="100px;" alt=""/><br /><sub><b>Oleg Kovalov</b></sub></a></td>
  <td align="center"><a href="https://silverwind.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/115237?u=ec97c900f701f18ed5d393f181396c57ce9d0a7d&v=4" width="100px;" alt=""/><br /><sub><b>@silverwind</b></sub></a></td>
  <td align="center"><a href="https://github.com/bosix?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/26360670?u=6b98683a6c327f449eb8d874c57d5310c2cf47a0&v=4" width="100px;" alt=""/><br /><sub><b>Florian Bosdorff</b></sub></a></td>
  <td align="center"><a href="https://github.com/kolyshkin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4522509?v=4" width="100px;" alt=""/><br /><sub><b>Kir Kolyshkin</b></sub></a></td>
  <td align="center"><a href="https://github.com/theckman?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/787332?u=32fbcb4a4b0022855141ef25ea52b0b9453eac4c&v=4" width="100px;" alt=""/><br /><sub><b>Tim Heckman</b></sub></a></td>
  <td align="center"><a href="https://github.com/Zamiell?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5511220?u=f8b0d15d0e5efe94463cff21f1f2b85df14c66b1&v=4" width="100px;" alt=""/><br /><sub><b>James</b></sub></a></td>
  <td align="center"><a href="https://github.com/carnott-snap?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/23408377?u=f53362538a6f5af7c6b91ab27dc0f73239abcab5&v=4" width="100px;" alt=""/><br /><sub><b>Colin Arnott</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="http://www.firelizzard.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/879055?v=4" width="100px;" alt=""/><br /><sub><b>Ethan Reesor</b></sub></a></td>
  <td align="center"><a href="https://github.com/xobotyi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6178739?u=ece401a01cb9e5f9d3cdea6481bd19e7eab458dd&v=4" width="100px;" alt=""/><br /><sub><b>Anton Zinovyev</b></sub></a></td>
  <td align="center"><a href="https://learningman.top?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/31370133?u=122e23d6e974614736be606e4ea816f45e7745f8&v=4" width="100px;" alt=""/><br /><sub><b>@Zxilly</b></sub></a></td>
  <td align="center"><a href="https://lukeshu.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/90273?u=fccd126cf88884f16b412efa0a4400f02e621d5e&v=4" width="100px;" alt=""/><br /><sub><b>Luke T. Shumaker</b></sub></a></td>
  <td align="center"><a href="https://github.com/kulti?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1286683?u=d6b6fa0c86e3b714f7cb744bc79c052f81e5678c&v=4" width="100px;" alt=""/><br /><sub><b>Aleksey Bakin</b></sub></a></td>
  <td align="center"><a href="https://sagikazarmark.hu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1226384?u=dd73ed07c3158112d758d0e3a439c896165bcf2d&v=4" width="100px;" alt=""/><br /><sub><b>Márk Sági-Kazár</b></sub></a></td>
  <td align="center"><a href="http://rski.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2960312?v=4" width="100px;" alt=""/><br /><sub><b>Rski</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/ryboe?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1250684?v=4" width="100px;" alt=""/><br /><sub><b>Ryan Boehning</b></sub></a></td>
  <td align="center"><a href="https://www.gustavobazan.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/461027?u=bec2c1defc5269c66ab0e6729a813761e06a28b1&v=4" width="100px;" alt=""/><br /><sub><b>Gustavo Bazan</b></sub></a></td>
  <td align="center"><a href="https://github.com/esimonov?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25531859?u=374b2f19abd0d62494bd458bc3a9c11921bd99c2&v=4" width="100px;" alt=""/><br /><sub><b>Eugene Simonov</b></sub></a></td>
  <td align="center"><a href="https://theo.im?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1398228?v=4" width="100px;" alt=""/><br /><sub><b>Timon Wong</b></sub></a></td>
  <td align="center"><a href="https://ferhatelmas.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/648018?u=40cb795f957e55956021e3273835566141de1ae9&v=4" width="100px;" alt=""/><br /><sub><b>ferhat elmas</b></sub></a></td>
  <td align="center"><a href="https://npf.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3185864?u=4d6303925d415d0a5e50a314d569807892a8b052&v=4" width="100px;" alt=""/><br /><sub><b>Nate Finch</b></sub></a></td>
  <td align="center"><a href="https://github.com/amenzhinsky?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1308953?v=4" width="100px;" alt=""/><br /><sub><b>Aliaksandr Mianzhynski</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://www.aneeshusa.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2085567?u=3b544afd09f49894fa41f941ebedb5585070ec60&v=4" width="100px;" alt=""/><br /><sub><b>Aneesh Agrawal</b></sub></a></td>
  <td align="center"><a href="http://qiita.com/sonatard/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1586910?u=a55afe04467991530d0e152ded35a2359b973f5e&v=4" width="100px;" alt=""/><br /><sub><b>sonatard</b></sub></a></td>
  <td align="center"><a href="https://leighmcculloch.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/351529?u=2d87a94e5ea68221f73a713d90224f9a293df9f8&v=4" width="100px;" alt=""/><br /><sub><b>Leigh McCulloch</b></sub></a></td>
  <td align="center"><a href="https://github.com/peakle?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/27820873?u=5ceb41a437bf0ef0525bfe90a42f18ca4348bfe1&v=4" width="100px;" alt=""/><br /><sub><b>Denis Limarev</b></sub></a></td>
  <td align="center"><a href="https://github.com/zhangyunhao116?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/18065074?u=dedce2f84503db8e3afc24f0f1f7d39d809e3d43&v=4" width="100px;" alt=""/><br /><sub><b>ZhangYunHao</b></sub></a></td>
  <td align="center"><a href="https://github.com/vovapi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/278946?u=7bf0f68b6b64b014dcf29964e83d96b360fbb542&v=4" width="100px;" alt=""/><br /><sub><b>Vladimir Evgrafov</b></sub></a></td>
  <td align="center"><a href="https://karamaru-alpha.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/38310693?u=a1afcd5d3fc7cc8bca1deacce9068a6ee1c2e835&v=4" width="100px;" alt=""/><br /><sub><b>Ryosei Karaki</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/jingyugao?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16934055?u=16d5d4b4b1574103cd1aaea399b236ae002055b2&v=4" width="100px;" alt=""/><br /><sub><b>gaojingyu</b></sub></a></td>
  <td align="center"><a href="https://github.com/odidev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/40816837?u=006db7f382c579d86c6649cfad96c04f54b8d222&v=4" width="100px;" alt=""/><br /><sub><b>@odidev</b></sub></a></td>
  <td align="center"><a href="https://github.com/fho?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/514535?v=4" width="100px;" alt=""/><br /><sub><b>Fabian Holler</b></sub></a></td>
  <td align="center"><a href="https://fuyu.moe/members/nisevoid?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3254486?u=b8ce61b14e893d15a418bfae299b05dad6af18c3&v=4" width="100px;" alt=""/><br /><sub><b>NiseVoid</b></sub></a></td>
  <td align="center"><a href="https://firefart.at?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/105281?u=34b91b58b59ab25a46eef20861ee0200496d3b56&v=4" width="100px;" alt=""/><br /><sub><b>Christian Mehlmauer</b></sub></a></td>
  <td align="center"><a href="http://siobud.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1302304?v=4" width="100px;" alt=""/><br /><sub><b>Sean DuBois</b></sub></a></td>
  <td align="center"><a href="http://www.neglostyti.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2631366?v=4" width="100px;" alt=""/><br /><sub><b>Viktoras Makauskas</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/System-Glitch?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7251668?u=b5317ffdcab8eac10e3c31eb0fd47bea89f8ec9f&v=4" width="100px;" alt=""/><br /><sub><b>SystemGlitch</b></sub></a></td>
  <td align="center"><a href="https://github.com/4meepo?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28745416?u=e235cbca8baa313f229998158631d9379e44fafa&v=4" width="100px;" alt=""/><br /><sub><b>Yifei Liu</b></sub></a></td>
  <td align="center"><a href="https://agniva.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1774000?u=2d77ef2b812cee7dd2dfd8f2709dcfad8b8ae539&v=4" width="100px;" alt=""/><br /><sub><b>Agniva De Sarker</b></sub></a></td>
  <td align="center"><a href="https://ashannon.us?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/120951?u=e3fc281afc247e3dd964f16c1db8e9c7adcce232&v=4" width="100px;" alt=""/><br /><sub><b>Adam Shannon</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/iliasergunin/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3991984?u=435bb9ab00bdad5a4d1e36aef6746cbfcf74fde1&v=4" width="100px;" alt=""/><br /><sub><b>Ilia Sergunin</b></sub></a></td>
  <td align="center"><a href="https://github.com/dahankzter?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/171091?v=4" width="100px;" alt=""/><br /><sub><b>Henrik Johansson</b></sub></a></td>
  <td align="center"><a href="https://blog.luxifer.fr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/419078?u=833a0696a0ec48366194a46cb9bee3746dd5a93e&v=4" width="100px;" alt=""/><br /><sub><b>Florent Viel</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://tomarrell.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7939459?u=330de5d206f2ff0fc34cde7d718e055971c3d8d0&v=4" width="100px;" alt=""/><br /><sub><b>Tom Arrell</b></sub></a></td>
  <td align="center"><a href="https://curioswitch.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5175532?v=4" width="100px;" alt=""/><br /><sub><b>Choko</b></sub></a></td>
  <td align="center"><a href="https://blog.johnstarich.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1009441?u=76ecc9848dd25d93f0722b077439806dac6e25b9&v=4" width="100px;" alt=""/><br /><sub><b>John Starich</b></sub></a></td>
  <td align="center"><a href="https://github.com/zchee?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6366270?u=b3b4c30edcd4ad8fe5da44faacbd1d70a8c836f5&v=4" width="100px;" alt=""/><br /><sub><b>Koichi Shiraishi</b></sub></a></td>
  <td align="center"><a href="https://github.com/barthr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9822478?u=c159fa0a22133fabb6a8468ed2372273f60cc7d9&v=4" width="100px;" alt=""/><br /><sub><b>Bart</b></sub></a></td>
  <td align="center"><a href="https://github.com/neha-viswanathan?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12013126?u=479684c936cc8b80f122fdede3f4afc4ceb80136&v=4" width="100px;" alt=""/><br /><sub><b>Neha Viswanathan</b></sub></a></td>
  <td align="center"><a href="https://github.com/dbraley?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2067019?u=47d3d161a65b877714779c39d2eb6dc686d427ec&v=4" width="100px;" alt=""/><br /><sub><b>David Braley</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://lukasmalkmus.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9931588?u=51de6132f5f0e8f88aedf265a5205d9a91f4e1aa&v=4" width="100px;" alt=""/><br /><sub><b>Lukas Malkmus</b></sub></a></td>
  <td align="center"><a href="https://ghost.im?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12181586?v=4" width="100px;" alt=""/><br /><sub><b>Vladislav Fursov</b></sub></a></td>
  <td align="center"><a href="https://dolmen.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/129536?v=4" width="100px;" alt=""/><br /><sub><b>Olivier Mengué</b></sub></a></td>
  <td align="center"><a href="https://kilabit.info?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43306?v=4" width="100px;" alt=""/><br /><sub><b>Shulhan</b></sub></a></td>
  <td align="center"><a href="https://github.com/cbandy?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/106560?v=4" width="100px;" alt=""/><br /><sub><b>Chris Bandy</b></sub></a></td>
  <td align="center"><a href="https://patrickkuca.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9790383?u=f3ee6bab4997260734040e0119d4cb35810973d7&v=4" width="100px;" alt=""/><br /><sub><b>Patrick Kuca</b></sub></a></td>
  <td align="center"><a href="https://dev.to/vearutop?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1381436?v=4" width="100px;" alt=""/><br /><sub><b>Viacheslav Poturaev</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://catenacyber.fr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/35799796?u=01eaaa217d6deb8022742f49c9bca386e33ff122&v=4" width="100px;" alt=""/><br /><sub><b>Catena cyber</b></sub></a></td>
  <td align="center"><a href="https://abirdcfly.eth?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5100555?u=9391013271dc52e7b259adcbdbe4da5748b10daf&v=4" width="100px;" alt=""/><br /><sub><b>@Abirdcfly</b></sub></a></td>
  <td align="center"><a href="https://github.com/hendrywiranto?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/19802534?u=5d0bbb72187e49e729d769d26f5c3eefa1f23d85&v=4" width="100px;" alt=""/><br /><sub><b>Hendry Wiranto</b></sub></a></td>
  <td align="center"><a href="https://github.com/szaydel?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/249424?v=4" width="100px;" alt=""/><br /><sub><b>Sam Zaydel</b></sub></a></td>
  <td align="center"><a href="https://github.com/rliebz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5321575?v=4" width="100px;" alt=""/><br /><sub><b>Robert Liebowitz</b></sub></a></td>
  <td align="center"><a href="http://mitar.tnode.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/585279?v=4" width="100px;" alt=""/><br /><sub><b>Mitar</b></sub></a></td>
  <td align="center"><a href="https://github.com/zikaeroh?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/48577114?u=0732d500b9122545949572de8a2e8f1fe9d4dd88&v=4" width="100px;" alt=""/><br /><sub><b>Zik Aeroh</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/zak-pawel?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17336997?v=4" width="100px;" alt=""/><br /><sub><b>Paweł Żak</b></sub></a></td>
  <td align="center"><a href="https://github.com/sylvia7788?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24389016?v=4" width="100px;" alt=""/><br /><sub><b>sylvia</b></sub></a></td>
  <td align="center"><a href="https://github.com/lasiar?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/31652715?u=80ab0258c264167ebb6143f722618ef4fe1b40d4&v=4" width="100px;" alt=""/><br /><sub><b>Roman Chaliy</b></sub></a></td>
  <td align="center"><a href="https://github.com/zealws?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/794008?u=254ae340544f623670da67073fdbd7cfe37aa9f7&v=4" width="100px;" alt=""/><br /><sub><b>Zeal Wierslee</b></sub></a></td>
  <td align="center"><a href="https://kyoh86.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5582459?u=062f9074b6d432f073b7e09940e70fc1c092e072&v=4" width="100px;" alt=""/><br /><sub><b>Kyoh</b></sub></a></td>
  <td align="center"><a href="https://github.com/timkral?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4274030?v=4" width="100px;" alt=""/><br /><sub><b>Tim Kral</b></sub></a></td>
  <td align="center"><a href="https://blog.yagipy.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/34264859?u=f5c99c28ae697458ab9cb23568df1ed0c6740166&v=4" width="100px;" alt=""/><br /><sub><b>Hiroyuki Yagihashi</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/denisvmedia?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5462781?u=bba427286e894ce43fc63856114a34f1378cda47&v=4" width="100px;" alt=""/><br /><sub><b>Denis Voytyuk</b></sub></a></td>
  <td align="center"><a href="https://jnan806.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43714056?u=0b130ca47186522120348fec6448a93edbbbe3d4&v=4" width="100px;" alt=""/><br /><sub><b>Jiangnan Jia</b></sub></a></td>
  <td align="center"><a href="https://github.com/adamroyjones?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10088591?u=4b57a1264ee0af0470d23574f5de4f8238eae6a1&v=4" width="100px;" alt=""/><br /><sub><b>Adam Jones</b></sub></a></td>
  <td align="center"><a href="https://github.com/kunwardeep?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13211086?u=d7eefb203f6ae0d66392ed4c874be785c1acc3d3&v=4" width="100px;" alt=""/><br /><sub><b>Kunwardeep</b></sub></a></td>
  <td align="center"><a href="https://github.com/dahu33?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2038888?u=a7fd865764d7211ad7f4af2107d31325f2689975&v=4" width="100px;" alt=""/><br /><sub><b>Pierre R</b></sub></a></td>
  <td align="center"><a href="https://github.com/srenatus?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/870638?u=4607741d467654d0c0643043a64da994df94b76f&v=4" width="100px;" alt=""/><br /><sub><b>Stephan Renatus</b></sub></a></td>
  <td align="center"><a href="https://github.com/gnuletik?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9059840?u=c37cef066ed05d5c25ea792bf839c622e1b5a3ec&v=4" width="100px;" alt=""/><br /><sub><b>Martin Desrumaux</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/tdakkota?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15220500?u=41aad36b4fcc340495e2d1d0193255e4010e6a59&v=4" width="100px;" alt=""/><br /><sub><b>tdakkota</b></sub></a></td>
  <td align="center"><a href="https://github.com/ibez92?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/21059325?v=4" width="100px;" alt=""/><br /><sub><b>Ivan</b></sub></a></td>
  <td align="center"><a href="http://www.gandarez.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/782854?u=08f8f3810c070b4f51c5ab34d349b83bee796fe7&v=4" width="100px;" alt=""/><br /><sub><b>Carlos Henrique Guardão Gandarez</b></sub></a></td>
  <td align="center"><a href="https://github.com/diegs?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/74719?u=bdfb13fd5280132f2a82f91cf9337d675472c489&v=4" width="100px;" alt=""/><br /><sub><b>Diego Pontoriero</b></sub></a></td>
  <td align="center"><a href="https://github.com/danielhelfand?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/34258252?u=68dad1d1d85d47c4bab2de0112ab495c89b6fd49&v=4" width="100px;" alt=""/><br /><sub><b>Daniel Helfand</b></sub></a></td>
  <td align="center"><a href="https://github.com/ahrtr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/30739825?u=7103d2d37664ace643337a0f648788c72132ae28&v=4" width="100px;" alt=""/><br /><sub><b>Benjamin Wang</b></sub></a></td>
  <td align="center"><a href="https://github.com/csilvers?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1445223?v=4" width="100px;" alt=""/><br /><sub><b>Craig Silverstein</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://www.linkedin.com/in/ifaisalalam?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24882101?u=596fdcd9e42c9e8bc1072975b828ca37d3164c34&v=4" width="100px;" alt=""/><br /><sub><b>Faisal Alam</b></sub></a></td>
  <td align="center"><a href="https://github.com/alexec?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1142830?u=c893f99c152727beb204caea70ed45ee936b20b2&v=4" width="100px;" alt=""/><br /><sub><b>Alex Collins</b></sub></a></td>
  <td align="center"><a href="https://nakabonne.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/19730728?u=88c465f1caf239c1852208116593939c22312c13&v=4" width="100px;" alt=""/><br /><sub><b>Ryo Nakao</b></sub></a></td>
  <td align="center"><a href="https://www.pedanticorderliness.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/343979?u=6443fee0e543d22b07b02edf0ed8fb1ce4943b5a&v=4" width="100px;" alt=""/><br /><sub><b>Ryan Olds</b></sub></a></td>
  <td align="center"><a href="https://github.com/matthewhughes934?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/34972397?u=5a8d68e52811e9b36fcdc53511d6b5352de3dcf2&v=4" width="100px;" alt=""/><br /><sub><b>Matthew Hughes</b></sub></a></td>
  <td align="center"><a href="https://github.com/macabu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1299138?u=8e157be586103823b212c5c9ada88ab2a9867ccf&v=4" width="100px;" alt=""/><br /><sub><b>Matheus Macabu</b></sub></a></td>
  <td align="center"><a href="https://tommy-muehle.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1351840?u=7d5b4339a1efe19fe5740314a4289eee59c20e6c&v=4" width="100px;" alt=""/><br /><sub><b>Tommy Mühle</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/thaJeztah?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1804568?u=ebc86d007fefd2b388d2a8da5f0e3d6f239ede2f&v=4" width="100px;" alt=""/><br /><sub><b>Sebastiaan van Stijn</b></sub></a></td>
  <td align="center"><a href="https://github.com/hanzo?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/248688?u=80e7b8ba522825019b599637277c3b3f2d384181&v=4" width="100px;" alt=""/><br /><sub><b>Hans Wernetti</b></sub></a></td>
  <td align="center"><a href="https://caarlos0.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/245435?v=4" width="100px;" alt=""/><br /><sub><b>Carlos Alexandro Becker</b></sub></a></td>
  <td align="center"><a href="https://github.com/Dominik-K?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5795847?u=e32b349860f30b6d08dd361399df310ab4bbf492&v=4" width="100px;" alt=""/><br /><sub><b>Dominik K.</b></sub></a></td>
  <td align="center"><a href="https://linkedin.com/in/jjtimmons/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13923102?u=6d064fbefa96e7d705cd821d1422138ebb8b87ed&v=4" width="100px;" alt=""/><br /><sub><b>Joshua Timmons</b></sub></a></td>
  <td align="center"><a href="https://dev.to/smyrman?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/75205?u=7c1c69aec977da78bf452fe2c2c8382999fdb42c&v=4" width="100px;" alt=""/><br /><sub><b>Sindre Røkenes Myren</b></sub></a></td>
  <td align="center"><a href="https://developer20.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1235620?u=8dcb00ac7132f4de19392d7f8b1b4e2b17e692b7&v=4" width="100px;" alt=""/><br /><sub><b>Bartłomiej Klimczak</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://gabnotes.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3630554?u=3dde57d38ab70e80d13ba5009ff466fd11fa8597&v=4" width="100px;" alt=""/><br /><sub><b>Gabriel Augendre</b></sub></a></td>
  <td align="center"><a href="https://github.com/fatanugraha?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4775076?u=ab6436fafde8e68f9f8dfe96935f904b078a9165&v=4" width="100px;" alt=""/><br /><sub><b>Fata Nugraha</b></sub></a></td>
  <td align="center"><a href="https://jimenolabs.net/about?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6826244?u=03bcd0f7f342886d3abc5281311c932e832b3146&v=4" width="100px;" alt=""/><br /><sub><b>M. Ángel Jimeno</b></sub></a></td>
  <td align="center"><a href="https://github.com/jrehwaldt?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/586617?v=4" width="100px;" alt=""/><br /><sub><b>Jan Oopkaup</b></sub></a></td>
  <td align="center"><a href="https://github.com/crsdrw?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/811010?v=4" width="100px;" alt=""/><br /><sub><b>Chris Drew</b></sub></a></td>
  <td align="center"><a href="https://teivah.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/934784?u=227613cb18fdee717ff7fc61360dddc542a55cab&v=4" width="100px;" alt=""/><br /><sub><b>Teiva Harsanyi</b></sub></a></td>
  <td align="center"><a href="https://github.com/bflad?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/189114?v=4" width="100px;" alt=""/><br /><sub><b>Brian Flad</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/cardil?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/540893?v=4" width="100px;" alt=""/><br /><sub><b>Chris Suszynski</b></sub></a></td>
  <td align="center"><a href="http://www.ivehearditbothways.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3922475?u=269fa198dabc1f436fa49fc45fa36d0ab85c590a&v=4" width="100px;" alt=""/><br /><sub><b>Sean McGinnis</b></sub></a></td>
  <td align="center"><a href="https://github.com/chenfeining?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/29514344?v=4" width="100px;" alt=""/><br /><sub><b>@chenfeining</b></sub></a></td>
  <td align="center"><a href="https://github.com/kailun-qin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12954187?u=a893a098076fa759905173eba04ef978a808c41d&v=4" width="100px;" alt=""/><br /><sub><b>Kailun Qin</b></sub></a></td>
  <td align="center"><a href="https://dottedmag.net?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/39945810?u=fcdadfc143065ea575d9d34b704bf06f0ff6d2e2&v=4" width="100px;" alt=""/><br /><sub><b>Misha Gusarov</b></sub></a></td>
  <td align="center"><a href="https://atlasgo.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7413593?u=cae4eee635d39364e7e7e259f81953729263ac65&v=4" width="100px;" alt=""/><br /><sub><b>Ariel Mashraki</b></sub></a></td>
  <td align="center"><a href="https://github.com/oscr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1570691?v=4" width="100px;" alt=""/><br /><sub><b>Oscar</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/idenx?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1843231?v=4" width="100px;" alt=""/><br /><sub><b>Denis Isaev</b></sub></a></td>
  <td align="center"><a href="https://github.com/Dreamacro?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8615343?u=327152a798c877f098eaa24ec15448e9e21df323&v=4" width="100px;" alt=""/><br /><sub><b>Dreamacro</b></sub></a></td>
  <td align="center"><a href="https://github.com/twpayne?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6942?u=227a4496aba8d3f526c53bdb6aa7713b22c56906&v=4" width="100px;" alt=""/><br /><sub><b>Tom Payne</b></sub></a></td>
  <td align="center"><a href="https://fsouza.blog?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/108725?u=272e1f5288c3706761865f846000fa81f175cf8f&v=4" width="100px;" alt=""/><br /><sub><b>@fsouza</b></sub></a></td>
  <td align="center"><a href="https://github.com/demoManito?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/27986239?u=88ab69eb88e79981e9ce6f8e73cb3bb29e873ac8&v=4" width="100px;" alt=""/><br /><sub><b>jessetang</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/siarhei-navatski?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/441946?u=3346608063a916c0b2f08abced998338b0dcb83c&v=4" width="100px;" alt=""/><br /><sub><b>Siarhei Navatski</b></sub></a></td>
  <td align="center"><a href="https://github.com/chrishalbert?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16158060?u=09eb6af70034c4cd09b545133e4b70598c7f6db7&v=4" width="100px;" alt=""/><br /><sub><b>Chris Halbert</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://bit.ly/linkedin_koya_iwamura?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28956664?u=8b8618534a848a548926b3ea222509ce2dc9debb&v=4" width="100px;" alt=""/><br /><sub><b>Koya IWAMURA</b></sub></a></td>
  <td align="center"><a href="https://www.suezawa.net/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1150301?u=ef7565231d0940a9bcf4b52496268cb56773ba0a&v=4" width="100px;" alt=""/><br /><sub><b>Hiroki Suezawa</b></sub></a></td>
  <td align="center"><a href="https://lafriks.id.lv/@me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/165205?u=efe2335d2197f524c25caa7abdfcb90b77eb8d98&v=4" width="100px;" alt=""/><br /><sub><b>Lauris BH</b></sub></a></td>
  <td align="center"><a href="https://github.com/jfrabaute?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/100247?v=4" width="100px;" alt=""/><br /><sub><b>Fabrice</b></sub></a></td>
  <td align="center"><a href="https://github.com/cblecker?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1431969?v=4" width="100px;" alt=""/><br /><sub><b>Christoph Blecker</b></sub></a></td>
  <td align="center"><a href="https://mbilski.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/909896?u=3fbb9dec515fff8277bfe64aa28677d2bb79c5f5&v=4" width="100px;" alt=""/><br /><sub><b>Mateusz Bilski</b></sub></a></td>
  <td align="center"><a href="https://github.com/grongor?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/972493?v=4" width="100px;" alt=""/><br /><sub><b>Jakub Chábek</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://yeya24.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25150124?u=0badd5f9ab8efd50a3f9a0c9cb2fd422aec1b07b&v=4" width="100px;" alt=""/><br /><sub><b>Ben Ye</b></sub></a></td>
  <td align="center"><a href="https://github.com/StephenBrown2?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1148665?u=b69e6fe797302f025a2d125e377e27f8ea0b8058&v=4" width="100px;" alt=""/><br /><sub><b>Stephen Brown II</b></sub></a></td>
  <td align="center"><a href="https://lufe.jp?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/65700946?u=e6c4b975cd1cb25726082ffddffb1b2b96779d98&v=4" width="100px;" alt=""/><br /><sub><b>lufe</b></sub></a></td>
  <td align="center"><a href="https://github.com/sg0hsmt?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6808111?v=4" width="100px;" alt=""/><br /><sub><b>@sg0hsmt</b></sub></a></td>
  <td align="center"><a href="https://github.com/RX14?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2788811?u=e8212dffab08bf0bed9c64380ee7fe7090e75f5e&v=4" width="100px;" alt=""/><br /><sub><b>Stephanie Wilde-Hobbs</b></sub></a></td>
  <td align="center"><a href="http://www.twitter.com/corylanou?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/585100?u=7a1c046e387bdd6358e970e75a9f8ff06d0cf75c&v=4" width="100px;" alt=""/><br /><sub><b>Cory LaNou</b></sub></a></td>
  <td align="center"><a href="https://github.com/vitalyisaev2?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5507054?u=a6015f53f3ce999d065218ecf43242f11b6c72ad&v=4" width="100px;" alt=""/><br /><sub><b>Vitaly Isaev</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="http://derekperkins.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3588778?v=4" width="100px;" alt=""/><br /><sub><b>Derek Perkins</b></sub></a></td>
  <td align="center"><a href="http://www.abemedia.co.uk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4355715?v=4" width="100px;" alt=""/><br /><sub><b>Adam Bouqdib</b></sub></a></td>
  <td align="center"><a href="https://github.com/thepwagner?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1559510?u=8d997016f3920edd57a45fdd2bce6ce7e59a7472&v=4" width="100px;" alt=""/><br /><sub><b>Pete Wagner</b></sub></a></td>
  <td align="center"><a href="https://github.com/renatosuero?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1093214?u=c37ab360f4fa3a6c7f168aaf706e8a47323dc101&v=4" width="100px;" alt=""/><br /><sub><b>Renato Suero</b></sub></a></td>
  <td align="center"><a href="https://github.com/rawen17?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/36483900?v=4" width="100px;" alt=""/><br /><sub><b>Buyanov Vladimir</b></sub></a></td>
  <td align="center"><a href="https://github.com/ansiwen?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7792669?u=f1da2f9c779c15bf9c69dac257c86180ba1591e0&v=4" width="100px;" alt=""/><br /><sub><b>Sven Anderson</b></sub></a></td>
  <td align="center"><a href="https://github.com/bvwells?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22873967?v=4" width="100px;" alt=""/><br /><sub><b>Ben Wells</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/chappjc?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9373513?u=e78e21f230dd575a53a060c37dee051806ae0572&v=4" width="100px;" alt=""/><br /><sub><b>Jonathan Chappelow</b></sub></a></td>
  <td align="center"><a href="https://www.oshino.meme?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25030997?u=6c6b7c662e1c7047ae3f25fe284f69a74e6679d6&v=4" width="100px;" alt=""/><br /><sub><b>Yuki Okushi</b></sub></a></td>
  <td align="center"><a href="https://www.build4.fun/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1975118?u=df7d2377689da4306390f138304aef5c8dde5ec4&v=4" width="100px;" alt=""/><br /><sub><b>hbc</b></sub></a></td>
  <td align="center"><a href="https://blog.xen0n.name?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1175567?u=f334fed91b1bc0cab3b71b58485c9e09c832d2d7&v=4" width="100px;" alt=""/><br /><sub><b>WÁNG Xuěruì</b></sub></a></td>
  <td align="center"><a href="https://github.com/796RCP92VZ?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/36819295?v=4" width="100px;" alt=""/><br /><sub><b>@796RCP92VZ</b></sub></a></td>
  <td align="center"><a href="https://dunglas.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/57224?u=a7ed2cf3f0ae84c9e06925b94091b85a7d6324b0&v=4" width="100px;" alt=""/><br /><sub><b>Kévin Dunglas</b></sub></a></td>
  <td align="center"><a href="https://github.com/ewohltman?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5953186?u=bf31ce63008802393b3b58c3bd84b8dae76b3946&v=4" width="100px;" alt=""/><br /><sub><b>Eric Wohltman</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://hachyderm.io/@clebs?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1059661?u=21de2d16ebd639a0e0a22952abd216f5af2709e1&v=4" width="100px;" alt=""/><br /><sub><b>Borja Clemente</b></sub></a></td>
  <td align="center"><a href="https://github.com/zalenskivolt?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/33487318?u=2e9a5cc35f6cde31c806274ef1b5b9ba100cba4a&v=4" width="100px;" alt=""/><br /><sub><b>Mattias de Zalenski</b></sub></a></td>
  <td align="center"><a href="https://aldanalonghi.me/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/60699220?u=415703168618923fac4b3ee83ac903c947ee4fa9&v=4" width="100px;" alt=""/><br /><sub><b>@AlduLonghi</b></sub></a></td>
  <td align="center"><a href="https://www.justindfuller.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11914897?u=2f5ea397ebbce3ecc18cf05e5b3c36f24dec7c7f&v=4" width="100px;" alt=""/><br /><sub><b>Justin Fuller</b></sub></a></td>
  <td align="center"><a href="https://github.com/masibw?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43804414?u=bf41b0908e132619f53489971fdb9e102e413d7d&v=4" width="100px;" alt=""/><br /><sub><b>masibw</b></sub></a></td>
  <td align="center"><a href="https://github.com/navijation?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16366921?u=3e1f181074b7d95d749ccbef64f5082f41aa4a2c&v=4" width="100px;" alt=""/><br /><sub><b>Navneeth Jayendran</b></sub></a></td>
  <td align="center"><a href="https://github.com/soniah?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/56102?u=39088fc794a8635849e06ba6e8a5ef8a75b194cf&v=4" width="100px;" alt=""/><br /><sub><b>Sonia Hamilton</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/black-06?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/50364282?u=bec671ff944adf97903b9239cda0cf1657fa065f&v=4" width="100px;" alt=""/><br /><sub><b>@black-06</b></sub></a></td>
  <td align="center"><a href="https://github.com/Inuart?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/441979?u=78fa97a9c09815a0b6369414333d508b382de643&v=4" width="100px;" alt=""/><br /><sub><b>Eduard Castany</b></sub></a></td>
  <td align="center"><a href="http://g7o.today?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/145909?u=a34cf5793b1a43f3ba2060fc320a416e03e85c54&v=4" width="100px;" alt=""/><br /><sub><b>Gianguido Sorà</b></sub></a></td>
  <td align="center"><a href="https://github.com/oksana-grishchenko?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/91597950?u=038a86cf86b64cd9ba59e87671a2acc37992b254&v=4" width="100px;" alt=""/><br /><sub><b>Oksana Grishchenko</b></sub></a></td>
  <td align="center"><a href="https://github.com/G-Rath?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3151613?v=4" width="100px;" alt=""/><br /><sub><b>Gareth Jones</b></sub></a></td>
  <td align="center"><a href="https://github.com/derElektrobesen?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4015637?u=8020c4cb1c123fe3ec6f393ea75b1927e92565a3&v=4" width="100px;" alt=""/><br /><sub><b>Berezhnoy Pavel</b></sub></a></td>
  <td align="center"><a href="https://sluongng.gitlab.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/26684313?u=7a89fa4dcacc000059fe3f67489d12a6f7fef8cd&v=4" width="100px;" alt=""/><br /><sub><b>Son Luong Ngoc</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://leduc.uk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/55436491?u=d3eb8998d0fb116bcda344b0489406c3cb24ef9a&v=4" width="100px;" alt=""/><br /><sub><b>Henry</b></sub></a></td>
  <td align="center"><a href="https://aofeisheng.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5037285?u=2f1c2a9317d995c4a84461d5197c552ab0d89e43&v=4" width="100px;" alt=""/><br /><sub><b>Aofei Sheng</b></sub></a></td>
  <td align="center"><a href="https://github.com/rnben?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/21094569?u=85af7d87fae89b3c720af1d6a07165201441093e&v=4" width="100px;" alt=""/><br /><sub><b>rnben</b></sub></a></td>
  <td align="center"><a href="https://github.com/mxpv?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/865334?u=a47007c3fc95832646d2c935da12aaff81a48ca3&v=4" width="100px;" alt=""/><br /><sub><b>Maksym Pavlenko</b></sub></a></td>
  <td align="center"><a href="http://sitano.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/564610?u=1830fc4bffb6829093a7f4404ee581c43d909c36&v=4" width="100px;" alt=""/><br /><sub><b>Ivan Prisyazhnyy</b></sub></a></td>
  <td align="center"><a href="https://github.com/ngehrsitz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/45375059?v=4" width="100px;" alt=""/><br /><sub><b>@ngehrsitz</b></sub></a></td>
  <td align="center"><a href="https://reese.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6980197?u=18a8e25bd6059057d9fdda1115db33ec184ddd6b&v=4" width="100px;" alt=""/><br /><sub><b>John Reese</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/mgabeler-lee-6rs?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/41014492?u=61831102f84d58f6906a775bf40b7a5cf24ba625&v=4" width="100px;" alt=""/><br /><sub><b>Matthew Gabeler-Lee</b></sub></a></td>
  <td align="center"><a href="https://github.com/mattdowdell?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/20556265?v=4" width="100px;" alt=""/><br /><sub><b>Matthew Dowdell</b></sub></a></td>
  <td align="center"><a href="https://jlucktay.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/460028?u=2cbe899ed33b64bdc02128467bc42f0bc2c7330e&v=4" width="100px;" alt=""/><br /><sub><b>James Lucktaylor</b></sub></a></td>
  <td align="center"><a href="http://inaba.hatenablog.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12012186?u=b0c31c6af5c29f2ead17cd28ca1ef9925f556331&v=4" width="100px;" alt=""/><br /><sub><b>Masahiro Furudate</b></sub></a></td>
  <td align="center"><a href="https://github.com/dhui?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/896205?u=3e4fbfd18cabace9d5f7c72b7e1da12dcce5b955&v=4" width="100px;" alt=""/><br /><sub><b>Dale Hui</b></sub></a></td>
  <td align="center"><a href="https://github.com/ondrej-fabry?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/32484950?u=34434913a7774f1db6558cb6c4ee5f759b2e13ee&v=4" width="100px;" alt=""/><br /><sub><b>Ondrej Fabry</b></sub></a></td>
  <td align="center"><a href="https://github.com/atzoum?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2481587?u=48a1520418d6a39f78c9fa097da06e0e996aac3f&v=4" width="100px;" alt=""/><br /><sub><b>Aris Tzoumas</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://javorszky.co.uk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1196299?u=45a315483c34993c7ffeff5ebe7a312904e27c47&v=4" width="100px;" alt=""/><br /><sub><b>Gabor Javorszky</b></sub></a></td>
  <td align="center"><a href="https://hori-ryota.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2936501?u=9e5c0a6fd206cfa8d77c20f5f0806db43e777b09&v=4" width="100px;" alt=""/><br /><sub><b>hori-ryota</b></sub></a></td>
  <td align="center"><a href="https://kishaningithub.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/763760?u=55a5f3e937025e54e2736ca1fc38f0ab3788527f&v=4" width="100px;" alt=""/><br /><sub><b>Kishan B</b></sub></a></td>
  <td align="center"><a href="https://github.com/proton-ab?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25139420?u=53918e67ce92a25351b1ea2ee9ce98435bea0cc8&v=4" width="100px;" alt=""/><br /><sub><b>proton</b></sub></a></td>
  <td align="center"><a href="https://eric.jain.name/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1323903?v=4" width="100px;" alt=""/><br /><sub><b>Eric Jain</b></sub></a></td>
  <td align="center"><a href="https://github.com/Ghvstcode?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/46195831?u=3d2cf08a0e737d60e2c7c65af7f5fd247ad2b47c&v=4" width="100px;" alt=""/><br /><sub><b>Ghvst Code</b></sub></a></td>
  <td align="center"><a href="https://saiko.tech?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5138316?u=a8fc4f0dd15abd2e5c05e393b575c8ee71cc1174&v=4" width="100px;" alt=""/><br /><sub><b>Markus</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://sspaink.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3441183?u=4e792fd6e0ba6852a7d17675f51e2efc74b07381&v=4" width="100px;" alt=""/><br /><sub><b>Sebastian Spaink</b></sub></a></td>
  <td align="center"><a href="https://github.com/laverya?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2318911?u=12f6803204811ffd8ce33c1fef0281554fdcbb20&v=4" width="100px;" alt=""/><br /><sub><b>Andrew Lavery</b></sub></a></td>
  <td align="center"><a href="https://github.com/mfine?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/60851?u=f9dee708e1940cc4d3b442f729aa064cfa65d3f8&v=4" width="100px;" alt=""/><br /><sub><b>Mark Fine</b></sub></a></td>
  <td align="center"><a href="https://github.com/deathbots?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7408170?u=b707d200ee986d56379a33880f3afb39c8f49656&v=4" width="100px;" alt=""/><br /><sub><b>Rory Prendergast</b></sub></a></td>
  <td align="center"><a href="https://github.com/Bysmyyr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3306756?u=0acd0c98e43ddd45ec78f29582724c8b2ed24265&v=4" width="100px;" alt=""/><br /><sub><b>Olli Raula</b></sub></a></td>
  <td align="center"><a href="https://github.com/tariq1890?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2658224?u=5719f58847e3414945290592663045c82b04b272&v=4" width="100px;" alt=""/><br /><sub><b>Tariq</b></sub></a></td>
  <td align="center"><a href="https://github.com/pstibrany?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/895919?u=d2de54fb88e2b270f49b647d7b4986b4a4f3c146&v=4" width="100px;" alt=""/><br /><sub><b>Peter Štibraný</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/kaka19ace?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1320568?u=9f02e3ae234ea1e76a3682ada8166c905104f555&v=4" width="100px;" alt=""/><br /><sub><b>kaixiang zhong</b></sub></a></td>
  <td align="center"><a href="https://github.com/ced42?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17880812?u=581ff1cda9a94c44e50e668e5310c4477b63a9d8&v=4" width="100px;" alt=""/><br /><sub><b>@ced42</b></sub></a></td>
  <td align="center"><a href="https://github.com/dgsb?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5495748?v=4" width="100px;" alt=""/><br /><sub><b>David Bariod</b></sub></a></td>
  <td align="center"><a href="http://bitbin.de/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/429763?u=dd2c1e820d0d41d3f804cf4ba39ae6a6995673e2&v=4" width="100px;" alt=""/><br /><sub><b>Stephen Benjamin</b></sub></a></td>
  <td align="center"><a href="https://github.com/kkHAIKE?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/64772?u=6d4d98531039b172e127fadfb3d9c70c150c42d6&v=4" width="100px;" alt=""/><br /><sub><b>@kkHAIKE</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/david-hsing-yu-chen/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17587061?v=4" width="100px;" alt=""/><br /><sub><b>Hsing-Yu (David) Chen</b></sub></a></td>
  <td align="center"><a href="https://hachyderm.io/@developerguy?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16693043?u=cbf54ecddb35755aaab1bc043de89224ee495202&v=4" width="100px;" alt=""/><br /><sub><b>Batuhan Apaydın</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://mostafa.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/54546?u=a6de7cb6258f15701ede0977ade995c7135e39b9&v=4" width="100px;" alt=""/><br /><sub><b>Mostafa Moradian</b></sub></a></td>
  <td align="center"><a href="https://github.com/SeigeC?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/39756973?u=192887560f2eea124cb28de6c9af9f64fcf30b32&v=4" width="100px;" alt=""/><br /><sub><b>过客龙门</b></sub></a></td>
  <td align="center"><a href="https://github.com/beono?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/539474?u=6a91ec994f805519330015aa6251677a307ada59&v=4" width="100px;" alt=""/><br /><sub><b>Eldar Rakhimberdin</b></sub></a></td>
  <td align="center"><a href="https://blog.schoentoon.blue?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/417618?u=294670670fd504a353586a57b32cf0fe4843f8eb&v=4" width="100px;" alt=""/><br /><sub><b>Toon Schoenmakers</b></sub></a></td>
  <td align="center"><a href="https://github.com/cezarsa?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11041?u=cde690e3dd7a6ebf895e11f3ff144b27f8fcb46c&v=4" width="100px;" alt=""/><br /><sub><b>Cezar Sá Espinola</b></sub></a></td>
  <td align="center"><a href="https://github.com/benpaxton-hf?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24317933?v=4" width="100px;" alt=""/><br /><sub><b>Ben Paxton</b></sub></a></td>
  <td align="center"><a href="https://connoradams.co.uk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10026538?u=532bda717283aa1bba2d47f74b19107787fead82&v=4" width="100px;" alt=""/><br /><sub><b>Connor Adams</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://draven.co/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6493255?u=856f82ae98a83bcee1ddbb7e3760e69f2343c496&v=4" width="100px;" alt=""/><br /><sub><b>Draven</b></sub></a></td>
  <td align="center"><a href="https://github.com/dcu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/73729?v=4" width="100px;" alt=""/><br /><sub><b>David Cuadrado</b></sub></a></td>
  <td align="center"><a href="https://github.com/kavu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1994?u=f544b0f2cb32df06f36677ffad5b06fc2caf6215&v=4" width="100px;" alt=""/><br /><sub><b>Max Riveiro</b></sub></a></td>
  <td align="center"><a href="https://martins.irbe.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13367583?u=9465cb342f4468df163a2aab2a3a81261fcaa26b&v=4" width="100px;" alt=""/><br /><sub><b>Mārtiņš Irbe</b></sub></a></td>
  <td align="center"><a href="https://elon.fun/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8433465?v=4" width="100px;" alt=""/><br /><sub><b>Yilong Li</b></sub></a></td>
  <td align="center"><a href="https://brito.com.br?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7620947?u=86baf7dc30b49b30a8efc5947ea4b1795969c6bf&v=4" width="100px;" alt=""/><br /><sub><b>Rodrigo Brito</b></sub></a></td>
  <td align="center"><a href="https://techknowlogick.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/164197?u=7c3342cf6315694c2248b233571856dc67e7c078&v=4" width="100px;" alt=""/><br /><sub><b>@techknowlogick</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/ytakaya?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28138590?u=b68d004404fb8b2910d6500babf24a753683f80c&v=4" width="100px;" alt=""/><br /><sub><b>takaya</b></sub></a></td>
  <td align="center"><a href="https://github.com/craigfurman?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4772216?u=31c29a937fa59a82f4a23d3beea287f42e6a7e2c&v=4" width="100px;" alt=""/><br /><sub><b>Craig Furman</b></sub></a></td>
  <td align="center"><a href="https://github.com/ttys3?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/41882455?u=f48189390ce1ba2cb973778538667e5b2c9eb8f3&v=4" width="100px;" alt=""/><br /><sub><b>@ttys3</b></sub></a></td>
  <td align="center"><a href="https://github.com/mfreeman451?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1821930?u=f82814f64334bece992b92c4648b84643a609d80&v=4" width="100px;" alt=""/><br /><sub><b>Michael Freeman</b></sub></a></td>
  <td align="center"><a href="https://github.com/marksartdev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/34810318?u=a1865af09b2fc37cd72885f6d7f38af949c63e1c&v=4" width="100px;" alt=""/><br /><sub><b>Mark Sart</b></sub></a></td>
  <td align="center"><a href="https://jawa.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/194275?u=d2a659a214ee5ddaa1b14a0537caabdc651389c9&v=4" width="100px;" alt=""/><br /><sub><b>Joshua Rubin</b></sub></a></td>
  <td align="center"><a href="https://vk.com/danil42russia?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6605618?u=59d4d721573ba305263423ce9886f234c99c1823&v=4" width="100px;" alt=""/><br /><sub><b>Danil Ovchinnikov</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://rafaelfranco.es?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6237457?u=40412ebef30755d37e88b6a3e3b1748eb5f73b59&v=4" width="100px;" alt=""/><br /><sub><b>Rafael Franco</b></sub></a></td>
  <td align="center"><a href="https://Telegram: @kseniadumpling ?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/39095863?u=4e140b5b4c421eb3248a0e69986c42b78952a123&v=4" width="100px;" alt=""/><br /><sub><b>Ksenia Rogova</b></sub></a></td>
  <td align="center"><a href="https://blog.vaughany.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/381767?v=4" width="100px;" alt=""/><br /><sub><b>Paul Vaughan</b></sub></a></td>
  <td align="center"><a href="https://jaredallard.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2391349?u=0293413bf8b4be72e07db70655ffa83885315708&v=4" width="100px;" alt=""/><br /><sub><b>Jared Allard</b></sub></a></td>
  <td align="center"><a href="http://stainlessed.co.uk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/151272?u=8a3688637befe674727827e9c2050c7c5b016c26&v=4" width="100px;" alt=""/><br /><sub><b>Glen Mailer</b></sub></a></td>
  <td align="center"><a href="https://github.com/ian-howell?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10422579?u=ff9c375b5ee2c41b4bdd20b1e32a6fc40bd6ad0f&v=4" width="100px;" alt=""/><br /><sub><b>Ian Howell</b></sub></a></td>
  <td align="center"><a href="https://github.com/hugelgupf?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1994130?u=69b9df9c7c4bbe26359c0b8c44051a8bde992b29&v=4" width="100px;" alt=""/><br /><sub><b>Chris K</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="http://ssgreg.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1574981?u=a5afff1d2f056a0ac05be2f5464afa5bc6d33631&v=4" width="100px;" alt=""/><br /><sub><b>Grigory Zubankov</b></sub></a></td>
  <td align="center"><a href="https://github.com/xxpxxxxp?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1585918?u=6c092f7b5db6e7d6842cc843148c92604c2fa3c7&v=4" width="100px;" alt=""/><br /><sub><b>@xxpxxxxp</b></sub></a></td>
  <td align="center"><a href="https://github.com/shmsr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/51480165?u=fdfea6d16b1e7ff8d272bf127078d78d10e1a08a&v=4" width="100px;" alt=""/><br /><sub><b>subham sarkar</b></sub></a></td>
  <td align="center"><a href="https://rleungx.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/35896542?u=b073e93cd4767203fccaaf008956e029d429ae6d&v=4" width="100px;" alt=""/><br /><sub><b>Ryan Leung</b></sub></a></td>
  <td align="center"><a href="https://www.byrnedo.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5528491?u=9ac8f3a6048553df8e59d6af46fa19cfd5babde5&v=4" width="100px;" alt=""/><br /><sub><b>Donal Byrne</b></sub></a></td>
  <td align="center"><a href="https://github.com/trajan0x?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/83933037?u=a4289b193e2b28f5840fb45242f3dc55c740e937&v=4" width="100px;" alt=""/><br /><sub><b>@trajan0x</b></sub></a></td>
  <td align="center"><a href="https://github.com/ykadowak?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/60080334?u=4b265f54e75dddad20666cee52c9bf6a6d26ba2c&v=4" width="100px;" alt=""/><br /><sub><b>Yusuke Kadowaki</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/CfirTsabari?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2716357?u=06dce8b85d85e22e7583c0c72ba81b4886f6d081&v=4" width="100px;" alt=""/><br /><sub><b>@CfirTsabari</b></sub></a></td>
  <td align="center"><a href="https://github.com/ImprintNav?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/125316979?v=4" width="100px;" alt=""/><br /><sub><b>Navneeth Jayendran</b></sub></a></td>
  <td align="center"><a href="https://media.giphy.com/media/XxWjoyOLi4mkM/giphy.gif?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24299864?u=5566396a3d5dcf65fec65a411b1d9dc4fd4bf085&v=4" width="100px;" alt=""/><br /><sub><b>Marko</b></sub></a></td>
  <td align="center"><a href="https://github.com/cflewis?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43708?u=20ffa568c463916d20483acee34b09dd26581dec&v=4" width="100px;" alt=""/><br /><sub><b>Chris Lewis</b></sub></a></td>
  <td align="center"><a href="https://pararang.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8720184?v=4" width="100px;" alt=""/><br /><sub><b>Muhammad Ikhsan</b></sub></a></td>
  <td align="center"><a href="https://github.com/AntonBraer?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/94956080?v=4" width="100px;" alt=""/><br /><sub><b>Anton Braer</b></sub></a></td>
  <td align="center"><a href="https://github.com/JaeguKim?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22807942?u=e7f381e6b64699f644af1bd5170e02f6087a26f0&v=4" width="100px;" alt=""/><br /><sub><b>Jaegoo Kim</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/reflechant?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5537648?v=4" width="100px;" alt=""/><br /><sub><b>Roman Gerasimov</b></sub></a></td>
  <td align="center"><a href="https://github.com/gleichda?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15176026?u=7555939416df1132efc87906be73f15846557db3&v=4" width="100px;" alt=""/><br /><sub><b>David Gleich</b></sub></a></td>
  <td align="center"><a href="https://github.com/connorszczepaniak-wk?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/85500372?u=3c7d6db069c7c2c72a7c198482490b3577c3daaa&v=4" width="100px;" alt=""/><br /><sub><b>@connorszczepaniak-wk</b></sub></a></td>
  <td align="center"><a href="https://github.com/yuqengo?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17488521?v=4" width="100px;" alt=""/><br /><sub><b>yuqengo</b></sub></a></td>
  <td align="center"><a href="https://github.com/thejan2009?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1621134?v=4" width="100px;" alt=""/><br /><sub><b>Dejan Benedik</b></sub></a></td>
  <td align="center"><a href="https://linkedin.com/in/rodrigc?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1895943?v=4" width="100px;" alt=""/><br /><sub><b>Craig Rodrigues</b></sub></a></td>
  <td align="center"><a href="https://github.com/Oloruntobi1?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/37913305?u=6a6a8180ef73fe5f51e2f21352fb8a85e30b7403&v=4" width="100px;" alt=""/><br /><sub><b>Askari</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/itsamirhn?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/19665344?u=4af46868a7a9ca5176e26da03aaeabf1c235c6ff&v=4" width="100px;" alt=""/><br /><sub><b>Amir Hosseini</b></sub></a></td>
  <td align="center"><a href="https://davidjb.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1002811?v=4" width="100px;" alt=""/><br /><sub><b>David Beitey</b></sub></a></td>
  <td align="center"><a href="https://brandur.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/96890?u=6e19efda669fd696053dfa8976e3ac3b3c16fbd4&v=4" width="100px;" alt=""/><br /><sub><b>Brandur Leach</b></sub></a></td>
  <td align="center"><a href="https://github.com/drichelson?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/602409?u=796941f98f6137c6bd1979d1434b69a15871059b&v=4" width="100px;" alt=""/><br /><sub><b>Dan Richelson</b></sub></a></td>
  <td align="center"><a href="https://github.com/titusjaka?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5277948?u=784515fda5ba2358fdc0b67ab9f654a70d4a426b&v=4" width="100px;" alt=""/><br /><sub><b>Denis Titusov</b></sub></a></td>
  <td align="center"><a href="https://t.me/pershin_daniil?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/52123477?u=71a1a20203043932f36b2995d9fbda2b320303a0&v=4" width="100px;" alt=""/><br /><sub><b>Daniil Pershin</b></sub></a></td>
  <td align="center"><a href="https://github.com/vterdunov?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13706147?v=4" width="100px;" alt=""/><br /><sub><b>Terdunov Vyacheslav</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/sean-?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/349516?u=30344c70395b9ae7cd713d628dd2579f4372037c&v=4" width="100px;" alt=""/><br /><sub><b>Sean Chittenden</b></sub></a></td>
  <td align="center"><a href="http://teawater.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/432382?u=b97108437f237fc551c87147288740f08504c0fa&v=4" width="100px;" alt=""/><br /><sub><b>Hui Zhu</b></sub></a></td>
  <td align="center"><a href="https://github.com/Harsimran1?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8309130?u=827935180bf29dbed77f16f0fd4783fae3a7e5e0&v=4" width="100px;" alt=""/><br /><sub><b>@Harsimran1</b></sub></a></td>
  <td align="center"><a href="https://rinsuki.net/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6533808?u=f179c4c07bd599d928a3169ba38c37f9a6402372&v=4" width="100px;" alt=""/><br /><sub><b>rinsuki</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/syndbg?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6031925?u=c4e3f377319dbe9b87b0c7fe4b06d9ba49895c9f&v=4" width="100px;" alt=""/><br /><sub><b>Anton Antonov</b></sub></a></td>
  <td align="center"><a href="https://github.com/hn8?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10730886?v=4" width="100px;" alt=""/><br /><sub><b>@hn8</b></sub></a></td>
  <td align="center"><a href="https://github.com/extemporalgenome?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/536740?v=4" width="100px;" alt=""/><br /><sub><b>Kevin Gillette</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://milas.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/841263?u=e9fa26ee58f8a63920ac3e7364255ca81114bef3&v=4" width="100px;" alt=""/><br /><sub><b>Milas Bowman</b></sub></a></td>
  <td align="center"><a href="https://github.com/credativ-dar?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/104132637?v=4" width="100px;" alt=""/><br /><sub><b>@credativ-dar</b></sub></a></td>
  <td align="center"><a href="https://github.com/SophisticaSean?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2059265?u=d911cbe69886c140097fa6ee448153245866137d&v=4" width="100px;" alt=""/><br /><sub><b>Sean Lewis</b></sub></a></td>
  <td align="center"><a href="https://github.com/elliots?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/622455?v=4" width="100px;" alt=""/><br /><sub><b>☃ Elliot Shepherd</b></sub></a></td>
  <td align="center"><a href="https://nvartolomei.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/543193?u=972ac6bbb1e48aa474e8677fd3b9368fe61e4872&v=4" width="100px;" alt=""/><br /><sub><b>Nicolae Vartolomei</b></sub></a></td>
  <td align="center"><a href="https://Boehringer-Ingelheim.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/873565?u=abceeaf3aaa299e89ad07ee33ebc9e17c0f3258d&v=4" width="100px;" alt=""/><br /><sub><b>Martin Etmajer</b></sub></a></td>
  <td align="center"><a href="https://github.com/fisherxu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28776356?u=16bb46f48840d43aaa8bf3692de51c26309ab27e&v=4" width="100px;" alt=""/><br /><sub><b>Fisher Xu</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/matthewpoer?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/727257?u=5efb699d02d7e627bbbdccafa804066b177e170b&v=4" width="100px;" alt=""/><br /><sub><b>Matthew Poer</b></sub></a></td>
  <td align="center"><a href="https://codyleyhan.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11651981?u=ee4ee8f95ae169207fb701e059f076ecadc51055&v=4" width="100px;" alt=""/><br /><sub><b>Cody Ley-Han</b></sub></a></td>
  <td align="center"><a href="https://github.com/darklore?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/958690?u=f23d414023f297c8cef1b2532c7e671c726bc343&v=4" width="100px;" alt=""/><br /><sub><b>@darklore</b></sub></a></td>
  <td align="center"><a href="https://github.com/to6ka?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/29016937?v=4" width="100px;" alt=""/><br /><sub><b>@to6ka</b></sub></a></td>
  <td align="center"><a href="https://github.com/evalexpr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/23485511?u=5c6b8d5b34333b88d58c11786812815b550aae94&v=4" width="100px;" alt=""/><br /><sub><b>Wilkins</b></sub></a></td>
  <td align="center"><a href="https://hachyderm.io/@cjkreklow?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/55775?u=8ee6cac6c286964a9c15a73e2fa48de097700d79&v=4" width="100px;" alt=""/><br /><sub><b>Collin Kreklow</b></sub></a></td>
  <td align="center"><a href="http://marcin.owsiany.pl/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/489420?u=e236c95628ea05d56bdc0b3d3ae01be35f2fb1d8&v=4" width="100px;" alt=""/><br /><sub><b>Marcin Owsiany</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/cjcjameson?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6885889?u=0b15031859ad908eb11af83878000ab09bed5609&v=4" width="100px;" alt=""/><br /><sub><b>C.J. Jameson</b></sub></a></td>
  <td align="center"><a href="https://github.com/JacekDuszenko?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24210015?u=895d98b6a4ff12621f58aa3afec4e2bb0b18e510&v=4" width="100px;" alt=""/><br /><sub><b>Jacek</b></sub></a></td>
  <td align="center"><a href="https://pfish.zone/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6622003?v=4" width="100px;" alt=""/><br /><sub><b>paul fisher</b></sub></a></td>
  <td align="center"><a href="https://github.com/ofw?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4242339?u=0ccfaabc4f092862ac479fec6fea4a5fb0c247f2&v=4" width="100px;" alt=""/><br /><sub><b>@ofw</b></sub></a></td>
  <td align="center"><a href="https://www.rafik.ca?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/767223?u=2ff01f475dc95599d398ccda2dddb326fd03cf3e&v=4" width="100px;" alt=""/><br /><sub><b>Rafik Draoui</b></sub></a></td>
  <td align="center"><a href="https://github.com/mdelah?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4904544?u=49076722c998f118fca18b532862ce0eb445e6b2&v=4" width="100px;" alt=""/><br /><sub><b>Miles Delahunty</b></sub></a></td>
  <td align="center"><a href="https://github.com/outcatcher?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8591561?u=805a75f3eda187538ba43ed176594c8ea7535802&v=4" width="100px;" alt=""/><br /><sub><b>Anton Kachurin</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://nico.ismaili.de?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/11136006?u=dafba6459cdd237535e7dd34cff6cedf8aec9b11&v=4" width="100px;" alt=""/><br /><sub><b>Nico Ismaili</b></sub></a></td>
  <td align="center"><a href="https://www.bbkane.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6081085?u=cfea130a8721b472b99feb656c3579251e5e8e7c&v=4" width="100px;" alt=""/><br /><sub><b>Benjamin Kane</b></sub></a></td>
  <td align="center"><a href="https://github.com/philiplinell?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3718865?u=91967dcf7fd10097737fe97050913dcbc08af1bc&v=4" width="100px;" alt=""/><br /><sub><b>Philip Linell</b></sub></a></td>
  <td align="center"><a href="https://github.com/herman26?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28861153?u=e915bacc8f3d90dda5831e683bcd9b71eee7498e&v=4" width="100px;" alt=""/><br /><sub><b>Herman van Zyl</b></sub></a></td>
  <td align="center"><a href="https://thearchivelog.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/44025432?u=8d9a7d5762f01774fdb88a940bb48c0257d5db63&v=4" width="100px;" alt=""/><br /><sub><b>Jongwoo Han</b></sub></a></td>
  <td align="center"><a href="https://github.com/surik?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/708165?u=522be01ebc4fddb969d98da89cff13df4a6ca681&v=4" width="100px;" alt=""/><br /><sub><b>Yury Gargay</b></sub></a></td>
  <td align="center"><a href="https://clifton.kaznocha.com.?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1851985?v=4" width="100px;" alt=""/><br /><sub><b>Clifton Kaznocha</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://jcarreras.es?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/993186?u=1e08d07e8759e0e7df8a4d9ba0d21e60f3f6a86d&v=4" width="100px;" alt=""/><br /><sub><b>Jan Carreras</b></sub></a></td>
  <td align="center"><a href="https://github.com/aimuz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17666471?u=43238e20a87a2109b55cf6770f052ab19845bca9&v=4" width="100px;" alt=""/><br /><sub><b>aimuz</b></sub></a></td>
  <td align="center"><a href="https://github.com/3100?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1296276?u=6bf65027d5cbe8af3ea616b328e6f792fa1c138a&v=4" width="100px;" alt=""/><br /><sub><b>Ryo Sato</b></sub></a></td>
  <td align="center"><a href="https://github.com/ezimanyi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1391982?u=1f7bb4075bdb56f5d76bbbca2e5e245e3b11b9f9&v=4" width="100px;" alt=""/><br /><sub><b>Eric Zimanyi</b></sub></a></td>
  <td align="center"><a href="https://github.com/bbernays?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/30294676?u=6a5769fa916310ef41791264cf3824f7b4389314&v=4" width="100px;" alt=""/><br /><sub><b>Ben Bernays</b></sub></a></td>
  <td align="center"><a href="https://ectobit.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2791202?u=04e899087611d5a698e236a8f2db6593b81015da&v=4" width="100px;" alt=""/><br /><sub><b>Boban Acimovic</b></sub></a></td>
  <td align="center"><a href="http://pacman.blog.br?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/59438?v=4" width="100px;" alt=""/><br /><sub><b>Tiago Peczenyj</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/strantalis?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/18211470?u=9b0a8a42f152e1d1b3f20c8c45b49fdebcb4d947&v=4" width="100px;" alt=""/><br /><sub><b>Sean Trantalis</b></sub></a></td>
  <td align="center"><a href="https://github.com/BorzdeG?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2332528?v=4" width="100px;" alt=""/><br /><sub><b>Viktor Alenkov</b></sub></a></td>
  <td align="center"><a href="https://github.com/ealves-pt?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5909095?u=3496cead0cd29206ebbe5ca8b61b427ccfd13cbb&v=4" width="100px;" alt=""/><br /><sub><b>Eduardo Alves</b></sub></a></td>
  <td align="center"><a href="https://github.com/alexbagnolini?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/23359609?u=abf04716f5a19fcf7c126efc6d8e882cbee63600&v=4" width="100px;" alt=""/><br /><sub><b>Alex Bagnolini</b></sub></a></td>
  <td align="center"><a href="https://github.com/hummerd?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1921665?u=fc42a642da357e81fb41987d69aa2efaa85e81c3&v=4" width="100px;" alt=""/><br /><sub><b>Dima</b></sub></a></td>
  <td align="center"><a href="https://github.com/dajohi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3308193?u=451dc7ae6de642e9dc40c02fcebc51c4ce4a7323&v=4" width="100px;" alt=""/><br /><sub><b>David Hill</b></sub></a></td>
  <td align="center"><a href="http://troyronda.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1906596?v=4" width="100px;" alt=""/><br /><sub><b>Troy Ronda</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/mirecl?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/28476324?u=6109606558f38dff064839b20b54320ba8a29a01&v=4" width="100px;" alt=""/><br /><sub><b>Andrey Grazhdankov</b></sub></a></td>
  <td align="center"><a href="https://gitlab.com/ashmckenzie?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9525?u=372034dbe17b31ee9c8444c1d2f4526cdc0b925e&v=4" width="100px;" alt=""/><br /><sub><b>Ash McKenzie</b></sub></a></td>
  <td align="center"><a href="https://github.com/gessnerfl?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6311334?v=4" width="100px;" alt=""/><br /><sub><b>Florian Gessner</b></sub></a></td>
  <td align="center"><a href="https://github.com/osamingo?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1390409?u=e86592e414db66d6ac047a242e294bca95b4ea56&v=4" width="100px;" alt=""/><br /><sub><b>Osamu TONOMORI</b></sub></a></td>
  <td align="center"><a href="https://github.com/liubog2008?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7920667?v=4" width="100px;" alt=""/><br /><sub><b>Bo Liu</b></sub></a></td>
  <td align="center"><a href="https://stebalien.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/310393?u=4e536db31b16cbf68588f80c363d2cf6ef6c7b9f&v=4" width="100px;" alt=""/><br /><sub><b>Steven Allen</b></sub></a></td>
  <td align="center"><a href="https://github.com/urandom2?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2526260?u=507397c1f883caedf479b9a647f9ba540d7ba32e&v=4" width="100px;" alt=""/><br /><sub><b>Colin Arnott</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://levyeran.medium.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/584783?u=4aa666a3a700fbde4a727f1828a5faf939c310d6&v=4" width="100px;" alt=""/><br /><sub><b>Eran Levy</b></sub></a></td>
  <td align="center"><a href="https://engineeringideas.substack.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/609240?v=4" width="100px;" alt=""/><br /><sub><b>Roman Leventov</b></sub></a></td>
  <td align="center"><a href="https://whynothugo.nl/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/730811?u=1bc85d57b1fd0f683e28d1898bb293a8e2901e26&v=4" width="100px;" alt=""/><br /><sub><b>Hugo</b></sub></a></td>
  <td align="center"><a href="https://github.com/mweb?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/882006?v=4" width="100px;" alt=""/><br /><sub><b>Mathias Weber</b></sub></a></td>
  <td align="center"><a href="https://naveensrinivasan.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/172697?u=ba481d3b319e42348d45f1c90fadb0648c00a5af&v=4" width="100px;" alt=""/><br /><sub><b>Naveen</b></sub></a></td>
  <td align="center"><a href="https://github.com/maxsond?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1946457?v=4" width="100px;" alt=""/><br /><sub><b>@maxsond</b></sub></a></td>
  <td align="center"><a href="https://github.com/subtle-byte?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/71576382?v=4" width="100px;" alt=""/><br /><sub><b>Maksim Meshkov</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/raffepaffe?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/23027567?u=022810e35df0d5071ff979c04b54bf5aa454a6ee&v=4" width="100px;" alt=""/><br /><sub><b>@raffepaffe</b></sub></a></td>
  <td align="center"><a href="http://abhinavg.net/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/41730?v=4" width="100px;" alt=""/><br /><sub><b>Abhinav Gupta</b></sub></a></td>
  <td align="center"><a href="https://github.com/mmatur?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1776972?u=fe2b7a5a4ab893f90667b8204803c4724d0cb7d7&v=4" width="100px;" alt=""/><br /><sub><b>Michael</b></sub></a></td>
  <td align="center"><a href="https://kulikov.im?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/888650?u=e42fab110432eeb3d28a81b6bde4fd8d63066220&v=4" width="100px;" alt=""/><br /><sub><b>Evgeniy Kulikov</b></sub></a></td>
  <td align="center"><a href="http://cns.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/715120?u=aaed72a09450c372c3e0f5115ff3c45116622a4a&v=4" width="100px;" alt=""/><br /><sub><b>Chris Nesbitt-Smith</b></sub></a></td>
  <td align="center"><a href="https://es.linkedin.com/in/danicaba?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15898942?u=ef836b375a210ca5e5a9c3485a9d6b5a94f9532d&v=4" width="100px;" alt=""/><br /><sub><b>Daniel Caballero</b></sub></a></td>
  <td align="center"><a href="https://github.com/hypnoglow?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4853075?u=46a46b12713a37327db040e701fdf974032e4f28&v=4" width="100px;" alt=""/><br /><sub><b>Igor Zibarev</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/CarltonHenderson?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22032748?u=04ffcb0d59948341a48c07a74fc158e44114c5dd&v=4" width="100px;" alt=""/><br /><sub><b>Carl Henderson</b></sub></a></td>
  <td align="center"><a href="https://momotaro98.github.io/about?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9294726?u=a31fa7e2665f98a12799947218395d4315fbad66&v=4" width="100px;" alt=""/><br /><sub><b>Shintaro Anazawa</b></sub></a></td>
  <td align="center"><a href="https://github.com/mattayes?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8622473?u=e68267ef69ef74636b036bd14194046cebc23246&v=4" width="100px;" alt=""/><br /><sub><b>Matt Braymer-Hayes</b></sub></a></td>
  <td align="center"><a href="https://github.com/arjenvanderende?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/357115?u=f3ea712dd957d3740daeca2ec47fe04cfe7d6522&v=4" width="100px;" alt=""/><br /><sub><b>Arjen van der Ende</b></sub></a></td>
  <td align="center"><a href="https://github.com/pd93?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9294862?u=e3ccf7d4ba3066e743615253981474b22719817a&v=4" width="100px;" alt=""/><br /><sub><b>Pete Davison</b></sub></a></td>
  <td align="center"><a href="https://github.com/lng2020?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/70063547?v=4" width="100px;" alt=""/><br /><sub><b>Nanguan Lin</b></sub></a></td>
  <td align="center"><a href="http://blast.hardchee.se/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/278900?u=3a46ad35166f5fc7f7f1fc64e27dab78e4e03139&v=4" width="100px;" alt=""/><br /><sub><b>Devon Stewart</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://sewell.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/18528?u=5b060be00e8258ac79b835ba30cbca84fbbea062&v=4" width="100px;" alt=""/><br /><sub><b>Silas Sewell</b></sub></a></td>
  <td align="center"><a href="https://github.com/tdabasinskas?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7723360?u=1acafe50a794b143a116e123d0d5ee4293d22102&v=4" width="100px;" alt=""/><br /><sub><b>Tomas Dabašinskas</b></sub></a></td>
  <td align="center"><a href="https://xuri.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2809468?u=c4de44a07b66fef3ba808b1becd4d3c2ed93e9c9&v=4" width="100px;" alt=""/><br /><sub><b>@xuri</b></sub></a></td>
  <td align="center"><a href="http://blog.ntrippy.net?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/36466?v=4" width="100px;" alt=""/><br /><sub><b>Charl Matthee</b></sub></a></td>
  <td align="center"><a href="https://srizzling.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2313668?u=30e4daec389bc14e50ae088a63b37b02ef81c0d9&v=4" width="100px;" alt=""/><br /><sub><b>Sriram Venkatesh</b></sub></a></td>
  <td align="center"><a href="http://www.scode.org/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/59476?u=35fe85f5175bacc5521c195def108a5680976d6d&v=4" width="100px;" alt=""/><br /><sub><b>Peter Schuller</b></sub></a></td>
  <td align="center"><a href="https://github.com/dgolub?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5299?v=4" width="100px;" alt=""/><br /><sub><b>David Golub</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="http://lk4d4.darth.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/101445?u=8d86da37cd14c1d871da0fb1977521da14ae7285&v=4" width="100px;" alt=""/><br /><sub><b>Alexander Morozov</b></sub></a></td>
  <td align="center"><a href="https://github.com/hbandura?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/731692?v=4" width="100px;" alt=""/><br /><sub><b>Pastoh</b></sub></a></td>
  <td align="center"><a href="https://www.linkedin.com/in/liam-white?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/14291598?u=669c70086377c0de758436d5ab1fca81f48690dc&v=4" width="100px;" alt=""/><br /><sub><b>Liam White</b></sub></a></td>
  <td align="center"><a href="https://github.com/alexdupre?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3694371?u=aa651af67b8de48a503cf82f5f7ef9d2a646af91&v=4" width="100px;" alt=""/><br /><sub><b>Alex Dupre</b></sub></a></td>
  <td align="center"><a href="https://gt.school/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10868426?u=6b2fef3f6a04b90cbabace8aae97e2a9837e6c1b&v=4" width="100px;" alt=""/><br /><sub><b>Juanito</b></sub></a></td>
  <td align="center"><a href="http://supereagle.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3390333?u=c2f3e02916de40814c175560bcd831181f1e7117&v=4" width="100px;" alt=""/><br /><sub><b>Jinming Yue</b></sub></a></td>
  <td align="center"><a href="https://github.com/wxdao?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1405249?u=5bf158903e33f6d6721b4b6989ced381b1c94eb9&v=4" width="100px;" alt=""/><br /><sub><b>@wxdao</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/iyangsj?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/780807?u=094f7862d4906b6c570eb299a5460bef5768b8a0&v=4" width="100px;" alt=""/><br /><sub><b>Sijie Yang</b></sub></a></td>
  <td align="center"><a href="http://www.stephengroat.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1159138?u=5dfa8464ae8884695e3214800085ac02a5da9283&v=4" width="100px;" alt=""/><br /><sub><b>Stephen</b></sub></a></td>
  <td align="center"><a href="https://me.coddeine.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5120965?u=9834ae2b7d0dfeb32e050d06d6f4dd979404daf7&v=4" width="100px;" alt=""/><br /><sub><b>Thang Minh Vu</b></sub></a></td>
  <td align="center"><a href="https://juli.au?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1596871?u=f911daad0502d9b840608caf8cb91d8fe600db13&v=4" width="100px;" alt=""/><br /><sub><b>Julia Ogris</b></sub></a></td>
  <td align="center"><a href="https://gregcurt.is?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/230338?v=4" width="100px;" alt=""/><br /><sub><b>Greg Curtis</b></sub></a></td>
  <td align="center"><a href="https://github.com/ac-rappi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/54147417?v=4" width="100px;" alt=""/><br /><sub><b>@ac-rappi</b></sub></a></td>
  <td align="center"><a href="https://siliconbrain.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/402845?v=4" width="100px;" alt=""/><br /><sub><b>Dudás Ádám</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://comparetoday.in?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/735158?u=0b41f582e25eab530c286e026815abc6d5c6dee6&v=4" width="100px;" alt=""/><br /><sub><b>Abhishek | अभिषेक</b></sub></a></td>
  <td align="center"><a href="https://brugnara.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2781191?v=4" width="100px;" alt=""/><br /><sub><b>Daniele</b></sub></a></td>
  <td align="center"><a href="https://github.com/sachaos?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6121271?u=1de51c81b7ae060e4ac9d09fce403e0eabf05f80&v=4" width="100px;" alt=""/><br /><sub><b>Takumasa Sakao</b></sub></a></td>
  <td align="center"><a href="http://www.bendrucker.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/808808?u=b5f986fef3fda93b4b8b970edadb5f3a631063cf&v=4" width="100px;" alt=""/><br /><sub><b>Ben Drucker</b></sub></a></td>
  <td align="center"><a href="https://www.cobbing.dev/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/578718?u=22e6ac23703c661e3f6054db1304b3b9ad86de77&v=4" width="100px;" alt=""/><br /><sub><b>Matthew Cobbing</b></sub></a></td>
  <td align="center"><a href="https://github.com/Darlez?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/79588890?v=4" width="100px;" alt=""/><br /><sub><b>@Darlez</b></sub></a></td>
  <td align="center"><a href="https://github.com/kirillDanshin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9026581?u=59455ec65bd65cad2c1a4f38a53e7df3826176cd&v=4" width="100px;" alt=""/><br /><sub><b>Kirill Danshin</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://blog.mookjp.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1519309?u=a5f64d46efc8689ce45875b962728dd0c4ddce9f&v=4" width="100px;" alt=""/><br /><sub><b>mook</b></sub></a></td>
  <td align="center"><a href="https://github.com/WKBae?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1346227?v=4" width="100px;" alt=""/><br /><sub><b>Kyungmin Bae</b></sub></a></td>
  <td align="center"><a href="https://dylanarbour.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7211830?u=bdfb1e059af7323cabc1cf8a822c0a5fa0f5e6f8&v=4" width="100px;" alt=""/><br /><sub><b>Dylan Arbour</b></sub></a></td>
  <td align="center"><a href="https://github.com/cory-miller?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13227161?u=9a680efae1cce64a3de4b7069d984d4da1ec6f33&v=4" width="100px;" alt=""/><br /><sub><b>Cory Miller</b></sub></a></td>
  <td align="center"><a href="http://benbrown.ca?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3832730?u=bce741714429988efa7d2771af61934dc2effd88&v=4" width="100px;" alt=""/><br /><sub><b>Ben Brown</b></sub></a></td>
  <td align="center"><a href="https://github.com/dorfire?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1499307?u=65a3d139c3f7b4de9fb9cfee7d058779391ccf42&v=4" width="100px;" alt=""/><br /><sub><b>Dor</b></sub></a></td>
  <td align="center"><a href="https://sinkcup.github.io/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4971414?u=078a87ad06d07a53dd9559158a58ce5bf87c9ff7&v=4" width="100px;" alt=""/><br /><sub><b>sink</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://joaomagfreitas.link/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/26190214?u=6ab8a7ded105abf7ba8e1b7557358649b9a4cf36&v=4" width="100px;" alt=""/><br /><sub><b>João Freitas</b></sub></a></td>
  <td align="center"><a href="https://nickfiggins.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/46427579?u=0524af5324fd2aa6befc9630fb7e9e13cfd66822&v=4" width="100px;" alt=""/><br /><sub><b>nick</b></sub></a></td>
  <td align="center"><a href="http://tekton.dev/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/17419217?v=4" width="100px;" alt=""/><br /><sub><b>David Bendory</b></sub></a></td>
  <td align="center"><a href="https://github.com/znley?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/105416820?v=4" width="100px;" alt=""/><br /><sub><b>@znley</b></sub></a></td>
  <td align="center"><a href="https://github.com/jcolby-avtx?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/87999609?v=4" width="100px;" alt=""/><br /><sub><b>Jonathan Colby</b></sub></a></td>
  <td align="center"><a href="https://github.com/Corazu?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15202670?u=838f19be1ca1921805a173a9bcb26e41f70acaa0&v=4" width="100px;" alt=""/><br /><sub><b>Justin Robertson</b></sub></a></td>
  <td align="center"><a href="https://github.com/alebcay?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3536482?v=4" width="100px;" alt=""/><br /><sub><b>Caleb Xu</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/sirkrypt0?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22522058?u=d36364990d75eb2af51784194d68835630ed6c9a&v=4" width="100px;" alt=""/><br /><sub><b>Tobias</b></sub></a></td>
  <td align="center"><a href="https://namco.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9165473?v=4" width="100px;" alt=""/><br /><sub><b>Namco</b></sub></a></td>
  <td align="center"><a href="https://github.com/vasyl-haievyi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/47991519?u=4063325e153a1cfcd0d656947980e404a9e5fb85&v=4" width="100px;" alt=""/><br /><sub><b>Vasyl Haievyi</b></sub></a></td>
  <td align="center"><a href="https://github.com/andreykuchin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/101262227?v=4" width="100px;" alt=""/><br /><sub><b>@andreykuchin</b></sub></a></td>
  <td align="center"><a href="https://github.com/irinazheltisheva?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/70594426?u=176984a0e30e43d3f135d0052f0b21c579d24d5f&v=4" width="100px;" alt=""/><br /><sub><b>Irina</b></sub></a></td>
  <td align="center"><a href="https://github.com/generalmimon?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/47499687?v=4" width="100px;" alt=""/><br /><sub><b>Petr Pučil</b></sub></a></td>
  <td align="center"><a href="https://github.com/abennett?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10927621?u=8134719b01c8d957dc30d89461903ecdf14f4198&v=4" width="100px;" alt=""/><br /><sub><b>Aaron Bennett</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/zaunist?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/38528079?u=2f3f9658181f80523799ba93234ffd41f7ebf5ca&v=4" width="100px;" alt=""/><br /><sub><b>zaunist</b></sub></a></td>
  <td align="center"><a href="https://samizdat.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8445924?u=3433bc8ba3fa64f14112aafb8f5366c6873173e5&v=4" width="100px;" alt=""/><br /><sub><b>Egor Kovetskiy</b></sub></a></td>
  <td align="center"><a href="https://github.com/SevereCloud?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/14944123?v=4" width="100px;" alt=""/><br /><sub><b>Daniil Suvorov</b></sub></a></td>
  <td align="center"><a href="https://yuki0920.hatenablog.jp?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/47182350?u=3bdb0bdd01b446604ae8340425add90f0dc192f1&v=4" width="100px;" alt=""/><br /><sub><b>Yuki Watanabe</b></sub></a></td>
  <td align="center"><a href="https://aisuko.gitbook.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8053949?u=96d7f39e3823c25e39db68f15095c884061583a3&v=4" width="100px;" alt=""/><br /><sub><b>Aisuko</b></sub></a></td>
  <td align="center"><a href="https://tungbq.github.io/tungbq/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/85242618?u=0d464d73a441883e68bcd46b7aafaaea5b586ff0&v=4" width="100px;" alt=""/><br /><sub><b>Tung Leo</b></sub></a></td>
  <td align="center"><a href="https://kunalsin9h.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/82411321?u=e27c711f1e774d2294437f12851cf3aea229aeda&v=4" width="100px;" alt=""/><br /><sub><b>Kunal Singh</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://chenrui.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1580956?u=20958539fe51538f375a7ce29aa6cca78ec5fc6d&v=4" width="100px;" alt=""/><br /><sub><b>Rui Chen</b></sub></a></td>
  <td align="center"><a href="https://github.com/rezkam?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1498074?u=33de37ebdc3f8f1e5b98769256870f1dab73d386&v=4" width="100px;" alt=""/><br /><sub><b>Rez</b></sub></a></td>
  <td align="center"><a href="https://github.com/alexandrevilain?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12498987?u=8c6c1a37e5e1cc427712a460cadeb80a08a0a925&v=4" width="100px;" alt=""/><br /><sub><b>Alexandre Vilain</b></sub></a></td>
  <td align="center"><a href="https://github.com/guerinoni?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/41150432?u=517ea366386144cb8ce16dc80ed1ad7bf3c03d55&v=4" width="100px;" alt=""/><br /><sub><b>Federico Guerinoni</b></sub></a></td>
  <td align="center"><a href="https://github.com/moitias?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1009280?v=4" width="100px;" alt=""/><br /><sub><b>Matias Lahti</b></sub></a></td>
  <td align="center"><a href="http://vasyharan.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/588211?v=4" width="100px;" alt=""/><br /><sub><b>Thirukumaran Vaseeharan</b></sub></a></td>
  <td align="center"><a href="https://www.asscrypto.co?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/229356?u=5ca849f65f44b8583f7a185797565043452ebf4e&v=4" width="100px;" alt=""/><br /><sub><b>Alessio Treglia</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/alaypatel07?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8192650?u=f59ac46c01927d4d5bdae29ee6160149a7558069&v=4" width="100px;" alt=""/><br /><sub><b>Alay Patel</b></sub></a></td>
  <td align="center"><a href="https://funloop.org/about?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/725613?u=4678351c405e5ee2927008690d6bc84541dcc9ac&v=4" width="100px;" alt=""/><br /><sub><b>Linus Arver</b></sub></a></td>
  <td align="center"><a href="https://github.com/mhutchinson?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1355668?u=87eff9e8bf3d147ef362b2c7d6978b2a2d8041f5&v=4" width="100px;" alt=""/><br /><sub><b>Martin Hutchinson</b></sub></a></td>
  <td align="center"><a href="https://github.com/l0nax?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/29659953?u=01b40c160e224232fe42bf4c4c3c2051bfd2b82c&v=4" width="100px;" alt=""/><br /><sub><b>Emanuel Bennici</b></sub></a></td>
  <td align="center"><a href="https://mayo.rocks?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/35420264?u=c68292fbb19178c6f5979f4b4614e8a651e7f1aa&v=4" width="100px;" alt=""/><br /><sub><b>Mayo</b></sub></a></td>
  <td align="center"><a href="https://blog.smantic.dev?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7060982?u=be529f231723b2461e0bdc2a7fcf5dc189ce4c23&v=4" width="100px;" alt=""/><br /><sub><b>smantic</b></sub></a></td>
  <td align="center"><a href="https://github.com/seabass-labrax?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/79224200?u=541b22b8049db773682106f58aa1d556d4e541bf&v=4" width="100px;" alt=""/><br /><sub><b>Sebastian Crane</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://else.id.au?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/165789?v=4" width="100px;" alt=""/><br /><sub><b>Alexander Else</b></sub></a></td>
  <td align="center"><a href="https://brrrrr.at?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/4353513?u=fa4b0c7b09a4aef658627da23f4cba289f4b5f0c&v=4" width="100px;" alt=""/><br /><sub><b>@vladopajic</b></sub></a></td>
  <td align="center"><a href="https://github.com/oxr463?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43783393?u=fd04db6e8e67ee0c63bcf9a42d550aba1eb05145&v=4" width="100px;" alt=""/><br /><sub><b>@oxr463</b></sub></a></td>
  <td align="center"><a href="https://blog.trim21.me/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/13553903?u=3cadf0f02095c9621aa29df6875f53a80ca4fbfb&v=4" width="100px;" alt=""/><br /><sub><b>Trim21</b></sub></a></td>
  <td align="center"><a href="https://github.com/eiffel-fl?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/12171754?v=4" width="100px;" alt=""/><br /><sub><b>@eiffel-fl</b></sub></a></td>
  <td align="center"><a href="https://code.pfad.fr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3864879?u=70c94404649e7e9b5da90e229019f5a4c8fd5f05&v=4" width="100px;" alt=""/><br /><sub><b>@oliverpool</b></sub></a></td>
  <td align="center"><a href="https://github.com/Ak-Army?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6526354?v=4" width="100px;" alt=""/><br /><sub><b>@Ak-Army</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/humancalico?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/51334444?u=f48686616772acc6d33b1c047c0527a11879a1e7&v=4" width="100px;" alt=""/><br /><sub><b>@humancalico</b></sub></a></td>
  <td align="center"><a href="https://github.com/cclauss?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3709715?u=0745d1d2473894c33f3b35f0b965d71cc9aec553&v=4" width="100px;" alt=""/><br /><sub><b>Christian Clauss</b></sub></a></td>
  <td align="center"><a href="https://liebermann.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/14969425?u=40c13a3fe4886c0c8a9a4a53531de8c0753f1e2f&v=4" width="100px;" alt=""/><br /><sub><b>Johanan Liebermann</b></sub></a></td>
  <td align="center"><a href="https://gravatar.com/korjavin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/148765?v=4" width="100px;" alt=""/><br /><sub><b>Korjavin Ivan</b></sub></a></td>
  <td align="center"><a href="https://github.com/Juneezee?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/20135478?u=315cb4e73533322273d7265ad0fc370c9f89e322&v=4" width="100px;" alt=""/><br /><sub><b>Eng Zer Jun</b></sub></a></td>
  <td align="center"><a href="https://github.com/ezradiniz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/19827734?u=da300cc19c86aa7c83564e391fcc0a7149d0043f&v=4" width="100px;" alt=""/><br /><sub><b>Mateus Esdras</b></sub></a></td>
  <td align="center"><a href="https://devingunay.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16074091?u=da6d24c8adaba95b24dbf5cccdf1f332153d6be5&v=4" width="100px;" alt=""/><br /><sub><b>Devin Gunay</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/hilariocoelho?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5185271?u=fa0d307b0fed0ca59e2d6976939336917e95410c&v=4" width="100px;" alt=""/><br /><sub><b>Hilário Coelho</b></sub></a></td>
  <td align="center"><a href="https://github.com/caveman280?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/26064434?u=7328a88324be832a899fe80806d762bc0e46c4a2&v=4" width="100px;" alt=""/><br /><sub><b>Thomas Cave</b></sub></a></td>
  <td align="center"><a href="http://selimcancaba.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7759682?u=7046d19e54208dc709003d7c547f80f5a0956398&v=4" width="100px;" alt=""/><br /><sub><b>Selim Can CABA</b></sub></a></td>
  <td align="center"><a href="https://github.com/t-botz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/693797?u=468a4c6ce6cef6842f9478e13fca4e878d5487ba&v=4" width="100px;" alt=""/><br /><sub><b>Tibo Delor</b></sub></a></td>
  <td align="center"><a href="https://github.com/chainchad?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/96362174?v=4" width="100px;" alt=""/><br /><sub><b>@chainchad</b></sub></a></td>
  <td align="center"><a href="https://github.com/francoispqt?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/24575934?u=afb7942a02e997bd463a3b99ca9b309b54e0f249&v=4" width="100px;" alt=""/><br /><sub><b>Francois Parquet</b></sub></a></td>
  <td align="center"><a href="http://23doors.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1051101?u=92cef9a943a64f6ec3d0c6b08e1f3de4b41b5d7c&v=4" width="100px;" alt=""/><br /><sub><b>Robert Kopaczewski</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://marctuduri.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/280193?u=2a661a76d6d746ec518ac7a31985a59484a34e5e&v=4" width="100px;" alt=""/><br /><sub><b>Marc Tudurí</b></sub></a></td>
  <td align="center"><a href="https://github.com/pohang?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/19980697?v=4" width="100px;" alt=""/><br /><sub><b>@pohang</b></sub></a></td>
  <td align="center"><a href="https://searace.org?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3671279?u=b17ab8bf511d39c29bf43d0a3878808ea8417bde&v=4" width="100px;" alt=""/><br /><sub><b>Cyrille Meichel</b></sub></a></td>
  <td align="center"><a href="https://github.com/neglect-yp?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/20413543?v=4" width="100px;" alt=""/><br /><sub><b>neglect-yp</b></sub></a></td>
  <td align="center"><a href="https://github.com/fpuc?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1822814?u=b1a59627064d62c912386a21ae13d33c5ef0c622&v=4" width="100px;" alt=""/><br /><sub><b>Felix</b></sub></a></td>
  <td align="center"><a href="https://github.com/abustany?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2526296?v=4" width="100px;" alt=""/><br /><sub><b>Adrien</b></sub></a></td>
  <td align="center"><a href="https://github.com/josephbergevin?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/2521874?v=4" width="100px;" alt=""/><br /><sub><b>Joe Bergevin</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://axetroy.xyz?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9758711?u=d306c2695c119ab9a21dbed1ef717b5687b848f9&v=4" width="100px;" alt=""/><br /><sub><b>Axetroy</b></sub></a></td>
  <td align="center"><a href="https://github.com/guillaumeio?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/98314376?v=4" width="100px;" alt=""/><br /><sub><b>Guillaume JG</b></sub></a></td>
  <td align="center"><a href="https://github.com/ecordell?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/58055?v=4" width="100px;" alt=""/><br /><sub><b>Evan Cordell</b></sub></a></td>
  <td align="center"><a href="https://uosblog.top?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/60995091?v=4" width="100px;" alt=""/><br /><sub><b>靳灿奇</b></sub></a></td>
  <td align="center"><a href="https://github.com/katsadim?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16381881?u=0527237d20283e1a48a81c5355b03727960dba80&v=4" width="100px;" alt=""/><br /><sub><b>Nassos Kat</b></sub></a></td>
  <td align="center"><a href="https://www.hitzhangjie.pro?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3725760?u=86a1d275a1bb305684adfda0dec994eafadb1088&v=4" width="100px;" alt=""/><br /><sub><b>hitzhangjie</b></sub></a></td>
  <td align="center"><a href="https://donatstudios.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/133747?u=ac894e3102c619c6efdcbc7eb5f9bc8f9e2fd1ad&v=4" width="100px;" alt=""/><br /><sub><b>Jesse Donat</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://www.linkedin.com/in/olegshparber/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/714940?u=5f6e90f5fc7c308bd96a8819c71038abebe3352c&v=4" width="100px;" alt=""/><br /><sub><b>Oleg Shparber</b></sub></a></td>
  <td align="center"><a href="https://github.com/kraashen?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/142790925?v=4" width="100px;" alt=""/><br /><sub><b>Tomi Juntunen</b></sub></a></td>
  <td align="center"><a href="https://github.com/mdonkers?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/954721?u=4becc84d0b69171446622a05bef514a64f576989&v=4" width="100px;" alt=""/><br /><sub><b>Miel Donkers</b></sub></a></td>
  <td align="center"><a href="https://github.com/marcciosilva?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7085857?v=4" width="100px;" alt=""/><br /><sub><b>Marccio Silva</b></sub></a></td>
  <td align="center"><a href="https://bare.id/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1145424?u=7b384a9e5634ea6f2926d1dbbf1e25faadec99af&v=4" width="100px;" alt=""/><br /><sub><b>Bastian</b></sub></a></td>
  <td align="center"><a href="https://github.com/tigrato?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3629062?v=4" width="100px;" alt=""/><br /><sub><b>Tiago Silva</b></sub></a></td>
  <td align="center"><a href="https://lufia.org/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1784379?u=566ae0173c29e10d545c1bdd122d6e538a4d7060&v=4" width="100px;" alt=""/><br /><sub><b>KADOTA, Kyohei</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/conorevans?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/43791257?u=8e19a809efd17b6fd87f6389fca64478962fd3a4&v=4" width="100px;" alt=""/><br /><sub><b>Conor Evans</b></sub></a></td>
  <td align="center"><a href="https://aniforprez.dev/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/993132?u=c2b88e3ae6d31be69031a2561a6e4759dfb9b723&v=4" width="100px;" alt=""/><br /><sub><b>Anirudh Sylendranath</b></sub></a></td>
  <td align="center"><a href="https://github.com/jumpeiMano?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6240874?u=779a2ed4b4ddd4117bac58c315013f6b7df7f50a&v=4" width="100px;" alt=""/><br /><sub><b>@jumpeiMano</b></sub></a></td>
  <td align="center"><a href="https://github.com/alexal?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/499857?u=1232f06a22fd0b98f3e43d1eaeab061015404cc8&v=4" width="100px;" alt=""/><br /><sub><b>Alex Rodin</b></sub></a></td>
  <td align="center"><a href="https://keybase.io/guggero?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1008879?u=2c337f92b7dbc69b8aaff7885926f2bc1865db0d&v=4" width="100px;" alt=""/><br /><sub><b>Oliver Gugger</b></sub></a></td>
  <td align="center"><a href="https://github.com/Bryan1041?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/16910401?u=c4be6e64e5aa2b169dd0d770b6a4bc857806877b&v=4" width="100px;" alt=""/><br /><sub><b>Bryan Andrews</b></sub></a></td>
  <td align="center"><a href="https://github.com/TomerJLevy?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/22237259?v=4" width="100px;" alt=""/><br /><sub><b>@TomerJLevy</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://titovcode.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/29011926?u=02af86afadc2e926192c3d59125e3247d8f0507d&v=4" width="100px;" alt=""/><br /><sub><b>Dmitry Titov</b></sub></a></td>
  <td align="center"><a href="https://github.com/tgorham4?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/83597118?u=89faed89471e89fedb7e302b479ec61b1427e87d&v=4" width="100px;" alt=""/><br /><sub><b>Thomas Gorham</b></sub></a></td>
  <td align="center"><a href="https://github.com/weijiangan?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6372144?u=6a8a13854375e531dca35bfbd67d37aeabb3a43a&v=4" width="100px;" alt=""/><br /><sub><b>Wei Jian Gan</b></sub></a></td>
  <td align="center"><a href="https://mastodon.green/@tgulacsi?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/256074?v=4" width="100px;" alt=""/><br /><sub><b>Tamás Gulácsi</b></sub></a></td>
  <td align="center"><a href="https://jackwilsdon.me?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1843197?u=0e5b9858f4ded98ffe7dfbbe9f5e4315cd597cd8&v=4" width="100px;" alt=""/><br /><sub><b>Jack Wilsdon</b></sub></a></td>
  <td align="center"><a href="https://github.com/Gobonoid?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/15029578?u=7fed21f2429bdca932dd55a69c8ec0ee36e772a2&v=4" width="100px;" alt=""/><br /><sub><b>Michał Suchwałko</b></sub></a></td>
  <td align="center"><a href="https://github.com/aLekSer?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5626814?u=f23f71d0b298f243de664879d949af6b808b1017&v=4" width="100px;" alt=""/><br /><sub><b>Alexander Apalikov</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://git.sr.ht/~domust?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/54954739?v=4" width="100px;" alt=""/><br /><sub><b>Domas Tamašauskas</b></sub></a></td>
  <td align="center"><a href="https://iomelette.fr?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7288655?u=c340284bba9db0444293d7f48e7f8ce2f33db653&v=4" width="100px;" alt=""/><br /><sub><b>Stéphane Chausson</b></sub></a></td>
  <td align="center"><a href="https://plus.google.com/u/0/104675305010518579165?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/1690210?u=152b7c1086a84a7e756d35c3c71767ed676ed4f8&v=4" width="100px;" alt=""/><br /><sub><b>neo_sli</b></sub></a></td>
  <td align="center"><a href="https://github.com/srdhoni?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/20898452?v=4" width="100px;" alt=""/><br /><sub><b>@srdhoni</b></sub></a></td>
  <td align="center"><a href="https://github.com/derekhuizhang?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/25254181?u=6b04fc6b2c6eb2f9cfd931b269336b92ac7209bc&v=4" width="100px;" alt=""/><br /><sub><b>@derekhuizhang</b></sub></a></td>
  <td align="center"><a href="https://takaokanbe.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/62293842?u=133729b3a223773ec0bffa861f29a63ebe474675&v=4" width="100px;" alt=""/><br /><sub><b>takaokanbe</b></sub></a></td>
  <td align="center"><a href="https://github.com/seanschneeweiss?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6184685?u=f9a0f1e38457a5d2bd0a2e707676dc0fcea1d054&v=4" width="100px;" alt=""/><br /><sub><b>Sean Schneeweiss</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/pkprzekwas?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/9121459?u=56fad5cbf6e8bead6088d0099122f9739b714bde&v=4" width="100px;" alt=""/><br /><sub><b>pprzekwas</b></sub></a></td>
  <td align="center"><a href="https://github.com/madflow?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/183248?v=4" width="100px;" alt=""/><br /><sub><b>madflow</b></sub></a></td>
  <td align="center"><a href="https://t.me/armantarkhanian?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/72862404?u=74bfc1f008f3a10d8a44b889dfcd7cfb1000e4fa&v=4" width="100px;" alt=""/><br /><sub><b>Arman Tarkhanian</b></sub></a></td>
  <td align="center"><a href="https://github.com/adlerjohn?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3290375?u=c0b3688f4e6dbed1eef0652efadca3ed286021bf&v=4" width="100px;" alt=""/><br /><sub><b>John Adler</b></sub></a></td>
  <td align="center"><a href="https://github.com/licraft2019?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/48341058?v=4" width="100px;" alt=""/><br /><sub><b>@licraft2019</b></sub></a></td>
  <td align="center"><a href="https://github.com/mlueckest?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/86692752?v=4" width="100px;" alt=""/><br /><sub><b>@mlueckest</b></sub></a></td>
  <td align="center"><a href="https://github.com/malteehrlen?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/42444300?v=4" width="100px;" alt=""/><br /><sub><b>Malte Ehrlen</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://github.com/golangaccount?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/7640666?v=4" width="100px;" alt=""/><br /><sub><b>@golangaccount</b></sub></a></td>
  <td align="center"><a href="https://tylerdorn.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5892788?u=81a2dc22cf91ffc7bb27b66217482dd991b7ddee&v=4" width="100px;" alt=""/><br /><sub><b>Tyler Dorn</b></sub></a></td>
  <td align="center"><a href="https://enmanuelmoreira.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/152518?u=8351b36570865a63908aa012fd63e873b17cf123&v=4" width="100px;" alt=""/><br /><sub><b>Enmanuel Moreira</b></sub></a></td>
  <td align="center"><a href="https://abstraction.fr/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/153052?v=4" width="100px;" alt=""/><br /><sub><b>Sylvain Rabot</b></sub></a></td>
  <td align="center"><a href="https://www.piotrpersona.com/?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/29518241?u=399c29ad144ce7c53ec4b5b16b82100a51ae7882&v=4" width="100px;" alt=""/><br /><sub><b>Piotr Persona</b></sub></a></td>
  <td align="center"><a href="http://kangssu.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/3623889?v=4" width="100px;" alt=""/><br /><sub><b>Han Gyoung-Su</b></sub></a></td>
  <td align="center"><a href="https://github.com/HarryTennent?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/71338309?u=776731bfbe0a8f8116ea19fbf50c8e1927456740&v=4" width="100px;" alt=""/><br /><sub><b>Harry Tennent</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://k.mirzavaziri.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/33681886?u=fe1cd9a3b2e3b4fd8dd1ec1ed5d72d2ebc7c20d3&v=4" width="100px;" alt=""/><br /><sub><b>Kamyar Mirzavaziri</b></sub></a></td>
  <td align="center"><a href="https://github.com/w1ck3dg0ph3r?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/10450851?v=4" width="100px;" alt=""/><br /><sub><b>@w1ck3dg0ph3r</b></sub></a></td>
  <td align="center"><a href="https://github.com/yuhrichard?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/149437554?v=4" width="100px;" alt=""/><br /><sub><b>Richard Yuh</b></sub></a></td>
  <td align="center"><a href="https://www.oscs1024.com/usr/1503957948160806912?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/101684156?u=e569df7c7e957e9daf22abc7c7829b9cf2613593&v=4" width="100px;" alt=""/><br /><sub><b>caption</b></sub></a></td>
  <td align="center"><a href="https://github.com/goodfirm?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/166383463?u=f31bbc6f1993bf1f1b4b7ea003c8c7dee8fc6ef9&v=4" width="100px;" alt=""/><br /><sub><b>Yi Song</b></sub></a></td>
  <td align="center"><a href="https://github.com/testwill?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/8717479?v=4" width="100px;" alt=""/><br /><sub><b>guoguangwu</b></sub></a></td>
  <td align="center"><a href="https://gitlab.com/artemk1337?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/51025000?u=33978463a0928ad98456ccb7cc9c2b394bfe52b2&v=4" width="100px;" alt=""/><br /><sub><b>Artem K</b></sub></a></td>
</tr>
<tr>
  <td align="center"><a href="https://raidancampbell.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/5506073?v=4" width="100px;" alt=""/><br /><sub><b>R. Aidan Campbell</b></sub></a></td>
  <td align="center"><a href="https://github.com/tbonfort?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/358469?u=bf6e92907c9f7b5f37221ac32fc72bff90ba683c&v=4" width="100px;" alt=""/><br /><sub><b>Thomas Bonfort</b></sub></a></td>
  <td align="center"><a href="https://github.com/mmorel-35?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/6032561?u=951551f72320f1d46dc7db517c3ad0ab1b771974&v=4" width="100px;" alt=""/><br /><sub><b>Matthieu MOREL</b></sub></a></td>
  <td align="center"><a href="http://jared.szechy.com?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/847739?v=4" width="100px;" alt=""/><br /><sub><b>Jared Szechy</b></sub></a></td>
  <td align="center"><a href="https://wilhelmagren.github.io?utm_source=golangci-lint-contributors"><img src="https://avatars.githubusercontent.com/u/36638274?u=28e2bf59b0792c4a500a1a3621447401888e1089&v=4" width="100px;" alt=""/><br /><sub><b>Wilhelm Ågren</b></sub></a></td>
</tr>
</table>

</details>

<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->
<!-- END AUTOGENERATED CONTRIBUTORS -->

## Stargazers over time

[![Stargazers over time](https://starchart.cc/golangci/golangci-lint.svg)](https://starchart.cc/golangci/golangci-lint)
