// Generated by running
//      maketesttables --url=http://www.unicode.org/Public/8.0.0/ucd/auxiliary/
// DO NOT EDIT

package segment

var unicodeGraphemeTests = []struct {
	input   []byte
	output  [][]byte
	comment string
}{
	{
		input:   []byte{0x20, 0x20},
		output:  [][]byte{[]byte{0x20}, []byte{0x20}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xd},
		output:  [][]byte{[]byte{0x20}, []byte{0xd}},
		comment: `÷ [0.2] SPACE (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xa},
		output:  [][]byte{[]byte{0x20}, []byte{0xa}},
		comment: `÷ [0.2] SPACE (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0x1},
		output:  [][]byte{[]byte{0x20}, []byte{0x1}},
		comment: `÷ [0.2] SPACE (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x80}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0x20, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] SPACE (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0x20}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0x20}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0x20}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0x20}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0x20}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x20}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0x20}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] SPACE (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0x20}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] SPACE (Other) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0x20, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x20},
		output:  [][]byte{[]byte{0xd}, []byte{0x20}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xa},
		output:  [][]byte{[]byte{0xd, 0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xd}, []byte{0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xd}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xd}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xd}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xd}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x20},
		output:  [][]byte{[]byte{0xa}, []byte{0x20}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xa}, []byte{0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xa}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xa}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xa}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xa}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xa}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x20},
		output:  [][]byte{[]byte{0x1}, []byte{0x20}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xd},
		output:  [][]byte{[]byte{0x1}, []byte{0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xa},
		output:  [][]byte{[]byte{0x1}, []byte{0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x1},
		output:  [][]byte{[]byte{0x1}, []byte{0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0x1}, []byte{0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0x1}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0x1}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0x1}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x1}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0x1}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0x1}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0x1}, []byte{0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x20},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x20}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0x20},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0x20}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xd},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xd}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xa},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xa}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0x1},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0x1}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe0, 0xa4, 0x83, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x84, 0x80, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x85, 0xa0, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xe1, 0x86, 0xa8, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0x20},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xa},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0x1},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x80, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0x20},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xa},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0x1},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xea, 0xb0, 0x81, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x20},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x20}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0x20},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0x20}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xd},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xd}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xa},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xa}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0x1},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0x1}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xcd, 0xb8}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcd, 0xb8, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xcd, 0xb8, 0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0x20},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0x20}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0x20},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0x20}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xd},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xd}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xa},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xa}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0x1},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0x1}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x84, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x85, 0xa0}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xe1, 0x86, 0xa8}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x80}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xea, 0xb0, 0x81}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xcd, 0xb8},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xcd, 0xb8}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0xef, 0xbf, 0xbd, 0xcc, 0x88, 0xef, 0xbf, 0xbd},
		output:  [][]byte{[]byte{0xef, 0xbf, 0xbd}, []byte{0xcc, 0x88}, []byte{0xef, 0xbf, 0xbd}},
		comment: `÷ [0.2] <surrogate-D800> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [5.0] <surrogate-D800> (Control) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0x62},
		output:  [][]byte{[]byte{0x61}, []byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x62}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER E (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xe2, 0x80, 0x8b, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba}, []byte{0xe2, 0x80, 0x8b}, []byte{0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) ÷ [5.0] ZERO WIDTH SPACE (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER E (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}, []byte{0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [9.0] ZERO WIDTH JOINER (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d}, []byte{0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [8.1] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [9.0] ZERO WIDTH JOINER (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		output:  [][]byte{[]byte{0x20, 0xe2, 0x80, 0x8d}, []byte{0xd9, 0x86}},
		comment: `÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (Extend) ÷ [999.0] ARABIC LETTER NOON (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		output:  [][]byte{[]byte{0xd9, 0x86, 0xe2, 0x80, 0x8d}, []byte{0x20}},
		comment: `÷ [0.2] ARABIC LETTER NOON (Other) × [9.0] ZERO WIDTH JOINER (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
}
var unicodeWordTests = []struct {
	input   []byte
	output  [][]byte
	comment string
}{
	{
		input:   []byte{0x1, 0x1},
		output:  [][]byte{[]byte{0x1}, []byte{0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xd},
		output:  [][]byte{[]byte{0x1}, []byte{0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xa},
		output:  [][]byte{[]byte{0x1}, []byte{0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xb},
		output:  [][]byte{[]byte{0x1}, []byte{0xb}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x1}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x41},
		output:  [][]byte{[]byte{0x1}, []byte{0x41}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x3a},
		output:  [][]byte{[]byte{0x1}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x2c},
		output:  [][]byte{[]byte{0x1}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x2e},
		output:  [][]byte{[]byte{0x1}, []byte{0x2e}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x30},
		output:  [][]byte{[]byte{0x1}, []byte{0x30}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x5f},
		output:  [][]byte{[]byte{0x1}, []byte{0x5f}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x1}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x1}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x22},
		output:  [][]byte{[]byte{0x1}, []byte{0x22}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x27},
		output:  [][]byte{[]byte{0x1}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x1, 0xc2, 0xad}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x1}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61, 0x27},
		output:  [][]byte{[]byte{0x1}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x1}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x1}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x31, 0x27},
		output:  [][]byte{[]byte{0x1}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x1}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xa},
		output:  [][]byte{[]byte{0xd, 0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xb},
		output:  [][]byte{[]byte{0xd}, []byte{0xb}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xd}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x41},
		output:  [][]byte{[]byte{0xd}, []byte{0x41}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x2e},
		output:  [][]byte{[]byte{0xd}, []byte{0x2e}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x30},
		output:  [][]byte{[]byte{0xd}, []byte{0x30}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x5f},
		output:  [][]byte{[]byte{0xd}, []byte{0x5f}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xd}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x22},
		output:  [][]byte{[]byte{0xd}, []byte{0x22}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x31, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xb},
		output:  [][]byte{[]byte{0xa}, []byte{0xb}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xa}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x41},
		output:  [][]byte{[]byte{0xa}, []byte{0x41}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x2e},
		output:  [][]byte{[]byte{0xa}, []byte{0x2e}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x30},
		output:  [][]byte{[]byte{0xa}, []byte{0x30}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x5f},
		output:  [][]byte{[]byte{0xa}, []byte{0x5f}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xa}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xa}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x22},
		output:  [][]byte{[]byte{0xa}, []byte{0x22}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xa}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x31, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x1},
		output:  [][]byte{[]byte{0xb}, []byte{0x1}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xd},
		output:  [][]byte{[]byte{0xb}, []byte{0xd}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xa},
		output:  [][]byte{[]byte{0xb}, []byte{0xa}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xb},
		output:  [][]byte{[]byte{0xb}, []byte{0xb}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xb}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x41},
		output:  [][]byte{[]byte{0xb}, []byte{0x41}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x2e},
		output:  [][]byte{[]byte{0xb}, []byte{0x2e}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x30},
		output:  [][]byte{[]byte{0xb}, []byte{0x30}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x5f},
		output:  [][]byte{[]byte{0xb}, []byte{0x5f}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xb}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xb}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x22},
		output:  [][]byte{[]byte{0xb}, []byte{0x22}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xb}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x61, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x31, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xb, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xb}, []byte{0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x1},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x1}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xd},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0xd}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xa},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0xa}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xb},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0xb}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x41},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x41}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x2e},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x2e}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x30},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x30}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x5f},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0x5f}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x22},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x22}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xc2, 0xad}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x80}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x61, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x31, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe3, 0x80, 0xb1, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x1},
		output:  [][]byte{[]byte{0x41}, []byte{0x1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xd},
		output:  [][]byte{[]byte{0x41}, []byte{0xd}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xa},
		output:  [][]byte{[]byte{0x41}, []byte{0xa}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xb},
		output:  [][]byte{[]byte{0x41}, []byte{0xb}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x41}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x41},
		output:  [][]byte{[]byte{0x41, 0x41}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x3a},
		output:  [][]byte{[]byte{0x41}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x2c},
		output:  [][]byte{[]byte{0x41}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x2e},
		output:  [][]byte{[]byte{0x41}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x30},
		output:  [][]byte{[]byte{0x41, 0x30}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x5f},
		output:  [][]byte{[]byte{0x41, 0x5f}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x41}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x41, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x22},
		output:  [][]byte{[]byte{0x41}, []byte{0x22}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x27},
		output:  [][]byte{[]byte{0x41}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x41, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x41, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61, 0x27},
		output:  [][]byte{[]byte{0x41, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x41, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x41, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x31, 0x27},
		output:  [][]byte{[]byte{0x41, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x41, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x1},
		output:  [][]byte{[]byte{0x3a}, []byte{0x1}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xd},
		output:  [][]byte{[]byte{0x3a}, []byte{0xd}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xa},
		output:  [][]byte{[]byte{0x3a}, []byte{0xa}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xb},
		output:  [][]byte{[]byte{0x3a}, []byte{0xb}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x3a}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x41},
		output:  [][]byte{[]byte{0x3a}, []byte{0x41}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x3a},
		output:  [][]byte{[]byte{0x3a}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x2c},
		output:  [][]byte{[]byte{0x3a}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x2e},
		output:  [][]byte{[]byte{0x3a}, []byte{0x2e}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x30},
		output:  [][]byte{[]byte{0x3a}, []byte{0x30}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x5f},
		output:  [][]byte{[]byte{0x3a}, []byte{0x5f}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x3a}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x3a}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x22},
		output:  [][]byte{[]byte{0x3a}, []byte{0x22}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x27},
		output:  [][]byte{[]byte{0x3a}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x3a, 0xc2, 0xad}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x80}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x3a}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x61, 0x27},
		output:  [][]byte{[]byte{0x3a}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x3a}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x3a}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x31, 0x27},
		output:  [][]byte{[]byte{0x3a}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x3a}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x1},
		output:  [][]byte{[]byte{0x2c}, []byte{0x1}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xd},
		output:  [][]byte{[]byte{0x2c}, []byte{0xd}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xa},
		output:  [][]byte{[]byte{0x2c}, []byte{0xa}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xb},
		output:  [][]byte{[]byte{0x2c}, []byte{0xb}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x2c}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x41},
		output:  [][]byte{[]byte{0x2c}, []byte{0x41}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x3a},
		output:  [][]byte{[]byte{0x2c}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x2c},
		output:  [][]byte{[]byte{0x2c}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x2e},
		output:  [][]byte{[]byte{0x2c}, []byte{0x2e}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x30},
		output:  [][]byte{[]byte{0x2c}, []byte{0x30}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x5f},
		output:  [][]byte{[]byte{0x2c}, []byte{0x5f}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x2c}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x2c}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x22},
		output:  [][]byte{[]byte{0x2c}, []byte{0x22}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x27},
		output:  [][]byte{[]byte{0x2c}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2c, 0xc2, 0xad}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x80}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x2c}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61, 0x27},
		output:  [][]byte{[]byte{0x2c}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x2c}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x2c}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x31, 0x27},
		output:  [][]byte{[]byte{0x2c}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x2c}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x1},
		output:  [][]byte{[]byte{0x2e}, []byte{0x1}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xd},
		output:  [][]byte{[]byte{0x2e}, []byte{0xd}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xa},
		output:  [][]byte{[]byte{0x2e}, []byte{0xa}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xb},
		output:  [][]byte{[]byte{0x2e}, []byte{0xb}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x2e}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x41},
		output:  [][]byte{[]byte{0x2e}, []byte{0x41}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x3a},
		output:  [][]byte{[]byte{0x2e}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x2c},
		output:  [][]byte{[]byte{0x2e}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x2e},
		output:  [][]byte{[]byte{0x2e}, []byte{0x2e}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x30},
		output:  [][]byte{[]byte{0x2e}, []byte{0x30}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x5f},
		output:  [][]byte{[]byte{0x2e}, []byte{0x5f}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x2e}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x2e}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x22},
		output:  [][]byte{[]byte{0x2e}, []byte{0x22}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x27},
		output:  [][]byte{[]byte{0x2e}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2e, 0xc2, 0xad}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x80}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x2e}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61, 0x27},
		output:  [][]byte{[]byte{0x2e}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x2e}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x2e}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x31, 0x27},
		output:  [][]byte{[]byte{0x2e}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x2e}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x1},
		output:  [][]byte{[]byte{0x30}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xd},
		output:  [][]byte{[]byte{0x30}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xa},
		output:  [][]byte{[]byte{0x30}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xb},
		output:  [][]byte{[]byte{0x30}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x30}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x41},
		output:  [][]byte{[]byte{0x30, 0x41}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x3a},
		output:  [][]byte{[]byte{0x30}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x2c},
		output:  [][]byte{[]byte{0x30}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x2e},
		output:  [][]byte{[]byte{0x30}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x30},
		output:  [][]byte{[]byte{0x30, 0x30}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x5f},
		output:  [][]byte{[]byte{0x30, 0x5f}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x30}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x30, 0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x22},
		output:  [][]byte{[]byte{0x30}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x27},
		output:  [][]byte{[]byte{0x30}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x30, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x30, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61, 0x27},
		output:  [][]byte{[]byte{0x30, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x30, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x30, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x31, 0x27},
		output:  [][]byte{[]byte{0x30, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x30, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x1},
		output:  [][]byte{[]byte{0x5f}, []byte{0x1}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xd},
		output:  [][]byte{[]byte{0x5f}, []byte{0xd}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xa},
		output:  [][]byte{[]byte{0x5f}, []byte{0xa}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xb},
		output:  [][]byte{[]byte{0x5f}, []byte{0xb}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x5f, 0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x41},
		output:  [][]byte{[]byte{0x5f, 0x41}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x3a},
		output:  [][]byte{[]byte{0x5f}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x2c},
		output:  [][]byte{[]byte{0x5f}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x2e},
		output:  [][]byte{[]byte{0x5f}, []byte{0x2e}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x30},
		output:  [][]byte{[]byte{0x5f, 0x30}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x5f},
		output:  [][]byte{[]byte{0x5f, 0x5f}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x5f}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x5f, 0xd7, 0x90}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x22},
		output:  [][]byte{[]byte{0x5f}, []byte{0x22}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x27},
		output:  [][]byte{[]byte{0x5f}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x5f, 0xc2, 0xad}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x80}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x5f, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x61, 0x27},
		output:  [][]byte{[]byte{0x5f, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x5f, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x5f, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x31, 0x27},
		output:  [][]byte{[]byte{0x5f, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x5f, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x5f, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x5f, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xb},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xb}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x41},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x41}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2e},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x2e}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x30},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x30}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x5f},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x5f}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.3] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x22},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x22}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x1},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0x1}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xd},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0xd}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xa},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0xa}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xb},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0xb}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x41},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x41}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x2e},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0x2e}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x30},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x30}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x5f},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x5f}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xd7, 0x90}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x22},
		output:  [][]byte{[]byte{0xd7, 0x90}, []byte{0x22}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xc2, 0xad}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x80}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x61, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x31, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xd7, 0x90, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x1},
		output:  [][]byte{[]byte{0x22}, []byte{0x1}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xd},
		output:  [][]byte{[]byte{0x22}, []byte{0xd}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xa},
		output:  [][]byte{[]byte{0x22}, []byte{0xa}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xb},
		output:  [][]byte{[]byte{0x22}, []byte{0xb}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x22}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x41},
		output:  [][]byte{[]byte{0x22}, []byte{0x41}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x3a},
		output:  [][]byte{[]byte{0x22}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x2c},
		output:  [][]byte{[]byte{0x22}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x2e},
		output:  [][]byte{[]byte{0x22}, []byte{0x2e}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x30},
		output:  [][]byte{[]byte{0x22}, []byte{0x30}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x5f},
		output:  [][]byte{[]byte{0x22}, []byte{0x5f}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x22}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x22}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x22},
		output:  [][]byte{[]byte{0x22}, []byte{0x22}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x27},
		output:  [][]byte{[]byte{0x22}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x22, 0xc2, 0xad}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x80}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x22}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61, 0x27},
		output:  [][]byte{[]byte{0x22}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x22}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x22}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x31, 0x27},
		output:  [][]byte{[]byte{0x22}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x22}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x1},
		output:  [][]byte{[]byte{0x27}, []byte{0x1}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xd},
		output:  [][]byte{[]byte{0x27}, []byte{0xd}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xa},
		output:  [][]byte{[]byte{0x27}, []byte{0xa}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xb},
		output:  [][]byte{[]byte{0x27}, []byte{0xb}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x27}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x41},
		output:  [][]byte{[]byte{0x27}, []byte{0x41}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x3a},
		output:  [][]byte{[]byte{0x27}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x2c},
		output:  [][]byte{[]byte{0x27}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x2e},
		output:  [][]byte{[]byte{0x27}, []byte{0x2e}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x30},
		output:  [][]byte{[]byte{0x27}, []byte{0x30}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x5f},
		output:  [][]byte{[]byte{0x27}, []byte{0x5f}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x27}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x27}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x22},
		output:  [][]byte{[]byte{0x27}, []byte{0x22}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x27},
		output:  [][]byte{[]byte{0x27}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x27, 0xc2, 0xad}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x80}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x27}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x61, 0x27},
		output:  [][]byte{[]byte{0x27}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x27}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x27}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x31, 0x27},
		output:  [][]byte{[]byte{0x27}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x27}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x1},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xd},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xd}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xa},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xa}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xb},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xb}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x41},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x41}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x2e}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x30},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x30}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x5f},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x5f}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x22},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x22}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xc2, 0xad}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x80}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x31, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xb},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xb}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x41},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x41}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x2e},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x2e}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x30},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x30}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x5f},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x5f}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x22},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x22}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xc2, 0xad}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x31, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x1},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xd},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xa},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xb},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x41},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x2e},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x30},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x5f},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x22},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x41},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x3a, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x3a, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x41},
		output:  [][]byte{[]byte{0x61, 0x27, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x27, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x27, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x27, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x27, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x27, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x27}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x41},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x30},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a, 0xcc, 0x88}, []byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x30},
		output:  [][]byte{[]byte{0x31, 0x27, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x31, 0x27, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x27}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x27, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x27, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x27, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x27, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x27, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x27, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x27, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x27, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x27, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x30},
		output:  [][]byte{[]byte{0x31, 0x2c, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x31, 0x2c, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x2c, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x2c, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x2c, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x2c, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x2c, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x2c, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x2c, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x2c, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xd}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xa}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xb}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xe3, 0x80, 0xb1}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x2e}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x5f}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xf0, 0x9f, 0x87, 0xa6}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0xd7, 0x90}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x22}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x61, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x61}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x61}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x61}, []byte{0x27, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x61}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x3a}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x27}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x2c}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, []byte{0x2e, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x61, 0x6e, 0x27, 0x74},
		output:  [][]byte{[]byte{0x63, 0x61, 0x6e, 0x27, 0x74}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER N (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER T (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x61, 0x6e, 0xe2, 0x80, 0x99, 0x74},
		output:  [][]byte{[]byte{0x63, 0x61, 0x6e, 0xe2, 0x80, 0x99, 0x74}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER N (ALetter) × [6.0] RIGHT SINGLE QUOTATION MARK (MidNumLet) × [7.0] LATIN SMALL LETTER T (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x62, 0xc2, 0xad, 0x62, 0x79},
		output:  [][]byte{[]byte{0x61, 0x62, 0xc2, 0xad, 0x62, 0x79}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER B (ALetter) × [4.0] SOFT HYPHEN (Format_FE) × [5.0] LATIN SMALL LETTER B (ALetter) × [5.0] LATIN SMALL LETTER Y (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x24, 0x2d, 0x33, 0x34, 0x2c, 0x35, 0x36, 0x37, 0x2e, 0x31, 0x34, 0x25, 0x62},
		output:  [][]byte{[]byte{0x61}, []byte{0x24}, []byte{0x2d}, []byte{0x33, 0x34, 0x2c, 0x35, 0x36, 0x37, 0x2e, 0x31, 0x34}, []byte{0x25}, []byte{0x62}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] DOLLAR SIGN (Other) ÷ [999.0] HYPHEN-MINUS (Other) ÷ [999.0] DIGIT THREE (Numeric) × [8.0] DIGIT FOUR (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT FIVE (Numeric) × [8.0] DIGIT SIX (Numeric) × [8.0] DIGIT SEVEN (Numeric) × [12.0] FULL STOP (MidNumLet) × [11.0] DIGIT ONE (Numeric) × [8.0] DIGIT FOUR (Numeric) ÷ [999.0] PERCENT SIGN (Other) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x33, 0x61},
		output:  [][]byte{[]byte{0x33, 0x61}},
		comment: `÷ [0.2] DIGIT THREE (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x2e, 0x64},
		output:  [][]byte{[]byte{0x63, 0x2e, 0x64}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (ALetter) × [6.0] FULL STOP (MidNumLet) × [7.0] LATIN SMALL LETTER D (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x43, 0x2e, 0x64},
		output:  [][]byte{[]byte{0x43, 0x2e, 0x64}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER C (ALetter) × [6.0] FULL STOP (MidNumLet) × [7.0] LATIN SMALL LETTER D (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x2e, 0x44},
		output:  [][]byte{[]byte{0x63, 0x2e, 0x44}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (ALetter) × [6.0] FULL STOP (MidNumLet) × [7.0] LATIN CAPITAL LETTER D (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x43, 0x2e, 0x44},
		output:  [][]byte{[]byte{0x43, 0x2e, 0x44}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER C (ALetter) × [6.0] FULL STOP (MidNumLet) × [7.0] LATIN CAPITAL LETTER D (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x6e, 0xe2, 0x81, 0xa0, 0x27, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x63, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x6e, 0xe2, 0x81, 0xa0, 0x27, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER N (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER T (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x6e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x63, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x6e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER N (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] RIGHT SINGLE QUOTATION MARK (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER T (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x62, 0xe2, 0x81, 0xa0, 0xc2, 0xad, 0xe2, 0x81, 0xa0, 0x62, 0xe2, 0x81, 0xa0, 0x79, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x61, 0xe2, 0x81, 0xa0, 0x62, 0xe2, 0x81, 0xa0, 0xc2, 0xad, 0xe2, 0x81, 0xa0, 0x62, 0xe2, 0x81, 0xa0, 0x79, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER B (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER B (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER Y (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x24, 0xe2, 0x81, 0xa0, 0x2d, 0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0x2c, 0xe2, 0x81, 0xa0, 0x35, 0xe2, 0x81, 0xa0, 0x36, 0xe2, 0x81, 0xa0, 0x37, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0x25, 0xe2, 0x81, 0xa0, 0x62, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x61, 0xe2, 0x81, 0xa0}, []byte{0x24, 0xe2, 0x81, 0xa0}, []byte{0x2d, 0xe2, 0x81, 0xa0}, []byte{0x33, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0x2c, 0xe2, 0x81, 0xa0, 0x35, 0xe2, 0x81, 0xa0, 0x36, 0xe2, 0x81, 0xa0, 0x37, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0}, []byte{0x25, 0xe2, 0x81, 0xa0}, []byte{0x62, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DOLLAR SIGN (Other) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] HYPHEN-MINUS (Other) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT THREE (Numeric) × [4.0] WORD JOINER (Format_FE) × [8.0] DIGIT FOUR (Numeric) × [4.0] WORD JOINER (Format_FE) × [12.0] COMMA (MidNum) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT FIVE (Numeric) × [4.0] WORD JOINER (Format_FE) × [8.0] DIGIT SIX (Numeric) × [4.0] WORD JOINER (Format_FE) × [8.0] DIGIT SEVEN (Numeric) × [4.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) × [4.0] WORD JOINER (Format_FE) × [8.0] DIGIT FOUR (Numeric) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] PERCENT SIGN (Other) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER B (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x33, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] DIGIT THREE (Numeric) × [4.0] WORD JOINER (Format_FE) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER D (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER D (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0}, []byte{0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER C (ALetter) × [4.0] WORD JOINER (Format_FE) × [6.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0x62},
		output:  [][]byte{[]byte{0x61}, []byte{0xf0, 0x9f, 0x87, 0xa6}, []byte{0x62}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER E (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba, 0xe2, 0x80, 0x8b, 0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xb7, 0xf0, 0x9f, 0x87, 0xba}, []byte{0xe2, 0x80, 0x8b}, []byte{0xf0, 0x9f, 0x87, 0xb8, 0xf0, 0x9f, 0x87, 0xaa}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER R (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER U (Regional_Indicator) ÷ [999.0] ZERO WIDTH SPACE (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER S (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER E (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd7, 0x90, 0x22, 0xd7, 0x90},
		output:  [][]byte{[]byte{0xd7, 0x90, 0x22, 0xd7, 0x90}},
		comment: `÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.2] QUOTATION MARK (Double_Quote) × [7.3] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [4.0] ZERO WIDTH JOINER (Extend_FE) × [13.3] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Regional_Indicator) × [13.3] REGIONAL INDICATOR SYMBOL LETTER B (Regional_Indicator) × [4.0] ZERO WIDTH JOINER (Extend_FE) × [13.3] REGIONAL INDICATOR SYMBOL LETTER C (Regional_Indicator) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		output:  [][]byte{[]byte{0x20, 0xe2, 0x80, 0x8d}, []byte{0xd9, 0x86}},
		comment: `÷ [0.2] SPACE (Other) × [4.0] ZERO WIDTH JOINER (Extend_FE) ÷ [999.0] ARABIC LETTER NOON (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		output:  [][]byte{[]byte{0xd9, 0x86, 0xe2, 0x80, 0x8d}, []byte{0x20}},
		comment: `÷ [0.2] ARABIC LETTER NOON (ALetter) × [4.0] ZERO WIDTH JOINER (Extend_FE) ÷ [999.0] SPACE (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x31, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x3a}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2e}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x3a}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2e}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x31}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x31}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		output:  [][]byte{[]byte{0x61, 0x5f, 0x61}, []byte{0x2c}, []byte{0x2c}, []byte{0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]`,
	},
}
var unicodeSentenceTests = []struct {
	input   []byte
	output  [][]byte
	comment string
}{
	{
		input:   []byte{0x1, 0x1},
		output:  [][]byte{[]byte{0x1, 0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xd},
		output:  [][]byte{[]byte{0x1, 0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xa},
		output:  [][]byte{[]byte{0x1, 0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x1, 0xc2, 0x85}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x9},
		output:  [][]byte{[]byte{0x1, 0x9}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x61},
		output:  [][]byte{[]byte{0x1, 0x61}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x41},
		output:  [][]byte{[]byte{0x1, 0x41}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x1, 0xc6, 0xbb}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x30},
		output:  [][]byte{[]byte{0x1, 0x30}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x2e},
		output:  [][]byte{[]byte{0x1, 0x2e}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x21},
		output:  [][]byte{[]byte{0x1, 0x21}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x22},
		output:  [][]byte{[]byte{0x1, 0x22}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0x2c},
		output:  [][]byte{[]byte{0x1, 0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x1, 0xc2, 0xad}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x1, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x1, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <START OF HEADING> (Other) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xa},
		output:  [][]byte{[]byte{0xd, 0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xd}, []byte{0xc2, 0x85}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x9},
		output:  [][]byte{[]byte{0xd}, []byte{0x9}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x61},
		output:  [][]byte{[]byte{0xd}, []byte{0x61}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x41},
		output:  [][]byte{[]byte{0xd}, []byte{0x41}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xd}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x30},
		output:  [][]byte{[]byte{0xd}, []byte{0x30}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x2e},
		output:  [][]byte{[]byte{0xd}, []byte{0x2e}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x21},
		output:  [][]byte{[]byte{0xd}, []byte{0x21}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x22},
		output:  [][]byte{[]byte{0xd}, []byte{0x22}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xd}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xa}, []byte{0xc2, 0x85}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x9},
		output:  [][]byte{[]byte{0xa}, []byte{0x9}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x61},
		output:  [][]byte{[]byte{0xa}, []byte{0x61}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x41},
		output:  [][]byte{[]byte{0xa}, []byte{0x41}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xa}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x30},
		output:  [][]byte{[]byte{0xa}, []byte{0x30}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x2e},
		output:  [][]byte{[]byte{0xa}, []byte{0x2e}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x21},
		output:  [][]byte{[]byte{0xa}, []byte{0x21}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x22},
		output:  [][]byte{[]byte{0xa}, []byte{0x22}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xa}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xa}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x1},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x1}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xd},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xd}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xa},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xa}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xc2, 0x85}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x9},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x9}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x61},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x61}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x41},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x41}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x30},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x30}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x2e}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x21},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x21}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x22},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x22}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0x2c}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xc2, 0xad}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x80}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0x85, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0x85}, []byte{0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x1},
		output:  [][]byte{[]byte{0x9, 0x1}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xd},
		output:  [][]byte{[]byte{0x9, 0xd}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xa},
		output:  [][]byte{[]byte{0x9, 0xa}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x9, 0xc2, 0x85}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x9},
		output:  [][]byte{[]byte{0x9, 0x9}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x61},
		output:  [][]byte{[]byte{0x9, 0x61}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x41},
		output:  [][]byte{[]byte{0x9, 0x41}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x9, 0xc6, 0xbb}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x30},
		output:  [][]byte{[]byte{0x9, 0x30}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x2e},
		output:  [][]byte{[]byte{0x9, 0x2e}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x21},
		output:  [][]byte{[]byte{0x9, 0x21}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x22},
		output:  [][]byte{[]byte{0x9, 0x22}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0x2c},
		output:  [][]byte{[]byte{0x9, 0x2c}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x9, 0xc2, 0xad}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x80}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x9, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x9, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x1},
		output:  [][]byte{[]byte{0x61, 0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xd},
		output:  [][]byte{[]byte{0x61, 0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xa},
		output:  [][]byte{[]byte{0x61, 0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x61, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x9},
		output:  [][]byte{[]byte{0x61, 0x9}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x61},
		output:  [][]byte{[]byte{0x61, 0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x41},
		output:  [][]byte{[]byte{0x61, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x61, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x30},
		output:  [][]byte{[]byte{0x61, 0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2e},
		output:  [][]byte{[]byte{0x61, 0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x21},
		output:  [][]byte{[]byte{0x61, 0x21}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x22},
		output:  [][]byte{[]byte{0x61, 0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0x2c},
		output:  [][]byte{[]byte{0x61, 0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x61, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x61, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x1},
		output:  [][]byte{[]byte{0x41, 0x1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xd},
		output:  [][]byte{[]byte{0x41, 0xd}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xa},
		output:  [][]byte{[]byte{0x41, 0xa}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x41, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x9},
		output:  [][]byte{[]byte{0x41, 0x9}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x61},
		output:  [][]byte{[]byte{0x41, 0x61}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x41},
		output:  [][]byte{[]byte{0x41, 0x41}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x41, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x30},
		output:  [][]byte{[]byte{0x41, 0x30}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x2e},
		output:  [][]byte{[]byte{0x41, 0x2e}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x21},
		output:  [][]byte{[]byte{0x41, 0x21}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x22},
		output:  [][]byte{[]byte{0x41, 0x22}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0x2c},
		output:  [][]byte{[]byte{0x41, 0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x41, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x41, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x41, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x1},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x1}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xd},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xd}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xa},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xa}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x9},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x9}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x61},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x61}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x41},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x41}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x30},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x30}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x2e},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x2e}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x21},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x21}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x22},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x22}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0x2c},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0x2c}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc6, 0xbb, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc6, 0xbb, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x1},
		output:  [][]byte{[]byte{0x30, 0x1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xd},
		output:  [][]byte{[]byte{0x30, 0xd}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xa},
		output:  [][]byte{[]byte{0x30, 0xa}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x30, 0xc2, 0x85}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x9},
		output:  [][]byte{[]byte{0x30, 0x9}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x61},
		output:  [][]byte{[]byte{0x30, 0x61}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x41},
		output:  [][]byte{[]byte{0x30, 0x41}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x30, 0xc6, 0xbb}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x30},
		output:  [][]byte{[]byte{0x30, 0x30}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x2e},
		output:  [][]byte{[]byte{0x30, 0x2e}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x21},
		output:  [][]byte{[]byte{0x30, 0x21}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x22},
		output:  [][]byte{[]byte{0x30, 0x22}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0x2c},
		output:  [][]byte{[]byte{0x30, 0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x30, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x30, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x30, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x1},
		output:  [][]byte{[]byte{0x2e}, []byte{0x1}},
		comment: `÷ [0.2] FULL STOP (ATerm) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xd},
		output:  [][]byte{[]byte{0x2e, 0xd}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xa},
		output:  [][]byte{[]byte{0x2e, 0xa}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x2e, 0xc2, 0x85}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x9},
		output:  [][]byte{[]byte{0x2e, 0x9}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x61},
		output:  [][]byte{[]byte{0x2e, 0x61}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x41},
		output:  [][]byte{[]byte{0x2e}, []byte{0x41}},
		comment: `÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x2e}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x30},
		output:  [][]byte{[]byte{0x2e, 0x30}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x2e},
		output:  [][]byte{[]byte{0x2e, 0x2e}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x21},
		output:  [][]byte{[]byte{0x2e, 0x21}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x22},
		output:  [][]byte{[]byte{0x2e, 0x22}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0x2c},
		output:  [][]byte{[]byte{0x2e, 0x2c}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [8.1] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2e, 0xc2, 0xad}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x80}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2e, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2e, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x1},
		output:  [][]byte{[]byte{0x21}, []byte{0x1}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88}, []byte{0x1}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xd},
		output:  [][]byte{[]byte{0x21, 0xd}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xa},
		output:  [][]byte{[]byte{0x21, 0xa}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x21, 0xc2, 0x85}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x9},
		output:  [][]byte{[]byte{0x21, 0x9}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x61},
		output:  [][]byte{[]byte{0x21}, []byte{0x61}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88}, []byte{0x61}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x41},
		output:  [][]byte{[]byte{0x21}, []byte{0x41}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88}, []byte{0x41}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x21}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88}, []byte{0xc6, 0xbb}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x30},
		output:  [][]byte{[]byte{0x21}, []byte{0x30}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88}, []byte{0x30}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x2e},
		output:  [][]byte{[]byte{0x21, 0x2e}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x21},
		output:  [][]byte{[]byte{0x21, 0x21}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x22},
		output:  [][]byte{[]byte{0x21, 0x22}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [9.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x2c},
		output:  [][]byte{[]byte{0x21, 0x2c}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.1] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x21, 0xc2, 0xad}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x80}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x21, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x1},
		output:  [][]byte{[]byte{0x22, 0x1}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xd},
		output:  [][]byte{[]byte{0x22, 0xd}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xa},
		output:  [][]byte{[]byte{0x22, 0xa}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x22, 0xc2, 0x85}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x9},
		output:  [][]byte{[]byte{0x22, 0x9}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x61},
		output:  [][]byte{[]byte{0x22, 0x61}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x41},
		output:  [][]byte{[]byte{0x22, 0x41}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x22, 0xc6, 0xbb}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x30},
		output:  [][]byte{[]byte{0x22, 0x30}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x2e},
		output:  [][]byte{[]byte{0x22, 0x2e}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x21},
		output:  [][]byte{[]byte{0x22, 0x21}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x22},
		output:  [][]byte{[]byte{0x22, 0x22}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0x2c},
		output:  [][]byte{[]byte{0x22, 0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x22, 0xc2, 0xad}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x80}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x22, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x22, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x1},
		output:  [][]byte{[]byte{0x2c, 0x1}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xd},
		output:  [][]byte{[]byte{0x2c, 0xd}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xa},
		output:  [][]byte{[]byte{0x2c, 0xa}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x2c, 0xc2, 0x85}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x9},
		output:  [][]byte{[]byte{0x2c, 0x9}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x61},
		output:  [][]byte{[]byte{0x2c, 0x61}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x41},
		output:  [][]byte{[]byte{0x2c, 0x41}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x2c, 0xc6, 0xbb}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x30},
		output:  [][]byte{[]byte{0x2c, 0x30}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x2e},
		output:  [][]byte{[]byte{0x2c, 0x2e}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x21},
		output:  [][]byte{[]byte{0x2c, 0x21}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x22},
		output:  [][]byte{[]byte{0x2c, 0x22}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0x2c},
		output:  [][]byte{[]byte{0x2c, 0x2c}},
		comment: `÷ [0.2] COMMA (SContinue) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2c, 0xc2, 0xad}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x80}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x1},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xd},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xd}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xa},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xa}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xc2, 0x85}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x9},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x9}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x61},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x61}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x41},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x41}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xc6, 0xbb}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x30},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x30}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x2e}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x21},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x21}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x22},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x22}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad, 0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xc2, 0xad}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x80}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] SOFT HYPHEN (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x1},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x1}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <START OF HEADING> (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xd}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xa}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <LINE FEED (LF)> (LF) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xc2, 0x85}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0x85},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0x85}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x9},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x9}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x9},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x9}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x61},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x61}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x61},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x61}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x41},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x41}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x41},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x41}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xc6, 0xbb}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xc6, 0xbb},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xc6, 0xbb}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x30},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x30}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x30},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x30}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] DIGIT ZERO (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x2e},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x2e}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x2e},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x2e}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x21},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x21}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x21},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x21}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] EXCLAMATION MARK (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x22},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x22}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x22},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x22}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] QUOTATION MARK (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80, 0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0x2c},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0x2c}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [12.0] COMMA (SContinue) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xc2, 0xad}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] SOFT HYPHEN (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		output:  [][]byte{[]byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment: `÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0x28, 0x22, 0x47, 0x6f, 0x2e, 0x22, 0x29, 0x20, 0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29},
		output:  [][]byte{[]byte{0x28, 0x22, 0x47, 0x6f, 0x2e, 0x22, 0x29, 0x20}, []byte{0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29}},
		comment: `÷ [0.2] LEFT PARENTHESIS (Close) × [12.0] QUOTATION MARK (Close) × [12.0] LATIN CAPITAL LETTER G (Upper) × [12.0] LATIN SMALL LETTER O (Lower) × [12.0] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [12.0] LATIN CAPITAL LETTER H (Upper) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] SPACE (Sp) × [12.0] LATIN SMALL LETTER D (Lower) × [12.0] LATIN SMALL LETTER I (Lower) × [12.0] LATIN SMALL LETTER D (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x28, 0xe2, 0x80, 0x9c, 0x47, 0x6f, 0x3f, 0xe2, 0x80, 0x9d, 0x29, 0x20, 0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29},
		output:  [][]byte{[]byte{0x28, 0xe2, 0x80, 0x9c, 0x47, 0x6f, 0x3f, 0xe2, 0x80, 0x9d, 0x29, 0x20}, []byte{0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29}},
		comment: `÷ [0.2] LEFT PARENTHESIS (Close) × [12.0] LEFT DOUBLE QUOTATION MARK (Close) × [12.0] LATIN CAPITAL LETTER G (Upper) × [12.0] LATIN SMALL LETTER O (Lower) × [12.0] QUESTION MARK (STerm) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [12.0] LATIN CAPITAL LETTER H (Upper) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] SPACE (Sp) × [12.0] LATIN SMALL LETTER D (Lower) × [12.0] LATIN SMALL LETTER I (Lower) × [12.0] LATIN SMALL LETTER D (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]`,
	},
	{
		input:   []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e, 0x20, 0x69, 0x73},
		output:  [][]byte{[]byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e, 0x20, 0x69, 0x73}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER I (Lower) × [12.0] LATIN SMALL LETTER S (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x3f, 0x20, 0x48, 0x65},
		output:  [][]byte{[]byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x3f, 0x20}, []byte{0x48, 0x65}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] QUESTION MARK (STerm) × [9.0] SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e},
		output:  [][]byte{[]byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] FULL STOP (ATerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0x33, 0x2e, 0x34},
		output:  [][]byte{[]byte{0x33, 0x2e, 0x34}},
		comment: `÷ [0.2] DIGIT THREE (Numeric) × [12.0] FULL STOP (ATerm) × [6.0] DIGIT FOUR (Numeric) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x2e, 0x64},
		output:  [][]byte{[]byte{0x63, 0x2e, 0x64}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x43, 0x2e, 0x64},
		output:  [][]byte{[]byte{0x43, 0x2e, 0x64}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [12.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x63, 0x2e, 0x44},
		output:  [][]byte{[]byte{0x63, 0x2e, 0x44}},
		comment: `÷ [0.2] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x43, 0x2e, 0x44},
		output:  [][]byte{[]byte{0x43, 0x2e, 0x44}},
		comment: `÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [12.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x74, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x74, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x54, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0}, []byte{0x54, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x74, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x74, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [12.0] LEFT PARENTHESIS (Close) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x54, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0}, []byte{0xe2, 0x80, 0x98, 0x28, 0x54, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [12.0] LEFT PARENTHESIS (Close) × [12.0] LATIN CAPITAL LETTER T (Upper) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x74, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x74, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x54, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88}, []byte{0x54, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xcc, 0x88, 0x54, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xcc, 0x88}, []byte{0x54, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xa, 0xcc, 0x88, 0x54, 0x68, 0x65},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xa}, []byte{0xcc, 0x88, 0x54, 0x68, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_FE) × [12.0] LATIN CAPITAL LETTER T (Upper) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x2e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65},
		output:  [][]byte{[]byte{0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x2e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65}},
		comment: `÷ [0.2] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER H (Lower) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] SPACE (Sp) × [12.0] LATIN SMALL LETTER R (Lower) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER S (Lower) × [12.0] LATIN SMALL LETTER P (Lower) × [12.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER L (Lower) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER A (Lower) × [12.0] LATIN SMALL LETTER D (Lower) × [12.0] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER R (Lower) × [12.0] LATIN SMALL LETTER S (Lower) × [12.0] SPACE (Sp) × [12.0] LATIN SMALL LETTER A (Lower) × [12.0] LATIN SMALL LETTER R (Lower) × [12.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe5, 0xad, 0x97, 0x2e, 0xe5, 0xad, 0x97},
		output:  [][]byte{[]byte{0xe5, 0xad, 0x97, 0x2e}, []byte{0xe5, 0xad, 0x97}},
		comment: `÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [12.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0xe5, 0xae, 0x83},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e}, []byte{0xe5, 0xae, 0x83}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x65, 0x74, 0x63, 0x2e, 0xe3, 0x80, 0x82},
		output:  [][]byte{[]byte{0x65, 0x74, 0x63, 0x2e, 0xe3, 0x80, 0x82}},
		comment: `÷ [0.2] LATIN SMALL LETTER E (Lower) × [12.0] LATIN SMALL LETTER T (Lower) × [12.0] LATIN SMALL LETTER C (Lower) × [12.0] FULL STOP (ATerm) × [8.1] IDEOGRAPHIC FULL STOP (STerm) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe5, 0xad, 0x97, 0xe3, 0x80, 0x82, 0xe5, 0xae, 0x83},
		output:  [][]byte{[]byte{0xe5, 0xad, 0x97, 0xe3, 0x80, 0x82}, []byte{0xe5, 0xae, 0x83}},
		comment: `÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [12.0] IDEOGRAPHIC FULL STOP (STerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0x21, 0x20, 0x20},
		output:  [][]byte{[]byte{0x21, 0x20, 0x20}},
		comment: `÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] SPACE (Sp) × [10.0] SPACE (Sp) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, []byte{0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9c, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x3f, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9d, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9c, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x3f, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9d, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, []byte{0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LEFT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x3f, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x3f, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, []byte{0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING GRAVE ACCENT (Extend_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] DIGIT THREE (Numeric) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [6.0] DIGIT FOUR (Numeric) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0}, []byte{0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0}, []byte{0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, []byte{0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xa, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xa}, []byte{0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format_FE) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] WORD JOINER (Format_FE) × [5.0] COMBINING DIAERESIS (Extend_FE) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x70, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x6c, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x70, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x6c, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER P (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [8.0] LATIN SMALL LETTER L (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0}, []byte{0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0}, []byte{0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format_FE) × [12.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format_FE) × [8.1] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0}, []byte{0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format_FE) × [12.0] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format_FE) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xe2, 0x81, 0xa0, 0x21, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		output:  [][]byte{[]byte{0xe2, 0x81, 0xa0, 0x21, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment: `÷ [0.2] WORD JOINER (Format_FE) × [12.0] EXCLAMATION MARK (STerm) × [5.0] WORD JOINER (Format_FE) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [10.0] SPACE (Sp) × [5.0] WORD JOINER (Format_FE) × [5.0] WORD JOINER (Format_FE) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Other) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (Other) × [12.0] REGIONAL INDICATOR SYMBOL LETTER C (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Other) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (Other) × [12.0] REGIONAL INDICATOR SYMBOL LETTER C (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8},
		output:  [][]byte{[]byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8}},
		comment: `÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (Other) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (Other) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [12.0] REGIONAL INDICATOR SYMBOL LETTER C (Other) ÷ [0.3]`,
	},
	{
		input:   []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		output:  [][]byte{[]byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86}},
		comment: `÷ [0.2] SPACE (Sp) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [12.0] ARABIC LETTER NOON (OLetter) ÷ [0.3]`,
	},
	{
		input:   []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		output:  [][]byte{[]byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20}},
		comment: `÷ [0.2] ARABIC LETTER NOON (OLetter) × [5.0] ZERO WIDTH JOINER (Extend_FE) × [12.0] SPACE (Sp) ÷ [0.3]`,
	},
}
