// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation
func (c *GuardDuty) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for Amazon GuardDuty.
//
// Accepts the invitation to be monitored by a GuardDuty administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation
func (c *GuardDuty) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opArchiveFindings = "ArchiveFindings"

// ArchiveFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ArchiveFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ArchiveFindings for more information on using the ArchiveFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ArchiveFindingsRequest method.
//    req, resp := client.ArchiveFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings
func (c *GuardDuty) ArchiveFindingsRequest(input *ArchiveFindingsInput) (req *request.Request, output *ArchiveFindingsOutput) {
	op := &request.Operation{
		Name:       opArchiveFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/archive",
	}

	if input == nil {
		input = &ArchiveFindingsInput{}
	}

	output = &ArchiveFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ArchiveFindings API operation for Amazon GuardDuty.
//
// Archives GuardDuty findings that are specified by the list of finding IDs.
//
// Only the administrator account can archive findings. Member accounts don't
// have permission to archive findings from their accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ArchiveFindings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings
func (c *GuardDuty) ArchiveFindings(input *ArchiveFindingsInput) (*ArchiveFindingsOutput, error) {
	req, out := c.ArchiveFindingsRequest(input)
	return out, req.Send()
}

// ArchiveFindingsWithContext is the same as ArchiveFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ArchiveFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ArchiveFindingsWithContext(ctx aws.Context, input *ArchiveFindingsInput, opts ...request.Option) (*ArchiveFindingsOutput, error) {
	req, out := c.ArchiveFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDetector = "CreateDetector"

// CreateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetector for more information on using the CreateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDetectorRequest method.
//    req, resp := client.CreateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector
func (c *GuardDuty) CreateDetectorRequest(input *CreateDetectorInput) (req *request.Request, output *CreateDetectorOutput) {
	op := &request.Operation{
		Name:       opCreateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detector",
	}

	if input == nil {
		input = &CreateDetectorInput{}
	}

	output = &CreateDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetector API operation for Amazon GuardDuty.
//
// Creates a single Amazon GuardDuty detector. A detector is a resource that
// represents the GuardDuty service. To start using GuardDuty, you must create
// a detector in each Region where you enable the service. You can have only
// one detector per account per Region. All data sources are enabled in a new
// detector by default.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateDetector for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector
func (c *GuardDuty) CreateDetector(input *CreateDetectorInput) (*CreateDetectorOutput, error) {
	req, out := c.CreateDetectorRequest(input)
	return out, req.Send()
}

// CreateDetectorWithContext is the same as CreateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateDetectorWithContext(ctx aws.Context, input *CreateDetectorInput, opts ...request.Option) (*CreateDetectorOutput, error) {
	req, out := c.CreateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFilter = "CreateFilter"

// CreateFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFilter for more information on using the CreateFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFilterRequest method.
//    req, resp := client.CreateFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter
func (c *GuardDuty) CreateFilterRequest(input *CreateFilterInput) (req *request.Request, output *CreateFilterOutput) {
	op := &request.Operation{
		Name:       opCreateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/filter",
	}

	if input == nil {
		input = &CreateFilterInput{}
	}

	output = &CreateFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFilter API operation for Amazon GuardDuty.
//
// Creates a filter using the specified finding criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter
func (c *GuardDuty) CreateFilter(input *CreateFilterInput) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	return out, req.Send()
}

// CreateFilterWithContext is the same as CreateFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateFilterWithContext(ctx aws.Context, input *CreateFilterInput, opts ...request.Option) (*CreateFilterOutput, error) {
	req, out := c.CreateFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIPSet for more information on using the CreateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet
func (c *GuardDuty) CreateIPSetRequest(input *CreateIPSetInput) (req *request.Request, output *CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/ipset",
	}

	if input == nil {
		input = &CreateIPSetInput{}
	}

	output = &CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for Amazon GuardDuty.
//
// Creates a new IPSet, which is called a trusted IP list in the console user
// interface. An IPSet is a list of IP addresses that are trusted for secure
// communication with AWS infrastructure and applications. GuardDuty doesn't
// generate findings for IP addresses that are included in IPSets. Only users
// from the administrator account can use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet
func (c *GuardDuty) CreateIPSet(input *CreateIPSetInput) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateIPSetWithContext(ctx aws.Context, input *CreateIPSetInput, opts ...request.Option) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers
func (c *GuardDuty) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for Amazon GuardDuty.
//
// Creates member accounts of the current AWS account by specifying a list of
// AWS account IDs. This step is a prerequisite for managing the associated
// member accounts either by invitation or through an organization.
//
// When using Create Members as an organizations delegated administrator this
// action will enable GuardDuty in the added member accounts, with the exception
// of the organization delegated administrator account, which must enable GuardDuty
// prior to being added as a member.
//
// If you are adding accounts by invitation use this action after GuardDuty
// has been enabled in potential member accounts and before using Invite Members
// (https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers
func (c *GuardDuty) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublishingDestination = "CreatePublishingDestination"

// CreatePublishingDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublishingDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublishingDestination for more information on using the CreatePublishingDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublishingDestinationRequest method.
//    req, resp := client.CreatePublishingDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination
func (c *GuardDuty) CreatePublishingDestinationRequest(input *CreatePublishingDestinationInput) (req *request.Request, output *CreatePublishingDestinationOutput) {
	op := &request.Operation{
		Name:       opCreatePublishingDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/publishingDestination",
	}

	if input == nil {
		input = &CreatePublishingDestinationInput{}
	}

	output = &CreatePublishingDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublishingDestination API operation for Amazon GuardDuty.
//
// Creates a publishing destination to export findings to. The resource to export
// findings to must exist before you use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreatePublishingDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination
func (c *GuardDuty) CreatePublishingDestination(input *CreatePublishingDestinationInput) (*CreatePublishingDestinationOutput, error) {
	req, out := c.CreatePublishingDestinationRequest(input)
	return out, req.Send()
}

// CreatePublishingDestinationWithContext is the same as CreatePublishingDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublishingDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreatePublishingDestinationWithContext(ctx aws.Context, input *CreatePublishingDestinationInput, opts ...request.Option) (*CreatePublishingDestinationOutput, error) {
	req, out := c.CreatePublishingDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSampleFindings = "CreateSampleFindings"

// CreateSampleFindingsRequest generates a "aws/request.Request" representing the
// client's request for the CreateSampleFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSampleFindings for more information on using the CreateSampleFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSampleFindingsRequest method.
//    req, resp := client.CreateSampleFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings
func (c *GuardDuty) CreateSampleFindingsRequest(input *CreateSampleFindingsInput) (req *request.Request, output *CreateSampleFindingsOutput) {
	op := &request.Operation{
		Name:       opCreateSampleFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/create",
	}

	if input == nil {
		input = &CreateSampleFindingsInput{}
	}

	output = &CreateSampleFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateSampleFindings API operation for Amazon GuardDuty.
//
// Generates example findings of types specified by the list of finding types.
// If 'NULL' is specified for findingTypes, the API generates example findings
// of all supported finding types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateSampleFindings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings
func (c *GuardDuty) CreateSampleFindings(input *CreateSampleFindingsInput) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	return out, req.Send()
}

// CreateSampleFindingsWithContext is the same as CreateSampleFindings with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSampleFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateSampleFindingsWithContext(ctx aws.Context, input *CreateSampleFindingsInput, opts ...request.Option) (*CreateSampleFindingsOutput, error) {
	req, out := c.CreateSampleFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThreatIntelSet = "CreateThreatIntelSet"

// CreateThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThreatIntelSet for more information on using the CreateThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThreatIntelSetRequest method.
//    req, resp := client.CreateThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet
func (c *GuardDuty) CreateThreatIntelSetRequest(input *CreateThreatIntelSetInput) (req *request.Request, output *CreateThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opCreateThreatIntelSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/threatintelset",
	}

	if input == nil {
		input = &CreateThreatIntelSetInput{}
	}

	output = &CreateThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThreatIntelSet API operation for Amazon GuardDuty.
//
// Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious
// IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only
// users of the administrator account can use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation CreateThreatIntelSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet
func (c *GuardDuty) CreateThreatIntelSet(input *CreateThreatIntelSetInput) (*CreateThreatIntelSetOutput, error) {
	req, out := c.CreateThreatIntelSetRequest(input)
	return out, req.Send()
}

// CreateThreatIntelSetWithContext is the same as CreateThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) CreateThreatIntelSetWithContext(ctx aws.Context, input *CreateThreatIntelSetInput, opts ...request.Option) (*CreateThreatIntelSetOutput, error) {
	req, out := c.CreateThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations
func (c *GuardDuty) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for Amazon GuardDuty.
//
// Declines invitations sent to the current member account by AWS accounts specified
// by their account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations
func (c *GuardDuty) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetector = "DeleteDetector"

// DeleteDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetector for more information on using the DeleteDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorRequest method.
//    req, resp := client.DeleteDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector
func (c *GuardDuty) DeleteDetectorRequest(input *DeleteDetectorInput) (req *request.Request, output *DeleteDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteDetector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &DeleteDetectorInput{}
	}

	output = &DeleteDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetector API operation for Amazon GuardDuty.
//
// Deletes an Amazon GuardDuty detector that is specified by the detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteDetector for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector
func (c *GuardDuty) DeleteDetector(input *DeleteDetectorInput) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	return out, req.Send()
}

// DeleteDetectorWithContext is the same as DeleteDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteDetectorWithContext(ctx aws.Context, input *DeleteDetectorInput, opts ...request.Option) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFilter = "DeleteFilter"

// DeleteFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFilter for more information on using the DeleteFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFilterRequest method.
//    req, resp := client.DeleteFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter
func (c *GuardDuty) DeleteFilterRequest(input *DeleteFilterInput) (req *request.Request, output *DeleteFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteFilter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/filter/{filterName}",
	}

	if input == nil {
		input = &DeleteFilterInput{}
	}

	output = &DeleteFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFilter API operation for Amazon GuardDuty.
//
// Deletes the filter specified by the filter name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter
func (c *GuardDuty) DeleteFilter(input *DeleteFilterInput) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	return out, req.Send()
}

// DeleteFilterWithContext is the same as DeleteFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteFilterWithContext(ctx aws.Context, input *DeleteFilterInput, opts ...request.Option) (*DeleteFilterOutput, error) {
	req, out := c.DeleteFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIPSet for more information on using the DeleteIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet
func (c *GuardDuty) DeleteIPSetRequest(input *DeleteIPSetInput) (req *request.Request, output *DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &DeleteIPSetInput{}
	}

	output = &DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIPSet API operation for Amazon GuardDuty.
//
// Deletes the IPSet specified by the ipSetId. IPSets are called trusted IP
// lists in the console user interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet
func (c *GuardDuty) DeleteIPSet(input *DeleteIPSetInput) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteIPSetWithContext(ctx aws.Context, input *DeleteIPSetInput, opts ...request.Option) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations
func (c *GuardDuty) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for Amazon GuardDuty.
//
// Deletes invitations sent to the current member account by AWS accounts specified
// by their account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations
func (c *GuardDuty) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers
func (c *GuardDuty) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for Amazon GuardDuty.
//
// Deletes GuardDuty member accounts (to the current GuardDuty administrator
// account) specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers
func (c *GuardDuty) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublishingDestination = "DeletePublishingDestination"

// DeletePublishingDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublishingDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublishingDestination for more information on using the DeletePublishingDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublishingDestinationRequest method.
//    req, resp := client.DeletePublishingDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination
func (c *GuardDuty) DeletePublishingDestinationRequest(input *DeletePublishingDestinationInput) (req *request.Request, output *DeletePublishingDestinationOutput) {
	op := &request.Operation{
		Name:       opDeletePublishingDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/publishingDestination/{destinationId}",
	}

	if input == nil {
		input = &DeletePublishingDestinationInput{}
	}

	output = &DeletePublishingDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublishingDestination API operation for Amazon GuardDuty.
//
// Deletes the publishing definition with the specified destinationId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeletePublishingDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination
func (c *GuardDuty) DeletePublishingDestination(input *DeletePublishingDestinationInput) (*DeletePublishingDestinationOutput, error) {
	req, out := c.DeletePublishingDestinationRequest(input)
	return out, req.Send()
}

// DeletePublishingDestinationWithContext is the same as DeletePublishingDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublishingDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeletePublishingDestinationWithContext(ctx aws.Context, input *DeletePublishingDestinationInput, opts ...request.Option) (*DeletePublishingDestinationOutput, error) {
	req, out := c.DeletePublishingDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThreatIntelSet = "DeleteThreatIntelSet"

// DeleteThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThreatIntelSet for more information on using the DeleteThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThreatIntelSetRequest method.
//    req, resp := client.DeleteThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet
func (c *GuardDuty) DeleteThreatIntelSetRequest(input *DeleteThreatIntelSetInput) (req *request.Request, output *DeleteThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opDeleteThreatIntelSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &DeleteThreatIntelSetInput{}
	}

	output = &DeleteThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteThreatIntelSet API operation for Amazon GuardDuty.
//
// Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DeleteThreatIntelSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet
func (c *GuardDuty) DeleteThreatIntelSet(input *DeleteThreatIntelSetInput) (*DeleteThreatIntelSetOutput, error) {
	req, out := c.DeleteThreatIntelSetRequest(input)
	return out, req.Send()
}

// DeleteThreatIntelSetWithContext is the same as DeleteThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DeleteThreatIntelSetWithContext(ctx aws.Context, input *DeleteThreatIntelSetInput, opts ...request.Option) (*DeleteThreatIntelSetOutput, error) {
	req, out := c.DeleteThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigurationRequest method.
//    req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration
func (c *GuardDuty) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/admin",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for Amazon GuardDuty.
//
// Returns information about the account selected as the delegated administrator
// for GuardDuty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribeOrganizationConfiguration
func (c *GuardDuty) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePublishingDestination = "DescribePublishingDestination"

// DescribePublishingDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DescribePublishingDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePublishingDestination for more information on using the DescribePublishingDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePublishingDestinationRequest method.
//    req, resp := client.DescribePublishingDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination
func (c *GuardDuty) DescribePublishingDestinationRequest(input *DescribePublishingDestinationInput) (req *request.Request, output *DescribePublishingDestinationOutput) {
	op := &request.Operation{
		Name:       opDescribePublishingDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/publishingDestination/{destinationId}",
	}

	if input == nil {
		input = &DescribePublishingDestinationInput{}
	}

	output = &DescribePublishingDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePublishingDestination API operation for Amazon GuardDuty.
//
// Returns information about the publishing destination specified by the provided
// destinationId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DescribePublishingDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination
func (c *GuardDuty) DescribePublishingDestination(input *DescribePublishingDestinationInput) (*DescribePublishingDestinationOutput, error) {
	req, out := c.DescribePublishingDestinationRequest(input)
	return out, req.Send()
}

// DescribePublishingDestinationWithContext is the same as DescribePublishingDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePublishingDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DescribePublishingDestinationWithContext(ctx aws.Context, input *DescribePublishingDestinationInput, opts ...request.Option) (*DescribePublishingDestinationOutput, error) {
	req, out := c.DescribePublishingDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableOrganizationAdminAccountRequest method.
//    req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount
func (c *GuardDuty) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/admin/disable",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for Amazon GuardDuty.
//
// Disables an AWS account within the Organization as the GuardDuty delegated
// administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisableOrganizationAdminAccount
func (c *GuardDuty) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount
func (c *GuardDuty) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for Amazon GuardDuty.
//
// Disassociates the current GuardDuty member account from its administrator
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount
func (c *GuardDuty) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers
func (c *GuardDuty) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateMembers API operation for Amazon GuardDuty.
//
// Disassociates GuardDuty member accounts (to the current GuardDuty administrator
// account) specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers
func (c *GuardDuty) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableOrganizationAdminAccountRequest method.
//    req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount
func (c *GuardDuty) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/admin/enable",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for Amazon GuardDuty.
//
// Enables an AWS account within the organization as the GuardDuty delegated
// administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/EnableOrganizationAdminAccount
func (c *GuardDuty) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetector = "GetDetector"

// GetDetectorRequest generates a "aws/request.Request" representing the
// client's request for the GetDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetector for more information on using the GetDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorRequest method.
//    req, resp := client.GetDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector
func (c *GuardDuty) GetDetectorRequest(input *GetDetectorInput) (req *request.Request, output *GetDetectorOutput) {
	op := &request.Operation{
		Name:       opGetDetector,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &GetDetectorInput{}
	}

	output = &GetDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetector API operation for Amazon GuardDuty.
//
// Retrieves an Amazon GuardDuty detector specified by the detectorId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetDetector for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector
func (c *GuardDuty) GetDetector(input *GetDetectorInput) (*GetDetectorOutput, error) {
	req, out := c.GetDetectorRequest(input)
	return out, req.Send()
}

// GetDetectorWithContext is the same as GetDetector with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetDetectorWithContext(ctx aws.Context, input *GetDetectorInput, opts ...request.Option) (*GetDetectorOutput, error) {
	req, out := c.GetDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFilter = "GetFilter"

// GetFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFilter for more information on using the GetFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFilterRequest method.
//    req, resp := client.GetFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter
func (c *GuardDuty) GetFilterRequest(input *GetFilterInput) (req *request.Request, output *GetFilterOutput) {
	op := &request.Operation{
		Name:       opGetFilter,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/filter/{filterName}",
	}

	if input == nil {
		input = &GetFilterInput{}
	}

	output = &GetFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFilter API operation for Amazon GuardDuty.
//
// Returns the details of the filter specified by the filter name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter
func (c *GuardDuty) GetFilter(input *GetFilterInput) (*GetFilterOutput, error) {
	req, out := c.GetFilterRequest(input)
	return out, req.Send()
}

// GetFilterWithContext is the same as GetFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetFilterWithContext(ctx aws.Context, input *GetFilterInput, opts ...request.Option) (*GetFilterOutput, error) {
	req, out := c.GetFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings
func (c *GuardDuty) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/get",
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for Amazon GuardDuty.
//
// Describes Amazon GuardDuty findings specified by finding IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings
func (c *GuardDuty) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindingsStatistics = "GetFindingsStatistics"

// GetFindingsStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindingsStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindingsStatistics for more information on using the GetFindingsStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsStatisticsRequest method.
//    req, resp := client.GetFindingsStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics
func (c *GuardDuty) GetFindingsStatisticsRequest(input *GetFindingsStatisticsInput) (req *request.Request, output *GetFindingsStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetFindingsStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/statistics",
	}

	if input == nil {
		input = &GetFindingsStatisticsInput{}
	}

	output = &GetFindingsStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindingsStatistics API operation for Amazon GuardDuty.
//
// Lists Amazon GuardDuty findings statistics for the specified detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetFindingsStatistics for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics
func (c *GuardDuty) GetFindingsStatistics(input *GetFindingsStatisticsInput) (*GetFindingsStatisticsOutput, error) {
	req, out := c.GetFindingsStatisticsRequest(input)
	return out, req.Send()
}

// GetFindingsStatisticsWithContext is the same as GetFindingsStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindingsStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetFindingsStatisticsWithContext(ctx aws.Context, input *GetFindingsStatisticsInput, opts ...request.Option) (*GetFindingsStatisticsOutput, error) {
	req, out := c.GetFindingsStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIPSet for more information on using the GetIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet
func (c *GuardDuty) GetIPSetRequest(input *GetIPSetInput) (req *request.Request, output *GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &GetIPSetInput{}
	}

	output = &GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for Amazon GuardDuty.
//
// Retrieves the IPSet specified by the ipSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetIPSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet
func (c *GuardDuty) GetIPSet(input *GetIPSetInput) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetIPSetWithContext(ctx aws.Context, input *GetIPSetInput, opts ...request.Option) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount
func (c *GuardDuty) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitation/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for Amazon GuardDuty.
//
// Returns the count of all GuardDuty membership invitations that were sent
// to the current member account except the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount
func (c *GuardDuty) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount
func (c *GuardDuty) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for Amazon GuardDuty.
//
// Provides the details for the GuardDuty administrator account associated with
// the current GuardDuty member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount
func (c *GuardDuty) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMemberDetectors = "GetMemberDetectors"

// GetMemberDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetMemberDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMemberDetectors for more information on using the GetMemberDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMemberDetectorsRequest method.
//    req, resp := client.GetMemberDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors
func (c *GuardDuty) GetMemberDetectorsRequest(input *GetMemberDetectorsInput) (req *request.Request, output *GetMemberDetectorsOutput) {
	op := &request.Operation{
		Name:       opGetMemberDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/detector/get",
	}

	if input == nil {
		input = &GetMemberDetectorsInput{}
	}

	output = &GetMemberDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMemberDetectors API operation for Amazon GuardDuty.
//
// Describes which data sources are enabled for the member account's detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetMemberDetectors for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMemberDetectors
func (c *GuardDuty) GetMemberDetectors(input *GetMemberDetectorsInput) (*GetMemberDetectorsOutput, error) {
	req, out := c.GetMemberDetectorsRequest(input)
	return out, req.Send()
}

// GetMemberDetectorsWithContext is the same as GetMemberDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetMemberDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetMemberDetectorsWithContext(ctx aws.Context, input *GetMemberDetectorsInput, opts ...request.Option) (*GetMemberDetectorsOutput, error) {
	req, out := c.GetMemberDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers
func (c *GuardDuty) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for Amazon GuardDuty.
//
// Retrieves GuardDuty member accounts (of the current GuardDuty administrator
// account) specified by the account IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers
func (c *GuardDuty) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThreatIntelSet = "GetThreatIntelSet"

// GetThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the GetThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThreatIntelSet for more information on using the GetThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetThreatIntelSetRequest method.
//    req, resp := client.GetThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet
func (c *GuardDuty) GetThreatIntelSetRequest(input *GetThreatIntelSetInput) (req *request.Request, output *GetThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opGetThreatIntelSet,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &GetThreatIntelSetInput{}
	}

	output = &GetThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThreatIntelSet API operation for Amazon GuardDuty.
//
// Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetThreatIntelSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet
func (c *GuardDuty) GetThreatIntelSet(input *GetThreatIntelSetInput) (*GetThreatIntelSetOutput, error) {
	req, out := c.GetThreatIntelSetRequest(input)
	return out, req.Send()
}

// GetThreatIntelSetWithContext is the same as GetThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetThreatIntelSetWithContext(ctx aws.Context, input *GetThreatIntelSetInput, opts ...request.Option) (*GetThreatIntelSetOutput, error) {
	req, out := c.GetThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsageStatistics = "GetUsageStatistics"

// GetUsageStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageStatistics for more information on using the GetUsageStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsageStatisticsRequest method.
//    req, resp := client.GetUsageStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics
func (c *GuardDuty) GetUsageStatisticsRequest(input *GetUsageStatisticsInput) (req *request.Request, output *GetUsageStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetUsageStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/usage/statistics",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsageStatisticsInput{}
	}

	output = &GetUsageStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageStatistics API operation for Amazon GuardDuty.
//
// Lists Amazon GuardDuty usage statistics over the last 30 days for the specified
// detector ID. For newly enabled detectors or data sources the cost returned
// will include only the usage so far under 30 days, this may differ from the
// cost metrics in the console, which projects usage over 30 days to provide
// a monthly cost estimate. For more information see Understanding How Usage
// Costs are Calculated (https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation GetUsageStatistics for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetUsageStatistics
func (c *GuardDuty) GetUsageStatistics(input *GetUsageStatisticsInput) (*GetUsageStatisticsOutput, error) {
	req, out := c.GetUsageStatisticsRequest(input)
	return out, req.Send()
}

// GetUsageStatisticsWithContext is the same as GetUsageStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetUsageStatisticsWithContext(ctx aws.Context, input *GetUsageStatisticsInput, opts ...request.Option) (*GetUsageStatisticsOutput, error) {
	req, out := c.GetUsageStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUsageStatisticsPages iterates over the pages of a GetUsageStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUsageStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUsageStatistics operation.
//    pageNum := 0
//    err := client.GetUsageStatisticsPages(params,
//        func(page *guardduty.GetUsageStatisticsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) GetUsageStatisticsPages(input *GetUsageStatisticsInput, fn func(*GetUsageStatisticsOutput, bool) bool) error {
	return c.GetUsageStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUsageStatisticsPagesWithContext same as GetUsageStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) GetUsageStatisticsPagesWithContext(ctx aws.Context, input *GetUsageStatisticsInput, fn func(*GetUsageStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUsageStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUsageStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUsageStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers
func (c *GuardDuty) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for Amazon GuardDuty.
//
// Invites other AWS accounts (created as members of the current AWS account
// by CreateMembers) to enable GuardDuty, and allow the current AWS account
// to view and manage these accounts' findings on their behalf as the GuardDuty
// administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation InviteMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers
func (c *GuardDuty) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectors = "ListDetectors"

// ListDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectors for more information on using the ListDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorsRequest method.
//    req, resp := client.ListDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors
func (c *GuardDuty) ListDetectorsRequest(input *ListDetectorsInput) (req *request.Request, output *ListDetectorsOutput) {
	op := &request.Operation{
		Name:       opListDetectors,
		HTTPMethod: "GET",
		HTTPPath:   "/detector",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDetectorsInput{}
	}

	output = &ListDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectors API operation for Amazon GuardDuty.
//
// Lists detectorIds of all the existing Amazon GuardDuty detector resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListDetectors for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors
func (c *GuardDuty) ListDetectors(input *ListDetectorsInput) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	return out, req.Send()
}

// ListDetectorsWithContext is the same as ListDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListDetectorsWithContext(ctx aws.Context, input *ListDetectorsInput, opts ...request.Option) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDetectorsPages iterates over the pages of a ListDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDetectors operation.
//    pageNum := 0
//    err := client.ListDetectorsPages(params,
//        func(page *guardduty.ListDetectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListDetectorsPages(input *ListDetectorsInput, fn func(*ListDetectorsOutput, bool) bool) error {
	return c.ListDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDetectorsPagesWithContext same as ListDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListDetectorsPagesWithContext(ctx aws.Context, input *ListDetectorsInput, fn func(*ListDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFilters = "ListFilters"

// ListFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFilters for more information on using the ListFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFiltersRequest method.
//    req, resp := client.ListFiltersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters
func (c *GuardDuty) ListFiltersRequest(input *ListFiltersInput) (req *request.Request, output *ListFiltersOutput) {
	op := &request.Operation{
		Name:       opListFilters,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/filter",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFiltersInput{}
	}

	output = &ListFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFilters API operation for Amazon GuardDuty.
//
// Returns a paginated list of the current filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListFilters for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters
func (c *GuardDuty) ListFilters(input *ListFiltersInput) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	return out, req.Send()
}

// ListFiltersWithContext is the same as ListFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFiltersWithContext(ctx aws.Context, input *ListFiltersInput, opts ...request.Option) (*ListFiltersOutput, error) {
	req, out := c.ListFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFiltersPages iterates over the pages of a ListFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFilters operation.
//    pageNum := 0
//    err := client.ListFiltersPages(params,
//        func(page *guardduty.ListFiltersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListFiltersPages(input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool) error {
	return c.ListFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFiltersPagesWithContext same as ListFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFiltersPagesWithContext(ctx aws.Context, input *ListFiltersInput, fn func(*ListFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindings for more information on using the ListFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFindingsRequest method.
//    req, resp := client.ListFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings
func (c *GuardDuty) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	output = &ListFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindings API operation for Amazon GuardDuty.
//
// Lists Amazon GuardDuty findings for the specified detector ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListFindings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings
func (c *GuardDuty) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	return out, req.Send()
}

// ListFindingsWithContext is the same as ListFindings with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFindingsWithContext(ctx aws.Context, input *ListFindingsInput, opts ...request.Option) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsPages iterates over the pages of a ListFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFindings operation.
//    pageNum := 0
//    err := client.ListFindingsPages(params,
//        func(page *guardduty.ListFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListFindingsPages(input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool) error {
	return c.ListFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsPagesWithContext same as ListFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListFindingsPagesWithContext(ctx aws.Context, input *ListFindingsInput, fn func(*ListFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets
func (c *GuardDuty) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/ipset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	output = &ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for Amazon GuardDuty.
//
// Lists the IPSets of the GuardDuty service specified by the detector ID. If
// you use this operation from a member account, the IPSets returned are the
// IPSets from the associated administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListIPSets for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets
func (c *GuardDuty) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListIPSetsWithContext(ctx aws.Context, input *ListIPSetsInput, opts ...request.Option) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIPSetsPages iterates over the pages of a ListIPSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIPSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIPSets operation.
//    pageNum := 0
//    err := client.ListIPSetsPages(params,
//        func(page *guardduty.ListIPSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListIPSetsPages(input *ListIPSetsInput, fn func(*ListIPSetsOutput, bool) bool) error {
	return c.ListIPSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIPSetsPagesWithContext same as ListIPSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListIPSetsPagesWithContext(ctx aws.Context, input *ListIPSetsInput, fn func(*ListIPSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIPSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIPSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIPSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations
func (c *GuardDuty) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon GuardDuty.
//
// Lists all GuardDuty membership invitations that were sent to the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations
func (c *GuardDuty) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *guardduty.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers
func (c *GuardDuty) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/member",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon GuardDuty.
//
// Lists details about all member accounts for the current GuardDuty administrator
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers
func (c *GuardDuty) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *guardduty.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationAdminAccountsRequest method.
//    req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts
func (c *GuardDuty) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/admin",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for Amazon GuardDuty.
//
// Lists the accounts configured as GuardDuty delegated administrators.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListOrganizationAdminAccounts
func (c *GuardDuty) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//    pageNum := 0
//    err := client.ListOrganizationAdminAccountsPages(params,
//        func(page *guardduty.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPublishingDestinations = "ListPublishingDestinations"

// ListPublishingDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPublishingDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublishingDestinations for more information on using the ListPublishingDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublishingDestinationsRequest method.
//    req, resp := client.ListPublishingDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations
func (c *GuardDuty) ListPublishingDestinationsRequest(input *ListPublishingDestinationsInput) (req *request.Request, output *ListPublishingDestinationsOutput) {
	op := &request.Operation{
		Name:       opListPublishingDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/publishingDestination",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPublishingDestinationsInput{}
	}

	output = &ListPublishingDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublishingDestinations API operation for Amazon GuardDuty.
//
// Returns a list of publishing destinations associated with the specified dectectorId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListPublishingDestinations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations
func (c *GuardDuty) ListPublishingDestinations(input *ListPublishingDestinationsInput) (*ListPublishingDestinationsOutput, error) {
	req, out := c.ListPublishingDestinationsRequest(input)
	return out, req.Send()
}

// ListPublishingDestinationsWithContext is the same as ListPublishingDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublishingDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListPublishingDestinationsWithContext(ctx aws.Context, input *ListPublishingDestinationsInput, opts ...request.Option) (*ListPublishingDestinationsOutput, error) {
	req, out := c.ListPublishingDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPublishingDestinationsPages iterates over the pages of a ListPublishingDestinations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPublishingDestinations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPublishingDestinations operation.
//    pageNum := 0
//    err := client.ListPublishingDestinationsPages(params,
//        func(page *guardduty.ListPublishingDestinationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListPublishingDestinationsPages(input *ListPublishingDestinationsInput, fn func(*ListPublishingDestinationsOutput, bool) bool) error {
	return c.ListPublishingDestinationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPublishingDestinationsPagesWithContext same as ListPublishingDestinationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListPublishingDestinationsPagesWithContext(ctx aws.Context, input *ListPublishingDestinationsInput, fn func(*ListPublishingDestinationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPublishingDestinationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPublishingDestinationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPublishingDestinationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource
func (c *GuardDuty) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon GuardDuty.
//
// Lists tags for a resource. Tagging is currently supported for detectors,
// finding filters, IP sets, and threat intel sets, with a limit of 50 tags
// per resource. When invoked, this operation returns all assigned tags for
// a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource
func (c *GuardDuty) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThreatIntelSets = "ListThreatIntelSets"

// ListThreatIntelSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListThreatIntelSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThreatIntelSets for more information on using the ListThreatIntelSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThreatIntelSetsRequest method.
//    req, resp := client.ListThreatIntelSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets
func (c *GuardDuty) ListThreatIntelSetsRequest(input *ListThreatIntelSetsInput) (req *request.Request, output *ListThreatIntelSetsOutput) {
	op := &request.Operation{
		Name:       opListThreatIntelSets,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/threatintelset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThreatIntelSetsInput{}
	}

	output = &ListThreatIntelSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThreatIntelSets API operation for Amazon GuardDuty.
//
// Lists the ThreatIntelSets of the GuardDuty service specified by the detector
// ID. If you use this operation from a member account, the ThreatIntelSets
// associated with the administrator account are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation ListThreatIntelSets for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets
func (c *GuardDuty) ListThreatIntelSets(input *ListThreatIntelSetsInput) (*ListThreatIntelSetsOutput, error) {
	req, out := c.ListThreatIntelSetsRequest(input)
	return out, req.Send()
}

// ListThreatIntelSetsWithContext is the same as ListThreatIntelSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListThreatIntelSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListThreatIntelSetsWithContext(ctx aws.Context, input *ListThreatIntelSetsInput, opts ...request.Option) (*ListThreatIntelSetsOutput, error) {
	req, out := c.ListThreatIntelSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThreatIntelSetsPages iterates over the pages of a ListThreatIntelSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThreatIntelSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListThreatIntelSets operation.
//    pageNum := 0
//    err := client.ListThreatIntelSetsPages(params,
//        func(page *guardduty.ListThreatIntelSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GuardDuty) ListThreatIntelSetsPages(input *ListThreatIntelSetsInput, fn func(*ListThreatIntelSetsOutput, bool) bool) error {
	return c.ListThreatIntelSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThreatIntelSetsPagesWithContext same as ListThreatIntelSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) ListThreatIntelSetsPagesWithContext(ctx aws.Context, input *ListThreatIntelSetsInput, fn func(*ListThreatIntelSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThreatIntelSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThreatIntelSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThreatIntelSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartMonitoringMembers = "StartMonitoringMembers"

// StartMonitoringMembersRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringMembers for more information on using the StartMonitoringMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMonitoringMembersRequest method.
//    req, resp := client.StartMonitoringMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers
func (c *GuardDuty) StartMonitoringMembersRequest(input *StartMonitoringMembersInput) (req *request.Request, output *StartMonitoringMembersOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/start",
	}

	if input == nil {
		input = &StartMonitoringMembersInput{}
	}

	output = &StartMonitoringMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMonitoringMembers API operation for Amazon GuardDuty.
//
// Turns on GuardDuty monitoring of the specified member accounts. Use this
// operation to restart monitoring of accounts that you stopped monitoring with
// the StopMonitoringMembers operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation StartMonitoringMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers
func (c *GuardDuty) StartMonitoringMembers(input *StartMonitoringMembersInput) (*StartMonitoringMembersOutput, error) {
	req, out := c.StartMonitoringMembersRequest(input)
	return out, req.Send()
}

// StartMonitoringMembersWithContext is the same as StartMonitoringMembers with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) StartMonitoringMembersWithContext(ctx aws.Context, input *StartMonitoringMembersInput, opts ...request.Option) (*StartMonitoringMembersOutput, error) {
	req, out := c.StartMonitoringMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMonitoringMembers = "StopMonitoringMembers"

// StopMonitoringMembersRequest generates a "aws/request.Request" representing the
// client's request for the StopMonitoringMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMonitoringMembers for more information on using the StopMonitoringMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMonitoringMembersRequest method.
//    req, resp := client.StopMonitoringMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers
func (c *GuardDuty) StopMonitoringMembersRequest(input *StopMonitoringMembersInput) (req *request.Request, output *StopMonitoringMembersOutput) {
	op := &request.Operation{
		Name:       opStopMonitoringMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/stop",
	}

	if input == nil {
		input = &StopMonitoringMembersInput{}
	}

	output = &StopMonitoringMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopMonitoringMembers API operation for Amazon GuardDuty.
//
// Stops GuardDuty monitoring for the specified member accounts. Use the StartMonitoringMembers
// operation to restart monitoring for those accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation StopMonitoringMembers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers
func (c *GuardDuty) StopMonitoringMembers(input *StopMonitoringMembersInput) (*StopMonitoringMembersOutput, error) {
	req, out := c.StopMonitoringMembersRequest(input)
	return out, req.Send()
}

// StopMonitoringMembersWithContext is the same as StopMonitoringMembers with the addition of
// the ability to pass a context and additional request options.
//
// See StopMonitoringMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) StopMonitoringMembersWithContext(ctx aws.Context, input *StopMonitoringMembersInput, opts ...request.Option) (*StopMonitoringMembersOutput, error) {
	req, out := c.StopMonitoringMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource
func (c *GuardDuty) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon GuardDuty.
//
// Adds tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource
func (c *GuardDuty) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnarchiveFindings = "UnarchiveFindings"

// UnarchiveFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UnarchiveFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnarchiveFindings for more information on using the UnarchiveFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnarchiveFindingsRequest method.
//    req, resp := client.UnarchiveFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings
func (c *GuardDuty) UnarchiveFindingsRequest(input *UnarchiveFindingsInput) (req *request.Request, output *UnarchiveFindingsOutput) {
	op := &request.Operation{
		Name:       opUnarchiveFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/unarchive",
	}

	if input == nil {
		input = &UnarchiveFindingsInput{}
	}

	output = &UnarchiveFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnarchiveFindings API operation for Amazon GuardDuty.
//
// Unarchives GuardDuty findings specified by the findingIds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UnarchiveFindings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings
func (c *GuardDuty) UnarchiveFindings(input *UnarchiveFindingsInput) (*UnarchiveFindingsOutput, error) {
	req, out := c.UnarchiveFindingsRequest(input)
	return out, req.Send()
}

// UnarchiveFindingsWithContext is the same as UnarchiveFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UnarchiveFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UnarchiveFindingsWithContext(ctx aws.Context, input *UnarchiveFindingsInput, opts ...request.Option) (*UnarchiveFindingsOutput, error) {
	req, out := c.UnarchiveFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource
func (c *GuardDuty) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon GuardDuty.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource
func (c *GuardDuty) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetector = "UpdateDetector"

// UpdateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetector for more information on using the UpdateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorRequest method.
//    req, resp := client.UpdateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector
func (c *GuardDuty) UpdateDetectorRequest(input *UpdateDetectorInput) (req *request.Request, output *UpdateDetectorOutput) {
	op := &request.Operation{
		Name:       opUpdateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &UpdateDetectorInput{}
	}

	output = &UpdateDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetector API operation for Amazon GuardDuty.
//
// Updates the Amazon GuardDuty detector specified by the detectorId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateDetector for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector
func (c *GuardDuty) UpdateDetector(input *UpdateDetectorInput) (*UpdateDetectorOutput, error) {
	req, out := c.UpdateDetectorRequest(input)
	return out, req.Send()
}

// UpdateDetectorWithContext is the same as UpdateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateDetectorWithContext(ctx aws.Context, input *UpdateDetectorInput, opts ...request.Option) (*UpdateDetectorOutput, error) {
	req, out := c.UpdateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFilter = "UpdateFilter"

// UpdateFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFilter for more information on using the UpdateFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFilterRequest method.
//    req, resp := client.UpdateFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter
func (c *GuardDuty) UpdateFilterRequest(input *UpdateFilterInput) (req *request.Request, output *UpdateFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/filter/{filterName}",
	}

	if input == nil {
		input = &UpdateFilterInput{}
	}

	output = &UpdateFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFilter API operation for Amazon GuardDuty.
//
// Updates the filter specified by the filter name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter
func (c *GuardDuty) UpdateFilter(input *UpdateFilterInput) (*UpdateFilterOutput, error) {
	req, out := c.UpdateFilterRequest(input)
	return out, req.Send()
}

// UpdateFilterWithContext is the same as UpdateFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateFilterWithContext(ctx aws.Context, input *UpdateFilterInput, opts ...request.Option) (*UpdateFilterOutput, error) {
	req, out := c.UpdateFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindingsFeedback = "UpdateFindingsFeedback"

// UpdateFindingsFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindingsFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindingsFeedback for more information on using the UpdateFindingsFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsFeedbackRequest method.
//    req, resp := client.UpdateFindingsFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback
func (c *GuardDuty) UpdateFindingsFeedbackRequest(input *UpdateFindingsFeedbackInput) (req *request.Request, output *UpdateFindingsFeedbackOutput) {
	op := &request.Operation{
		Name:       opUpdateFindingsFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/feedback",
	}

	if input == nil {
		input = &UpdateFindingsFeedbackInput{}
	}

	output = &UpdateFindingsFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindingsFeedback API operation for Amazon GuardDuty.
//
// Marks the specified GuardDuty findings as useful or not useful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateFindingsFeedback for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback
func (c *GuardDuty) UpdateFindingsFeedback(input *UpdateFindingsFeedbackInput) (*UpdateFindingsFeedbackOutput, error) {
	req, out := c.UpdateFindingsFeedbackRequest(input)
	return out, req.Send()
}

// UpdateFindingsFeedbackWithContext is the same as UpdateFindingsFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindingsFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateFindingsFeedbackWithContext(ctx aws.Context, input *UpdateFindingsFeedbackInput, opts ...request.Option) (*UpdateFindingsFeedbackOutput, error) {
	req, out := c.UpdateFindingsFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIPSet for more information on using the UpdateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet
func (c *GuardDuty) UpdateIPSetRequest(input *UpdateIPSetInput) (req *request.Request, output *UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/ipset/{ipSetId}",
	}

	if input == nil {
		input = &UpdateIPSetInput{}
	}

	output = &UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIPSet API operation for Amazon GuardDuty.
//
// Updates the IPSet specified by the IPSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet
func (c *GuardDuty) UpdateIPSet(input *UpdateIPSetInput) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateIPSetWithContext(ctx aws.Context, input *UpdateIPSetInput, opts ...request.Option) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMemberDetectors = "UpdateMemberDetectors"

// UpdateMemberDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMemberDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMemberDetectors for more information on using the UpdateMemberDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMemberDetectorsRequest method.
//    req, resp := client.UpdateMemberDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors
func (c *GuardDuty) UpdateMemberDetectorsRequest(input *UpdateMemberDetectorsInput) (req *request.Request, output *UpdateMemberDetectorsOutput) {
	op := &request.Operation{
		Name:       opUpdateMemberDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/member/detector/update",
	}

	if input == nil {
		input = &UpdateMemberDetectorsInput{}
	}

	output = &UpdateMemberDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMemberDetectors API operation for Amazon GuardDuty.
//
// Contains information on member accounts to be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateMemberDetectors for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMemberDetectors
func (c *GuardDuty) UpdateMemberDetectors(input *UpdateMemberDetectorsInput) (*UpdateMemberDetectorsOutput, error) {
	req, out := c.UpdateMemberDetectorsRequest(input)
	return out, req.Send()
}

// UpdateMemberDetectorsWithContext is the same as UpdateMemberDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMemberDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateMemberDetectorsWithContext(ctx aws.Context, input *UpdateMemberDetectorsInput, opts ...request.Option) (*UpdateMemberDetectorsOutput, error) {
	req, out := c.UpdateMemberDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOrganizationConfigurationRequest method.
//    req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration
func (c *GuardDuty) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/admin",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for Amazon GuardDuty.
//
// Updates the delegated administrator account with the values provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateOrganizationConfiguration
func (c *GuardDuty) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublishingDestination = "UpdatePublishingDestination"

// UpdatePublishingDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublishingDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublishingDestination for more information on using the UpdatePublishingDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePublishingDestinationRequest method.
//    req, resp := client.UpdatePublishingDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination
func (c *GuardDuty) UpdatePublishingDestinationRequest(input *UpdatePublishingDestinationInput) (req *request.Request, output *UpdatePublishingDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdatePublishingDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/publishingDestination/{destinationId}",
	}

	if input == nil {
		input = &UpdatePublishingDestinationInput{}
	}

	output = &UpdatePublishingDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePublishingDestination API operation for Amazon GuardDuty.
//
// Updates information about the publishing destination specified by the destinationId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdatePublishingDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination
func (c *GuardDuty) UpdatePublishingDestination(input *UpdatePublishingDestinationInput) (*UpdatePublishingDestinationOutput, error) {
	req, out := c.UpdatePublishingDestinationRequest(input)
	return out, req.Send()
}

// UpdatePublishingDestinationWithContext is the same as UpdatePublishingDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublishingDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdatePublishingDestinationWithContext(ctx aws.Context, input *UpdatePublishingDestinationInput, opts ...request.Option) (*UpdatePublishingDestinationOutput, error) {
	req, out := c.UpdatePublishingDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThreatIntelSet = "UpdateThreatIntelSet"

// UpdateThreatIntelSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThreatIntelSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThreatIntelSet for more information on using the UpdateThreatIntelSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThreatIntelSetRequest method.
//    req, resp := client.UpdateThreatIntelSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet
func (c *GuardDuty) UpdateThreatIntelSetRequest(input *UpdateThreatIntelSetInput) (req *request.Request, output *UpdateThreatIntelSetOutput) {
	op := &request.Operation{
		Name:       opUpdateThreatIntelSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
	}

	if input == nil {
		input = &UpdateThreatIntelSetInput{}
	}

	output = &UpdateThreatIntelSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateThreatIntelSet API operation for Amazon GuardDuty.
//
// Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GuardDuty's
// API operation UpdateThreatIntelSet for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   A bad request exception object.
//
//   * InternalServerErrorException
//   An internal server error exception object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet
func (c *GuardDuty) UpdateThreatIntelSet(input *UpdateThreatIntelSetInput) (*UpdateThreatIntelSetOutput, error) {
	req, out := c.UpdateThreatIntelSetRequest(input)
	return out, req.Send()
}

// UpdateThreatIntelSetWithContext is the same as UpdateThreatIntelSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThreatIntelSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GuardDuty) UpdateThreatIntelSetWithContext(ctx aws.Context, input *UpdateThreatIntelSetInput, opts ...request.Option) (*UpdateThreatIntelSetOutput, error) {
	req, out := c.UpdateThreatIntelSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector of the GuardDuty member account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The value that is used to validate the administrator account to the member
	// account.
	//
	// InvitationId is a required field
	InvitationId *string `locationName:"invitationId" type:"string" required:"true"`

	// The account ID of the GuardDuty administrator account whose invitation you're
	// accepting.
	//
	// MasterId is a required field
	MasterId *string `locationName:"masterId" type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterId == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *AcceptInvitationInput) SetDetectorId(v string) *AcceptInvitationInput {
	s.DetectorId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// Contains information on the current access control policies for the bucket.
type AccessControlList struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether public read access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	// A value that indicates whether public write access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlList) GoString() string {
	return s.String()
}

// SetAllowsPublicReadAccess sets the AllowsPublicReadAccess field's value.
func (s *AccessControlList) SetAllowsPublicReadAccess(v bool) *AccessControlList {
	s.AllowsPublicReadAccess = &v
	return s
}

// SetAllowsPublicWriteAccess sets the AllowsPublicWriteAccess field's value.
func (s *AccessControlList) SetAllowsPublicWriteAccess(v bool) *AccessControlList {
	s.AllowsPublicWriteAccess = &v
	return s
}

// Contains information about the access keys.
type AccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The access key ID of the user.
	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	// The principal ID of the user.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The name of the user.
	UserName *string `locationName:"userName" type:"string"`

	// The type of the user.
	UserType *string `locationName:"userType" type:"string"`
}

// String returns the string representation
func (s AccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyDetails) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AccessKeyDetails) SetAccessKeyId(v string) *AccessKeyDetails {
	s.AccessKeyId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccessKeyDetails) SetPrincipalId(v string) *AccessKeyDetails {
	s.PrincipalId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AccessKeyDetails) SetUserName(v string) *AccessKeyDetails {
	s.UserName = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *AccessKeyDetails) SetUserType(v string) *AccessKeyDetails {
	s.UserType = &v
	return s
}

// Contains information about the account.
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// The member account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The email address of the member account.
	//
	// Email is a required field
	Email *string `locationName:"email" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountDetail"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetail) SetAccountId(v string) *AccountDetail {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetail) SetEmail(v string) *AccountDetail {
	s.Email = &v
	return s
}

// Contains information about the account level permissions on the S3 bucket.
type AccountLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Describes the S3 Block Public Access settings of the bucket's parent account.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`
}

// String returns the string representation
func (s AccountLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLevelPermissions) GoString() string {
	return s.String()
}

// SetBlockPublicAccess sets the BlockPublicAccess field's value.
func (s *AccountLevelPermissions) SetBlockPublicAccess(v *BlockPublicAccess) *AccountLevelPermissions {
	s.BlockPublicAccess = v
	return s
}

// Contains information about actions.
type Action struct {
	_ struct{} `type:"structure"`

	// The GuardDuty finding activity type.
	ActionType *string `locationName:"actionType" type:"string"`

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction `locationName:"awsApiCallAction" type:"structure"`

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction `locationName:"dnsRequestAction" type:"structure"`

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction `locationName:"networkConnectionAction" type:"structure"`

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction `locationName:"portProbeAction" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *Action) SetActionType(v string) *Action {
	s.ActionType = &v
	return s
}

// SetAwsApiCallAction sets the AwsApiCallAction field's value.
func (s *Action) SetAwsApiCallAction(v *AwsApiCallAction) *Action {
	s.AwsApiCallAction = v
	return s
}

// SetDnsRequestAction sets the DnsRequestAction field's value.
func (s *Action) SetDnsRequestAction(v *DnsRequestAction) *Action {
	s.DnsRequestAction = v
	return s
}

// SetNetworkConnectionAction sets the NetworkConnectionAction field's value.
func (s *Action) SetNetworkConnectionAction(v *NetworkConnectionAction) *Action {
	s.NetworkConnectionAction = v
	return s
}

// SetPortProbeAction sets the PortProbeAction field's value.
func (s *Action) SetPortProbeAction(v *PortProbeAction) *Action {
	s.PortProbeAction = v
	return s
}

// The account within the organization specified as the GuardDuty delegated
// administrator.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account ID for the account.
	AdminAccountId *string `locationName:"adminAccountId" type:"string"`

	// Indicates whether the account is enabled as the delegated administrator.
	AdminStatus *string `locationName:"adminStatus" min:"1" type:"string" enum:"AdminStatus"`
}

// String returns the string representation
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminAccount) GoString() string {
	return s.String()
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *AdminAccount) SetAdminAccountId(v string) *AdminAccount {
	s.AdminAccountId = &v
	return s
}

// SetAdminStatus sets the AdminStatus field's value.
func (s *AdminAccount) SetAdminStatus(v string) *AdminAccount {
	s.AdminStatus = &v
	return s
}

type ArchiveFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose findings
	// you want to archive.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The IDs of the findings that you want to archive.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`
}

// String returns the string representation
func (s ArchiveFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ArchiveFindingsInput) SetDetectorId(v string) *ArchiveFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *ArchiveFindingsInput) SetFindingIds(v []*string) *ArchiveFindingsInput {
	s.FindingIds = v
	return s
}

type ArchiveFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ArchiveFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveFindingsOutput) GoString() string {
	return s.String()
}

// Contains information about the API action.
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// The AWS API name.
	Api *string `locationName:"api" type:"string"`

	// The AWS API caller type.
	CallerType *string `locationName:"callerType" type:"string"`

	// The domain information for the AWS API call.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// The error code of the failed AWS API action.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The remote IP information of the connection that initiated the AWS API call.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// The AWS service name whose API was invoked.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiCallAction) GoString() string {
	return s.String()
}

// SetApi sets the Api field's value.
func (s *AwsApiCallAction) SetApi(v string) *AwsApiCallAction {
	s.Api = &v
	return s
}

// SetCallerType sets the CallerType field's value.
func (s *AwsApiCallAction) SetCallerType(v string) *AwsApiCallAction {
	s.CallerType = &v
	return s
}

// SetDomainDetails sets the DomainDetails field's value.
func (s *AwsApiCallAction) SetDomainDetails(v *DomainDetails) *AwsApiCallAction {
	s.DomainDetails = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AwsApiCallAction) SetErrorCode(v string) *AwsApiCallAction {
	s.ErrorCode = &v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *AwsApiCallAction) SetRemoteIpDetails(v *RemoteIpDetails) *AwsApiCallAction {
	s.RemoteIpDetails = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AwsApiCallAction) SetServiceName(v string) *AwsApiCallAction {
	s.ServiceName = &v
	return s
}

// A bad request exception object.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message.
	Message_ *string `locationName:"message" type:"string"`

	// The error type.
	Type *string `locationName:"__type" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information on how the bucker owner's S3 Block Public Access settings
// are being applied to the S3 bucket. See S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// for more information.
type BlockPublicAccess struct {
	_ struct{} `type:"structure"`

	// Indicates if S3 Block Public Access is set to BlockPublicAcls.
	BlockPublicAcls *bool `locationName:"blockPublicAcls" type:"boolean"`

	// Indicates if S3 Block Public Access is set to BlockPublicPolicy.
	BlockPublicPolicy *bool `locationName:"blockPublicPolicy" type:"boolean"`

	// Indicates if S3 Block Public Access is set to IgnorePublicAcls.
	IgnorePublicAcls *bool `locationName:"ignorePublicAcls" type:"boolean"`

	// Indicates if S3 Block Public Access is set to RestrictPublicBuckets.
	RestrictPublicBuckets *bool `locationName:"restrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s BlockPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockPublicAccess) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *BlockPublicAccess) SetBlockPublicAcls(v bool) *BlockPublicAccess {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *BlockPublicAccess) SetBlockPublicPolicy(v bool) *BlockPublicAccess {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *BlockPublicAccess) SetIgnorePublicAcls(v bool) *BlockPublicAccess {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *BlockPublicAccess) SetRestrictPublicBuckets(v bool) *BlockPublicAccess {
	s.RestrictPublicBuckets = &v
	return s
}

// Contains information about the bucket level permissions for the S3 bucket.
type BucketLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Contains information on how Access Control Policies are applied to the bucket.
	AccessControlList *AccessControlList `locationName:"accessControlList" type:"structure"`

	// Contains information on which account level S3 Block Public Access settings
	// are applied to the S3 bucket.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`

	// Contains information on the bucket policies for the S3 bucket.
	BucketPolicy *BucketPolicy `locationName:"bucketPolicy" type:"structure"`
}

// String returns the string representation
func (s BucketLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLevelPermissions) GoString() string {
	return s.String()
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *BucketLevelPermissions) SetAccessControlList(v *AccessControlList) *BucketLevelPermissions {
	s.AccessControlList = v
	return s
}

// SetBlockPublicAccess sets the BlockPublicAccess field's value.
func (s *BucketLevelPermissions) SetBlockPublicAccess(v *BlockPublicAccess) *BucketLevelPermissions {
	s.BlockPublicAccess = v
	return s
}

// SetBucketPolicy sets the BucketPolicy field's value.
func (s *BucketLevelPermissions) SetBucketPolicy(v *BucketPolicy) *BucketLevelPermissions {
	s.BucketPolicy = v
	return s
}

// Contains information on the current bucket policies for the S3 bucket.
type BucketPolicy struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether public read access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	// A value that indicates whether public write access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s BucketPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketPolicy) GoString() string {
	return s.String()
}

// SetAllowsPublicReadAccess sets the AllowsPublicReadAccess field's value.
func (s *BucketPolicy) SetAllowsPublicReadAccess(v bool) *BucketPolicy {
	s.AllowsPublicReadAccess = &v
	return s
}

// SetAllowsPublicWriteAccess sets the AllowsPublicWriteAccess field's value.
func (s *BucketPolicy) SetAllowsPublicWriteAccess(v bool) *BucketPolicy {
	s.AllowsPublicWriteAccess = &v
	return s
}

// Contains information about the city associated with the IP address.
type City struct {
	_ struct{} `type:"structure"`

	// The city name of the remote IP address.
	CityName *string `locationName:"cityName" type:"string"`
}

// String returns the string representation
func (s City) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s City) GoString() string {
	return s.String()
}

// SetCityName sets the CityName field's value.
func (s *City) SetCityName(v string) *City {
	s.CityName = &v
	return s
}

// Contains information on the status of CloudTrail as a data source for the
// detector.
type CloudTrailConfigurationResult struct {
	_ struct{} `type:"structure"`

	// Describes whether CloudTrail is enabled as a data source for the detector.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation
func (s CloudTrailConfigurationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudTrailConfigurationResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CloudTrailConfigurationResult) SetStatus(v string) *CloudTrailConfigurationResult {
	s.Status = &v
	return s
}

// Contains information about the condition.
type Condition struct {
	_ struct{} `type:"structure"`

	// Represents the equal condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: Eq has been deprecated
	Eq []*string `locationName:"eq" deprecated:"true" type:"list"`

	// Represents an equal condition to be applied to a single field when querying
	// for findings.
	Equals []*string `locationName:"equals" type:"list"`

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	GreaterThan *int64 `locationName:"greaterThan" type:"long"`

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	GreaterThanOrEqual *int64 `locationName:"greaterThanOrEqual" type:"long"`

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: Gt has been deprecated
	Gt *int64 `locationName:"gt" deprecated:"true" type:"integer"`

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	//
	// Deprecated: Gte has been deprecated
	Gte *int64 `locationName:"gte" deprecated:"true" type:"integer"`

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	LessThan *int64 `locationName:"lessThan" type:"long"`

	// Represents a less than or equal condition to be applied to a single field
	// when querying for findings.
	LessThanOrEqual *int64 `locationName:"lessThanOrEqual" type:"long"`

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: Lt has been deprecated
	Lt *int64 `locationName:"lt" deprecated:"true" type:"integer"`

	// Represents a less than or equal condition to be applied to a single field
	// when querying for findings.
	//
	// Deprecated: Lte has been deprecated
	Lte *int64 `locationName:"lte" deprecated:"true" type:"integer"`

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: Neq has been deprecated
	Neq []*string `locationName:"neq" deprecated:"true" type:"list"`

	// Represents a not equal condition to be applied to a single field when querying
	// for findings.
	NotEquals []*string `locationName:"notEquals" type:"list"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *Condition) SetEq(v []*string) *Condition {
	s.Eq = v
	return s
}

// SetEquals sets the Equals field's value.
func (s *Condition) SetEquals(v []*string) *Condition {
	s.Equals = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *Condition) SetGreaterThan(v int64) *Condition {
	s.GreaterThan = &v
	return s
}

// SetGreaterThanOrEqual sets the GreaterThanOrEqual field's value.
func (s *Condition) SetGreaterThanOrEqual(v int64) *Condition {
	s.GreaterThanOrEqual = &v
	return s
}

// SetGt sets the Gt field's value.
func (s *Condition) SetGt(v int64) *Condition {
	s.Gt = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *Condition) SetGte(v int64) *Condition {
	s.Gte = &v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *Condition) SetLessThan(v int64) *Condition {
	s.LessThan = &v
	return s
}

// SetLessThanOrEqual sets the LessThanOrEqual field's value.
func (s *Condition) SetLessThanOrEqual(v int64) *Condition {
	s.LessThanOrEqual = &v
	return s
}

// SetLt sets the Lt field's value.
func (s *Condition) SetLt(v int64) *Condition {
	s.Lt = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *Condition) SetLte(v int64) *Condition {
	s.Lte = &v
	return s
}

// SetNeq sets the Neq field's value.
func (s *Condition) SetNeq(v []*string) *Condition {
	s.Neq = v
	return s
}

// SetNotEquals sets the NotEquals field's value.
func (s *Condition) SetNotEquals(v []*string) *Condition {
	s.NotEquals = v
	return s
}

// Contains information about the country where the remote IP address is located.
type Country struct {
	_ struct{} `type:"structure"`

	// The country code of the remote IP address.
	CountryCode *string `locationName:"countryCode" type:"string"`

	// The country name of the remote IP address.
	CountryName *string `locationName:"countryName" type:"string"`
}

// String returns the string representation
func (s Country) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Country) GoString() string {
	return s.String()
}

// SetCountryCode sets the CountryCode field's value.
func (s *Country) SetCountryCode(v string) *Country {
	s.CountryCode = &v
	return s
}

// SetCountryName sets the CountryName field's value.
func (s *Country) SetCountryName(v string) *Country {
	s.CountryName = &v
	return s
}

type CreateDetectorInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Describes which data sources will be enabled for the detector.
	DataSources *DataSourceConfigurations `locationName:"dataSources" type:"structure"`

	// A Boolean value that specifies whether the detector is to be enabled.
	//
	// Enable is a required field
	Enable *bool `locationName:"enable" type:"boolean" required:"true"`

	// A value that specifies how frequently updated findings are exported.
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`

	// The tags to be added to a new detector resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDetectorInput"}
	if s.Enable == nil {
		invalidParams.Add(request.NewErrParamRequired("Enable"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.DataSources != nil {
		if err := s.DataSources.Validate(); err != nil {
			invalidParams.AddNested("DataSources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDetectorInput) SetClientToken(v string) *CreateDetectorInput {
	s.ClientToken = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *CreateDetectorInput) SetDataSources(v *DataSourceConfigurations) *CreateDetectorInput {
	s.DataSources = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *CreateDetectorInput) SetEnable(v bool) *CreateDetectorInput {
	s.Enable = &v
	return s
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *CreateDetectorInput) SetFindingPublishingFrequency(v string) *CreateDetectorInput {
	s.FindingPublishingFrequency = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDetectorInput) SetTags(v map[string]*string) *CreateDetectorInput {
	s.Tags = v
	return s
}

type CreateDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the created detector.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorOutput) SetDetectorId(v string) *CreateDetectorOutput {
	s.DetectorId = &v
	return s
}

type CreateFilterInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action *string `locationName:"action" min:"1" type:"string" enum:"FilterAction"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the filter.
	Description *string `locationName:"description" type:"string"`

	// The ID of the detector belonging to the GuardDuty account that you want to
	// create a filter for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Represents the criteria to be used in the filter for querying findings.
	//
	// You can only use the following attributes to query findings:
	//
	//    * accountId
	//
	//    * region
	//
	//    * confidence
	//
	//    * id
	//
	//    * resource.accessKeyDetails.accessKeyId
	//
	//    * resource.accessKeyDetails.principalId
	//
	//    * resource.accessKeyDetails.userName
	//
	//    * resource.accessKeyDetails.userType
	//
	//    * resource.instanceDetails.iamInstanceProfile.id
	//
	//    * resource.instanceDetails.imageId
	//
	//    * resource.instanceDetails.instanceId
	//
	//    * resource.instanceDetails.outpostArn
	//
	//    * resource.instanceDetails.networkInterfaces.ipv6Addresses
	//
	//    * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
	//
	//    * resource.instanceDetails.networkInterfaces.publicDnsName
	//
	//    * resource.instanceDetails.networkInterfaces.publicIp
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupId
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupName
	//
	//    * resource.instanceDetails.networkInterfaces.subnetId
	//
	//    * resource.instanceDetails.networkInterfaces.vpcId
	//
	//    * resource.instanceDetails.tags.key
	//
	//    * resource.instanceDetails.tags.value
	//
	//    * resource.resourceType
	//
	//    * service.action.actionType
	//
	//    * service.action.awsApiCallAction.api
	//
	//    * service.action.awsApiCallAction.callerType
	//
	//    * service.action.awsApiCallAction.errorCode
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.city.cityName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.country.countryName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asn
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.awsApiCallAction.serviceName
	//
	//    * service.action.dnsRequestAction.domain
	//
	//    * service.action.networkConnectionAction.blocked
	//
	//    * service.action.networkConnectionAction.connectionDirection
	//
	//    * service.action.networkConnectionAction.localPortDetails.port
	//
	//    * service.action.networkConnectionAction.protocol
	//
	//    * service.action.networkConnectionAction.localIpDetails.ipAddressV4
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.city.cityName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.country.countryName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asn
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.networkConnectionAction.remotePortDetails.port
	//
	//    * service.additionalInfo.threatListName
	//
	//    * service.archived When this attribute is set to TRUE, only archived findings
	//    are listed. When it's set to FALSE, only unarchived findings are listed.
	//    When this attribute is not set, all existing findings are listed.
	//
	//    * service.resourceRole
	//
	//    * severity
	//
	//    * type
	//
	//    * updatedAt Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
	//    YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.
	//
	// FindingCriteria is a required field
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure" required:"true"`

	// The name of the filter. Minimum length of 3. Maximum length of 64. Valid
	// characters include alphanumeric characters, dot (.), underscore (_), and
	// dash (-). Spaces are not allowed.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank *int64 `locationName:"rank" min:"1" type:"integer"`

	// The tags to be added to a new filter resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFilterInput"}
	if s.Action != nil && len(*s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FindingCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingCriteria"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Rank != nil && *s.Rank < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Rank", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateFilterInput) SetAction(v string) *CreateFilterInput {
	s.Action = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFilterInput) SetClientToken(v string) *CreateFilterInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFilterInput) SetDescription(v string) *CreateFilterInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateFilterInput) SetDetectorId(v string) *CreateFilterInput {
	s.DetectorId = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *CreateFilterInput) SetFindingCriteria(v *FindingCriteria) *CreateFilterInput {
	s.FindingCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFilterInput) SetName(v string) *CreateFilterInput {
	s.Name = &v
	return s
}

// SetRank sets the Rank field's value.
func (s *CreateFilterInput) SetRank(v int64) *CreateFilterInput {
	s.Rank = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFilterInput) SetTags(v map[string]*string) *CreateFilterInput {
	s.Tags = v
	return s
}

type CreateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The name of the successfully created filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFilterOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateFilterOutput) SetName(v string) *CreateFilterOutput {
	s.Name = &v
	return s
}

type CreateIPSetInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether GuardDuty is to start using the uploaded
	// IPSet.
	//
	// Activate is a required field
	Activate *bool `locationName:"activate" type:"boolean" required:"true"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The unique ID of the detector of the GuardDuty account that you want to create
	// an IPSet for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The format of the file that contains the IPSet.
	//
	// Format is a required field
	Format *string `locationName:"format" min:"1" type:"string" required:"true" enum:"IpSetFormat"`

	// The URI of the file that contains the IPSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"1" type:"string" required:"true"`

	// The user-friendly name to identify the IPSet.
	//
	// Allowed characters are alphanumerics, spaces, hyphens (-), and underscores
	// (_).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags to be added to a new IP set resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIPSetInput"}
	if s.Activate == nil {
		invalidParams.Add(request.NewErrParamRequired("Activate"))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Format != nil && len(*s.Format) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Format", 1))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *CreateIPSetInput) SetActivate(v bool) *CreateIPSetInput {
	s.Activate = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIPSetInput) SetClientToken(v string) *CreateIPSetInput {
	s.ClientToken = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateIPSetInput) SetDetectorId(v string) *CreateIPSetInput {
	s.DetectorId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateIPSetInput) SetFormat(v string) *CreateIPSetInput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateIPSetInput) SetLocation(v string) *CreateIPSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIPSetInput) SetName(v string) *CreateIPSetInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIPSetInput) SetTags(v map[string]*string) *CreateIPSetInput {
	s.Tags = v
	return s
}

type CreateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the IPSet resource.
	//
	// IpSetId is a required field
	IpSetId *string `locationName:"ipSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetOutput) GoString() string {
	return s.String()
}

// SetIpSetId sets the IpSetId field's value.
func (s *CreateIPSetOutput) SetIpSetId(v string) *CreateIPSetOutput {
	s.IpSetId = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the accounts that you want
	// to associate with the GuardDuty administrator account.
	//
	// AccountDetails is a required field
	AccountDetails []*AccountDetail `locationName:"accountDetails" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty account that you want to associate
	// member accounts with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembersInput"}
	if s.AccountDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountDetails"))
	}
	if s.AccountDetails != nil && len(s.AccountDetails) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountDetails", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.AccountDetails != nil {
		for i, v := range s.AccountDetails {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountDetails", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *CreateMembersInput) SetAccountDetails(v []*AccountDetail) *CreateMembersInput {
	s.AccountDetails = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateMembersInput) SetDetectorId(v string) *CreateMembersInput {
	s.DetectorId = &v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that include the accountIds of the unprocessed accounts
	// and a result string that explains why each was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type CreatePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token for the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The properties of the publishing destination, including the ARNs for the
	// destination and the KMS key used for encryption.
	//
	// DestinationProperties is a required field
	DestinationProperties *DestinationProperties `locationName:"destinationProperties" type:"structure" required:"true"`

	// The type of resource for the publishing destination. Currently only Amazon
	// S3 buckets are supported.
	//
	// DestinationType is a required field
	DestinationType *string `locationName:"destinationType" min:"1" type:"string" required:"true" enum:"DestinationType"`

	// The ID of the GuardDuty detector associated with the publishing destination.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublishingDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublishingDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublishingDestinationInput"}
	if s.DestinationProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationProperties"))
	}
	if s.DestinationType == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationType"))
	}
	if s.DestinationType != nil && len(*s.DestinationType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationType", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePublishingDestinationInput) SetClientToken(v string) *CreatePublishingDestinationInput {
	s.ClientToken = &v
	return s
}

// SetDestinationProperties sets the DestinationProperties field's value.
func (s *CreatePublishingDestinationInput) SetDestinationProperties(v *DestinationProperties) *CreatePublishingDestinationInput {
	s.DestinationProperties = v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *CreatePublishingDestinationInput) SetDestinationType(v string) *CreatePublishingDestinationInput {
	s.DestinationType = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreatePublishingDestinationInput) SetDetectorId(v string) *CreatePublishingDestinationInput {
	s.DetectorId = &v
	return s
}

type CreatePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination that is created.
	//
	// DestinationId is a required field
	DestinationId *string `locationName:"destinationId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublishingDestinationOutput) GoString() string {
	return s.String()
}

// SetDestinationId sets the DestinationId field's value.
func (s *CreatePublishingDestinationOutput) SetDestinationId(v string) *CreatePublishingDestinationOutput {
	s.DestinationId = &v
	return s
}

type CreateSampleFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to create sample findings for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The types of sample findings to generate.
	FindingTypes []*string `locationName:"findingTypes" type:"list"`
}

// String returns the string representation
func (s CreateSampleFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSampleFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSampleFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateSampleFindingsInput) SetDetectorId(v string) *CreateSampleFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingTypes sets the FindingTypes field's value.
func (s *CreateSampleFindingsInput) SetFindingTypes(v []*string) *CreateSampleFindingsInput {
	s.FindingTypes = v
	return s
}

type CreateSampleFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateSampleFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSampleFindingsOutput) GoString() string {
	return s.String()
}

type CreateThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether GuardDuty is to start using the uploaded
	// ThreatIntelSet.
	//
	// Activate is a required field
	Activate *bool `locationName:"activate" type:"boolean" required:"true"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The unique ID of the detector of the GuardDuty account that you want to create
	// a threatIntelSet for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The format of the file that contains the ThreatIntelSet.
	//
	// Format is a required field
	Format *string `locationName:"format" min:"1" type:"string" required:"true" enum:"ThreatIntelSetFormat"`

	// The URI of the file that contains the ThreatIntelSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"1" type:"string" required:"true"`

	// A user-friendly ThreatIntelSet name displayed in all findings that are generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags to be added to a new threat list resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThreatIntelSetInput"}
	if s.Activate == nil {
		invalidParams.Add(request.NewErrParamRequired("Activate"))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Format != nil && len(*s.Format) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Format", 1))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *CreateThreatIntelSetInput) SetActivate(v bool) *CreateThreatIntelSetInput {
	s.Activate = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateThreatIntelSetInput) SetClientToken(v string) *CreateThreatIntelSetInput {
	s.ClientToken = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateThreatIntelSetInput) SetDetectorId(v string) *CreateThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CreateThreatIntelSetInput) SetFormat(v string) *CreateThreatIntelSetInput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateThreatIntelSetInput) SetLocation(v string) *CreateThreatIntelSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateThreatIntelSetInput) SetName(v string) *CreateThreatIntelSetInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThreatIntelSetInput) SetTags(v map[string]*string) *CreateThreatIntelSetInput {
	s.Tags = v
	return s
}

type CreateThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the ThreatIntelSet resource.
	//
	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateThreatIntelSetOutput) GoString() string {
	return s.String()
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *CreateThreatIntelSetOutput) SetThreatIntelSetId(v string) *CreateThreatIntelSetOutput {
	s.ThreatIntelSetId = &v
	return s
}

// Contains information on the status of DNS logs as a data source.
type DNSLogsConfigurationResult struct {
	_ struct{} `type:"structure"`

	// Denotes whether DNS logs is enabled as a data source.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation
func (s DNSLogsConfigurationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DNSLogsConfigurationResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DNSLogsConfigurationResult) SetStatus(v string) *DNSLogsConfigurationResult {
	s.Status = &v
	return s
}

// Contains information about which data sources are enabled.
type DataSourceConfigurations struct {
	_ struct{} `type:"structure"`

	// Describes whether S3 data event logs are enabled as a data source.
	S3Logs *S3LogsConfiguration `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s DataSourceConfigurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceConfigurations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfigurations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfigurations"}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Logs sets the S3Logs field's value.
func (s *DataSourceConfigurations) SetS3Logs(v *S3LogsConfiguration) *DataSourceConfigurations {
	s.S3Logs = v
	return s
}

// Contains information on the status of data sources for the detector.
type DataSourceConfigurationsResult struct {
	_ struct{} `type:"structure"`

	// An object that contains information on the status of CloudTrail as a data
	// source.
	//
	// CloudTrail is a required field
	CloudTrail *CloudTrailConfigurationResult `locationName:"cloudTrail" type:"structure" required:"true"`

	// An object that contains information on the status of DNS logs as a data source.
	//
	// DNSLogs is a required field
	DNSLogs *DNSLogsConfigurationResult `locationName:"dnsLogs" type:"structure" required:"true"`

	// An object that contains information on the status of VPC flow logs as a data
	// source.
	//
	// FlowLogs is a required field
	FlowLogs *FlowLogsConfigurationResult `locationName:"flowLogs" type:"structure" required:"true"`

	// An object that contains information on the status of S3 Data event logs as
	// a data source.
	//
	// S3Logs is a required field
	S3Logs *S3LogsConfigurationResult `locationName:"s3Logs" type:"structure" required:"true"`
}

// String returns the string representation
func (s DataSourceConfigurationsResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceConfigurationsResult) GoString() string {
	return s.String()
}

// SetCloudTrail sets the CloudTrail field's value.
func (s *DataSourceConfigurationsResult) SetCloudTrail(v *CloudTrailConfigurationResult) *DataSourceConfigurationsResult {
	s.CloudTrail = v
	return s
}

// SetDNSLogs sets the DNSLogs field's value.
func (s *DataSourceConfigurationsResult) SetDNSLogs(v *DNSLogsConfigurationResult) *DataSourceConfigurationsResult {
	s.DNSLogs = v
	return s
}

// SetFlowLogs sets the FlowLogs field's value.
func (s *DataSourceConfigurationsResult) SetFlowLogs(v *FlowLogsConfigurationResult) *DataSourceConfigurationsResult {
	s.FlowLogs = v
	return s
}

// SetS3Logs sets the S3Logs field's value.
func (s *DataSourceConfigurationsResult) SetS3Logs(v *S3LogsConfigurationResult) *DataSourceConfigurationsResult {
	s.S3Logs = v
	return s
}

type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the AWS accounts that sent invitations to the current
	// member account that you want to decline invitations from.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

// Contains information on the server side encryption method used in the S3
// bucket. See S3 Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
// for more information.
type DefaultServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The type of encryption used for objects within the S3 bucket.
	EncryptionType *string `locationName:"encryptionType" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS encryption key. Only available
	// if the bucket EncryptionType is aws:kms.
	KmsMasterKeyArn *string `locationName:"kmsMasterKeyArn" type:"string"`
}

// String returns the string representation
func (s DefaultServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultServerSideEncryption) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *DefaultServerSideEncryption) SetEncryptionType(v string) *DefaultServerSideEncryption {
	s.EncryptionType = &v
	return s
}

// SetKmsMasterKeyArn sets the KmsMasterKeyArn field's value.
func (s *DefaultServerSideEncryption) SetKmsMasterKeyArn(v string) *DefaultServerSideEncryption {
	s.KmsMasterKeyArn = &v
	return s
}

type DeleteDetectorInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that you want to delete.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorInput) SetDetectorId(v string) *DeleteDetectorInput {
	s.DetectorId = &v
	return s
}

type DeleteDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorOutput) GoString() string {
	return s.String()
}

type DeleteFilterInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the filter is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the filter that you want to delete.
	//
	// FilterName is a required field
	FilterName *string `location:"uri" locationName:"filterName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFilterInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteFilterInput) SetDetectorId(v string) *DeleteFilterInput {
	s.DetectorId = &v
	return s
}

// SetFilterName sets the FilterName field's value.
func (s *DeleteFilterInput) SetFilterName(v string) *DeleteFilterInput {
	s.FilterName = &v
	return s
}

type DeleteFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFilterOutput) GoString() string {
	return s.String()
}

type DeleteIPSetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector associated with the IPSet.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The unique ID of the IPSet to delete.
	//
	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}
	if s.IpSetId != nil && len(*s.IpSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteIPSetInput) SetDetectorId(v string) *DeleteIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *DeleteIPSetInput) SetIpSetId(v string) *DeleteIPSetInput {
	s.IpSetId = &v
	return s
}

type DeleteIPSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetOutput) GoString() string {
	return s.String()
}

type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the AWS accounts that sent invitations to the current
	// member account that you want to delete invitations from.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to delete.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty account whose members you
	// want to delete.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteMembersInput) SetDetectorId(v string) *DeleteMembersInput {
	s.DetectorId = &v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The accounts that could not be processed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeletePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination to delete.
	//
	// DestinationId is a required field
	DestinationId *string `location:"uri" locationName:"destinationId" type:"string" required:"true"`

	// The unique ID of the detector associated with the publishing destination
	// to delete.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublishingDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublishingDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublishingDestinationInput"}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationId sets the DestinationId field's value.
func (s *DeletePublishingDestinationInput) SetDestinationId(v string) *DeletePublishingDestinationInput {
	s.DestinationId = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeletePublishingDestinationInput) SetDetectorId(v string) *DeletePublishingDestinationInput {
	s.DetectorId = &v
	return s
}

type DeletePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublishingDestinationOutput) GoString() string {
	return s.String()
}

type DeleteThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the threatIntelSet is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The unique ID of the threatIntelSet that you want to delete.
	//
	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}
	if s.ThreatIntelSetId != nil && len(*s.ThreatIntelSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThreatIntelSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteThreatIntelSetInput) SetDetectorId(v string) *DeleteThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *DeleteThreatIntelSetInput) SetThreatIntelSetId(v string) *DeleteThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

type DeleteThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteThreatIntelSetOutput) GoString() string {
	return s.String()
}

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to retrieve information about the delegated administrator
	// from.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationConfigurationInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeOrganizationConfigurationInput) SetDetectorId(v string) *DescribeOrganizationConfigurationInput {
	s.DetectorId = &v
	return s
}

type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether GuardDuty is automatically enabled for accounts added to
	// the organization.
	//
	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`

	// Describes which data sources are enabled automatically for member accounts.
	DataSources *OrganizationDataSourceConfigurationsResult `locationName:"dataSources" type:"structure"`

	// Indicates whether the maximum number of allowed member accounts are already
	// associated with the delegated administrator account for your organization.
	//
	// MemberAccountLimitReached is a required field
	MemberAccountLimitReached *bool `locationName:"memberAccountLimitReached" type:"boolean" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *DescribeOrganizationConfigurationOutput) SetAutoEnable(v bool) *DescribeOrganizationConfigurationOutput {
	s.AutoEnable = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *DescribeOrganizationConfigurationOutput) SetDataSources(v *OrganizationDataSourceConfigurationsResult) *DescribeOrganizationConfigurationOutput {
	s.DataSources = v
	return s
}

// SetMemberAccountLimitReached sets the MemberAccountLimitReached field's value.
func (s *DescribeOrganizationConfigurationOutput) SetMemberAccountLimitReached(v bool) *DescribeOrganizationConfigurationOutput {
	s.MemberAccountLimitReached = &v
	return s
}

type DescribePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination to retrieve.
	//
	// DestinationId is a required field
	DestinationId *string `location:"uri" locationName:"destinationId" type:"string" required:"true"`

	// The unique ID of the detector associated with the publishing destination
	// to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePublishingDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePublishingDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePublishingDestinationInput"}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationId sets the DestinationId field's value.
func (s *DescribePublishingDestinationInput) SetDestinationId(v string) *DescribePublishingDestinationInput {
	s.DestinationId = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribePublishingDestinationInput) SetDetectorId(v string) *DescribePublishingDestinationInput {
	s.DetectorId = &v
	return s
}

type DescribePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination.
	//
	// DestinationId is a required field
	DestinationId *string `locationName:"destinationId" type:"string" required:"true"`

	// A DestinationProperties object that includes the DestinationArn and KmsKeyArn
	// of the publishing destination.
	//
	// DestinationProperties is a required field
	DestinationProperties *DestinationProperties `locationName:"destinationProperties" type:"structure" required:"true"`

	// The type of publishing destination. Currently, only Amazon S3 buckets are
	// supported.
	//
	// DestinationType is a required field
	DestinationType *string `locationName:"destinationType" min:"1" type:"string" required:"true" enum:"DestinationType"`

	// The time, in epoch millisecond format, at which GuardDuty was first unable
	// to publish findings to the destination.
	//
	// PublishingFailureStartTimestamp is a required field
	PublishingFailureStartTimestamp *int64 `locationName:"publishingFailureStartTimestamp" type:"long" required:"true"`

	// The status of the publishing destination.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"PublishingStatus"`
}

// String returns the string representation
func (s DescribePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePublishingDestinationOutput) GoString() string {
	return s.String()
}

// SetDestinationId sets the DestinationId field's value.
func (s *DescribePublishingDestinationOutput) SetDestinationId(v string) *DescribePublishingDestinationOutput {
	s.DestinationId = &v
	return s
}

// SetDestinationProperties sets the DestinationProperties field's value.
func (s *DescribePublishingDestinationOutput) SetDestinationProperties(v *DestinationProperties) *DescribePublishingDestinationOutput {
	s.DestinationProperties = v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *DescribePublishingDestinationOutput) SetDestinationType(v string) *DescribePublishingDestinationOutput {
	s.DestinationType = &v
	return s
}

// SetPublishingFailureStartTimestamp sets the PublishingFailureStartTimestamp field's value.
func (s *DescribePublishingDestinationOutput) SetPublishingFailureStartTimestamp(v int64) *DescribePublishingDestinationOutput {
	s.PublishingFailureStartTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribePublishingDestinationOutput) SetStatus(v string) *DescribePublishingDestinationOutput {
	s.Status = &v
	return s
}

// Contains information about the publishing destination, including the ID,
// type, and status.
type Destination struct {
	_ struct{} `type:"structure"`

	// The unique ID of the publishing destination.
	//
	// DestinationId is a required field
	DestinationId *string `locationName:"destinationId" type:"string" required:"true"`

	// The type of resource used for the publishing destination. Currently, only
	// Amazon S3 buckets are supported.
	//
	// DestinationType is a required field
	DestinationType *string `locationName:"destinationType" min:"1" type:"string" required:"true" enum:"DestinationType"`

	// The status of the publishing destination.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"PublishingStatus"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// SetDestinationId sets the DestinationId field's value.
func (s *Destination) SetDestinationId(v string) *Destination {
	s.DestinationId = &v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *Destination) SetDestinationType(v string) *Destination {
	s.DestinationType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Destination) SetStatus(v string) *Destination {
	s.Status = &v
	return s
}

// Contains the Amazon Resource Name (ARN) of the resource to publish to, such
// as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
type DestinationProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to publish to.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// The ARN of the KMS key to use for encryption.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`
}

// String returns the string representation
func (s DestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationProperties) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *DestinationProperties) SetDestinationArn(v string) *DestinationProperties {
	s.DestinationArn = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DestinationProperties) SetKmsKeyArn(v string) *DestinationProperties {
	s.KmsKeyArn = &v
	return s
}

type DisableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID for the organizations account to be disabled as a GuardDuty
	// delegated administrator.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `locationName:"adminAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *DisableOrganizationAdminAccountInput) SetAdminAccountId(v string) *DisableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type DisableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector of the GuardDuty member account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFromMasterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFromMasterAccountInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DisassociateFromMasterAccountInput) SetDetectorId(v string) *DisassociateFromMasterAccountInput {
	s.DetectorId = &v
	return s
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to disassociate
	// from the administrator account.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty account whose members you
	// want to disassociate from the administrator account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateMembersInput) SetAccountIds(v []*string) *DisassociateMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DisassociateMembersInput) SetDetectorId(v string) *DisassociateMembersInput {
	s.DetectorId = &v
	return s
}

type DisassociateMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DisassociateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DisassociateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Contains information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {
	_ struct{} `type:"structure"`

	// The domain information for the API request.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DnsRequestAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsRequestAction) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DnsRequestAction) SetDomain(v string) *DnsRequestAction {
	s.Domain = &v
	return s
}

// Contains information about the domain.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	// The domain information for the AWS API call.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDetails) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DomainDetails) SetDomain(v string) *DomainDetails {
	s.Domain = &v
	return s
}

type EnableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS Account ID for the organization account to be enabled as a GuardDuty
	// delegated administrator.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `locationName:"adminAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *EnableOrganizationAdminAccountInput) SetAdminAccountId(v string) *EnableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type EnableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

// Contains information about the reason that the finding was generated.
type Evidence struct {
	_ struct{} `type:"structure"`

	// A list of threat intelligence details related to the evidence.
	ThreatIntelligenceDetails []*ThreatIntelligenceDetail `locationName:"threatIntelligenceDetails" type:"list"`
}

// String returns the string representation
func (s Evidence) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evidence) GoString() string {
	return s.String()
}

// SetThreatIntelligenceDetails sets the ThreatIntelligenceDetails field's value.
func (s *Evidence) SetThreatIntelligenceDetails(v []*ThreatIntelligenceDetail) *Evidence {
	s.ThreatIntelligenceDetails = v
	return s
}

// Contains information about the finding, which is generated when abnormal
// or suspicious activity is detected.
type Finding struct {
	_ struct{} `type:"structure"`

	// The ID of the account in which the finding was generated.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// The ARN of the finding.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The confidence score for the finding.
	Confidence *float64 `locationName:"confidence" type:"double"`

	// The time and date when the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *string `locationName:"createdAt" type:"string" required:"true"`

	// The description of the finding.
	Description *string `locationName:"description" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The partition associated with the finding.
	Partition *string `locationName:"partition" type:"string"`

	// The Region where the finding was generated.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// Contains information about the AWS resource associated with the activity
	// that prompted GuardDuty to generate a finding.
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`

	// The version of the schema used for the finding.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `locationName:"schemaVersion" type:"string" required:"true"`

	// Contains additional information about the generated finding.
	Service *Service `locationName:"service" type:"structure"`

	// The severity of the finding.
	//
	// Severity is a required field
	Severity *float64 `locationName:"severity" type:"double" required:"true"`

	// The title of the finding.
	Title *string `locationName:"title" type:"string"`

	// The type of finding.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`

	// The time and date when the finding was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Finding) SetAccountId(v string) *Finding {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Finding) SetArn(v string) *Finding {
	s.Arn = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Finding) SetConfidence(v float64) *Finding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v string) *Finding {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Finding) SetPartition(v string) *Finding {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Finding) SetRegion(v string) *Finding {
	s.Region = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *Finding) SetResource(v *Resource) *Finding {
	s.Resource = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *Finding) SetSchemaVersion(v string) *Finding {
	s.SchemaVersion = &v
	return s
}

// SetService sets the Service field's value.
func (s *Finding) SetService(v *Service) *Finding {
	s.Service = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v float64) *Finding {
	s.Severity = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *Finding) SetType(v string) *Finding {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v string) *Finding {
	s.UpdatedAt = &v
	return s
}

// Contains information about the criteria used for querying findings.
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]*Condition `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingCriteria) GoString() string {
	return s.String()
}

// SetCriterion sets the Criterion field's value.
func (s *FindingCriteria) SetCriterion(v map[string]*Condition) *FindingCriteria {
	s.Criterion = v
	return s
}

// Contains information about finding statistics.
type FindingStatistics struct {
	_ struct{} `type:"structure"`

	// Represents a map of severity to count statistics for a set of findings.
	CountBySeverity map[string]*int64 `locationName:"countBySeverity" type:"map"`
}

// String returns the string representation
func (s FindingStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingStatistics) GoString() string {
	return s.String()
}

// SetCountBySeverity sets the CountBySeverity field's value.
func (s *FindingStatistics) SetCountBySeverity(v map[string]*int64) *FindingStatistics {
	s.CountBySeverity = v
	return s
}

// Contains information on the status of VPC flow logs as a data source.
type FlowLogsConfigurationResult struct {
	_ struct{} `type:"structure"`

	// Denotes whether VPC flow logs is enabled as a data source.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation
func (s FlowLogsConfigurationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowLogsConfigurationResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *FlowLogsConfigurationResult) SetStatus(v string) *FlowLogsConfigurationResult {
	s.Status = &v
	return s
}

// Contains information about the location of the remote IP address.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The latitude information of the remote IP address.
	Lat *float64 `locationName:"lat" type:"double"`

	// The longitude information of the remote IP address.
	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// SetLat sets the Lat field's value.
func (s *GeoLocation) SetLat(v float64) *GeoLocation {
	s.Lat = &v
	return s
}

// SetLon sets the Lon field's value.
func (s *GeoLocation) SetLon(v float64) *GeoLocation {
	s.Lon = &v
	return s
}

type GetDetectorInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that you want to get.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorInput) SetDetectorId(v string) *GetDetectorInput {
	s.DetectorId = &v
	return s
}

type GetDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the detector was created.
	CreatedAt *string `locationName:"createdAt" type:"string"`

	// Describes which data sources are enabled for the detector.
	DataSources *DataSourceConfigurationsResult `locationName:"dataSources" type:"structure"`

	// The publishing frequency of the finding.
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`

	// The GuardDuty service role.
	//
	// ServiceRole is a required field
	ServiceRole *string `locationName:"serviceRole" type:"string" required:"true"`

	// The detector status.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"DetectorStatus"`

	// The tags of the detector resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The last-updated timestamp for the detector.
	UpdatedAt *string `locationName:"updatedAt" type:"string"`
}

// String returns the string representation
func (s GetDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDetectorOutput) SetCreatedAt(v string) *GetDetectorOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *GetDetectorOutput) SetDataSources(v *DataSourceConfigurationsResult) *GetDetectorOutput {
	s.DataSources = v
	return s
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *GetDetectorOutput) SetFindingPublishingFrequency(v string) *GetDetectorOutput {
	s.FindingPublishingFrequency = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *GetDetectorOutput) SetServiceRole(v string) *GetDetectorOutput {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDetectorOutput) SetStatus(v string) *GetDetectorOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDetectorOutput) SetTags(v map[string]*string) *GetDetectorOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDetectorOutput) SetUpdatedAt(v string) *GetDetectorOutput {
	s.UpdatedAt = &v
	return s
}

type GetFilterInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the filter is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the filter you want to get.
	//
	// FilterName is a required field
	FilterName *string `location:"uri" locationName:"filterName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFilterInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetFilterInput) SetDetectorId(v string) *GetFilterInput {
	s.DetectorId = &v
	return s
}

// SetFilterName sets the FilterName field's value.
func (s *GetFilterInput) SetFilterName(v string) *GetFilterInput {
	s.FilterName = &v
	return s
}

type GetFilterOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	//
	// Action is a required field
	Action *string `locationName:"action" min:"1" type:"string" required:"true" enum:"FilterAction"`

	// The description of the filter.
	Description *string `locationName:"description" type:"string"`

	// Represents the criteria to be used in the filter for querying findings.
	//
	// FindingCriteria is a required field
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure" required:"true"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank *int64 `locationName:"rank" min:"1" type:"integer"`

	// The tags of the filter resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s GetFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFilterOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GetFilterOutput) SetAction(v string) *GetFilterOutput {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFilterOutput) SetDescription(v string) *GetFilterOutput {
	s.Description = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *GetFilterOutput) SetFindingCriteria(v *FindingCriteria) *GetFilterOutput {
	s.FindingCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *GetFilterOutput) SetName(v string) *GetFilterOutput {
	s.Name = &v
	return s
}

// SetRank sets the Rank field's value.
func (s *GetFilterOutput) SetRank(v int64) *GetFilterOutput {
	s.Rank = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFilterOutput) SetTags(v map[string]*string) *GetFilterOutput {
	s.Tags = v
	return s
}

type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose findings
	// you want to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The IDs of the findings that you want to retrieve.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`

	// Represents the criteria used for sorting findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetFindingsInput) SetDetectorId(v string) *GetFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *GetFindingsInput) SetFindingIds(v []*string) *GetFindingsInput {
	s.FindingIds = v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v *SortCriteria) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings.
	//
	// Findings is a required field
	Findings []*Finding `locationName:"findings" type:"list" required:"true"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*Finding) *GetFindingsOutput {
	s.Findings = v
	return s
}

type GetFindingsStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose findings'
	// statistics you want to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Represents the criteria that is used for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// The types of finding statistics to retrieve.
	//
	// FindingStatisticTypes is a required field
	FindingStatisticTypes []*string `locationName:"findingStatisticTypes" type:"list" required:"true"`
}

// String returns the string representation
func (s GetFindingsStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsStatisticsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FindingStatisticTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingStatisticTypes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetFindingsStatisticsInput) SetDetectorId(v string) *GetFindingsStatisticsInput {
	s.DetectorId = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *GetFindingsStatisticsInput) SetFindingCriteria(v *FindingCriteria) *GetFindingsStatisticsInput {
	s.FindingCriteria = v
	return s
}

// SetFindingStatisticTypes sets the FindingStatisticTypes field's value.
func (s *GetFindingsStatisticsInput) SetFindingStatisticTypes(v []*string) *GetFindingsStatisticsInput {
	s.FindingStatisticTypes = v
	return s
}

type GetFindingsStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The finding statistics object.
	//
	// FindingStatistics is a required field
	FindingStatistics *FindingStatistics `locationName:"findingStatistics" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetFindingsStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsStatisticsOutput) GoString() string {
	return s.String()
}

// SetFindingStatistics sets the FindingStatistics field's value.
func (s *GetFindingsStatisticsOutput) SetFindingStatistics(v *FindingStatistics) *GetFindingsStatisticsOutput {
	s.FindingStatistics = v
	return s
}

type GetIPSetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the IPSet is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The unique ID of the IPSet to retrieve.
	//
	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}
	if s.IpSetId != nil && len(*s.IpSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetIPSetInput) SetDetectorId(v string) *GetIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *GetIPSetInput) SetIpSetId(v string) *GetIPSetInput {
	s.IpSetId = &v
	return s
}

type GetIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The format of the file that contains the IPSet.
	//
	// Format is a required field
	Format *string `locationName:"format" min:"1" type:"string" required:"true" enum:"IpSetFormat"`

	// The URI of the file that contains the IPSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"1" type:"string" required:"true"`

	// The user-friendly name for the IPSet.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of IPSet file that was uploaded.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"IpSetStatus"`

	// The tags of the IPSet resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s GetIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetIPSetOutput) SetFormat(v string) *GetIPSetOutput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetIPSetOutput) SetLocation(v string) *GetIPSetOutput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetIPSetOutput) SetName(v string) *GetIPSetOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIPSetOutput) SetStatus(v string) *GetIPSetOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIPSetOutput) SetTags(v map[string]*string) *GetIPSetOutput {
	s.Tags = v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of received invitations.
	InvitationsCount *int64 `locationName:"invitationsCount" type:"integer"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector of the GuardDuty member account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMasterAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMasterAccountInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetMasterAccountInput) SetDetectorId(v string) *GetMasterAccountInput {
	s.DetectorId = &v
	return s
}

type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// The administrator account details.
	//
	// Master is a required field
	Master *Master `locationName:"master" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Master) *GetMasterAccountOutput {
	s.Master = v
	return s
}

type GetMemberDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the member account.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The detector ID for the administrator account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMemberDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMemberDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMemberDetectorsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMemberDetectorsInput) SetAccountIds(v []*string) *GetMemberDetectorsInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetMemberDetectorsInput) SetDetectorId(v string) *GetMemberDetectorsInput {
	s.DetectorId = &v
	return s
}

type GetMemberDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes which data sources are enabled for a member account.
	//
	// MemberDataSourceConfigurations is a required field
	MemberDataSourceConfigurations []*MemberDataSourceConfiguration `locationName:"members" min:"1" type:"list" required:"true"`

	// A list of member account IDs that were unable to be processed along with
	// an explanation for why they were not processed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s GetMemberDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMemberDetectorsOutput) GoString() string {
	return s.String()
}

// SetMemberDataSourceConfigurations sets the MemberDataSourceConfigurations field's value.
func (s *GetMemberDetectorsOutput) SetMemberDataSourceConfigurations(v []*MemberDataSourceConfiguration) *GetMemberDetectorsOutput {
	s.MemberDataSourceConfigurations = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMemberDetectorsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *GetMemberDetectorsOutput {
	s.UnprocessedAccounts = v
	return s
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts that you want to describe.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty account whose members you
	// want to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetMembersInput) SetDetectorId(v string) *GetMembersInput {
	s.DetectorId = &v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of members.
	//
	// Members is a required field
	Members []*Member `locationName:"members" type:"list" required:"true"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *GetMembersOutput) SetMembers(v []*Member) *GetMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type GetThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the threatIntelSet is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The unique ID of the threatIntelSet that you want to get.
	//
	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}
	if s.ThreatIntelSetId != nil && len(*s.ThreatIntelSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThreatIntelSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetThreatIntelSetInput) SetDetectorId(v string) *GetThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *GetThreatIntelSetInput) SetThreatIntelSetId(v string) *GetThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

type GetThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The format of the threatIntelSet.
	//
	// Format is a required field
	Format *string `locationName:"format" min:"1" type:"string" required:"true" enum:"ThreatIntelSetFormat"`

	// The URI of the file that contains the ThreatIntelSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"1" type:"string" required:"true"`

	// A user-friendly ThreatIntelSet name displayed in all findings that are generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of threatIntelSet file uploaded.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"ThreatIntelSetStatus"`

	// The tags of the threat list resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s GetThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThreatIntelSetOutput) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *GetThreatIntelSetOutput) SetFormat(v string) *GetThreatIntelSetOutput {
	s.Format = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetThreatIntelSetOutput) SetLocation(v string) *GetThreatIntelSetOutput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetThreatIntelSetOutput) SetName(v string) *GetThreatIntelSetOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetThreatIntelSetOutput) SetStatus(v string) *GetThreatIntelSetOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetThreatIntelSetOutput) SetTags(v map[string]*string) *GetThreatIntelSetOutput {
	s.Tags = v
	return s
}

type GetUsageStatisticsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose usage statistics
	// you want to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The currency unit you would like to view your usage statistics in. Current
	// valid values are USD.
	Unit *string `locationName:"unit" type:"string"`

	// Represents the criteria used for querying usage.
	//
	// UsageCriteria is a required field
	UsageCriteria *UsageCriteria `locationName:"usageCriteria" type:"structure" required:"true"`

	// The type of usage statistics to retrieve.
	//
	// UsageStatisticType is a required field
	UsageStatisticType *string `locationName:"usageStatisticsType" type:"string" required:"true" enum:"UsageStatisticType"`
}

// String returns the string representation
func (s GetUsageStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsageStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsageStatisticsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.UsageCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageCriteria"))
	}
	if s.UsageStatisticType == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageStatisticType"))
	}
	if s.UsageCriteria != nil {
		if err := s.UsageCriteria.Validate(); err != nil {
			invalidParams.AddNested("UsageCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetUsageStatisticsInput) SetDetectorId(v string) *GetUsageStatisticsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUsageStatisticsInput) SetMaxResults(v int64) *GetUsageStatisticsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUsageStatisticsInput) SetNextToken(v string) *GetUsageStatisticsInput {
	s.NextToken = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetUsageStatisticsInput) SetUnit(v string) *GetUsageStatisticsInput {
	s.Unit = &v
	return s
}

// SetUsageCriteria sets the UsageCriteria field's value.
func (s *GetUsageStatisticsInput) SetUsageCriteria(v *UsageCriteria) *GetUsageStatisticsInput {
	s.UsageCriteria = v
	return s
}

// SetUsageStatisticType sets the UsageStatisticType field's value.
func (s *GetUsageStatisticsInput) SetUsageStatisticType(v string) *GetUsageStatisticsInput {
	s.UsageStatisticType = &v
	return s
}

type GetUsageStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The usage statistics object. If a UsageStatisticType was provided, the objects
	// representing other types will be null.
	UsageStatistics *UsageStatistics `locationName:"usageStatistics" type:"structure"`
}

// String returns the string representation
func (s GetUsageStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUsageStatisticsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUsageStatisticsOutput) SetNextToken(v string) *GetUsageStatisticsOutput {
	s.NextToken = &v
	return s
}

// SetUsageStatistics sets the UsageStatistics field's value.
func (s *GetUsageStatisticsOutput) SetUsageStatistics(v *UsageStatistics) *GetUsageStatisticsOutput {
	s.UsageStatistics = v
	return s
}

// Contains information about the EC2 instance profile.
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The profile ARN of the EC2 instance.
	Arn *string `locationName:"arn" type:"string"`

	// The profile ID of the EC2 instance.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IamInstanceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *IamInstanceProfile) SetArn(v string) *IamInstanceProfile {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *IamInstanceProfile) SetId(v string) *IamInstanceProfile {
	s.Id = &v
	return s
}

// Contains information about the details of an instance.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the EC2 instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The image description of the EC2 instance.
	ImageDescription *string `locationName:"imageDescription" type:"string"`

	// The image ID of the EC2 instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the EC2 instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The state of the EC2 instance.
	InstanceState *string `locationName:"instanceState" type:"string"`

	// The type of the EC2 instance.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The launch time of the EC2 instance.
	LaunchTime *string `locationName:"launchTime" type:"string"`

	// The elastic network interface information of the EC2 instance.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS
	// Outposts instances.
	OutpostArn *string `locationName:"outpostArn" type:"string"`

	// The platform of the EC2 instance.
	Platform *string `locationName:"platform" type:"string"`

	// The product code of the EC2 instance.
	ProductCodes []*ProductCode `locationName:"productCodes" type:"list"`

	// The tags of the EC2 instance.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InstanceDetails) SetAvailabilityZone(v string) *InstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *InstanceDetails) SetIamInstanceProfile(v *IamInstanceProfile) *InstanceDetails {
	s.IamInstanceProfile = v
	return s
}

// SetImageDescription sets the ImageDescription field's value.
func (s *InstanceDetails) SetImageDescription(v string) *InstanceDetails {
	s.ImageDescription = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *InstanceDetails) SetImageId(v string) *InstanceDetails {
	s.ImageId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceDetails) SetInstanceId(v string) *InstanceDetails {
	s.InstanceId = &v
	return s
}

// SetInstanceState sets the InstanceState field's value.
func (s *InstanceDetails) SetInstanceState(v string) *InstanceDetails {
	s.InstanceState = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceDetails) SetInstanceType(v string) *InstanceDetails {
	s.InstanceType = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *InstanceDetails) SetLaunchTime(v string) *InstanceDetails {
	s.LaunchTime = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *InstanceDetails) SetNetworkInterfaces(v []*NetworkInterface) *InstanceDetails {
	s.NetworkInterfaces = v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *InstanceDetails) SetOutpostArn(v string) *InstanceDetails {
	s.OutpostArn = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *InstanceDetails) SetPlatform(v string) *InstanceDetails {
	s.Platform = &v
	return s
}

// SetProductCodes sets the ProductCodes field's value.
func (s *InstanceDetails) SetProductCodes(v []*ProductCode) *InstanceDetails {
	s.ProductCodes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstanceDetails) SetTags(v []*Tag) *InstanceDetails {
	s.Tags = v
	return s
}

// An internal server error exception object.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message.
	Message_ *string `locationName:"message" type:"string"`

	// The error type.
	Type *string `locationName:"__type" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the invitation to become a member account.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The ID of the account that the invitation was sent from.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The ID of the invitation. This value is used to validate the inviter account
	// to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v string) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Invitation) SetRelationshipStatus(v string) *Invitation {
	s.RelationshipStatus = &v
	return s
}

type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the accounts that you want to invite to GuardDuty
	// as members.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty account that you want to invite
	// members with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// A Boolean value that specifies whether you want to disable email notification
	// to the accounts that you are inviting to GuardDuty as members.
	DisableEmailNotification *bool `locationName:"disableEmailNotification" type:"boolean"`

	// The invitation message that you want to send to the accounts that you're
	// inviting to GuardDuty as members.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *InviteMembersInput) SetAccountIds(v []*string) *InviteMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *InviteMembersInput) SetDetectorId(v string) *InviteMembersInput {
	s.DetectorId = &v
	return s
}

// SetDisableEmailNotification sets the DisableEmailNotification field's value.
func (s *InviteMembersInput) SetDisableEmailNotification(v bool) *InviteMembersInput {
	s.DisableEmailNotification = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *InviteMembersInput) SetMessage(v string) *InviteMembersInput {
	s.Message = &v
	return s
}

type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *InviteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *InviteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type ListDetectorsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorsInput) SetMaxResults(v int64) *ListDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsInput) SetNextToken(v string) *ListDetectorsInput {
	s.NextToken = &v
	return s
}

type ListDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of detector IDs.
	//
	// DetectorIds is a required field
	DetectorIds []*string `locationName:"detectorIds" type:"list" required:"true"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectorIds sets the DetectorIds field's value.
func (s *ListDetectorsOutput) SetDetectorIds(v []*string) *ListDetectorsOutput {
	s.DetectorIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsOutput) SetNextToken(v string) *ListDetectorsOutput {
	s.NextToken = &v
	return s
}

type ListFiltersInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the filter is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFiltersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListFiltersInput) SetDetectorId(v string) *ListFiltersInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFiltersInput) SetMaxResults(v int64) *ListFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersInput) SetNextToken(v string) *ListFiltersInput {
	s.NextToken = &v
	return s
}

type ListFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of filter names.
	//
	// FilterNames is a required field
	FilterNames []*string `locationName:"filterNames" type:"list" required:"true"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFiltersOutput) GoString() string {
	return s.String()
}

// SetFilterNames sets the FilterNames field's value.
func (s *ListFiltersOutput) SetFilterNames(v []*string) *ListFiltersOutput {
	s.FilterNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFiltersOutput) SetNextToken(v string) *ListFiltersOutput {
	s.NextToken = &v
	return s
}

type ListFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector that specifies the GuardDuty service whose findings
	// you want to list.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Represents the criteria used for querying findings. Valid values include:
	//
	//    * JSON field name
	//
	//    * accountId
	//
	//    * region
	//
	//    * confidence
	//
	//    * id
	//
	//    * resource.accessKeyDetails.accessKeyId
	//
	//    * resource.accessKeyDetails.principalId
	//
	//    * resource.accessKeyDetails.userName
	//
	//    * resource.accessKeyDetails.userType
	//
	//    * resource.instanceDetails.iamInstanceProfile.id
	//
	//    * resource.instanceDetails.imageId
	//
	//    * resource.instanceDetails.instanceId
	//
	//    * resource.instanceDetails.networkInterfaces.ipv6Addresses
	//
	//    * resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
	//
	//    * resource.instanceDetails.networkInterfaces.publicDnsName
	//
	//    * resource.instanceDetails.networkInterfaces.publicIp
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupId
	//
	//    * resource.instanceDetails.networkInterfaces.securityGroups.groupName
	//
	//    * resource.instanceDetails.networkInterfaces.subnetId
	//
	//    * resource.instanceDetails.networkInterfaces.vpcId
	//
	//    * resource.instanceDetails.tags.key
	//
	//    * resource.instanceDetails.tags.value
	//
	//    * resource.resourceType
	//
	//    * service.action.actionType
	//
	//    * service.action.awsApiCallAction.api
	//
	//    * service.action.awsApiCallAction.callerType
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.city.cityName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.country.countryName
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asn
	//
	//    * service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.awsApiCallAction.serviceName
	//
	//    * service.action.dnsRequestAction.domain
	//
	//    * service.action.networkConnectionAction.blocked
	//
	//    * service.action.networkConnectionAction.connectionDirection
	//
	//    * service.action.networkConnectionAction.localPortDetails.port
	//
	//    * service.action.networkConnectionAction.protocol
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.city.cityName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.country.countryName
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asn
	//
	//    * service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
	//
	//    * service.action.networkConnectionAction.remotePortDetails.port
	//
	//    * service.additionalInfo.threatListName
	//
	//    * service.archived When this attribute is set to 'true', only archived
	//    findings are listed. When it's set to 'false', only unarchived findings
	//    are listed. When this attribute is not set, all existing findings are
	//    listed.
	//
	//    * service.resourceRole
	//
	//    * severity
	//
	//    * type
	//
	//    * updatedAt Type: Timestamp in Unix Epoch millisecond format: 1486685375000
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Represents the criteria used for sorting findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListFindingsInput) SetDetectorId(v string) *ListFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *ListFindingsInput) SetFindingCriteria(v *FindingCriteria) *ListFindingsInput {
	s.FindingCriteria = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsInput) SetMaxResults(v int64) *ListFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsInput) SetNextToken(v string) *ListFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *ListFindingsInput) SetSortCriteria(v *SortCriteria) *ListFindingsInput {
	s.SortCriteria = v
	return s
}

type ListFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the findings that you're listing.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

// SetFindingIds sets the FindingIds field's value.
func (s *ListFindingsOutput) SetFindingIds(v []*string) *ListFindingsOutput {
	s.FindingIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsOutput) SetNextToken(v string) *ListFindingsOutput {
	s.NextToken = &v
	return s
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the IPSet is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIPSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIPSetsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListIPSetsInput) SetDetectorId(v string) *ListIPSetsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIPSetsInput) SetMaxResults(v int64) *ListIPSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIPSetsInput) SetNextToken(v string) *ListIPSetsInput {
	s.NextToken = &v
	return s
}

type ListIPSetsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the IPSet resources.
	//
	// IpSetIds is a required field
	IpSetIds []*string `locationName:"ipSetIds" type:"list" required:"true"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

// SetIpSetIds sets the IpSetIds field's value.
func (s *ListIPSetsOutput) SetIpSetIds(v []*string) *ListIPSetsOutput {
	s.IpSetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIPSetsOutput) SetNextToken(v string) *ListIPSetsOutput {
	s.NextToken = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of invitation descriptions.
	Invitations []*Invitation `locationName:"invitations" type:"list"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector the member is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to null on your first call to the list action. For subsequent calls
	// to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Specifies whether to only return associated members or to return all members
	// (including members who haven't been invited yet or have been disassociated).
	OnlyAssociated *string `location:"querystring" locationName:"onlyAssociated" type:"string"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListMembersInput) SetDetectorId(v string) *ListMembersInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v string) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of members.
	Members []*Member `locationName:"members" type:"list"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationAdminAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationAdminAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationAdminAccountsInput) SetMaxResults(v int64) *ListOrganizationAdminAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsInput) SetNextToken(v string) *ListOrganizationAdminAccountsInput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A list of accounts configured as GuardDuty delegated administrators.
	AdminAccounts []*AdminAccount `locationName:"adminAccounts" type:"list"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsOutput) GoString() string {
	return s.String()
}

// SetAdminAccounts sets the AdminAccounts field's value.
func (s *ListOrganizationAdminAccountsOutput) SetAdminAccounts(v []*AdminAccount) *ListOrganizationAdminAccountsOutput {
	s.AdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsOutput) SetNextToken(v string) *ListOrganizationAdminAccountsOutput {
	s.NextToken = &v
	return s
}

type ListPublishingDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to retrieve publishing destinations for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPublishingDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublishingDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPublishingDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPublishingDestinationsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListPublishingDestinationsInput) SetDetectorId(v string) *ListPublishingDestinationsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPublishingDestinationsInput) SetMaxResults(v int64) *ListPublishingDestinationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublishingDestinationsInput) SetNextToken(v string) *ListPublishingDestinationsInput {
	s.NextToken = &v
	return s
}

type ListPublishingDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// A Destinations object that includes information about each publishing destination
	// returned.
	//
	// Destinations is a required field
	Destinations []*Destination `locationName:"destinations" type:"list" required:"true"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request to a list action.
	// For subsequent calls, use the NextToken value returned from the previous
	// request to continue listing results after the first page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPublishingDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublishingDestinationsOutput) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *ListPublishingDestinationsOutput) SetDestinations(v []*Destination) *ListPublishingDestinationsOutput {
	s.Destinations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublishingDestinationsOutput) SetNextToken(v string) *ListPublishingDestinationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the given GuardDuty resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListThreatIntelSetsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector that the threatIntelSet is associated with.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// You can use this parameter to indicate the maximum number of items that you
	// want in the response. The default value is 50. The maximum value is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// You can use this parameter to paginate results in the response. Set the value
	// of this parameter to null on your first call to the list action. For subsequent
	// calls to the action, fill nextToken in the request with the value of NextToken
	// from the previous response to continue listing data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListThreatIntelSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThreatIntelSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThreatIntelSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListThreatIntelSetsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *ListThreatIntelSetsInput) SetDetectorId(v string) *ListThreatIntelSetsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListThreatIntelSetsInput) SetMaxResults(v int64) *ListThreatIntelSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListThreatIntelSetsInput) SetNextToken(v string) *ListThreatIntelSetsInput {
	s.NextToken = &v
	return s
}

type ListThreatIntelSetsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination parameter to be used on the next list operation to retrieve
	// more items.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of the ThreatIntelSet resources.
	//
	// ThreatIntelSetIds is a required field
	ThreatIntelSetIds []*string `locationName:"threatIntelSetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s ListThreatIntelSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListThreatIntelSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListThreatIntelSetsOutput) SetNextToken(v string) *ListThreatIntelSetsOutput {
	s.NextToken = &v
	return s
}

// SetThreatIntelSetIds sets the ThreatIntelSetIds field's value.
func (s *ListThreatIntelSetsOutput) SetThreatIntelSetIds(v []*string) *ListThreatIntelSetsOutput {
	s.ThreatIntelSetIds = v
	return s
}

// Contains information about the local IP address of the connection.
type LocalIpDetails struct {
	_ struct{} `type:"structure"`

	// The IPv4 local address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`
}

// String returns the string representation
func (s LocalIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalIpDetails) GoString() string {
	return s.String()
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *LocalIpDetails) SetIpAddressV4(v string) *LocalIpDetails {
	s.IpAddressV4 = &v
	return s
}

// Contains information about the port for the local connection.
type LocalPortDetails struct {
	_ struct{} `type:"structure"`

	// The port number of the local connection.
	Port *int64 `locationName:"port" type:"integer"`

	// The port name of the local connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s LocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalPortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *LocalPortDetails) SetPort(v int64) *LocalPortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *LocalPortDetails) SetPortName(v string) *LocalPortDetails {
	s.PortName = &v
	return s
}

// Contains information about the administrator account and invitation.
type Master struct {
	_ struct{} `type:"structure"`

	// The ID of the account used as the administrator account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The value used to validate the administrator account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Master) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Master) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Master) SetAccountId(v string) *Master {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Master) SetInvitationId(v string) *Master {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Master) SetInvitedAt(v string) *Master {
	s.InvitedAt = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Master) SetRelationshipStatus(v string) *Master {
	s.RelationshipStatus = &v
	return s
}

// Contains information about the member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The ID of the member account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The detector ID of the member account.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The email address of the member account.
	//
	// Email is a required field
	Email *string `locationName:"email" min:"1" type:"string" required:"true"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The administrator account ID.
	//
	// MasterId is a required field
	MasterId *string `locationName:"masterId" type:"string" required:"true"`

	// The status of the relationship between the member and the administrator.
	//
	// RelationshipStatus is a required field
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" required:"true"`

	// The last-updated timestamp of the member.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Member) SetDetectorId(v string) *Member {
	s.DetectorId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v string) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *Member) SetMasterId(v string) *Member {
	s.MasterId = &v
	return s
}

// SetRelationshipStatus sets the RelationshipStatus field's value.
func (s *Member) SetRelationshipStatus(v string) *Member {
	s.RelationshipStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v string) *Member {
	s.UpdatedAt = &v
	return s
}

// Contains information on which data sources are enabled for a member account.
type MemberDataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The account ID for the member account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// Contains information on the status of data sources for the account.
	//
	// DataSources is a required field
	DataSources *DataSourceConfigurationsResult `locationName:"dataSources" type:"structure" required:"true"`
}

// String returns the string representation
func (s MemberDataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberDataSourceConfiguration) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberDataSourceConfiguration) SetAccountId(v string) *MemberDataSourceConfiguration {
	s.AccountId = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *MemberDataSourceConfiguration) SetDataSources(v *DataSourceConfigurationsResult) *MemberDataSourceConfiguration {
	s.DataSources = v
	return s
}

// Contains information about the NETWORK_CONNECTION action described in the
// finding.
type NetworkConnectionAction struct {
	_ struct{} `type:"structure"`

	// Indicates whether EC2 blocked the network connection to your instance.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// The network connection direction.
	ConnectionDirection *string `locationName:"connectionDirection" type:"string"`

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails `locationName:"localIpDetails" type:"structure"`

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// The network connection protocol.
	Protocol *string `locationName:"protocol" type:"string"`

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// The remote port information of the connection.
	RemotePortDetails *RemotePortDetails `locationName:"remotePortDetails" type:"structure"`
}

// String returns the string representation
func (s NetworkConnectionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkConnectionAction) GoString() string {
	return s.String()
}

// SetBlocked sets the Blocked field's value.
func (s *NetworkConnectionAction) SetBlocked(v bool) *NetworkConnectionAction {
	s.Blocked = &v
	return s
}

// SetConnectionDirection sets the ConnectionDirection field's value.
func (s *NetworkConnectionAction) SetConnectionDirection(v string) *NetworkConnectionAction {
	s.ConnectionDirection = &v
	return s
}

// SetLocalIpDetails sets the LocalIpDetails field's value.
func (s *NetworkConnectionAction) SetLocalIpDetails(v *LocalIpDetails) *NetworkConnectionAction {
	s.LocalIpDetails = v
	return s
}

// SetLocalPortDetails sets the LocalPortDetails field's value.
func (s *NetworkConnectionAction) SetLocalPortDetails(v *LocalPortDetails) *NetworkConnectionAction {
	s.LocalPortDetails = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkConnectionAction) SetProtocol(v string) *NetworkConnectionAction {
	s.Protocol = &v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *NetworkConnectionAction) SetRemoteIpDetails(v *RemoteIpDetails) *NetworkConnectionAction {
	s.RemoteIpDetails = v
	return s
}

// SetRemotePortDetails sets the RemotePortDetails field's value.
func (s *NetworkConnectionAction) SetRemotePortDetails(v *RemotePortDetails) *NetworkConnectionAction {
	s.RemotePortDetails = v
	return s
}

// Contains information about the elastic network interface of the EC2 instance.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// A list of IPv6 addresses for the EC2 instance.
	Ipv6Addresses []*string `locationName:"ipv6Addresses" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []*PrivateIpAddressDetails `locationName:"privateIpAddresses" type:"list"`

	// The public DNS name of the EC2 instance.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The public IP address of the EC2 instance.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// The security groups associated with the EC2 instance.
	SecurityGroups []*SecurityGroup `locationName:"securityGroups" type:"list"`

	// The subnet ID of the EC2 instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The VPC ID of the EC2 instance.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIpv6Addresses sets the Ipv6Addresses field's value.
func (s *NetworkInterface) SetIpv6Addresses(v []*string) *NetworkInterface {
	s.Ipv6Addresses = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *NetworkInterface) SetPrivateDnsName(v string) *NetworkInterface {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *NetworkInterface) SetPrivateIpAddress(v string) *NetworkInterface {
	s.PrivateIpAddress = &v
	return s
}

// SetPrivateIpAddresses sets the PrivateIpAddresses field's value.
func (s *NetworkInterface) SetPrivateIpAddresses(v []*PrivateIpAddressDetails) *NetworkInterface {
	s.PrivateIpAddresses = v
	return s
}

// SetPublicDnsName sets the PublicDnsName field's value.
func (s *NetworkInterface) SetPublicDnsName(v string) *NetworkInterface {
	s.PublicDnsName = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *NetworkInterface) SetPublicIp(v string) *NetworkInterface {
	s.PublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *NetworkInterface) SetSecurityGroups(v []*SecurityGroup) *NetworkInterface {
	s.SecurityGroups = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkInterface) SetSubnetId(v string) *NetworkInterface {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *NetworkInterface) SetVpcId(v string) *NetworkInterface {
	s.VpcId = &v
	return s
}

// Contains information about the ISP organization of the remote IP address.
type Organization struct {
	_ struct{} `type:"structure"`

	// The Autonomous System Number (ASN) of the internet provider of the remote
	// IP address.
	Asn *string `locationName:"asn" type:"string"`

	// The organization that registered this ASN.
	AsnOrg *string `locationName:"asnOrg" type:"string"`

	// The ISP information for the internet provider.
	Isp *string `locationName:"isp" type:"string"`

	// The name of the internet provider.
	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Organization) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *Organization) SetAsn(v string) *Organization {
	s.Asn = &v
	return s
}

// SetAsnOrg sets the AsnOrg field's value.
func (s *Organization) SetAsnOrg(v string) *Organization {
	s.AsnOrg = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *Organization) SetIsp(v string) *Organization {
	s.Isp = &v
	return s
}

// SetOrg sets the Org field's value.
func (s *Organization) SetOrg(v string) *Organization {
	s.Org = &v
	return s
}

// An object that contains information on which data sources will be configured
// to be automatically enabled for new members within the organization.
type OrganizationDataSourceConfigurations struct {
	_ struct{} `type:"structure"`

	// Describes whether S3 data event logs are enabled for new members of the organization.
	S3Logs *OrganizationS3LogsConfiguration `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s OrganizationDataSourceConfigurations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationDataSourceConfigurations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationDataSourceConfigurations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationDataSourceConfigurations"}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Logs sets the S3Logs field's value.
func (s *OrganizationDataSourceConfigurations) SetS3Logs(v *OrganizationS3LogsConfiguration) *OrganizationDataSourceConfigurations {
	s.S3Logs = v
	return s
}

// An object that contains information on which data sources are automatically
// enabled for new members within the organization.
type OrganizationDataSourceConfigurationsResult struct {
	_ struct{} `type:"structure"`

	// Describes whether S3 data event logs are enabled as a data source.
	//
	// S3Logs is a required field
	S3Logs *OrganizationS3LogsConfigurationResult `locationName:"s3Logs" type:"structure" required:"true"`
}

// String returns the string representation
func (s OrganizationDataSourceConfigurationsResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationDataSourceConfigurationsResult) GoString() string {
	return s.String()
}

// SetS3Logs sets the S3Logs field's value.
func (s *OrganizationDataSourceConfigurationsResult) SetS3Logs(v *OrganizationS3LogsConfigurationResult) *OrganizationDataSourceConfigurationsResult {
	s.S3Logs = v
	return s
}

// Describes whether S3 data event logs will be automatically enabled for new
// members of the organization.
type OrganizationS3LogsConfiguration struct {
	_ struct{} `type:"structure"`

	// A value that contains information on whether S3 data event logs will be enabled
	// automatically as a data source for the organization.
	//
	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s OrganizationS3LogsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationS3LogsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationS3LogsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationS3LogsConfiguration"}
	if s.AutoEnable == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoEnable"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *OrganizationS3LogsConfiguration) SetAutoEnable(v bool) *OrganizationS3LogsConfiguration {
	s.AutoEnable = &v
	return s
}

// The current configuration of S3 data event logs as a data source for the
// organization.
type OrganizationS3LogsConfigurationResult struct {
	_ struct{} `type:"structure"`

	// A value that describes whether S3 data event logs are automatically enabled
	// for new members of the organization.
	//
	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s OrganizationS3LogsConfigurationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationS3LogsConfigurationResult) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *OrganizationS3LogsConfigurationResult) SetAutoEnable(v bool) *OrganizationS3LogsConfigurationResult {
	s.AutoEnable = &v
	return s
}

// Contains information on the owner of the bucket.
type Owner struct {
	_ struct{} `type:"structure"`

	// The canonical user ID of the bucket owner. For information about locating
	// your canonical user ID see Finding Your Account Canonical User ID. (https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId)
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Owner) SetId(v string) *Owner {
	s.Id = &v
	return s
}

// Contains information about how permissions are configured for the S3 bucket.
type PermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about the account level permissions on the S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions `locationName:"accountLevelPermissions" type:"structure"`

	// Contains information about the bucket level permissions for the S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions `locationName:"bucketLevelPermissions" type:"structure"`
}

// String returns the string representation
func (s PermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionConfiguration) GoString() string {
	return s.String()
}

// SetAccountLevelPermissions sets the AccountLevelPermissions field's value.
func (s *PermissionConfiguration) SetAccountLevelPermissions(v *AccountLevelPermissions) *PermissionConfiguration {
	s.AccountLevelPermissions = v
	return s
}

// SetBucketLevelPermissions sets the BucketLevelPermissions field's value.
func (s *PermissionConfiguration) SetBucketLevelPermissions(v *BucketLevelPermissions) *PermissionConfiguration {
	s.BucketLevelPermissions = v
	return s
}

// Contains information about the PORT_PROBE action described in the finding.
type PortProbeAction struct {
	_ struct{} `type:"structure"`

	// Indicates whether EC2 blocked the port probe to the instance, such as with
	// an ACL.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// A list of objects related to port probe details.
	PortProbeDetails []*PortProbeDetail `locationName:"portProbeDetails" type:"list"`
}

// String returns the string representation
func (s PortProbeAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortProbeAction) GoString() string {
	return s.String()
}

// SetBlocked sets the Blocked field's value.
func (s *PortProbeAction) SetBlocked(v bool) *PortProbeAction {
	s.Blocked = &v
	return s
}

// SetPortProbeDetails sets the PortProbeDetails field's value.
func (s *PortProbeAction) SetPortProbeDetails(v []*PortProbeDetail) *PortProbeAction {
	s.PortProbeDetails = v
	return s
}

// Contains information about the port probe details.
type PortProbeDetail struct {
	_ struct{} `type:"structure"`

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails `locationName:"localIpDetails" type:"structure"`

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`
}

// String returns the string representation
func (s PortProbeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortProbeDetail) GoString() string {
	return s.String()
}

// SetLocalIpDetails sets the LocalIpDetails field's value.
func (s *PortProbeDetail) SetLocalIpDetails(v *LocalIpDetails) *PortProbeDetail {
	s.LocalIpDetails = v
	return s
}

// SetLocalPortDetails sets the LocalPortDetails field's value.
func (s *PortProbeDetail) SetLocalPortDetails(v *LocalPortDetails) *PortProbeDetail {
	s.LocalPortDetails = v
	return s
}

// SetRemoteIpDetails sets the RemoteIpDetails field's value.
func (s *PortProbeDetail) SetRemoteIpDetails(v *RemoteIpDetails) *PortProbeDetail {
	s.RemoteIpDetails = v
	return s
}

// Contains other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {
	_ struct{} `type:"structure"`

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateIpAddressDetails) GoString() string {
	return s.String()
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *PrivateIpAddressDetails) SetPrivateDnsName(v string) *PrivateIpAddressDetails {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *PrivateIpAddressDetails) SetPrivateIpAddress(v string) *PrivateIpAddressDetails {
	s.PrivateIpAddress = &v
	return s
}

// Contains information about the product code for the EC2 instance.
type ProductCode struct {
	_ struct{} `type:"structure"`

	// The product code information.
	Code *string `locationName:"code" type:"string"`

	// The product code type.
	ProductType *string `locationName:"productType" type:"string"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductCode) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ProductCode) SetCode(v string) *ProductCode {
	s.Code = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *ProductCode) SetProductType(v string) *ProductCode {
	s.ProductType = &v
	return s
}

// Describes the public access policies that apply to the S3 bucket.
type PublicAccess struct {
	_ struct{} `type:"structure"`

	// Describes the effective permission on this bucket after factoring all attached
	// policies.
	EffectivePermission *string `locationName:"effectivePermission" type:"string"`

	// Contains information about how permissions are configured for the S3 bucket.
	PermissionConfiguration *PermissionConfiguration `locationName:"permissionConfiguration" type:"structure"`
}

// String returns the string representation
func (s PublicAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccess) GoString() string {
	return s.String()
}

// SetEffectivePermission sets the EffectivePermission field's value.
func (s *PublicAccess) SetEffectivePermission(v string) *PublicAccess {
	s.EffectivePermission = &v
	return s
}

// SetPermissionConfiguration sets the PermissionConfiguration field's value.
func (s *PublicAccess) SetPermissionConfiguration(v *PermissionConfiguration) *PublicAccess {
	s.PermissionConfiguration = v
	return s
}

// Contains information about the remote IP address of the connection.
type RemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// The city information of the remote IP address.
	City *City `locationName:"city" type:"structure"`

	// The country code of the remote IP address.
	Country *Country `locationName:"country" type:"structure"`

	// The location information of the remote IP address.
	GeoLocation *GeoLocation `locationName:"geoLocation" type:"structure"`

	// The IPv4 remote address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// The ISP organization information of the remote IP address.
	Organization *Organization `locationName:"organization" type:"structure"`
}

// String returns the string representation
func (s RemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteIpDetails) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *RemoteIpDetails) SetCity(v *City) *RemoteIpDetails {
	s.City = v
	return s
}

// SetCountry sets the Country field's value.
func (s *RemoteIpDetails) SetCountry(v *Country) *RemoteIpDetails {
	s.Country = v
	return s
}

// SetGeoLocation sets the GeoLocation field's value.
func (s *RemoteIpDetails) SetGeoLocation(v *GeoLocation) *RemoteIpDetails {
	s.GeoLocation = v
	return s
}

// SetIpAddressV4 sets the IpAddressV4 field's value.
func (s *RemoteIpDetails) SetIpAddressV4(v string) *RemoteIpDetails {
	s.IpAddressV4 = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *RemoteIpDetails) SetOrganization(v *Organization) *RemoteIpDetails {
	s.Organization = v
	return s
}

// Contains information about the remote port.
type RemotePortDetails struct {
	_ struct{} `type:"structure"`

	// The port number of the remote connection.
	Port *int64 `locationName:"port" type:"integer"`

	// The port name of the remote connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s RemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemotePortDetails) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *RemotePortDetails) SetPort(v int64) *RemotePortDetails {
	s.Port = &v
	return s
}

// SetPortName sets the PortName field's value.
func (s *RemotePortDetails) SetPortName(v string) *RemotePortDetails {
	s.PortName = &v
	return s
}

// Contains information about the AWS resource associated with the activity
// that prompted GuardDuty to generate a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// The IAM access key details (IAM user information) of a user that engaged
	// in the activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails `locationName:"accessKeyDetails" type:"structure"`

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails `locationName:"instanceDetails" type:"structure"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Contains information on the S3 bucket.
	S3BucketDetails []*S3BucketDetail `locationName:"s3BucketDetails" type:"list"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetAccessKeyDetails sets the AccessKeyDetails field's value.
func (s *Resource) SetAccessKeyDetails(v *AccessKeyDetails) *Resource {
	s.AccessKeyDetails = v
	return s
}

// SetInstanceDetails sets the InstanceDetails field's value.
func (s *Resource) SetInstanceDetails(v *InstanceDetails) *Resource {
	s.InstanceDetails = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Resource) SetResourceType(v string) *Resource {
	s.ResourceType = &v
	return s
}

// SetS3BucketDetails sets the S3BucketDetails field's value.
func (s *Resource) SetS3BucketDetails(v []*S3BucketDetail) *Resource {
	s.S3BucketDetails = v
	return s
}

// Contains information on the S3 bucket.
type S3BucketDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time the bucket was created at.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Describes the server side encryption method used in the S3 bucket.
	DefaultServerSideEncryption *DefaultServerSideEncryption `locationName:"defaultServerSideEncryption" type:"structure"`

	// The name of the S3 bucket.
	Name *string `locationName:"name" type:"string"`

	// The owner of the S3 bucket.
	Owner *Owner `locationName:"owner" type:"structure"`

	// Describes the public access policies that apply to the S3 bucket.
	PublicAccess *PublicAccess `locationName:"publicAccess" type:"structure"`

	// All tags attached to the S3 bucket
	Tags []*Tag `locationName:"tags" type:"list"`

	// Describes whether the bucket is a source or destination bucket.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s S3BucketDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3BucketDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *S3BucketDetail) SetArn(v string) *S3BucketDetail {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *S3BucketDetail) SetCreatedAt(v time.Time) *S3BucketDetail {
	s.CreatedAt = &v
	return s
}

// SetDefaultServerSideEncryption sets the DefaultServerSideEncryption field's value.
func (s *S3BucketDetail) SetDefaultServerSideEncryption(v *DefaultServerSideEncryption) *S3BucketDetail {
	s.DefaultServerSideEncryption = v
	return s
}

// SetName sets the Name field's value.
func (s *S3BucketDetail) SetName(v string) *S3BucketDetail {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *S3BucketDetail) SetOwner(v *Owner) *S3BucketDetail {
	s.Owner = v
	return s
}

// SetPublicAccess sets the PublicAccess field's value.
func (s *S3BucketDetail) SetPublicAccess(v *PublicAccess) *S3BucketDetail {
	s.PublicAccess = v
	return s
}

// SetTags sets the Tags field's value.
func (s *S3BucketDetail) SetTags(v []*Tag) *S3BucketDetail {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *S3BucketDetail) SetType(v string) *S3BucketDetail {
	s.Type = &v
	return s
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfiguration struct {
	_ struct{} `type:"structure"`

	// The status of S3 data event logs as a data source.
	//
	// Enable is a required field
	Enable *bool `locationName:"enable" type:"boolean" required:"true"`
}

// String returns the string representation
func (s S3LogsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3LogsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3LogsConfiguration"}
	if s.Enable == nil {
		invalidParams.Add(request.NewErrParamRequired("Enable"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnable sets the Enable field's value.
func (s *S3LogsConfiguration) SetEnable(v bool) *S3LogsConfiguration {
	s.Enable = &v
	return s
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfigurationResult struct {
	_ struct{} `type:"structure"`

	// A value that describes whether S3 data event logs are automatically enabled
	// for new members of the organization.
	//
	// Status is a required field
	Status *string `locationName:"status" min:"1" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation
func (s S3LogsConfigurationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3LogsConfigurationResult) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *S3LogsConfigurationResult) SetStatus(v string) *S3LogsConfigurationResult {
	s.Status = &v
	return s
}

// Contains information about the security groups associated with the EC2 instance.
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The security group ID of the EC2 instance.
	GroupId *string `locationName:"groupId" type:"string"`

	// The security group name of the EC2 instance.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *SecurityGroup) SetGroupId(v string) *SecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *SecurityGroup) SetGroupName(v string) *SecurityGroup {
	s.GroupName = &v
	return s
}

// Contains additional information about the generated finding.
type Service struct {
	_ struct{} `type:"structure"`

	// Information about the activity that is described in a finding.
	Action *Action `locationName:"action" type:"structure"`

	// Indicates whether this finding is archived.
	Archived *bool `locationName:"archived" type:"boolean"`

	// The total count of the occurrences of this finding type.
	Count *int64 `locationName:"count" type:"integer"`

	// The detector ID for the GuardDuty service.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The first-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string `locationName:"eventFirstSeen" type:"string"`

	// The last-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventLastSeen *string `locationName:"eventLastSeen" type:"string"`

	// An evidence object associated with the service.
	Evidence *Evidence `locationName:"evidence" type:"structure"`

	// The resource role information for this finding.
	ResourceRole *string `locationName:"resourceRole" type:"string"`

	// The name of the AWS service (GuardDuty) that generated a finding.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// Feedback that was submitted about the finding.
	UserFeedback *string `locationName:"userFeedback" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Service) SetAction(v *Action) *Service {
	s.Action = v
	return s
}

// SetArchived sets the Archived field's value.
func (s *Service) SetArchived(v bool) *Service {
	s.Archived = &v
	return s
}

// SetCount sets the Count field's value.
func (s *Service) SetCount(v int64) *Service {
	s.Count = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Service) SetDetectorId(v string) *Service {
	s.DetectorId = &v
	return s
}

// SetEventFirstSeen sets the EventFirstSeen field's value.
func (s *Service) SetEventFirstSeen(v string) *Service {
	s.EventFirstSeen = &v
	return s
}

// SetEventLastSeen sets the EventLastSeen field's value.
func (s *Service) SetEventLastSeen(v string) *Service {
	s.EventLastSeen = &v
	return s
}

// SetEvidence sets the Evidence field's value.
func (s *Service) SetEvidence(v *Evidence) *Service {
	s.Evidence = v
	return s
}

// SetResourceRole sets the ResourceRole field's value.
func (s *Service) SetResourceRole(v string) *Service {
	s.ResourceRole = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Service) SetServiceName(v string) *Service {
	s.ServiceName = &v
	return s
}

// SetUserFeedback sets the UserFeedback field's value.
func (s *Service) SetUserFeedback(v string) *Service {
	s.UserFeedback = &v
	return s
}

// Contains information about the criteria used for sorting findings.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// Represents the finding attribute (for example, accountId) to sort findings
	// by.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The order by which the sorted findings are to be displayed.
	OrderBy *string `locationName:"orderBy" type:"string" enum:"OrderBy"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriteria) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *SortCriteria) SetAttributeName(v string) *SortCriteria {
	s.AttributeName = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortCriteria) SetOrderBy(v string) *SortCriteria {
	s.OrderBy = &v
	return s
}

type StartMonitoringMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs of the GuardDuty member accounts to start monitoring.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector of the GuardDuty administrator account associated
	// with the member accounts to monitor.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMonitoringMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMonitoringMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMonitoringMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *StartMonitoringMembersInput) SetAccountIds(v []*string) *StartMonitoringMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *StartMonitoringMembersInput) SetDetectorId(v string) *StartMonitoringMembersInput {
	s.DetectorId = &v
	return s
}

type StartMonitoringMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain the unprocessed account and a result string
	// that explains why it was unprocessed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s StartMonitoringMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *StartMonitoringMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *StartMonitoringMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type StopMonitoringMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of account IDs for the member accounts to stop monitoring.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// The unique ID of the detector associated with the GuardDuty administrator
	// account that is monitoring member accounts.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMonitoringMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMonitoringMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMonitoringMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMonitoringMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *StopMonitoringMembersInput) SetAccountIds(v []*string) *StopMonitoringMembersInput {
	s.AccountIds = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *StopMonitoringMembersInput) SetDetectorId(v string) *StopMonitoringMembersInput {
	s.DetectorId = &v
	return s
}

type StopMonitoringMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain an accountId for each account that could not
	// be processed, and a result string that indicates why the account was not
	// processed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s StopMonitoringMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopMonitoringMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *StopMonitoringMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *StopMonitoringMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// Contains information about a tag associated with the EC2 instance.
type Tag struct {
	_ struct{} `type:"structure"`

	// The EC2 instance tag key.
	Key *string `locationName:"key" type:"string"`

	// The EC2 instance tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to be added to a resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An instance of a threat intelligence detail that constitutes evidence for
// the finding.
type ThreatIntelligenceDetail struct {
	_ struct{} `type:"structure"`

	// The name of the threat intelligence list that triggered the finding.
	ThreatListName *string `locationName:"threatListName" type:"string"`

	// A list of names of the threats in the threat intelligence list that triggered
	// the finding.
	ThreatNames []*string `locationName:"threatNames" type:"list"`
}

// String returns the string representation
func (s ThreatIntelligenceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThreatIntelligenceDetail) GoString() string {
	return s.String()
}

// SetThreatListName sets the ThreatListName field's value.
func (s *ThreatIntelligenceDetail) SetThreatListName(v string) *ThreatIntelligenceDetail {
	s.ThreatListName = &v
	return s
}

// SetThreatNames sets the ThreatNames field's value.
func (s *ThreatIntelligenceDetail) SetThreatNames(v []*string) *ThreatIntelligenceDetail {
	s.ThreatNames = v
	return s
}

// Contains the total usage with the corresponding currency unit for that value.
type Total struct {
	_ struct{} `type:"structure"`

	// The total usage.
	Amount *string `locationName:"amount" type:"string"`

	// The currency unit that the amount is given in.
	Unit *string `locationName:"unit" type:"string"`
}

// String returns the string representation
func (s Total) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Total) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *Total) SetAmount(v string) *Total {
	s.Amount = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *Total) SetUnit(v string) *Total {
	s.Unit = &v
	return s
}

type UnarchiveFindingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector associated with the findings to unarchive.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The IDs of the findings to unarchive.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`
}

// String returns the string representation
func (s UnarchiveFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnarchiveFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnarchiveFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnarchiveFindingsInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UnarchiveFindingsInput) SetDetectorId(v string) *UnarchiveFindingsInput {
	s.DetectorId = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *UnarchiveFindingsInput) SetFindingIds(v []*string) *UnarchiveFindingsInput {
	s.FindingIds = v
	return s
}

type UnarchiveFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnarchiveFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnarchiveFindingsOutput) GoString() string {
	return s.String()
}

// Contains information about the accounts that weren't processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// A reason why the account hasn't been processed.
	//
	// Result is a required field
	Result *string `locationName:"result" type:"string" required:"true"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UnprocessedAccount) SetAccountId(v string) *UnprocessedAccount {
	s.AccountId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *UnprocessedAccount) SetResult(v string) *UnprocessedAccount {
	s.Result = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDetectorInput struct {
	_ struct{} `type:"structure"`

	// Describes which data sources will be updated.
	DataSources *DataSourceConfigurations `locationName:"dataSources" type:"structure"`

	// The unique ID of the detector to update.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// Specifies whether the detector is enabled or not enabled.
	Enable *bool `locationName:"enable" type:"boolean"`

	// An enum value that specifies how frequently findings are exported, such as
	// to CloudWatch Events.
	FindingPublishingFrequency *string `locationName:"findingPublishingFrequency" type:"string" enum:"FindingPublishingFrequency"`
}

// String returns the string representation
func (s UpdateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DataSources != nil {
		if err := s.DataSources.Validate(); err != nil {
			invalidParams.AddNested("DataSources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSources sets the DataSources field's value.
func (s *UpdateDetectorInput) SetDataSources(v *DataSourceConfigurations) *UpdateDetectorInput {
	s.DataSources = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorInput) SetDetectorId(v string) *UpdateDetectorInput {
	s.DetectorId = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *UpdateDetectorInput) SetEnable(v bool) *UpdateDetectorInput {
	s.Enable = &v
	return s
}

// SetFindingPublishingFrequency sets the FindingPublishingFrequency field's value.
func (s *UpdateDetectorInput) SetFindingPublishingFrequency(v string) *UpdateDetectorInput {
	s.FindingPublishingFrequency = &v
	return s
}

type UpdateDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorOutput) GoString() string {
	return s.String()
}

type UpdateFilterInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action *string `locationName:"action" min:"1" type:"string" enum:"FilterAction"`

	// The description of the filter.
	Description *string `locationName:"description" type:"string"`

	// The unique ID of the detector that specifies the GuardDuty service where
	// you want to update a filter.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the filter.
	//
	// FilterName is a required field
	FilterName *string `location:"uri" locationName:"filterName" type:"string" required:"true"`

	// Represents the criteria to be used in the filter for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank *int64 `locationName:"rank" min:"1" type:"integer"`
}

// String returns the string representation
func (s UpdateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFilterInput"}
	if s.Action != nil && len(*s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.FilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterName"))
	}
	if s.FilterName != nil && len(*s.FilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterName", 1))
	}
	if s.Rank != nil && *s.Rank < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Rank", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateFilterInput) SetAction(v string) *UpdateFilterInput {
	s.Action = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFilterInput) SetDescription(v string) *UpdateFilterInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateFilterInput) SetDetectorId(v string) *UpdateFilterInput {
	s.DetectorId = &v
	return s
}

// SetFilterName sets the FilterName field's value.
func (s *UpdateFilterInput) SetFilterName(v string) *UpdateFilterInput {
	s.FilterName = &v
	return s
}

// SetFindingCriteria sets the FindingCriteria field's value.
func (s *UpdateFilterInput) SetFindingCriteria(v *FindingCriteria) *UpdateFilterInput {
	s.FindingCriteria = v
	return s
}

// SetRank sets the Rank field's value.
func (s *UpdateFilterInput) SetRank(v int64) *UpdateFilterInput {
	s.Rank = &v
	return s
}

type UpdateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFilterOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UpdateFilterOutput) SetName(v string) *UpdateFilterOutput {
	s.Name = &v
	return s
}

type UpdateFindingsFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Additional feedback about the GuardDuty findings.
	Comments *string `locationName:"comments" type:"string"`

	// The ID of the detector associated with the findings to update feedback for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The feedback for the finding.
	//
	// Feedback is a required field
	Feedback *string `locationName:"feedback" type:"string" required:"true" enum:"Feedback"`

	// The IDs of the findings that you want to mark as useful or not useful.
	//
	// FindingIds is a required field
	FindingIds []*string `locationName:"findingIds" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsFeedbackInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Feedback == nil {
		invalidParams.Add(request.NewErrParamRequired("Feedback"))
	}
	if s.FindingIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComments sets the Comments field's value.
func (s *UpdateFindingsFeedbackInput) SetComments(v string) *UpdateFindingsFeedbackInput {
	s.Comments = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateFindingsFeedbackInput) SetDetectorId(v string) *UpdateFindingsFeedbackInput {
	s.DetectorId = &v
	return s
}

// SetFeedback sets the Feedback field's value.
func (s *UpdateFindingsFeedbackInput) SetFeedback(v string) *UpdateFindingsFeedbackInput {
	s.Feedback = &v
	return s
}

// SetFindingIds sets the FindingIds field's value.
func (s *UpdateFindingsFeedbackInput) SetFindingIds(v []*string) *UpdateFindingsFeedbackInput {
	s.FindingIds = v
	return s
}

type UpdateFindingsFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsFeedbackOutput) GoString() string {
	return s.String()
}

type UpdateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The updated Boolean value that specifies whether the IPSet is active or not.
	Activate *bool `locationName:"activate" type:"boolean"`

	// The detectorID that specifies the GuardDuty service whose IPSet you want
	// to update.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The unique ID that specifies the IPSet that you want to update.
	//
	// IpSetId is a required field
	IpSetId *string `location:"uri" locationName:"ipSetId" type:"string" required:"true"`

	// The updated URI of the file that contains the IPSet. For example: https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.
	Location *string `locationName:"location" min:"1" type:"string"`

	// The unique ID that specifies the IPSet that you want to update.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIPSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.IpSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpSetId"))
	}
	if s.IpSetId != nil && len(*s.IpSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpSetId", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *UpdateIPSetInput) SetActivate(v bool) *UpdateIPSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateIPSetInput) SetDetectorId(v string) *UpdateIPSetInput {
	s.DetectorId = &v
	return s
}

// SetIpSetId sets the IpSetId field's value.
func (s *UpdateIPSetInput) SetIpSetId(v string) *UpdateIPSetInput {
	s.IpSetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *UpdateIPSetInput) SetLocation(v string) *UpdateIPSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateIPSetInput) SetName(v string) *UpdateIPSetInput {
	s.Name = &v
	return s
}

type UpdateIPSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetOutput) GoString() string {
	return s.String()
}

type UpdateMemberDetectorsInput struct {
	_ struct{} `type:"structure"`

	// A list of member account IDs to be updated.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// Describes which data sources will be updated.
	DataSources *DataSourceConfigurations `locationName:"dataSources" type:"structure"`

	// The detector ID of the administrator account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMemberDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMemberDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMemberDetectorsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DataSources != nil {
		if err := s.DataSources.Validate(); err != nil {
			invalidParams.AddNested("DataSources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *UpdateMemberDetectorsInput) SetAccountIds(v []*string) *UpdateMemberDetectorsInput {
	s.AccountIds = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *UpdateMemberDetectorsInput) SetDataSources(v *DataSourceConfigurations) *UpdateMemberDetectorsInput {
	s.DataSources = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateMemberDetectorsInput) SetDetectorId(v string) *UpdateMemberDetectorsInput {
	s.DetectorId = &v
	return s
}

type UpdateMemberDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of member account IDs that were unable to be processed along with
	// an explanation for why they were not processed.
	//
	// UnprocessedAccounts is a required field
	UnprocessedAccounts []*UnprocessedAccount `locationName:"unprocessedAccounts" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateMemberDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMemberDetectorsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *UpdateMemberDetectorsOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *UpdateMemberDetectorsOutput {
	s.UnprocessedAccounts = v
	return s
}

type UpdateOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to automatically enable member accounts in the organization.
	//
	// AutoEnable is a required field
	AutoEnable *bool `locationName:"autoEnable" type:"boolean" required:"true"`

	// Describes which data sources will be updated.
	DataSources *OrganizationDataSourceConfigurations `locationName:"dataSources" type:"structure"`

	// The ID of the detector to update the delegated administrator for.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationConfigurationInput"}
	if s.AutoEnable == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoEnable"))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DataSources != nil {
		if err := s.DataSources.Validate(); err != nil {
			invalidParams.AddNested("DataSources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationInput) SetAutoEnable(v bool) *UpdateOrganizationConfigurationInput {
	s.AutoEnable = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *UpdateOrganizationConfigurationInput) SetDataSources(v *OrganizationDataSourceConfigurations) *UpdateOrganizationConfigurationInput {
	s.DataSources = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateOrganizationConfigurationInput) SetDetectorId(v string) *UpdateOrganizationConfigurationInput {
	s.DetectorId = &v
	return s
}

type UpdateOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

type UpdatePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination to update.
	//
	// DestinationId is a required field
	DestinationId *string `location:"uri" locationName:"destinationId" type:"string" required:"true"`

	// A DestinationProperties object that includes the DestinationArn and KmsKeyArn
	// of the publishing destination.
	DestinationProperties *DestinationProperties `locationName:"destinationProperties" type:"structure"`

	// The ID of the detector associated with the publishing destinations to update.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublishingDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePublishingDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePublishingDestinationInput"}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationId sets the DestinationId field's value.
func (s *UpdatePublishingDestinationInput) SetDestinationId(v string) *UpdatePublishingDestinationInput {
	s.DestinationId = &v
	return s
}

// SetDestinationProperties sets the DestinationProperties field's value.
func (s *UpdatePublishingDestinationInput) SetDestinationProperties(v *DestinationProperties) *UpdatePublishingDestinationInput {
	s.DestinationProperties = v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdatePublishingDestinationInput) SetDetectorId(v string) *UpdatePublishingDestinationInput {
	s.DetectorId = &v
	return s
}

type UpdatePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublishingDestinationOutput) GoString() string {
	return s.String()
}

type UpdateThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// The updated Boolean value that specifies whether the ThreateIntelSet is active
	// or not.
	Activate *bool `locationName:"activate" type:"boolean"`

	// The detectorID that specifies the GuardDuty service whose ThreatIntelSet
	// you want to update.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The updated URI of the file that contains the ThreateIntelSet.
	Location *string `locationName:"location" min:"1" type:"string"`

	// The unique ID that specifies the ThreatIntelSet that you want to update.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The unique ID that specifies the ThreatIntelSet that you want to update.
	//
	// ThreatIntelSetId is a required field
	ThreatIntelSetId *string `location:"uri" locationName:"threatIntelSetId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThreatIntelSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThreatIntelSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThreatIntelSetInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ThreatIntelSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThreatIntelSetId"))
	}
	if s.ThreatIntelSetId != nil && len(*s.ThreatIntelSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThreatIntelSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivate sets the Activate field's value.
func (s *UpdateThreatIntelSetInput) SetActivate(v bool) *UpdateThreatIntelSetInput {
	s.Activate = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateThreatIntelSetInput) SetDetectorId(v string) *UpdateThreatIntelSetInput {
	s.DetectorId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *UpdateThreatIntelSetInput) SetLocation(v string) *UpdateThreatIntelSetInput {
	s.Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateThreatIntelSetInput) SetName(v string) *UpdateThreatIntelSetInput {
	s.Name = &v
	return s
}

// SetThreatIntelSetId sets the ThreatIntelSetId field's value.
func (s *UpdateThreatIntelSetInput) SetThreatIntelSetId(v string) *UpdateThreatIntelSetInput {
	s.ThreatIntelSetId = &v
	return s
}

type UpdateThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateThreatIntelSetOutput) GoString() string {
	return s.String()
}

// Contains information on the total of usage based on account IDs.
type UsageAccountResult struct {
	_ struct{} `type:"structure"`

	// The Account ID that generated usage.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// Represents the total of usage for the Account ID.
	Total *Total `locationName:"total" type:"structure"`
}

// String returns the string representation
func (s UsageAccountResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageAccountResult) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UsageAccountResult) SetAccountId(v string) *UsageAccountResult {
	s.AccountId = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *UsageAccountResult) SetTotal(v *Total) *UsageAccountResult {
	s.Total = v
	return s
}

// Contains information about the criteria used to query usage statistics.
type UsageCriteria struct {
	_ struct{} `type:"structure"`

	// The account IDs to aggregate usage statistics from.
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list"`

	// The data sources to aggregate usage statistics from.
	//
	// DataSources is a required field
	DataSources []*string `locationName:"dataSources" type:"list" required:"true"`

	// The resources to aggregate usage statistics from. Only accepts exact resource
	// names.
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s UsageCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UsageCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UsageCriteria"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.DataSources == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSources"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *UsageCriteria) SetAccountIds(v []*string) *UsageCriteria {
	s.AccountIds = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *UsageCriteria) SetDataSources(v []*string) *UsageCriteria {
	s.DataSources = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UsageCriteria) SetResources(v []*string) *UsageCriteria {
	s.Resources = v
	return s
}

// Contains information on the result of usage based on data source type.
type UsageDataSourceResult struct {
	_ struct{} `type:"structure"`

	// The data source type that generated usage.
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// Represents the total of usage for the specified data source.
	Total *Total `locationName:"total" type:"structure"`
}

// String returns the string representation
func (s UsageDataSourceResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageDataSourceResult) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *UsageDataSourceResult) SetDataSource(v string) *UsageDataSourceResult {
	s.DataSource = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *UsageDataSourceResult) SetTotal(v *Total) *UsageDataSourceResult {
	s.Total = v
	return s
}

// Contains information on the sum of usage based on an AWS resource.
type UsageResourceResult struct {
	_ struct{} `type:"structure"`

	// The AWS resource that generated usage.
	Resource *string `locationName:"resource" type:"string"`

	// Represents the sum total of usage for the specified resource type.
	Total *Total `locationName:"total" type:"structure"`
}

// String returns the string representation
func (s UsageResourceResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageResourceResult) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *UsageResourceResult) SetResource(v string) *UsageResourceResult {
	s.Resource = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *UsageResourceResult) SetTotal(v *Total) *UsageResourceResult {
	s.Total = v
	return s
}

// Contains the result of GuardDuty usage. If a UsageStatisticType is provided
// the result for other types will be null.
type UsageStatistics struct {
	_ struct{} `type:"structure"`

	// The usage statistic sum organized by account ID.
	SumByAccount []*UsageAccountResult `locationName:"sumByAccount" type:"list"`

	// The usage statistic sum organized by on data source.
	SumByDataSource []*UsageDataSourceResult `locationName:"sumByDataSource" type:"list"`

	// The usage statistic sum organized by resource.
	SumByResource []*UsageResourceResult `locationName:"sumByResource" type:"list"`

	// Lists the top 50 resources that have generated the most GuardDuty usage,
	// in order from most to least expensive.
	TopResources []*UsageResourceResult `locationName:"topResources" type:"list"`
}

// String returns the string representation
func (s UsageStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageStatistics) GoString() string {
	return s.String()
}

// SetSumByAccount sets the SumByAccount field's value.
func (s *UsageStatistics) SetSumByAccount(v []*UsageAccountResult) *UsageStatistics {
	s.SumByAccount = v
	return s
}

// SetSumByDataSource sets the SumByDataSource field's value.
func (s *UsageStatistics) SetSumByDataSource(v []*UsageDataSourceResult) *UsageStatistics {
	s.SumByDataSource = v
	return s
}

// SetSumByResource sets the SumByResource field's value.
func (s *UsageStatistics) SetSumByResource(v []*UsageResourceResult) *UsageStatistics {
	s.SumByResource = v
	return s
}

// SetTopResources sets the TopResources field's value.
func (s *UsageStatistics) SetTopResources(v []*UsageResourceResult) *UsageStatistics {
	s.TopResources = v
	return s
}

const (
	// AdminStatusEnabled is a AdminStatus enum value
	AdminStatusEnabled = "ENABLED"

	// AdminStatusDisableInProgress is a AdminStatus enum value
	AdminStatusDisableInProgress = "DISABLE_IN_PROGRESS"
)

// AdminStatus_Values returns all elements of the AdminStatus enum
func AdminStatus_Values() []string {
	return []string{
		AdminStatusEnabled,
		AdminStatusDisableInProgress,
	}
}

const (
	// DataSourceFlowLogs is a DataSource enum value
	DataSourceFlowLogs = "FLOW_LOGS"

	// DataSourceCloudTrail is a DataSource enum value
	DataSourceCloudTrail = "CLOUD_TRAIL"

	// DataSourceDnsLogs is a DataSource enum value
	DataSourceDnsLogs = "DNS_LOGS"

	// DataSourceS3Logs is a DataSource enum value
	DataSourceS3Logs = "S3_LOGS"
)

// DataSource_Values returns all elements of the DataSource enum
func DataSource_Values() []string {
	return []string{
		DataSourceFlowLogs,
		DataSourceCloudTrail,
		DataSourceDnsLogs,
		DataSourceS3Logs,
	}
}

const (
	// DataSourceStatusEnabled is a DataSourceStatus enum value
	DataSourceStatusEnabled = "ENABLED"

	// DataSourceStatusDisabled is a DataSourceStatus enum value
	DataSourceStatusDisabled = "DISABLED"
)

// DataSourceStatus_Values returns all elements of the DataSourceStatus enum
func DataSourceStatus_Values() []string {
	return []string{
		DataSourceStatusEnabled,
		DataSourceStatusDisabled,
	}
}

const (
	// DestinationTypeS3 is a DestinationType enum value
	DestinationTypeS3 = "S3"
)

// DestinationType_Values returns all elements of the DestinationType enum
func DestinationType_Values() []string {
	return []string{
		DestinationTypeS3,
	}
}

const (
	// DetectorStatusEnabled is a DetectorStatus enum value
	DetectorStatusEnabled = "ENABLED"

	// DetectorStatusDisabled is a DetectorStatus enum value
	DetectorStatusDisabled = "DISABLED"
)

// DetectorStatus_Values returns all elements of the DetectorStatus enum
func DetectorStatus_Values() []string {
	return []string{
		DetectorStatusEnabled,
		DetectorStatusDisabled,
	}
}

const (
	// FeedbackUseful is a Feedback enum value
	FeedbackUseful = "USEFUL"

	// FeedbackNotUseful is a Feedback enum value
	FeedbackNotUseful = "NOT_USEFUL"
)

// Feedback_Values returns all elements of the Feedback enum
func Feedback_Values() []string {
	return []string{
		FeedbackUseful,
		FeedbackNotUseful,
	}
}

const (
	// FilterActionNoop is a FilterAction enum value
	FilterActionNoop = "NOOP"

	// FilterActionArchive is a FilterAction enum value
	FilterActionArchive = "ARCHIVE"
)

// FilterAction_Values returns all elements of the FilterAction enum
func FilterAction_Values() []string {
	return []string{
		FilterActionNoop,
		FilterActionArchive,
	}
}

const (
	// FindingPublishingFrequencyFifteenMinutes is a FindingPublishingFrequency enum value
	FindingPublishingFrequencyFifteenMinutes = "FIFTEEN_MINUTES"

	// FindingPublishingFrequencyOneHour is a FindingPublishingFrequency enum value
	FindingPublishingFrequencyOneHour = "ONE_HOUR"

	// FindingPublishingFrequencySixHours is a FindingPublishingFrequency enum value
	FindingPublishingFrequencySixHours = "SIX_HOURS"
)

// FindingPublishingFrequency_Values returns all elements of the FindingPublishingFrequency enum
func FindingPublishingFrequency_Values() []string {
	return []string{
		FindingPublishingFrequencyFifteenMinutes,
		FindingPublishingFrequencyOneHour,
		FindingPublishingFrequencySixHours,
	}
}

const (
	// FindingStatisticTypeCountBySeverity is a FindingStatisticType enum value
	FindingStatisticTypeCountBySeverity = "COUNT_BY_SEVERITY"
)

// FindingStatisticType_Values returns all elements of the FindingStatisticType enum
func FindingStatisticType_Values() []string {
	return []string{
		FindingStatisticTypeCountBySeverity,
	}
}

const (
	// IpSetFormatTxt is a IpSetFormat enum value
	IpSetFormatTxt = "TXT"

	// IpSetFormatStix is a IpSetFormat enum value
	IpSetFormatStix = "STIX"

	// IpSetFormatOtxCsv is a IpSetFormat enum value
	IpSetFormatOtxCsv = "OTX_CSV"

	// IpSetFormatAlienVault is a IpSetFormat enum value
	IpSetFormatAlienVault = "ALIEN_VAULT"

	// IpSetFormatProofPoint is a IpSetFormat enum value
	IpSetFormatProofPoint = "PROOF_POINT"

	// IpSetFormatFireEye is a IpSetFormat enum value
	IpSetFormatFireEye = "FIRE_EYE"
)

// IpSetFormat_Values returns all elements of the IpSetFormat enum
func IpSetFormat_Values() []string {
	return []string{
		IpSetFormatTxt,
		IpSetFormatStix,
		IpSetFormatOtxCsv,
		IpSetFormatAlienVault,
		IpSetFormatProofPoint,
		IpSetFormatFireEye,
	}
}

const (
	// IpSetStatusInactive is a IpSetStatus enum value
	IpSetStatusInactive = "INACTIVE"

	// IpSetStatusActivating is a IpSetStatus enum value
	IpSetStatusActivating = "ACTIVATING"

	// IpSetStatusActive is a IpSetStatus enum value
	IpSetStatusActive = "ACTIVE"

	// IpSetStatusDeactivating is a IpSetStatus enum value
	IpSetStatusDeactivating = "DEACTIVATING"

	// IpSetStatusError is a IpSetStatus enum value
	IpSetStatusError = "ERROR"

	// IpSetStatusDeletePending is a IpSetStatus enum value
	IpSetStatusDeletePending = "DELETE_PENDING"

	// IpSetStatusDeleted is a IpSetStatus enum value
	IpSetStatusDeleted = "DELETED"
)

// IpSetStatus_Values returns all elements of the IpSetStatus enum
func IpSetStatus_Values() []string {
	return []string{
		IpSetStatusInactive,
		IpSetStatusActivating,
		IpSetStatusActive,
		IpSetStatusDeactivating,
		IpSetStatusError,
		IpSetStatusDeletePending,
		IpSetStatusDeleted,
	}
}

const (
	// OrderByAsc is a OrderBy enum value
	OrderByAsc = "ASC"

	// OrderByDesc is a OrderBy enum value
	OrderByDesc = "DESC"
)

// OrderBy_Values returns all elements of the OrderBy enum
func OrderBy_Values() []string {
	return []string{
		OrderByAsc,
		OrderByDesc,
	}
}

const (
	// PublishingStatusPendingVerification is a PublishingStatus enum value
	PublishingStatusPendingVerification = "PENDING_VERIFICATION"

	// PublishingStatusPublishing is a PublishingStatus enum value
	PublishingStatusPublishing = "PUBLISHING"

	// PublishingStatusUnableToPublishFixDestinationProperty is a PublishingStatus enum value
	PublishingStatusUnableToPublishFixDestinationProperty = "UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY"

	// PublishingStatusStopped is a PublishingStatus enum value
	PublishingStatusStopped = "STOPPED"
)

// PublishingStatus_Values returns all elements of the PublishingStatus enum
func PublishingStatus_Values() []string {
	return []string{
		PublishingStatusPendingVerification,
		PublishingStatusPublishing,
		PublishingStatusUnableToPublishFixDestinationProperty,
		PublishingStatusStopped,
	}
}

const (
	// ThreatIntelSetFormatTxt is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatTxt = "TXT"

	// ThreatIntelSetFormatStix is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatStix = "STIX"

	// ThreatIntelSetFormatOtxCsv is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatOtxCsv = "OTX_CSV"

	// ThreatIntelSetFormatAlienVault is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatAlienVault = "ALIEN_VAULT"

	// ThreatIntelSetFormatProofPoint is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatProofPoint = "PROOF_POINT"

	// ThreatIntelSetFormatFireEye is a ThreatIntelSetFormat enum value
	ThreatIntelSetFormatFireEye = "FIRE_EYE"
)

// ThreatIntelSetFormat_Values returns all elements of the ThreatIntelSetFormat enum
func ThreatIntelSetFormat_Values() []string {
	return []string{
		ThreatIntelSetFormatTxt,
		ThreatIntelSetFormatStix,
		ThreatIntelSetFormatOtxCsv,
		ThreatIntelSetFormatAlienVault,
		ThreatIntelSetFormatProofPoint,
		ThreatIntelSetFormatFireEye,
	}
}

const (
	// ThreatIntelSetStatusInactive is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusInactive = "INACTIVE"

	// ThreatIntelSetStatusActivating is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusActivating = "ACTIVATING"

	// ThreatIntelSetStatusActive is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusActive = "ACTIVE"

	// ThreatIntelSetStatusDeactivating is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeactivating = "DEACTIVATING"

	// ThreatIntelSetStatusError is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusError = "ERROR"

	// ThreatIntelSetStatusDeletePending is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeletePending = "DELETE_PENDING"

	// ThreatIntelSetStatusDeleted is a ThreatIntelSetStatus enum value
	ThreatIntelSetStatusDeleted = "DELETED"
)

// ThreatIntelSetStatus_Values returns all elements of the ThreatIntelSetStatus enum
func ThreatIntelSetStatus_Values() []string {
	return []string{
		ThreatIntelSetStatusInactive,
		ThreatIntelSetStatusActivating,
		ThreatIntelSetStatusActive,
		ThreatIntelSetStatusDeactivating,
		ThreatIntelSetStatusError,
		ThreatIntelSetStatusDeletePending,
		ThreatIntelSetStatusDeleted,
	}
}

const (
	// UsageStatisticTypeSumByAccount is a UsageStatisticType enum value
	UsageStatisticTypeSumByAccount = "SUM_BY_ACCOUNT"

	// UsageStatisticTypeSumByDataSource is a UsageStatisticType enum value
	UsageStatisticTypeSumByDataSource = "SUM_BY_DATA_SOURCE"

	// UsageStatisticTypeSumByResource is a UsageStatisticType enum value
	UsageStatisticTypeSumByResource = "SUM_BY_RESOURCE"

	// UsageStatisticTypeTopResources is a UsageStatisticType enum value
	UsageStatisticTypeTopResources = "TOP_RESOURCES"
)

// UsageStatisticType_Values returns all elements of the UsageStatisticType enum
func UsageStatisticType_Values() []string {
	return []string{
		UsageStatisticTypeSumByAccount,
		UsageStatisticTypeSumByDataSource,
		UsageStatisticTypeSumByResource,
		UsageStatisticTypeTopResources,
	}
}
