package teslamaxcompute

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserInstance invokes the teslamaxcompute.GetUserInstance API synchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getuserinstance.html
func (client *Client) GetUserInstance(request *GetUserInstanceRequest) (response *GetUserInstanceResponse, err error) {
	response = CreateGetUserInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserInstanceWithChan invokes the teslamaxcompute.GetUserInstance API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getuserinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInstanceWithChan(request *GetUserInstanceRequest) (<-chan *GetUserInstanceResponse, <-chan error) {
	responseChan := make(chan *GetUserInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserInstanceWithCallback invokes the teslamaxcompute.GetUserInstance API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/getuserinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInstanceWithCallback(request *GetUserInstanceRequest, callback func(response *GetUserInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetUserInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserInstanceRequest is the request struct for api GetUserInstance
type GetUserInstanceRequest struct {
	*requests.RpcRequest
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	Region   string           `position:"Query" name:"Region"`
	User     string           `position:"Query" name:"User"`
	Status   string           `position:"Query" name:"Status"`
}

// GetUserInstanceResponse is the response struct for api GetUserInstance
type GetUserInstanceResponse struct {
	*responses.BaseResponse
	Code      int                   `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Data      DataInGetUserInstance `json:"Data" xml:"Data"`
}

// CreateGetUserInstanceRequest creates a request to invoke GetUserInstance API
func CreateGetUserInstanceRequest() (request *GetUserInstanceRequest) {
	request = &GetUserInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("TeslaMaxCompute", "2018-01-04", "GetUserInstance", "teslamaxcompute", "openAPI")
	return
}

// CreateGetUserInstanceResponse creates a response to parse from GetUserInstance response
func CreateGetUserInstanceResponse() (response *GetUserInstanceResponse) {
	response = &GetUserInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
