package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApp invokes the retailcloud.ListApp API synchronously
func (client *Client) ListApp(request *ListAppRequest) (response *ListAppResponse, err error) {
	response = CreateListAppResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppWithChan invokes the retailcloud.ListApp API asynchronously
func (client *Client) ListAppWithChan(request *ListAppRequest) (<-chan *ListAppResponse, <-chan error) {
	responseChan := make(chan *ListAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppWithCallback invokes the retailcloud.ListApp API asynchronously
func (client *Client) ListAppWithCallback(request *ListAppRequest, callback func(response *ListAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppResponse
		var err error
		defer close(result)
		response, err = client.ListApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppRequest is the request struct for api ListApp
type ListAppRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListAppResponse is the response struct for api ListApp
type ListAppResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Code       int         `json:"Code" xml:"Code"`
	ErrorMsg   string      `json:"ErrorMsg" xml:"ErrorMsg"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	Data       []AppDetail `json:"Data" xml:"Data"`
}

// CreateListAppRequest creates a request to invoke ListApp API
func CreateListAppRequest() (request *ListAppRequest) {
	request = &ListAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ListApp", "", "")
	request.Method = requests.GET
	return
}

// CreateListAppResponse creates a response to parse from ListApp response
func CreateListAppResponse() (response *ListAppResponse) {
	response = &ListAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
