package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceSyncScan invokes the green.VoiceSyncScan API synchronously
func (client *Client) VoiceSyncScan(request *VoiceSyncScanRequest) (response *VoiceSyncScanResponse, err error) {
	response = CreateVoiceSyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceSyncScanWithChan invokes the green.VoiceSyncScan API asynchronously
func (client *Client) VoiceSyncScanWithChan(request *VoiceSyncScanRequest) (<-chan *VoiceSyncScanResponse, <-chan error) {
	responseChan := make(chan *VoiceSyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceSyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceSyncScanWithCallback invokes the green.VoiceSyncScan API asynchronously
func (client *Client) VoiceSyncScanWithCallback(request *VoiceSyncScanRequest, callback func(response *VoiceSyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceSyncScanResponse
		var err error
		defer close(result)
		response, err = client.VoiceSyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceSyncScanRequest is the request struct for api VoiceSyncScan
type VoiceSyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceSyncScanResponse is the response struct for api VoiceSyncScan
type VoiceSyncScanResponse struct {
	*responses.BaseResponse
}

// CreateVoiceSyncScanRequest creates a request to invoke VoiceSyncScan API
func CreateVoiceSyncScanRequest() (request *VoiceSyncScanRequest) {
	request = &VoiceSyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceSyncScan", "/green/voice/syncscan", "", "")
	request.Method = requests.POST
	return
}

// CreateVoiceSyncScanResponse creates a response to parse from VoiceSyncScan response
func CreateVoiceSyncScanResponse() (response *VoiceSyncScanResponse) {
	response = &VoiceSyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
