package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHealthMonitorLogs invokes the ehpc.GetHealthMonitorLogs API synchronously
func (client *Client) GetHealthMonitorLogs(request *GetHealthMonitorLogsRequest) (response *GetHealthMonitorLogsResponse, err error) {
	response = CreateGetHealthMonitorLogsResponse()
	err = client.DoAction(request, response)
	return
}

// GetHealthMonitorLogsWithChan invokes the ehpc.GetHealthMonitorLogs API asynchronously
func (client *Client) GetHealthMonitorLogsWithChan(request *GetHealthMonitorLogsRequest) (<-chan *GetHealthMonitorLogsResponse, <-chan error) {
	responseChan := make(chan *GetHealthMonitorLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHealthMonitorLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHealthMonitorLogsWithCallback invokes the ehpc.GetHealthMonitorLogs API asynchronously
func (client *Client) GetHealthMonitorLogsWithCallback(request *GetHealthMonitorLogsRequest, callback func(response *GetHealthMonitorLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHealthMonitorLogsResponse
		var err error
		defer close(result)
		response, err = client.GetHealthMonitorLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHealthMonitorLogsRequest is the request struct for api GetHealthMonitorLogs
type GetHealthMonitorLogsRequest struct {
	*requests.RpcRequest
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	ClusterId     string           `position:"Query" name:"ClusterId"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	EnableReverse requests.Boolean `position:"Query" name:"EnableReverse"`
	Filter        string           `position:"Query" name:"Filter"`
}

// GetHealthMonitorLogsResponse is the response struct for api GetHealthMonitorLogs
type GetHealthMonitorLogsResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	LogInfo   LogInfoInGetHealthMonitorLogs `json:"LogInfo" xml:"LogInfo"`
}

// CreateGetHealthMonitorLogsRequest creates a request to invoke GetHealthMonitorLogs API
func CreateGetHealthMonitorLogsRequest() (request *GetHealthMonitorLogsRequest) {
	request = &GetHealthMonitorLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetHealthMonitorLogs", "", "")
	request.Method = requests.GET
	return
}

// CreateGetHealthMonitorLogsResponse creates a response to parse from GetHealthMonitorLogs response
func CreateGetHealthMonitorLogsResponse() (response *GetHealthMonitorLogsResponse) {
	response = &GetHealthMonitorLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
