package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImagePipelines invokes the ecs.DescribeImagePipelines API synchronously
func (client *Client) DescribeImagePipelines(request *DescribeImagePipelinesRequest) (response *DescribeImagePipelinesResponse, err error) {
	response = CreateDescribeImagePipelinesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImagePipelinesWithChan invokes the ecs.DescribeImagePipelines API asynchronously
func (client *Client) DescribeImagePipelinesWithChan(request *DescribeImagePipelinesRequest) (<-chan *DescribeImagePipelinesResponse, <-chan error) {
	responseChan := make(chan *DescribeImagePipelinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImagePipelines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImagePipelinesWithCallback invokes the ecs.DescribeImagePipelines API asynchronously
func (client *Client) DescribeImagePipelinesWithCallback(request *DescribeImagePipelinesRequest, callback func(response *DescribeImagePipelinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImagePipelinesResponse
		var err error
		defer close(result)
		response, err = client.DescribeImagePipelines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImagePipelinesRequest is the request struct for api DescribeImagePipelines
type DescribeImagePipelinesRequest struct {
	*requests.RpcRequest
	ImagePipelineId      *[]string                    `position:"Query" name:"ImagePipelineId"  type:"Repeated"`
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string                       `position:"Query" name:"ResourceGroupId"`
	NextToken            string                       `position:"Query" name:"NextToken"`
	Tag                  *[]DescribeImagePipelinesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                       `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer             `position:"Query" name:"OwnerId"`
	Name                 string                       `position:"Query" name:"Name"`
	MaxResults           requests.Integer             `position:"Query" name:"MaxResults"`
}

// DescribeImagePipelinesTag is a repeated param struct in DescribeImagePipelinesRequest
type DescribeImagePipelinesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeImagePipelinesResponse is the response struct for api DescribeImagePipelines
type DescribeImagePipelinesResponse struct {
	*responses.BaseResponse
	NextToken     string        `json:"NextToken" xml:"NextToken"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	MaxResults    int           `json:"MaxResults" xml:"MaxResults"`
	ImagePipeline ImagePipeline `json:"ImagePipeline" xml:"ImagePipeline"`
}

// CreateDescribeImagePipelinesRequest creates a request to invoke DescribeImagePipelines API
func CreateDescribeImagePipelinesRequest() (request *DescribeImagePipelinesRequest) {
	request = &DescribeImagePipelinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeImagePipelines", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImagePipelinesResponse creates a response to parse from DescribeImagePipelines response
func CreateDescribeImagePipelinesResponse() (response *DescribeImagePipelinesResponse) {
	response = &DescribeImagePipelinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
