package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenDomainSlsConfig invokes the ddoscoo.OpenDomainSlsConfig API synchronously
func (client *Client) OpenDomainSlsConfig(request *OpenDomainSlsConfigRequest) (response *OpenDomainSlsConfigResponse, err error) {
	response = CreateOpenDomainSlsConfigResponse()
	err = client.DoAction(request, response)
	return
}

// OpenDomainSlsConfigWithChan invokes the ddoscoo.OpenDomainSlsConfig API asynchronously
func (client *Client) OpenDomainSlsConfigWithChan(request *OpenDomainSlsConfigRequest) (<-chan *OpenDomainSlsConfigResponse, <-chan error) {
	responseChan := make(chan *OpenDomainSlsConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenDomainSlsConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenDomainSlsConfigWithCallback invokes the ddoscoo.OpenDomainSlsConfig API asynchronously
func (client *Client) OpenDomainSlsConfigWithCallback(request *OpenDomainSlsConfigRequest, callback func(response *OpenDomainSlsConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenDomainSlsConfigResponse
		var err error
		defer close(result)
		response, err = client.OpenDomainSlsConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenDomainSlsConfigRequest is the request struct for api OpenDomainSlsConfig
type OpenDomainSlsConfigRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Lang            string `position:"Query" name:"Lang"`
}

// OpenDomainSlsConfigResponse is the response struct for api OpenDomainSlsConfig
type OpenDomainSlsConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenDomainSlsConfigRequest creates a request to invoke OpenDomainSlsConfig API
func CreateOpenDomainSlsConfigRequest() (request *OpenDomainSlsConfigRequest) {
	request = &OpenDomainSlsConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "OpenDomainSlsConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenDomainSlsConfigResponse creates a response to parse from OpenDomainSlsConfig response
func CreateOpenDomainSlsConfigResponse() (response *OpenDomainSlsConfigResponse) {
	response = &OpenDomainSlsConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
