package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDcdnCertificateSigningRequest invokes the dcdn.CreateDcdnCertificateSigningRequest API synchronously
func (client *Client) CreateDcdnCertificateSigningRequest(request *CreateDcdnCertificateSigningRequestRequest) (response *CreateDcdnCertificateSigningRequestResponse, err error) {
	response = CreateCreateDcdnCertificateSigningRequestResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDcdnCertificateSigningRequestWithChan invokes the dcdn.CreateDcdnCertificateSigningRequest API asynchronously
func (client *Client) CreateDcdnCertificateSigningRequestWithChan(request *CreateDcdnCertificateSigningRequestRequest) (<-chan *CreateDcdnCertificateSigningRequestResponse, <-chan error) {
	responseChan := make(chan *CreateDcdnCertificateSigningRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDcdnCertificateSigningRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDcdnCertificateSigningRequestWithCallback invokes the dcdn.CreateDcdnCertificateSigningRequest API asynchronously
func (client *Client) CreateDcdnCertificateSigningRequestWithCallback(request *CreateDcdnCertificateSigningRequestRequest, callback func(response *CreateDcdnCertificateSigningRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDcdnCertificateSigningRequestResponse
		var err error
		defer close(result)
		response, err = client.CreateDcdnCertificateSigningRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDcdnCertificateSigningRequestRequest is the request struct for api CreateDcdnCertificateSigningRequest
type CreateDcdnCertificateSigningRequestRequest struct {
	*requests.RpcRequest
	Country          string           `position:"Query" name:"Country"`
	City             string           `position:"Query" name:"City"`
	CommonName       string           `position:"Query" name:"CommonName"`
	State            string           `position:"Query" name:"State"`
	Email            string           `position:"Query" name:"Email"`
	SANs             string           `position:"Query" name:"SANs"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	Organization     string           `position:"Query" name:"Organization"`
	OrganizationUnit string           `position:"Query" name:"OrganizationUnit"`
}

// CreateDcdnCertificateSigningRequestResponse is the response struct for api CreateDcdnCertificateSigningRequest
type CreateDcdnCertificateSigningRequestResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	CommonName string `json:"CommonName" xml:"CommonName"`
	Csr        string `json:"Csr" xml:"Csr"`
	PubMd5     string `json:"PubMd5" xml:"PubMd5"`
}

// CreateCreateDcdnCertificateSigningRequestRequest creates a request to invoke CreateDcdnCertificateSigningRequest API
func CreateCreateDcdnCertificateSigningRequestRequest() (request *CreateDcdnCertificateSigningRequestRequest) {
	request = &CreateDcdnCertificateSigningRequestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "CreateDcdnCertificateSigningRequest", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDcdnCertificateSigningRequestResponse creates a response to parse from CreateDcdnCertificateSigningRequest response
func CreateCreateDcdnCertificateSigningRequestResponse() (response *CreateDcdnCertificateSigningRequestResponse) {
	response = &CreateDcdnCertificateSigningRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
