package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDnsCacheDomainRemark invokes the alidns.UpdateDnsCacheDomainRemark API synchronously
func (client *Client) UpdateDnsCacheDomainRemark(request *UpdateDnsCacheDomainRemarkRequest) (response *UpdateDnsCacheDomainRemarkResponse, err error) {
	response = CreateUpdateDnsCacheDomainRemarkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDnsCacheDomainRemarkWithChan invokes the alidns.UpdateDnsCacheDomainRemark API asynchronously
func (client *Client) UpdateDnsCacheDomainRemarkWithChan(request *UpdateDnsCacheDomainRemarkRequest) (<-chan *UpdateDnsCacheDomainRemarkResponse, <-chan error) {
	responseChan := make(chan *UpdateDnsCacheDomainRemarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDnsCacheDomainRemark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDnsCacheDomainRemarkWithCallback invokes the alidns.UpdateDnsCacheDomainRemark API asynchronously
func (client *Client) UpdateDnsCacheDomainRemarkWithCallback(request *UpdateDnsCacheDomainRemarkRequest, callback func(response *UpdateDnsCacheDomainRemarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDnsCacheDomainRemarkResponse
		var err error
		defer close(result)
		response, err = client.UpdateDnsCacheDomainRemark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDnsCacheDomainRemarkRequest is the request struct for api UpdateDnsCacheDomainRemark
type UpdateDnsCacheDomainRemarkRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	Remark       string `position:"Query" name:"Remark"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// UpdateDnsCacheDomainRemarkResponse is the response struct for api UpdateDnsCacheDomainRemark
type UpdateDnsCacheDomainRemarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDnsCacheDomainRemarkRequest creates a request to invoke UpdateDnsCacheDomainRemark API
func CreateUpdateDnsCacheDomainRemarkRequest() (request *UpdateDnsCacheDomainRemarkRequest) {
	request = &UpdateDnsCacheDomainRemarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "UpdateDnsCacheDomainRemark", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDnsCacheDomainRemarkResponse creates a response to parse from UpdateDnsCacheDomainRemark response
func CreateUpdateDnsCacheDomainRemarkResponse() (response *UpdateDnsCacheDomainRemarkResponse) {
	response = &UpdateDnsCacheDomainRemarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
