package storagepool

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// OperationalStatus enumerates the values for operational status.
type OperationalStatus string

const (
	// Healthy ...
	Healthy OperationalStatus = "Healthy"
	// Invalid ...
	Invalid OperationalStatus = "Invalid"
	// Unhealthy ...
	Unhealthy OperationalStatus = "Unhealthy"
	// Unknown ...
	Unknown OperationalStatus = "Unknown"
)

// PossibleOperationalStatusValues returns an array of possible values for the OperationalStatus const type.
func PossibleOperationalStatusValues() []OperationalStatus {
	return []OperationalStatus{Healthy, Invalid, Unhealthy, Unknown}
}

// ProvisioningStates enumerates the values for provisioning states.
type ProvisioningStates string

const (
	// ProvisioningStatesCanceled ...
	ProvisioningStatesCanceled ProvisioningStates = "Canceled"
	// ProvisioningStatesCreating ...
	ProvisioningStatesCreating ProvisioningStates = "Creating"
	// ProvisioningStatesDeleting ...
	ProvisioningStatesDeleting ProvisioningStates = "Deleting"
	// ProvisioningStatesFailed ...
	ProvisioningStatesFailed ProvisioningStates = "Failed"
	// ProvisioningStatesInvalid ...
	ProvisioningStatesInvalid ProvisioningStates = "Invalid"
	// ProvisioningStatesPending ...
	ProvisioningStatesPending ProvisioningStates = "Pending"
	// ProvisioningStatesSucceeded ...
	ProvisioningStatesSucceeded ProvisioningStates = "Succeeded"
	// ProvisioningStatesUpdating ...
	ProvisioningStatesUpdating ProvisioningStates = "Updating"
)

// PossibleProvisioningStatesValues returns an array of possible values for the ProvisioningStates const type.
func PossibleProvisioningStatesValues() []ProvisioningStates {
	return []ProvisioningStates{ProvisioningStatesCanceled, ProvisioningStatesCreating, ProvisioningStatesDeleting, ProvisioningStatesFailed, ProvisioningStatesInvalid, ProvisioningStatesPending, ProvisioningStatesSucceeded, ProvisioningStatesUpdating}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Basic ...
	Basic SkuTier = "Basic"
	// Free ...
	Free SkuTier = "Free"
	// Premium ...
	Premium SkuTier = "Premium"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Basic, Free, Premium, Standard}
}
