#!/bin/sh

# This test makes sure that outputs created using the 'sh' output format can
# be parsed using the 'dotenv' input format.

set -e
set -u
set -x

OUT="$("$RQ" -o sh '{"foo": 10, "hello": "world"}' | "$RQ" -i dotenv)"

EXPECT="$(printf '{\n\t"foo": "10",\n\t"hello": "world"\n}')"

if [ "$OUT" != "$EXPECT" ] ; then
	printf "==== expected output\n%s\n==== actual output\n%s\n================\n" "$EXPECT" "$OUT"
	exit 1
fi
