// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/volume.proto

package gkebackuppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Identifies the format used for the volume backup.
type VolumeBackup_VolumeBackupFormat int32

const (
	// Default value, not specified.
	VolumeBackup_VOLUME_BACKUP_FORMAT_UNSPECIFIED VolumeBackup_VolumeBackupFormat = 0
	// Compute Engine Persistent Disk snapshot based volume backup.
	VolumeBackup_GCE_PERSISTENT_DISK VolumeBackup_VolumeBackupFormat = 1
)

// Enum value maps for VolumeBackup_VolumeBackupFormat.
var (
	VolumeBackup_VolumeBackupFormat_name = map[int32]string{
		0: "VOLUME_BACKUP_FORMAT_UNSPECIFIED",
		1: "GCE_PERSISTENT_DISK",
	}
	VolumeBackup_VolumeBackupFormat_value = map[string]int32{
		"VOLUME_BACKUP_FORMAT_UNSPECIFIED": 0,
		"GCE_PERSISTENT_DISK":              1,
	}
)

func (x VolumeBackup_VolumeBackupFormat) Enum() *VolumeBackup_VolumeBackupFormat {
	p := new(VolumeBackup_VolumeBackupFormat)
	*p = x
	return p
}

func (x VolumeBackup_VolumeBackupFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeBackup_VolumeBackupFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_volume_proto_enumTypes[0].Descriptor()
}

func (VolumeBackup_VolumeBackupFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_volume_proto_enumTypes[0]
}

func (x VolumeBackup_VolumeBackupFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeBackup_VolumeBackupFormat.Descriptor instead.
func (VolumeBackup_VolumeBackupFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{0, 0}
}

// The current state of a VolumeBackup
type VolumeBackup_State int32

const (
	// This is an illegal state and should not be encountered.
	VolumeBackup_STATE_UNSPECIFIED VolumeBackup_State = 0
	// A volume for the backup was identified and backup process is about to
	// start.
	VolumeBackup_CREATING VolumeBackup_State = 1
	// The volume backup operation has begun and is in the initial "snapshot"
	// phase of the process. Any defined ProtectedApplication "pre" hooks will
	// be executed before entering this state and "post" hooks will be executed
	// upon leaving this state.
	VolumeBackup_SNAPSHOTTING VolumeBackup_State = 2
	// The snapshot phase of the volume backup operation has completed and
	// the snapshot is now being uploaded to backup storage.
	VolumeBackup_UPLOADING VolumeBackup_State = 3
	// The volume backup operation has completed successfully.
	VolumeBackup_SUCCEEDED VolumeBackup_State = 4
	// The volume backup operation has failed.
	VolumeBackup_FAILED VolumeBackup_State = 5
	// This VolumeBackup resource (and its associated artifacts) is in the
	// process of being deleted.
	VolumeBackup_DELETING VolumeBackup_State = 6
)

// Enum value maps for VolumeBackup_State.
var (
	VolumeBackup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "SNAPSHOTTING",
		3: "UPLOADING",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "DELETING",
	}
	VolumeBackup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"SNAPSHOTTING":      2,
		"UPLOADING":         3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"DELETING":          6,
	}
)

func (x VolumeBackup_State) Enum() *VolumeBackup_State {
	p := new(VolumeBackup_State)
	*p = x
	return p
}

func (x VolumeBackup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeBackup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_volume_proto_enumTypes[1].Descriptor()
}

func (VolumeBackup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_volume_proto_enumTypes[1]
}

func (x VolumeBackup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeBackup_State.Descriptor instead.
func (VolumeBackup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{0, 1}
}

// Supported volume types.
type VolumeRestore_VolumeType int32

const (
	// Default
	VolumeRestore_VOLUME_TYPE_UNSPECIFIED VolumeRestore_VolumeType = 0
	// Compute Engine Persistent Disk volume
	VolumeRestore_GCE_PERSISTENT_DISK VolumeRestore_VolumeType = 1
)

// Enum value maps for VolumeRestore_VolumeType.
var (
	VolumeRestore_VolumeType_name = map[int32]string{
		0: "VOLUME_TYPE_UNSPECIFIED",
		1: "GCE_PERSISTENT_DISK",
	}
	VolumeRestore_VolumeType_value = map[string]int32{
		"VOLUME_TYPE_UNSPECIFIED": 0,
		"GCE_PERSISTENT_DISK":     1,
	}
)

func (x VolumeRestore_VolumeType) Enum() *VolumeRestore_VolumeType {
	p := new(VolumeRestore_VolumeType)
	*p = x
	return p
}

func (x VolumeRestore_VolumeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeRestore_VolumeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_volume_proto_enumTypes[2].Descriptor()
}

func (VolumeRestore_VolumeType) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_volume_proto_enumTypes[2]
}

func (x VolumeRestore_VolumeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeRestore_VolumeType.Descriptor instead.
func (VolumeRestore_VolumeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{1, 0}
}

// The current state of a VolumeRestore
type VolumeRestore_State int32

const (
	// This is an illegal state and should not be encountered.
	VolumeRestore_STATE_UNSPECIFIED VolumeRestore_State = 0
	// A volume for the restore was identified and restore process is about to
	// start.
	VolumeRestore_CREATING VolumeRestore_State = 1
	// The volume is currently being restored.
	VolumeRestore_RESTORING VolumeRestore_State = 2
	// The volume has been successfully restored.
	VolumeRestore_SUCCEEDED VolumeRestore_State = 3
	// The volume restoration process failed.
	VolumeRestore_FAILED VolumeRestore_State = 4
	// This VolumeRestore resource is in the process of being deleted.
	VolumeRestore_DELETING VolumeRestore_State = 5
)

// Enum value maps for VolumeRestore_State.
var (
	VolumeRestore_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "RESTORING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "DELETING",
	}
	VolumeRestore_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"RESTORING":         2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"DELETING":          5,
	}
)

func (x VolumeRestore_State) Enum() *VolumeRestore_State {
	p := new(VolumeRestore_State)
	*p = x
	return p
}

func (x VolumeRestore_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeRestore_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_volume_proto_enumTypes[3].Descriptor()
}

func (VolumeRestore_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_volume_proto_enumTypes[3]
}

func (x VolumeRestore_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeRestore_State.Descriptor instead.
func (VolumeRestore_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{1, 1}
}

// Represents the backup of a specific persistent volume as a component of a
// Backup - both the record of the operation and a pointer to the underlying
// storage-specific artifacts.
type VolumeBackup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the VolumeBackup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this VolumeBackup resource was
	// created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this VolumeBackup resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. A reference to the source Kubernetes PVC from which this
	// VolumeBackup was created.
	SourcePvc *NamespacedName `protobuf:"bytes,5,opt,name=source_pvc,json=sourcePvc,proto3" json:"source_pvc,omitempty"`
	// Output only. A storage system-specific opaque handle to the underlying
	// volume backup.
	VolumeBackupHandle string `protobuf:"bytes,6,opt,name=volume_backup_handle,json=volumeBackupHandle,proto3" json:"volume_backup_handle,omitempty"`
	// Output only. The format used for the volume backup.
	Format VolumeBackup_VolumeBackupFormat `protobuf:"varint,7,opt,name=format,proto3,enum=google.cloud.gkebackup.v1.VolumeBackup_VolumeBackupFormat" json:"format,omitempty"`
	// Output only. The aggregate size of the underlying artifacts associated with
	// this VolumeBackup in the backup storage. This may change over time when
	// multiple backups of the same volume share the same backup storage
	// location. In particular, this is likely to increase in size when
	// the immediately preceding backup of the same volume is deleted.
	StorageBytes int64 `protobuf:"varint,8,opt,name=storage_bytes,json=storageBytes,proto3" json:"storage_bytes,omitempty"`
	// Output only. The minimum size of the disk to which this VolumeBackup can be
	// restored.
	DiskSizeBytes int64 `protobuf:"varint,9,opt,name=disk_size_bytes,json=diskSizeBytes,proto3" json:"disk_size_bytes,omitempty"`
	// Output only. The timestamp when the associated underlying volume backup
	// operation completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. The current state of this VolumeBackup.
	State VolumeBackup_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.VolumeBackup_State" json:"state,omitempty"`
	// Output only. A human readable message explaining why the VolumeBackup is in
	// its current state.
	StateMessage string `protobuf:"bytes,12,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a volume backup from overwriting each
	// other. It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform volume backup updates in order to avoid
	// race conditions.
	Etag string `protobuf:"bytes,13,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *VolumeBackup) Reset() {
	*x = VolumeBackup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_volume_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeBackup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeBackup) ProtoMessage() {}

func (x *VolumeBackup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_volume_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeBackup.ProtoReflect.Descriptor instead.
func (*VolumeBackup) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{0}
}

func (x *VolumeBackup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VolumeBackup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *VolumeBackup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VolumeBackup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VolumeBackup) GetSourcePvc() *NamespacedName {
	if x != nil {
		return x.SourcePvc
	}
	return nil
}

func (x *VolumeBackup) GetVolumeBackupHandle() string {
	if x != nil {
		return x.VolumeBackupHandle
	}
	return ""
}

func (x *VolumeBackup) GetFormat() VolumeBackup_VolumeBackupFormat {
	if x != nil {
		return x.Format
	}
	return VolumeBackup_VOLUME_BACKUP_FORMAT_UNSPECIFIED
}

func (x *VolumeBackup) GetStorageBytes() int64 {
	if x != nil {
		return x.StorageBytes
	}
	return 0
}

func (x *VolumeBackup) GetDiskSizeBytes() int64 {
	if x != nil {
		return x.DiskSizeBytes
	}
	return 0
}

func (x *VolumeBackup) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *VolumeBackup) GetState() VolumeBackup_State {
	if x != nil {
		return x.State
	}
	return VolumeBackup_STATE_UNSPECIFIED
}

func (x *VolumeBackup) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *VolumeBackup) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Represents the operation of restoring a volume from a VolumeBackup.
type VolumeRestore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Full name of the VolumeRestore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this VolumeRestore resource was
	// created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this VolumeRestore resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The full name of the VolumeBackup from which the volume will
	// be restored. Format:
	// `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`.
	VolumeBackup string `protobuf:"bytes,5,opt,name=volume_backup,json=volumeBackup,proto3" json:"volume_backup,omitempty"`
	// Output only. The reference to the target Kubernetes PVC to be restored.
	TargetPvc *NamespacedName `protobuf:"bytes,6,opt,name=target_pvc,json=targetPvc,proto3" json:"target_pvc,omitempty"`
	// Output only. A storage system-specific opaque handler to the underlying
	// volume created for the target PVC from the volume backup.
	VolumeHandle string `protobuf:"bytes,7,opt,name=volume_handle,json=volumeHandle,proto3" json:"volume_handle,omitempty"`
	// Output only. The type of volume provisioned
	VolumeType VolumeRestore_VolumeType `protobuf:"varint,8,opt,name=volume_type,json=volumeType,proto3,enum=google.cloud.gkebackup.v1.VolumeRestore_VolumeType" json:"volume_type,omitempty"`
	// Output only. The timestamp when the associated underlying volume
	// restoration completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. The current state of this VolumeRestore.
	State VolumeRestore_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.VolumeRestore_State" json:"state,omitempty"`
	// Output only. A human readable message explaining why the VolumeRestore is
	// in its current state.
	StateMessage string `protobuf:"bytes,11,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a volume restore from overwriting each
	// other. It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform volume restore updates in order to avoid
	// race conditions.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *VolumeRestore) Reset() {
	*x = VolumeRestore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_volume_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeRestore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeRestore) ProtoMessage() {}

func (x *VolumeRestore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_volume_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeRestore.ProtoReflect.Descriptor instead.
func (*VolumeRestore) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP(), []int{1}
}

func (x *VolumeRestore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VolumeRestore) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *VolumeRestore) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VolumeRestore) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VolumeRestore) GetVolumeBackup() string {
	if x != nil {
		return x.VolumeBackup
	}
	return ""
}

func (x *VolumeRestore) GetTargetPvc() *NamespacedName {
	if x != nil {
		return x.TargetPvc
	}
	return nil
}

func (x *VolumeRestore) GetVolumeHandle() string {
	if x != nil {
		return x.VolumeHandle
	}
	return ""
}

func (x *VolumeRestore) GetVolumeType() VolumeRestore_VolumeType {
	if x != nil {
		return x.VolumeType
	}
	return VolumeRestore_VOLUME_TYPE_UNSPECIFIED
}

func (x *VolumeRestore) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *VolumeRestore) GetState() VolumeRestore_State {
	if x != nil {
		return x.State
	}
	return VolumeRestore_STATE_UNSPECIFIED
}

func (x *VolumeRestore) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *VolumeRestore) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

var File_google_cloud_gkebackup_v1_volume_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_volume_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb8, 0x08, 0x0a, 0x0c, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a,
	0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x76, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x76, 0x63, 0x12, 0x35, 0x0a, 0x14,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x12, 0x57, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x53, 0x0a, 0x12, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x20,
	0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x46, 0x4f,
	0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x43, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53,
	0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x10, 0x01, 0x22, 0x76, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4e, 0x41,
	0x50, 0x53, 0x48, 0x4f, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x55,
	0x50, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x06, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x25, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x12, 0x70, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x7d, 0x22, 0xe6, 0x07, 0x0a, 0x0d, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x4d, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x76,
	0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x76, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x59, 0x0a, 0x0b,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x42, 0x0a, 0x0a, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x56, 0x4f, 0x4c,
	0x55, 0x4d, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x47, 0x43, 0x45, 0x5f, 0x50, 0x45,
	0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x10, 0x01, 0x22,
	0x64, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a, 0xa4, 0x01, 0xea, 0x41, 0xa0, 0x01, 0x0a, 0x26, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x76, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x42, 0xc2, 0x01, 0x0a,
	0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0b,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_volume_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_volume_proto_rawDescData = file_google_cloud_gkebackup_v1_volume_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_volume_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_volume_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_volume_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_volume_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_volume_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_volume_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_gkebackup_v1_volume_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_gkebackup_v1_volume_proto_goTypes = []any{
	(VolumeBackup_VolumeBackupFormat)(0), // 0: google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat
	(VolumeBackup_State)(0),              // 1: google.cloud.gkebackup.v1.VolumeBackup.State
	(VolumeRestore_VolumeType)(0),        // 2: google.cloud.gkebackup.v1.VolumeRestore.VolumeType
	(VolumeRestore_State)(0),             // 3: google.cloud.gkebackup.v1.VolumeRestore.State
	(*VolumeBackup)(nil),                 // 4: google.cloud.gkebackup.v1.VolumeBackup
	(*VolumeRestore)(nil),                // 5: google.cloud.gkebackup.v1.VolumeRestore
	(*timestamppb.Timestamp)(nil),        // 6: google.protobuf.Timestamp
	(*NamespacedName)(nil),               // 7: google.cloud.gkebackup.v1.NamespacedName
}
var file_google_cloud_gkebackup_v1_volume_proto_depIdxs = []int32{
	6,  // 0: google.cloud.gkebackup.v1.VolumeBackup.create_time:type_name -> google.protobuf.Timestamp
	6,  // 1: google.cloud.gkebackup.v1.VolumeBackup.update_time:type_name -> google.protobuf.Timestamp
	7,  // 2: google.cloud.gkebackup.v1.VolumeBackup.source_pvc:type_name -> google.cloud.gkebackup.v1.NamespacedName
	0,  // 3: google.cloud.gkebackup.v1.VolumeBackup.format:type_name -> google.cloud.gkebackup.v1.VolumeBackup.VolumeBackupFormat
	6,  // 4: google.cloud.gkebackup.v1.VolumeBackup.complete_time:type_name -> google.protobuf.Timestamp
	1,  // 5: google.cloud.gkebackup.v1.VolumeBackup.state:type_name -> google.cloud.gkebackup.v1.VolumeBackup.State
	6,  // 6: google.cloud.gkebackup.v1.VolumeRestore.create_time:type_name -> google.protobuf.Timestamp
	6,  // 7: google.cloud.gkebackup.v1.VolumeRestore.update_time:type_name -> google.protobuf.Timestamp
	7,  // 8: google.cloud.gkebackup.v1.VolumeRestore.target_pvc:type_name -> google.cloud.gkebackup.v1.NamespacedName
	2,  // 9: google.cloud.gkebackup.v1.VolumeRestore.volume_type:type_name -> google.cloud.gkebackup.v1.VolumeRestore.VolumeType
	6,  // 10: google.cloud.gkebackup.v1.VolumeRestore.complete_time:type_name -> google.protobuf.Timestamp
	3,  // 11: google.cloud.gkebackup.v1.VolumeRestore.state:type_name -> google.cloud.gkebackup.v1.VolumeRestore.State
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_volume_proto_init() }
func file_google_cloud_gkebackup_v1_volume_proto_init() {
	if File_google_cloud_gkebackup_v1_volume_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_v1_volume_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*VolumeBackup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_volume_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*VolumeRestore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_volume_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_volume_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_volume_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_volume_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_volume_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_volume_proto = out.File
	file_google_cloud_gkebackup_v1_volume_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_volume_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_volume_proto_depIdxs = nil
}
