# Contributing to libcbor

libcbor is maintained by [@PJK](https://github.com/PJK) in his spare time on a best-effort basis.

Community contributions are welcome as long as they align with the [project priorities](https://github.com/PJK/libcbor#main-features) and [goals](https://libcbor.readthedocs.io/en/latest/development.html#goals) and follow the guidelines described belows. 

## Principles

**Bug reports and questions:** Bug reports and specific technical questions are always welcome. Feel free to open an [issue](https://github.com/PJK/libcbor/issues).   

**Incremental improvements:** Bug fixes (including build scripts, examples, test, typos, CI/CD config, etc.) and documentation improvements (fixes of typos, inaccuracies, out of date content, etc.) are always welcome. Feel free to open a [PR](https://github.com/PJK/libcbor/pulls).

**New features:** I am looking to keep the scope of libcbor small. If you would like to add a feature, please open an issue with your proposal (or reach out to me privately) to discuss if the feature fits into libcbor before opening a PR.

**Major changes:** Please open an issue with your proposal (or reach out to me privately) to discuss if the improvement fits into cbor before opening a PR.

## Pull Request Process

1. Ensure that all CI checks pass
2. Check that the PR is complete and of good quality
    - Include a descriptive summary of the change. If the PR addresses an open issue, please link it.
    - Code changes: Add tests
    - If necessary: Update documentation, including any links 
3. Code changes: Update [the changelog](https://github.com/PJK/libcbor/blob/master/CHANGELOG.md). Do *not* change the version number.

## Interactions

I work on libcbor on a best effort basis. The typical response time is a few days. 

If you do not receive a response in a few weeks, feel free to ping the PR or issue.

## Resources

- [Development documentation](https://libcbor.readthedocs.io/en/latest/development.html)

