/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** No Commercial Usage
**
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#ifndef COMMUNITYWELCOMEPAGEWIDGET_H
#define COMMUNITYWELCOMEPAGEWIDGET_H

#include <QtGui/QWidget>

QT_BEGIN_NAMESPACE
class QUrl;
QT_END_NAMESPACE

namespace Core{
namespace Internal {
    class RssFetcher;
}
}

namespace Welcome {
namespace Internal {

namespace Ui {
    class CommunityWelcomePageWidget;
}

class CommunityWelcomePageWidget : public QWidget
{
    Q_OBJECT

public:
    explicit CommunityWelcomePageWidget(QWidget *parent = 0);
    ~CommunityWelcomePageWidget();

signals:
    void startRssFetching(const QUrl& url);

private slots:
    void slotUrlClicked(const QString &data);


private:
    Core::Internal::RssFetcher *m_rssFetcher;
    Ui::CommunityWelcomePageWidget *ui;
};


} // namespace Internal
} // namespace Welcome
#endif // COMMUNITYWELCOMEPAGEWIDGET_H
