import*as RootModule from'../root/root.js';RootModule.Runtime.cachedResources.set("elements/classesPaneWidget.css","/**\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.styles-element-classes-pane {\n  background-color: var(--toolbar-bg-color);\n  border-bottom: 1px solid rgb(189 189 189);\n  padding: 6px 2px 2px;\n}\n\n.styles-element-classes-container {\n  display: flex;\n  flex-wrap: wrap;\n  justify-content: flex-start;\n}\n\n.styles-element-classes-pane [is=dt-checkbox] {\n  margin-right: 15px;\n}\n\n.styles-element-classes-pane .title-container {\n  padding-bottom: 2px;\n}\n\n.styles-element-classes-pane .new-class-input {\n  padding-left: 3px;\n  padding-right: 3px;\n  overflow: hidden;\n  border: 1px solid #ddd;\n  line-height: 15px;\n  margin-left: 3px;\n  width: calc(100% - 7px);\n  background-color: var(--color-background);\n  cursor: text;\n}\n\n/*# sourceURL=elements/classesPaneWidget.css */");RootModule.Runtime.cachedResources.set("elements/computedStyleSidebarPane.css","/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.computed-properties {\n  user-select: text;\n  flex-shrink: 0;\n}\n\n.styles-sidebar-pane-toolbar {\n  border-bottom: 1px solid #eee;\n  flex-shrink: 0;\n}\n\n.styles-sidebar-pane-filter-box {\n  flex: auto;\n  display: flex;\n}\n\n.styles-sidebar-pane-filter-box > input {\n  outline: none !important;\n  border: none;\n  width: 100%;\n  background: var(--color-background);\n  padding-left: 4px;\n  margin: 3px;\n}\n\n.styles-sidebar-pane-filter-box > input:focus,\n.styles-sidebar-pane-filter-box > input:not(:placeholder-shown) {\n  box-shadow: var(--focus-ring-active-shadow);\n}\n\n.styles-sidebar-pane-filter-box > input::placeholder {\n  color: rgb(0 0 0 / 54%);\n}\n\n@media (forced-colors: active) {\n  .styles-sidebar-pane-filter-box > input {\n    border: 1px solid ButtonText;\n  }\n}\n\n/*# sourceURL=elements/computedStyleSidebarPane.css */");RootModule.Runtime.cachedResources.set("elements/computedStyleWidgetTree.css","/*\n * Copyright (c) 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline,\n.tree-outline ol {\n  padding-left: 0;\n}\n\n.tree-outline li:hover {\n  background-color: var(--focus-bg-color);\n  cursor: pointer;\n}\n\n.tree-outline li::before {\n  margin: 0 -1px 0 4px;\n}\n\n.group-title {\n  /* tree-outline li::before is set to be 16px wide */\n  padding-right: 16px;\n}\n\n.tree-outline li.group-title:hover {\n  background-color: transparent;\n}\n\n.group-title > h1 {\n  margin: 1px 0 0 0;\n  padding: 1em 0;\n  width: 100%;\n  cursor: pointer;\n  color: #5f6368;\n  font-size: 11px;\n  font-weight: 400;\n}\n\n.group-title:not(.first-group) > h1 {\n  border-top: 1px solid var(--divider-color);\n}\n\n:host-context(.-theme-with-dark-background) .group-title > h1 {\n  color: #e8eaed;\n}\n\n.group-title + ol.children {\n  margin-bottom: 1em;\n}\n\n@media (forced-colors: active) {\n  :host-context(.monospace.computed-properties) .tree-outline li:hover {\n    forced-color-adjust: none;\n    background-color: Highlight;\n  }\n\n  :host-context(.monospace.computed-properties) .tree-outline:not(.hide-selection-when-blurred) li.parent:hover.selected::before,\n  :host-context(.monospace.computed-properties) .tree-outline-disclosure li.parent:hover::before {\n    background-color: HighlightText;\n  }\n\n  :host-context(.monospace.computed-properties) .tree-outline li:hover * {\n    color: HighlightText;\n  }\n}\n\n/*# sourceURL=elements/computedStyleWidgetTree.css */");RootModule.Runtime.cachedResources.set("elements/domLinkifier.css","/*\n * Copyright 2018 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  display: inline;\n}\n\n.node-link {\n  cursor: pointer;\n  display: inline;\n  pointer-events: auto;\n}\n\n.node-link:focus-visible {\n  outline-width: unset;\n}\n\n.node-label-name {\n  color: var(--color-syntax-1);\n}\n\n.node-label-class,\n.node-label-pseudo {\n  color: var(--color-syntax-4);\n}\n\n/*# sourceURL=elements/domLinkifier.css */");RootModule.Runtime.cachedResources.set("elements/elementsPanel.css","/*\n * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.\n * Copyright (C) 2009 Anthony Ricaud <rik@webkit.org>\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions\n * are met:\n *\n * 1.  Redistributions of source code must retain the above copyright\n *     notice, this list of conditions and the following disclaimer.\n * 2.  Redistributions in binary form must reproduce the above copyright\n *     notice, this list of conditions and the following disclaimer in the\n *     documentation and/or other materials provided with the distribution.\n * 3.  Neither the name of Apple Computer, Inc. (\"Apple\") nor the names of\n *     its contributors may be used to endorse or promote products derived\n *     from this software without specific prior written permission.\n *\n * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS \"AS IS\" AND ANY\n * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY\n * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF\n * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n */\n\n#elements-content {\n  flex: 1 1;\n  overflow: auto;\n  padding: 2px 0 0 0;\n}\n\n.style-panes-wrapper {\n  overflow: hidden scroll;\n}\n\n.style-panes-wrapper > div:not(:last-child) {\n  border-bottom: 1px solid var(--divider-color);\n}\n\n#elements-content:not(.elements-wrap) > div {\n  display: inline-block;\n  min-width: 100%;\n}\n\n#elements-crumbs {\n  background-color: var(--color-background);\n  border-top: 1px solid var(--divider-color);\n  overflow: hidden;\n  width: 100%;\n}\n\n.elements-tree-header {\n  height: 24px;\n  border-top: 1px solid var(--divider-color);\n  border-bottom: 1px solid var(--divider-color);\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.elements-tree-header-frame {\n  margin-left: 6px;\n  margin-right: 6px;\n  flex: none;\n}\n\n/*# sourceURL=elements/elementsPanel.css */");RootModule.Runtime.cachedResources.set("elements/elementStatePaneWidget.css","/**\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.styles-element-state-pane {\n  overflow: hidden;\n  padding-left: 2px;\n  background-color: var(--toolbar-bg-color);\n  border-bottom: 1px solid rgb(189 189 189);\n  margin-top: 0;\n  padding-bottom: 2px;\n}\n\n.styles-element-state-pane > div {\n  margin: 8px 4px 6px;\n}\n\n.styles-element-state-pane > table {\n  width: 100%;\n  border-spacing: 0;\n}\n\n.styles-element-state-pane td {\n  padding: 0;\n}\n\n/*# sourceURL=elements/elementStatePaneWidget.css */");RootModule.Runtime.cachedResources.set("elements/elementsTreeOutline.css","/*\n * Copyright (c) 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.editing {\n  box-shadow: var(--drop-shadow);\n  background-color: var(--color-background);\n  text-overflow: clip !important;\n  padding-left: 2px;\n  margin-left: -2px;\n  padding-right: 2px;\n  margin-right: -2px;\n  margin-bottom: -1px;\n  padding-bottom: 1px;\n  opacity: 100% !important;\n}\n\n.editing,\n.editing * {\n  color: #222 !important;\n  text-decoration: none !important;\n}\n\n.editing br {\n  display: none;\n}\n\n.elements-disclosure {\n  width: 100%;\n  display: inline-block;\n  line-height: normal;\n}\n\n.elements-disclosure li {\n  /** Keep margin-left & padding-left in sync with ElementsTreeElements.updateDecorators **/\n  padding: 1px 0 0 14px;\n  margin-left: -2px;\n  word-break: normal;\n  position: relative;\n  min-height: 15px;\n  line-height: 1.36;\n  min-width: 200px;\n}\n\n.elements-disclosure li.parent {\n  /** Keep it in sync with ElementsTreeElements.updateDecorators **/\n  margin-left: -13px;\n}\n\n.elements-disclosure li .selected-hint::before {\n  font-style: italic;\n  content: \" == $0\";\n  opacity: 0%;\n  position: absolute;\n  white-space: pre;\n}\n\n.elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) li.selected .selected-hint::before {\n  opacity: 60%;\n}\n\n.elements-disclosure li.parent::before {\n  box-sizing: border-box;\n  user-select: none;\n  -webkit-mask-image: url(Images/treeoutlineTriangles.svg);\n  -webkit-mask-size: 32px 24px;\n  content: '\\A0\\A0';\n  color: transparent;\n  text-shadow: none;\n  margin-right: -3px;\n  -webkit-mask-position: 0 0;\n  background-color: #727272;\n}\n\n.elements-disclosure li.parent.expanded::before {\n  -webkit-mask-position: -16px 0;\n}\n\n.elements-disclosure li.always-parent::before {\n  visibility: hidden;\n}\n\n.elements-disclosure li .selection {\n  display: none;\n  z-index: -1;\n}\n\n.elements-disclosure li.selected .selection {\n  display: block;\n}\n\n.elements-disclosure li.elements-drag-over .selection {\n  display: block;\n  margin-top: -2px;\n  border-top: 2px solid var(--selection-bg-color);\n}\n\n.elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) .selection {\n  background-color: var(--item-selection-inactive-bg-color);\n}\n\n.elements-disclosure li.hovered:not(.selected) .selection {\n  display: block;\n  left: 3px;\n  right: 3px;\n  background-color: var(--item-hover-color);\n  border-radius: 5px;\n}\n\n.elements-disclosure li .webkit-html-tag.close {\n  margin-left: -12px;\n}\n\n.elements-disclosure .elements-tree-outline.hide-selection-when-blurred .selected:focus-visible .highlight > * {\n  background: var(--focus-bg-color);\n  border-radius: 2px;\n  box-shadow: 0 0 0 2px var(--focus-bg-color);\n}\n\n.elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) li.selected:focus .selection {\n  background-color: var(--item-selection-bg-color);\n}\n\n.elements-disclosure ol {\n  list-style-type: none;\n\n  /** Keep it in sync with ElementsTreeElements.updateDecorators **/\n  padding-inline-start: 12px;\n  margin: 0;\n}\n\n.elements-disclosure ol.children {\n  display: none;\n  min-width: 100%;\n}\n\n.elements-disclosure ol.children.expanded {\n  display: inline-block;\n}\n\n.elements-disclosure > ol {\n  position: relative;\n  margin: 0;\n  cursor: default;\n  min-width: 100%;\n  min-height: 100%;\n  padding-left: 2px;\n}\n\n.elements-disclosure li.in-clipboard .highlight {\n  outline: 1px dotted darkgrey;\n}\n\n.elements-tree-outline ol.shadow-root-depth-4 {\n  background-color: rgb(0 0 0 / 4%);\n}\n\n.elements-tree-outline ol.shadow-root-depth-3 {\n  background-color: rgb(0 0 0 / 3%);\n}\n\n.elements-tree-outline ol.shadow-root-depth-2 {\n  background-color: rgb(0 0 0 / 2%);\n}\n\n.elements-tree-outline ol.shadow-root-depth-1 {\n  background-color: rgb(0 0 0 / 1%);\n}\n\n.elements-tree-outline ol.shadow-root-deep {\n  background-color: transparent;\n}\n\n.elements-tree-editor {\n  box-shadow: var(--drop-shadow);\n  margin-right: 4px;\n}\n\n.CodeMirror {\n  background-color: var(--color-background);\n  height: 300px !important;\n}\n\n.CodeMirror-lines {\n  padding: 0;\n}\n\n.CodeMirror pre {\n  padding: 0;\n}\n\nbutton,\ninput,\nselect {\n  font-family: inherit;\n  font-size: inherit;\n}\n\n.elements-gutter-decoration {\n  position: absolute;\n  top: 3px;\n  left: 2px;\n  height: 9px;\n  width: 9px;\n  border-radius: 5px;\n  border: 1px solid orange;\n  background-color: orange;\n  cursor: pointer;\n}\n\n.elements-gutter-decoration.elements-has-decorated-children {\n  opacity: 50%;\n}\n\n.add-attribute {\n  margin-left: 1px;\n  margin-right: 1px;\n  white-space: nowrap;\n}\n\n.elements-tree-nowrap,\n.elements-tree-nowrap .li {\n  white-space: pre !important;\n}\n\n.elements-disclosure .elements-tree-nowrap li {\n  word-wrap: normal;\n}\n\n/* DOM update highlight */\n@keyframes dom-update-highlight-animation {\n  from {\n    background-color: rgb(158 54 153);\n    color: white;\n  }\n\n  80% {\n    background-color: rgb(245 219 244);\n    color: inherit;\n  }\n\n  to {\n    background-color: inherit;\n  }\n}\n\n@keyframes dom-update-highlight-animation-dark {\n  from {\n    background-color: rgb(158 54 153);\n    color: white;\n  }\n\n  80% {\n    background-color: #333;\n    color: inherit;\n  }\n\n  to {\n    background-color: inherit;\n  }\n}\n\n.dom-update-highlight {\n  animation: dom-update-highlight-animation 1.4s 1 cubic-bezier(0, 0, 0.2, 1);\n  border-radius: 2px;\n}\n\n:host-context(.-theme-with-dark-background) .dom-update-highlight {\n  animation: dom-update-highlight-animation-dark 1.4s 1 cubic-bezier(0, 0, 0.2, 1);\n}\n\n.elements-disclosure.single-node li {\n  padding-left: 2px;\n}\n\n.elements-tree-shortcut-title,\n.elements-tree-shortcut-link {\n  color: rgb(87 87 87);\n}\n\n.elements-disclosure .gutter-container {\n  position: absolute;\n  top: 0;\n  left: 0;\n  cursor: pointer;\n  width: 15px;\n  height: 15px;\n}\n\n.elements-hide-gutter .gutter-container {\n  display: none;\n}\n\n.gutter-menu-icon {\n  display: block;\n  visibility: hidden;\n  transform: rotate(-90deg) scale(0.8);\n  background-color: var(--color-background);\n  position: relative;\n  left: -7px;\n  top: -3px;\n}\n\n.elements-disclosure li.selected .gutter-container:not(.has-decorations) .gutter-menu-icon {\n  visibility: visible;\n}\n\n/** Guide line */\n\nli.selected {\n  z-index: 0;\n}\n\nli.hovered:not(.always-parent) + ol.children,\n.elements-tree-outline ol.shadow-root,\nli.selected:not(.always-parent) + ol.children {\n  background: linear-gradient(to right, var(--indentation-level-border-color), var(--indentation-level-border-color) 0.5px, transparent 0);\n  background-position-x: 5px;\n}\n\nli.selected:not(.always-parent) + ol.children {\n  --indentation-level-border-color: hsl(216deg 68% 80% / 100%) !important;\n}\n\nli.hovered:not(.always-parent) + ol.children:not(.shadow-root) {\n  --indentation-level-border-color: hsl(0deg 0% 0% / 10%);\n}\n\n.elements-tree-outline ol.shadow-root {\n  --indentation-level-border-color: hsl(0deg 0% 80% / 100%);\n}\n\n@media (forced-colors: active) {\n  .elements-disclosure li.parent::before {\n    forced-color-adjust: none;\n    background-color: ButtonText !important;\n  }\n\n  .elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) li.selected .selected-hint::before {\n    opacity: unset;\n  }\n\n  .elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) .selection,\n  .elements-disclosure li.hovered:not(.selected) .selection,\n  .elements-disclosure .elements-tree-outline:not(.hide-selection-when-blurred) li.selected:focus .selection {\n    forced-color-adjust: none;\n    background: canvas !important;\n    border: 1px solid Highlight !important;\n  }\n\n  .gutter-menu-icon {\n    forced-color-adjust: none;\n  }\n}\n\n/*# sourceURL=elements/elementsTreeOutline.css */");RootModule.Runtime.cachedResources.set("elements/layoutPane.css","* {\n  box-sizing: border-box;\n  font-size: 12px;\n}\n\n.header {\n  background-color: var(--toolbar-bg-color, #f3f3f3);\n  border-bottom: var(--divider-border, 1px solid #d0d0d0);\n  line-height: 1.6;\n  overflow: hidden;\n  padding: 0 5px;\n  white-space: nowrap;\n}\n\n.header::marker {\n  color: rgb(110 110 110);\n  font-size: 11px;\n  line-height: 1;\n}\n\n.header:focus {\n  background-color: var(--focus-bg-color);\n}\n\n.content-section {\n  padding: 16px;\n  border-bottom: var(--divider-border, 1px solid #d0d0d0);\n}\n\n.content-section-title {\n  font-size: 12px;\n  font-weight: 500;\n  line-height: 1.1;\n  margin: 0;\n  padding: 0;\n}\n\n.checkbox-settings {\n  margin-top: 8px;\n  display: grid;\n  grid-template-columns: 1fr;\n  gap: 5px;\n}\n\n.checkbox-label {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.checkbox-settings .checkbox-label {\n  margin-bottom: 8px;\n}\n\n.checkbox-settings .checkbox-label:last-child {\n  margin-bottom: 0;\n}\n\n.checkbox-label input {\n  margin: 0 6px 0 0;\n  padding: 0;\n  flex: none;\n}\n\n.checkbox-label input:focus {\n  outline: auto 5px -webkit-focus-ring-color;\n}\n\n.checkbox-label > span {\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n\n.select-settings {\n  margin-top: 16px;\n  display: grid;\n  grid-template-columns: repeat(auto-fill, 150px);\n  gap: 16px;\n}\n\n.select-label {\n  display: flex;\n  flex-direction: column;\n}\n\n.select-label span {\n  margin-bottom: 4px;\n}\n\n.elements {\n  margin-top: 12px;\n  color: var(--dom-tag-name-color);\n  display: grid;\n  grid-template-columns: repeat(auto-fill, minmax(min(250px, 100%), 1fr));\n  gap: 8px;\n}\n\n.element {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.show-element {\n  margin: 0 0 0 8px;\n  padding: 0;\n  background: none;\n  border: none;\n  -webkit-mask-image: url(Images/ic_show_node_16x16.svg);\n  background-color: #333;\n  width: 16px;\n  height: 16px;\n  display: block;\n  cursor: pointer;\n  flex: none;\n}\n\n.show-element:focus,\n.show-element:hover {\n  background-color: #6e6e6e;\n}\n\n:host-context(.-theme-with-dark-background) .show-element {\n  background-color: rgb(204 204 204);\n}\n\n:host-context(.-theme-with-dark-background) .show-element:focus,\n:host-context(.-theme-with-dark-background) .show-element:hover {\n  background-color: #6e6e6e;\n}\n\n.color-picker {\n  visibility: hidden;\n}\n\n.color-picker-label {\n  border: 1px solid rgb(128 128 128 / 60%);\n  cursor: default;\n  display: inline-block;\n  flex: none;\n  height: 10px;\n  margin: 0 0 0 8px;\n  width: 10px;\n}\n\n.color-picker-label:hover,\n.color-picker-label:focus {\n  border: 1px solid var(--accent-color-hover);\n  transform: scale(1.2);\n}\n\n.node-text-container {\n  line-height: 16px;\n  padding: 0 0.5ex;\n  border-radius: 5px;\n}\n\n.node-text-container:hover {\n  background-color: var(--item-hover-color);\n}\n\n/*# sourceURL=elements/layoutPane.css */");RootModule.Runtime.cachedResources.set("elements/metricsSidebarPane.css","/**\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.metrics {\n  padding: 8px;\n  font-size: 10px;\n  text-align: center;\n  white-space: nowrap;\n  min-height: var(--metrics-height);\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n}\n\n:host {\n  --metrics-height: 190px;\n\n  height: var(--metrics-height);\n  contain: strict;\n}\n\n:host(.invisible) {\n  visibility: hidden;\n  height: 0;\n}\n\n:host(.collapsed) {\n  visibility: collapse;\n  height: 0;\n}\n\n/* The font we use on Windows takes up more vertical space, so adjust\n * the height of the metrics sidebar pane accordingly.\n */\n:host-context(.platform-windows) {\n  --metrics-height: 214px;\n}\n\n.metrics .label {\n  position: absolute;\n  font-size: 10px;\n  left: 4px;\n}\n\n.metrics .position {\n  border: 1px rgb(66% 66% 66%) dotted;\n  background-color: var(--color-background);\n  display: inline-block;\n  text-align: center;\n  padding: 3px;\n  margin: 3px;\n  position: relative;\n}\n\n.metrics .margin {\n  border: 1px dashed rgb(48 57 66);\n  background-color: var(--color-background);\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  padding: 3px 6px;\n  margin: 3px;\n  position: relative;\n}\n\n.metrics .border {\n  border: 1px black solid;\n  background-color: var(--color-background);\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  padding: 3px 6px;\n  margin: 3px;\n  position: relative;\n}\n\n.metrics .padding {\n  border: 1px grey dashed;\n  background-color: var(--color-background);\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  padding: 3px 6px;\n  margin: 3px;\n  position: relative;\n  min-width: 120px;\n}\n\n.metrics .content {\n  position: static;\n  border: 1px gray solid;\n  background-color: var(--color-background);\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  padding: 3px;\n  margin: 3px;\n  min-width: 80px;\n  overflow: visible;\n}\n\n.metrics .content span {\n  display: inline-block;\n}\n\n.metrics .editing {\n  position: relative;\n  z-index: 100;\n  cursor: text;\n}\n\n.metrics .left {\n  display: inline-block;\n  vertical-align: middle;\n}\n\n.metrics .right {\n  display: inline-block;\n  vertical-align: middle;\n}\n\n.metrics .top {\n  display: inline-block;\n}\n\n.metrics .bottom {\n  display: inline-block;\n}\n\n/* All computed layout attributes except position have a quite light\n * background color applied to them, so the default light font in dark\n * mode is very low contrast. Therefore we swap back to a dark font by\n * default in dark mode because the background colors are lighter.\n */\n:host-context(.-theme-with-dark-background) .metrics .margin,\n:host-context(.-theme-with-dark-background) .metrics .border,\n:host-context(.-theme-with-dark-background) .metrics .padding,\n:host-context(.-theme-with-dark-background) .metrics .content {\n  color: #222;\n}\n\n/* When you hover over margin the rest of the items get given a black\n * background and so then the black text we set above means the numbers\n * are invisible. So if you're hovering over the margin we set the\n * color of the text for all the children to light. This also fixes\n * hovering over anything within margin such as border/padding.\n */\n:host-context(.-theme-with-dark-background) .metrics > div:hover div {\n  color: #ccc;\n}\n\n/*# sourceURL=elements/metricsSidebarPane.css */");RootModule.Runtime.cachedResources.set("elements/platformFontsWidget.css","/**\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n  user-select: text;\n}\n\n.platform-fonts {\n  flex-shrink: 0;\n}\n\n.font-name {\n  font-weight: bold;\n}\n\n.font-usage {\n  color: #888;\n  padding-left: 3px;\n}\n\n.title {\n  padding: 0 5px;\n  border-top: 1px solid;\n  border-bottom: 1px solid;\n  border-color: #ddd;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  height: 24px;\n  background-color: #f1f1f1;\n  display: flex;\n  align-items: center;\n}\n\n.stats-section {\n  margin: 5px 0;\n}\n\n.font-stats-item {\n  padding-left: 1em;\n}\n\n.font-stats-item .font-delimeter {\n  margin: 0 1ex 0 1ex;\n}\n\n/*# sourceURL=elements/platformFontsWidget.css */");RootModule.Runtime.cachedResources.set("elements/propertiesWidget.css","/*\n * Copyright (c) 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.properties-widget-section {\n  padding: 2px 0 2px 5px;\n  flex: none;\n}\n\n/*# sourceURL=elements/propertiesWidget.css */");RootModule.Runtime.cachedResources.set("elements/nodeStackTraceWidget.css","/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.stack-trace {\n  font-size: 11px !important;\n  font-family: Menlo, monospace;\n}\n\n/*# sourceURL=elements/nodeStackTraceWidget.css */");RootModule.Runtime.cachedResources.set("elements/stylesSectionTree.css","/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n  padding: 0;\n}\n\n.tree-outline li.has-warning,\n.tree-outline li.not-parsed-ok {\n  margin-left: 0;\n}\n\n.tree-outline li.filter-match {\n  background-color: rgb(255 255 0 / 50%);\n}\n\n:host-context(.-theme-with-dark-background) .tree-outline li.filter-match {\n  background-color: hsl(133deg 100% 30% / 50%);\n}\n\n.tree-outline li.overloaded.filter-match {\n  background-color: rgb(255 255 0 / 25%);\n}\n\n:host-context(.-theme-with-dark-background) .tree-outline li.overloaded.filter-match {\n  background-color: hsl(133deg 100% 30% / 25%);\n}\n\n.tree-outline li.has-warning .exclamation-mark,\n.tree-outline li.not-parsed-ok .exclamation-mark {\n  display: inline-block;\n  position: relative;\n  width: 11px;\n  height: 10px;\n  margin: 0 7px 0 0;\n  top: 1px;\n  left: -36px; /* outdent to compensate for the top-level property indent */\n  user-select: none;\n  cursor: default;\n  z-index: 1;\n}\n\n.tree-outline li {\n  margin-left: 12px;\n  padding-left: 22px;\n  white-space: normal;\n  text-overflow: ellipsis;\n  cursor: auto;\n  display: block;\n}\n\n.tree-outline li::before {\n  display: none;\n}\n\n.has-ignorable-error .webkit-css-property {\n  color: inherit;\n}\n\n.tree-outline li .webkit-css-property {\n  margin-left: -22px; /* outdent the first line of longhand properties (in an expanded shorthand) to compensate for the \"padding-left\" shift in .tree-outline li */\n}\n\n.tree-outline > li {\n  padding-left: 38px;\n  clear: both;\n  min-height: 14px;\n}\n\n.tree-outline > li .webkit-css-property {\n  margin-left: -38px; /* outdent the first line of the top-level properties to compensate for the \"padding-left\" shift in .tree-outline > li */\n}\n\n.tree-outline > li.child-editing {\n  padding-left: 8px;\n}\n\n.tree-outline > li.child-editing .text-prompt {\n  white-space: pre-wrap;\n}\n\n.tree-outline > li.child-editing .webkit-css-property {\n  margin-left: 0;\n}\n\n.tree-outline li.child-editing {\n  word-wrap: break-word !important;\n  white-space: normal !important;\n  padding-left: 0;\n}\n\nol:not(.tree-outline) {\n  display: none;\n  margin: 0;\n  padding-inline-start: 12px;\n  list-style: none;\n}\n\nol.expanded {\n  display: block;\n}\n\n.tree-outline li .info {\n  padding-top: 4px;\n  padding-bottom: 3px;\n}\n\n.enabled-button {\n  visibility: hidden;\n  float: left;\n  font-size: 10px;\n  margin: 0;\n  vertical-align: top;\n  position: relative;\n  z-index: 1;\n  width: 18px;\n  left: -40px; /* original -2px + (-38px) to compensate for the first line outdent */\n  top: 1px;\n  height: 13px;\n}\n\n.tree-outline li.editing .enabled-button {\n  display: none !important;\n}\n\n.overloaded:not(.has-ignorable-error),\n.inactive,\n.disabled,\n.not-parsed-ok:not(.has-ignorable-error) {\n  text-decoration: line-through;\n}\n\n.implicit,\n.inherited {\n  opacity: 50%;\n}\n\n.has-ignorable-error {\n  color: gray;\n}\n\n.tree-outline li.editing {\n  margin-left: 10px;\n  text-overflow: clip;\n}\n\n.tree-outline li.editing-sub-part {\n  padding: 3px 6px 8px 18px;\n  margin: -1px -6px -8px -6px;\n  text-overflow: clip;\n}\n\n:host-context(.no-affect) .tree-outline li {\n  opacity: 50%;\n}\n\n:host-context(.no-affect) .tree-outline li.editing {\n  opacity: 100%;\n}\n\n:host-context(.styles-panel-hovered:not(.read-only)) .webkit-css-property:hover,\n:host-context(.styles-panel-hovered:not(.read-only)) .value:hover {\n  text-decoration: underline;\n  cursor: default;\n}\n\n.styles-name-value-separator {\n  display: inline-block;\n  width: 14px;\n  text-decoration: inherit;\n  white-space: pre;\n}\n\n.styles-clipboard-only {\n  display: inline-block;\n  width: 0;\n  opacity: 0%;\n  pointer-events: none;\n  white-space: pre;\n}\n\n.tree-outline li.child-editing .styles-clipboard-only {\n  display: none;\n}\n\n/* Matched styles */\n\n:host-context(.matched-styles) .tree-outline li {\n  margin-left: 0 !important;\n}\n\n.expand-icon {\n  user-select: none;\n  margin-left: -6px;\n  margin-right: 2px;\n  margin-bottom: -2px;\n}\n\n.tree-outline li:not(.parent) .expand-icon {\n  display: none;\n}\n\n:host-context(.matched-styles:not(.read-only):hover) .enabled-button {\n  visibility: visible;\n}\n\n:host-context(.matched-styles:not(.read-only)) .tree-outline li.disabled .enabled-button {\n  visibility: visible;\n}\n\n:host-context(.matched-styles) ol.expanded {\n  margin-left: 16px;\n}\n\n.devtools-link-styled-trim {\n  display: inline-block;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  max-width: 80%;\n  vertical-align: bottom;\n}\n\ndevtools-css-angle {\n  display: inline-block;\n}\n\n/*# sourceURL=elements/stylesSectionTree.css */");RootModule.Runtime.cachedResources.set("elements/stylesSidebarPane.css","/**\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.styles-section {\n  min-height: 18px;\n  white-space: nowrap;\n  user-select: text;\n  border-bottom: 1px solid var(--divider-color);\n  position: relative;\n  overflow: hidden;\n}\n\n.styles-section > div {\n  padding: 2px 2px 4px 4px;\n}\n\n.styles-section:last-child {\n  border-bottom: none;\n}\n\n.styles-section.read-only {\n  background-color: #fafafa;\n  font-style: italic;\n}\n\n.styles-section.has-open-popover {\n  z-index: 1;\n}\n\n.styles-section:focus-visible {\n  background-color: hsl(214deg 48% 95%);\n}\n\n.styles-section.read-only:focus-visible {\n  background-color: hsl(215deg 25% 87%);\n}\n\n.styles-section .simple-selector.filter-match {\n  background-color: rgb(255 255 0 / 50%);\n}\n\n:host-context(.-theme-with-dark-background) .styles-section .simple-selector.filter-match {\n  background-color: hsl(133deg 100% 30% / 50%);\n}\n\n.sidebar-pane-closing-brace {\n  clear: both;\n}\n\n.styles-section-title {\n  background-origin: padding;\n  background-clip: padding;\n  word-wrap: break-word;\n  white-space: normal;\n}\n\n.styles-section-title .media-list {\n  color: hsl(0deg 0% 46%);\n}\n\n.styles-section-title .media-list.media-matches .media.editable-media {\n  color: #222;\n}\n\n.styles-section-title .media .subtitle {\n  float: right;\n  color: hsl(0deg 0% 34%);\n}\n\n.styles-section-title .media:not(.editing-media),\n.styles-section-title .media:not(.editing-media) .subtitle {\n  overflow: hidden;\n}\n\n.styles-section-subtitle {\n  color: hsl(0deg 0% 44%);\n  float: right;\n  padding-left: 15px;\n  max-width: 100%;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n  height: 15px;\n  margin-bottom: -1px;\n}\n\n.sidebar-pane-open-brace,\n.sidebar-pane-closing-brace {\n  color: hsl(0deg 0% 46%);\n}\n\n.styles-section .devtools-link {\n  user-select: none;\n}\n\n.styles-section .styles-section-subtitle .devtools-link {\n  color: hsl(0deg 0% 44%);\n  text-decoration-color: hsl(0deg 0% 60%);\n}\n\n.styles-section .selector {\n  color: hsl(0deg 0% 46%);\n}\n\n.styles-section .simple-selector.selector-matches,\n.styles-section.keyframe-key {\n  color: #222;\n}\n\n.styles-section .style-properties {\n  margin: 0;\n  padding: 2px 4px 0 0;\n  list-style: none;\n  clear: both;\n  display: flex;\n}\n\n.styles-section.matched-styles .style-properties {\n  padding-left: 0;\n}\n\n@keyframes styles-element-state-pane-slidein {\n  from {\n    margin-top: -60px;\n  }\n\n  to {\n    margin-top: 0;\n  }\n}\n\n@keyframes styles-element-state-pane-slideout {\n  from {\n    margin-top: 0;\n  }\n\n  to {\n    margin-top: -60px;\n  }\n}\n\n.styles-sidebar-toolbar-pane {\n  position: relative;\n  animation-duration: 0.1s;\n  animation-direction: normal;\n}\n\n.styles-sidebar-toolbar-pane-container {\n  position: relative;\n  overflow: hidden;\n  flex-shrink: 0;\n}\n\n.styles-selector {\n  cursor: text;\n}\n\n.styles-sidebar-pane-toolbar-container {\n  flex-shrink: 0;\n  overflow: hidden;\n  position: sticky;\n  top: 0;\n  background-color: var(--toolbar-bg-color);\n  z-index: 2;\n}\n\n.styles-sidebar-pane-toolbar {\n  border-bottom: 1px solid #eee;\n  flex-shrink: 0;\n}\n\n.font-toolbar-hidden {\n  visibility: hidden;\n}\n\n.styles-sidebar-pane-filter-box {\n  flex: auto;\n  display: flex;\n}\n\n.styles-sidebar-pane-filter-box > input {\n  outline: none !important;\n  border: none;\n  width: 100%;\n  background: var(--color-background);\n  padding-left: 4px;\n  margin: 3px;\n}\n\n.styles-sidebar-pane-filter-box > input:hover {\n  box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n.styles-sidebar-pane-filter-box > input:focus,\n.styles-sidebar-pane-filter-box > input:not(:placeholder-shown) {\n  box-shadow: var(--focus-ring-active-shadow);\n}\n\n.styles-sidebar-pane-filter-box > input::placeholder {\n  color: rgb(0 0 0 / 54%);\n}\n\n.styles-section.styles-panel-hovered:not(.read-only) span.simple-selector:hover,\n.styles-section.styles-panel-hovered:not(.read-only) .media-text :hover {\n  text-decoration: underline;\n  cursor: default;\n}\n\n.sidebar-separator {\n  background-color: var(--toolbar-bg-color);\n  padding: 0 5px;\n  border-bottom: 1px solid var(--divider-color);\n  color: hsl(0deg 0% 32% / 100%);\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  line-height: 22px;\n}\n\n.sidebar-separator > span.monospace {\n  max-width: 180px;\n  display: inline-block;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  vertical-align: middle;\n  margin-left: 2px;\n}\n\n.sidebar-pane-section-toolbar {\n  position: absolute;\n  right: 0;\n  bottom: 0;\n  background-color: rgb(255 255 255 / 90%);\n  z-index: 0;\n}\n\n.sidebar-pane-section-toolbar.new-rule-toolbar {\n  visibility: hidden;\n}\n\n.styles-section:focus-visible .sidebar-pane-section-toolbar {\n  background-color: hsl(214deg 67% 95% / 90%);\n}\n\n.styles-pane:not(.is-editing-style) .styles-section.matched-styles:not(.read-only):hover .sidebar-pane-section-toolbar.new-rule-toolbar {\n  visibility: visible;\n}\n\n.sidebar-pane-section-toolbar.shifted-toolbar {\n  padding-right: 32px;\n}\n\n.styles-show-all {\n  margin-left: 16px;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  max-width: -webkit-fill-available;\n}\n\n@media (forced-colors: active) {\n  .styles-sidebar-pane-filter-box > input {\n    border: 1px solid ButtonText;\n    background: ButtonFace;\n  }\n\n  .styles-section:focus-visible,\n  .styles-section.read-only:focus-visible {\n    forced-color-adjust: none;\n    background-color: Highlight;\n  }\n\n  .styles-section .styles-section-subtitle .devtools-link {\n    color: linktext;\n    text-decoration-color: linktext;\n  }\n\n  .styles-section:focus-visible *,\n  .styles-section.read-only:focus-visible *,\n  .styles-section:focus-visible .styles-section-subtitle .devtools-link {\n    color: HighlightText;\n    text-decoration-color: HighlightText;\n  }\n\n  .sidebar-pane-section-toolbar {\n    forced-color-adjust: none;\n    border-color: 1px solid ButtonText;\n    background-color: ButtonFace;\n  }\n\n  .styles-section:focus-visible .sidebar-pane-section-toolbar {\n    background-color: ButtonFace;\n  }\n}\n\n.spinner::before {\n  --dimension: 24px;\n\n  margin-top: 2em;\n  left: calc(50% - var(--dimension) / 2);\n}\n\n/*# sourceURL=elements/stylesSidebarPane.css */");