import{UIString as t,ls as e,Color as s,Settings as i,Throttler as n,ObjectWrapper as o}from"../common/common.js";import{NumberUtilities as r,assertNever as a,ls as l}from"../platform/platform.js";import{UIUtils as h,Geometry as d,Widget as c,KeyboardShortcut as u,Context as p,ARIAUtils as _,Toolbar as m,Utils as g,Icon as v,GlassPane as f}from"../ui/ui.js";import{GetStylesheet as x,SetCSSProperty as S}from"../component_helpers/component_helpers.js";import*as w from"../third_party/lit-html/lit-html.js";import{render as b,html as y,Directives as C}from"../third_party/lit-html/lit-html.js";import{TextUtils as I}from"../text_utils/text_utils.js";import{DOMModel as E,SDKModel as P,RuntimeModel as T}from"../sdk/sdk.js";import{CSSOverviewModel as k}from"../css_overview/css_overview.js";class z{constructor(t,e,s,i,n){this.width=t,this.height=e,this.marginTop=s,this.radius=i,this.linearLine=n}static drawVelocityChart(t,e,s){const i=L;let n=["M",0,i];const o=1/40;let r=t.evaluateAt(0);for(let e=o;e<1.025;e+=o){const o=t.evaluateAt(e);let a=(o.y-r.y)/(o.x-r.x);const l=r.x*(1-e)+o.x*e;a=Math.tanh(a/1.5),n=n.concat(["L",(l*s).toFixed(2),(i-a*i).toFixed(2)]),r=o}n=n.concat(["L",s.toFixed(2),i,"Z"]),e.setAttribute("d",n.join(" "))}curveWidth(){return this.width-2*this.radius}curveHeight(){return this.height-2*this.radius-2*this.marginTop}_drawLine(t,e,s,i,n,o){const r=h.createSVGChild(t,"line",e);r.setAttribute("x1",String(s+this.radius)),r.setAttribute("y1",String(i+this.radius+this.marginTop)),r.setAttribute("x2",String(n+this.radius)),r.setAttribute("y2",String(o+this.radius+this.marginTop))}_drawControlPoints(t,e,s,i,n){this._drawLine(t,"bezier-control-line",e,s,i,n);const o=h.createSVGChild(t,"circle","bezier-control-circle");o.setAttribute("cx",String(i+this.radius)),o.setAttribute("cy",String(n+this.radius+this.marginTop)),o.setAttribute("r",String(this.radius))}drawCurve(t,e){if(!t)return;const s=this.curveWidth(),i=this.curveHeight();e.setAttribute("width",String(this.width)),e.setAttribute("height",String(this.height)),e.removeChildren();const n=h.createSVGChild(e,"g");this.linearLine&&this._drawLine(n,"linear-line",0,i,s,0);const o=h.createSVGChild(n,"path","bezier-path"),r=[new d.Point(t.controlPoints[0].x*s+this.radius,(1-t.controlPoints[0].y)*i+this.radius+this.marginTop),new d.Point(t.controlPoints[1].x*s+this.radius,(1-t.controlPoints[1].y)*i+this.radius+this.marginTop),new d.Point(s+this.radius,this.marginTop+this.radius)];o.setAttribute("d","M"+this.radius+","+(i+this.radius+this.marginTop)+" C"+r.join(" ")),this._drawControlPoints(n,0,i,t.controlPoints[0].x*s,(1-t.controlPoints[0].y)*i),this._drawControlPoints(n,s,0,t.controlPoints[1].x*s,(1-t.controlPoints[1].y)*i)}}const L=26;var M=Object.freeze({__proto__:null,BezierUI:z,Height:L});class A extends c.VBox{constructor(t){super(!0),this._bezier=t,this.registerRequiredCSS("inline_editor/bezierEditor.css",{enableLegacyPatching:!0}),this.contentElement.tabIndex=0,this.setDefaultFocusedElement(this.contentElement),this._previewElement=this.contentElement.createChild("div","bezier-preview-container"),this._previewElement.createChild("div","bezier-preview-animation"),this._previewElement.addEventListener("click",this._startPreviewAnimation.bind(this)),this._previewOnion=this.contentElement.createChild("div","bezier-preview-onion"),this._previewOnion.addEventListener("click",this._startPreviewAnimation.bind(this)),this._outerContainer=this.contentElement.createChild("div","bezier-container"),this._selectedCategory=null,this._presetsContainer=this._outerContainer.createChild("div","bezier-presets"),this._presetUI=new z(40,40,0,2,!1),this._presetCategories=[];for(let t=0;t<F.length;t++)this._presetCategories[t]=this._createCategory(F[t]),this._presetsContainer.appendChild(this._presetCategories[t].icon);this._curveUI=new z(150,250,50,7,!0),this._curve=h.createSVGChild(this._outerContainer,"svg","bezier-curve"),h.installDragHandle(this._curve,this._dragStart.bind(this),this._dragMove.bind(this),this._dragEnd.bind(this),"default"),this._header=this.contentElement.createChild("div","bezier-header");const e=this._createPresetModifyIcon(this._header,"bezier-preset-minus","M 12 6 L 8 10 L 12 14"),s=this._createPresetModifyIcon(this._header,"bezier-preset-plus","M 8 6 L 12 10 L 8 14");e.addEventListener("click",this._presetModifyClicked.bind(this,!1)),s.addEventListener("click",this._presetModifyClicked.bind(this,!0)),this._label=this._header.createChild("span","source-code bezier-display-value")}setBezier(t){t&&(this._bezier=t,this._updateUI())}bezier(){return this._bezier}wasShown(){this._unselectPresets();for(const t of this._presetCategories)for(let e=0;e<t.presets.length;e++)this._bezier.asCSSText()===t.presets[e].value&&(t.presetIndex=e,this._presetCategorySelected(t));this._updateUI(),this._startPreviewAnimation()}_onchange(){this._updateUI(),this.dispatchEventToListeners(B.BezierChanged,this._bezier.asCSSText())}_updateUI(){const e=this._selectedCategory?this._selectedCategory.presets[this._selectedCategory.presetIndex].name:this._bezier.asCSSText().replace(/\s(-\d\.\d)/g,"$1");this._label.textContent=t.UIString(e),this._curveUI.drawCurve(this._bezier,this._curve),this._previewOnion.removeChildren()}_dragStart(t){this._mouseDownPosition=new d.Point(t.x,t.y);const e=this._curveUI;this._controlPosition=new d.Point(r.clamp((t.offsetX-e.radius)/e.curveWidth(),0,1),(e.curveHeight()+e.marginTop+e.radius-t.offsetY)/e.curveHeight());const s=this._controlPosition.distanceTo(this._bezier.controlPoints[0])<this._controlPosition.distanceTo(this._bezier.controlPoints[1]);return this._selectedPoint=s?0:1,this._bezier.controlPoints[this._selectedPoint]=this._controlPosition,this._unselectPresets(),this._onchange(),t.consume(!0),!0}_updateControlPosition(t,e){if(void 0===this._mouseDownPosition||void 0===this._controlPosition||void 0===this._selectedPoint)return;const s=(t-this._mouseDownPosition.x)/this._curveUI.curveWidth(),i=(e-this._mouseDownPosition.y)/this._curveUI.curveHeight(),n=new d.Point(r.clamp(this._controlPosition.x+s,0,1),this._controlPosition.y-i);this._bezier.controlPoints[this._selectedPoint]=n}_dragMove(t){this._updateControlPosition(t.x,t.y),this._onchange()}_dragEnd(t){this._updateControlPosition(t.x,t.y),this._onchange(),this._startPreviewAnimation()}_createCategory(t){const e=document.createElement("div");e.classList.add("bezier-preset-category");const s=h.createSVGChild(e,"svg","bezier-preset monospace"),i={presets:t,presetIndex:0,icon:e};return this._presetUI.drawCurve(d.CubicBezier.parse(i.presets[0].value),s),s.addEventListener("click",this._presetCategorySelected.bind(this,i)),i}_createPresetModifyIcon(t,e,s){const i=h.createSVGChild(t,"svg","bezier-preset-modify "+e);i.setAttribute("width","20"),i.setAttribute("height","20");return h.createSVGChild(i,"path").setAttribute("d",s),i}_unselectPresets(){for(const t of this._presetCategories)t.icon.classList.remove("bezier-preset-selected");this._selectedCategory=null,this._header.classList.remove("bezier-header-active")}_presetCategorySelected(t,e){if(this._selectedCategory===t)return;this._unselectPresets(),this._header.classList.add("bezier-header-active"),this._selectedCategory=t,this._selectedCategory.icon.classList.add("bezier-preset-selected");const s=d.CubicBezier.parse(t.presets[t.presetIndex].value);s&&(this.setBezier(s),this._onchange(),this._startPreviewAnimation()),e&&e.consume(!0)}_presetModifyClicked(t,e){if(null===this._selectedCategory)return;const s=this._selectedCategory.presets.length;this._selectedCategory.presetIndex=(this._selectedCategory.presetIndex+(t?1:-1)+s)%s;const i=d.CubicBezier.parse(this._selectedCategory.presets[this._selectedCategory.presetIndex].value);i&&(this.setBezier(i),this._onchange(),this._startPreviewAnimation())}_startPreviewAnimation(){this._previewAnimation&&this._previewAnimation.cancel();const t=1600,e=[{offset:0,transform:"translateX(0px)",easing:this._bezier.asCSSText(),opacity:1},{offset:.9,transform:"translateX(218px)",opacity:1},{offset:1,transform:"translateX(218px)",opacity:0}];this._previewAnimation=this._previewElement.animate(e,t),this._previewOnion.removeChildren();for(let e=0;e<=20;e++){const s=this._previewOnion.createChild("div","bezier-preview-animation").animate([{transform:"translateX(0px)",easing:this._bezier.asCSSText()},{transform:"translateX(218px)"}],{duration:t,fill:"forwards"});s.pause(),s.currentTime=t*e/20}}}const B={BezierChanged:Symbol("BezierChanged")},F=[[{name:"ease-in-out",value:"ease-in-out"},{name:"In Out · Sine",value:"cubic-bezier(0.45, 0.05, 0.55, 0.95)"},{name:"In Out · Quadratic",value:"cubic-bezier(0.46, 0.03, 0.52, 0.96)"},{name:"In Out · Cubic",value:"cubic-bezier(0.65, 0.05, 0.36, 1)"},{name:"Fast Out, Slow In",value:"cubic-bezier(0.4, 0, 0.2, 1)"},{name:"In Out · Back",value:"cubic-bezier(0.68, -0.55, 0.27, 1.55)"}],[{name:"Fast Out, Linear In",value:"cubic-bezier(0.4, 0, 1, 1)"},{name:"ease-in",value:"ease-in"},{name:"In · Sine",value:"cubic-bezier(0.47, 0, 0.75, 0.72)"},{name:"In · Quadratic",value:"cubic-bezier(0.55, 0.09, 0.68, 0.53)"},{name:"In · Cubic",value:"cubic-bezier(0.55, 0.06, 0.68, 0.19)"},{name:"In · Back",value:"cubic-bezier(0.6, -0.28, 0.74, 0.05)"}],[{name:"ease-out",value:"ease-out"},{name:"Out · Sine",value:"cubic-bezier(0.39, 0.58, 0.57, 1)"},{name:"Out · Quadratic",value:"cubic-bezier(0.25, 0.46, 0.45, 0.94)"},{name:"Out · Cubic",value:"cubic-bezier(0.22, 0.61, 0.36, 1)"},{name:"Linear Out, Slow In",value:"cubic-bezier(0, 0, 0.2, 1)"},{name:"Out · Back",value:"cubic-bezier(0.18, 0.89, 0.32, 1.28)"}]];var O=Object.freeze({__proto__:null,BezierEditor:A,Events:B,Presets:F,PresetCategory:undefined});const R=e,U=x.getStyleSheets;class V extends Event{constructor(t,e){super("format-changed",{}),this.data={format:t,text:e}}}class N extends HTMLElement{constructor(){super(),this.shadow=this.attachShadow({mode:"open"}),this.tooltip=R`Shift-click to change color format`,this.text=null,this._color=null,this._format=null,this.shadow.adoptedStyleSheets=[...U("inline_editor/colorSwatch.css",{enableLegacyPatching:!1})]}static isColorSwatch(t){return"devtools-color-swatch"===t.localName}get color(){return this._color}get format(){return this._format}get anchorBox(){const t=this.shadow.querySelector(".color-swatch");return t?t.boxInWindow():null}renderColor(t,e,n){if("string"==typeof t){if(this._color=s.Color.parse(t),this.text=t,!this._color)return void this.renderTextOnly()}else this._color=t;this._format="boolean"==typeof e&&e?i.detectColorFormat(this._color):"string"==typeof e?e:this._color.format(),this.text=this._color.asString(this._format),n&&(this.tooltip=n),this.render()}renderTextOnly(){b(this.text,this.shadow,{eventContext:this})}render(){b(y`<span class="color-swatch" title="${this.tooltip}"><span class="color-swatch-inner"
        style="background-color:${this.text};"
        @click=${this.onClick}
        @mousedown=${this.consume}
        @dblclick=${this.consume}></span></span><slot><span>${this.text}</span></slot>`,this.shadow,{eventContext:this})}onClick(t){t.stopPropagation(),t.shiftKey?this.toggleNextFormat():this.dispatchEvent(new Event("swatch-click"))}consume(t){t.stopPropagation()}toggleNextFormat(){if(!this._color||!this._format)return;let t;do{this._format=$(this._color,this._format),t=this._color.asString(this._format)}while(t===this.text);t&&(this.text=t,this.render(),this.dispatchEvent(new V(this._format,this.text)))}}function $(t,e){const i=s.Format;switch(e){case i.Original:return t.hasAlpha()?i.RGBA:i.RGB;case i.RGB:case i.RGBA:return t.hasAlpha()?i.HSLA:i.HSL;case i.HSL:case i.HSLA:return t.nickname()?i.Nickname:t.detectHEXFormat();case i.ShortHEX:return i.HEX;case i.ShortHEXA:return i.HEXA;case i.HEXA:case i.HEX:return i.Original;case i.Nickname:return t.detectHEXFormat();default:return i.RGBA}}customElements.get("devtools-color-swatch")||customElements.define("devtools-color-swatch",N);var X=Object.freeze({__proto__:null,FormatChangedEvent:V,ColorSwatch:N});const H=/(?<value>[+-]?\d*\.?\d+)(?<unit>deg|grad|rad|turn)/,D=t=>{const e=t.match(H);return e&&e.groups?{value:Number(e.groups.value),unit:e.groups.unit}:null},Y=(t,e)=>{let s=t;switch(e){case"grad":s=d.radiansToGradians(t);break;case"deg":s=d.radiansToDegrees(t);break;case"turn":s=d.radiansToTurns(t)}return{value:s,unit:e}},j=t=>{switch(t.unit){case"deg":return d.degreesToRadians(t.value);case"grad":return d.gradiansToRadians(t.value);case"turn":return d.turnsToRadians(t.value)}return t.value},G=(t,e)=>{const s=j(t);return{translateX:Math.sin(s)*e,translateY:-Math.cos(s)*e}},K=t=>{let e=t.value;switch(t.unit){case"deg":case"grad":e=Math.round(t.value);break;case"rad":e=Math.round(1e4*t.value)/1e4;break;case"turn":e=Math.round(100*t.value)/100;break;default:a(t.unit,"Unknown angle unit: "+t.unit)}return{value:e,unit:t.unit}},W=t=>{switch(t){case"deg":return"grad";case"grad":return"rad";case"rad":return"turn";default:return"deg"}},q=(t,e)=>{if(t.unit===e)return t;const s=j(t);return Y(s,e)},Z=(t,e)=>{const s=h.getValueModificationDirection(e);if(null===s)return;let i="Up"===s?Math.PI/180:-Math.PI/180;e.shiftKey&&(i*=10);const n=j(t);return Y(n+i,t.unit)};var Q=Object.freeze({__proto__:null,CSSAngleRegex:H,parseText:D,getAngleFromRadians:Y,getRadiansFromAngle:j,get2DTranslationsForAngle:G,roundAngleByUnit:K,getNextUnit:W,convertAngleUnit:q,getNewAngleFromEvent:Z});const{render:J,html:tt}=w,et=C.styleMap;class st extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle={value:0,unit:"rad"},this.background="",this.clockRadius=38.5,this.mousemoveThrottler=new n.Throttler(16.67)}connectedCallback(){S.set(this,"--clock-dial-length","6px")}set data(t){this.angle=t.angle,this.onAngleUpdate=t.onAngleUpdate,this.background=t.background,this.render()}updateAngleFromMousePosition(t,e,s){const i=this.shadow.querySelector(".clock");if(!i||!this.onAngleUpdate)return;const{top:n,right:o,bottom:r,left:a}=i.getBoundingClientRect();this.clockRadius=(o-a)/2;const l=(a+o)/2,h=(r+n)/2,d=-Math.atan2(t-l,e-h)+Math.PI;if(s){const t=j({value:15,unit:"deg"}),e=Math.round(d/t)*t;this.onAngleUpdate(Y(e,this.angle.unit))}else this.onAngleUpdate(Y(d,this.angle.unit))}onEditorMousedown(t){t.stopPropagation(),this.updateAngleFromMousePosition(t.pageX,t.pageY,t.shiftKey)}onEditorMousemove(t){1===t.buttons&&this.mousemoveThrottler.schedule((()=>(this.updateAngleFromMousePosition(t.pageX,t.pageY,t.shiftKey),Promise.resolve())))}onEditorWheel(t){if(!this.onAngleUpdate)return;const e=Z(this.angle,t);e&&this.onAngleUpdate(e),t.preventDefault()}render(){const t={background:this.background},{translateX:e,translateY:s}=G(this.angle,this.clockRadius/2),i={transform:`translate(${e}px, ${s}px) rotate(${this.angle.value}${this.angle.unit})`};J(tt`
      <style>
        .clock, .pointer, .center, .hand, .dial {
          position: absolute;
        }

        .clock {
          top: 6px;
          width: 6em;
          height: 6em;
          background-color: var(--color-background);
          border: 0.5em solid var(--border-color);
          border-radius: 9em;
          box-shadow: var(--drop-shadow), inset 0 0 15px hsl(0 0% 0% / 25%);
          transform: translateX(-3em);
        }

        :host-context(.-theme-with-dark-background) .clock {
          background-color: hsl(225 5% 27%);
        }

        .pointer {
          margin: auto;
          top: 0;
          left: -0.4em;
          right: 0;
          width: 0;
          height: 0;
          border-style: solid;
          border-width: 0 0.9em 0.9em 0.9em;
          border-color: transparent transparent var(--border-color) transparent;
        }

        .center, .hand, .dial {
          margin: auto;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
        }

        .center, .hand {
          box-shadow: 0 0 2px hsl(0 0% 0% / 20%);
        }

        :host-context(.-theme-with-dark-background) .center,
        :host-context(.-theme-with-dark-background) .hand {
          box-shadow: 0 0 2px hsl(0 0% 0% / 60%);
        }

        .center {
          width: 0.7em;
          height: 0.7em;
          border-radius: 10px;
        }

        .dial {
          width: 2px;
          height: var(--clock-dial-length);
          background-color: var(--dial-color);
          border-radius: 1px;
        }

        .hand {
          height: 50%;
          width: 0.3em;
          background: var(--accent-fg-color);
        }

        .hand::before {
          content: '';
          display: inline-block;
          position: absolute;
          top: -0.6em;
          left: -0.35em;
          width: 1em;
          height: 1em;
          border-radius: 1em;
          cursor: pointer;
          box-shadow: 0 0 5px hsl(0 0% 0% / 30%);
        }

        :host-context(.-theme-with-dark-background) .hand::before {
          box-shadow: 0 0 5px hsl(0 0% 0% / 80%);
        }

        .hand::before,
        .center {
          background-color: var(--accent-fg-color);
        }
      </style>

      <div class="editor">
        <span class="pointer"></span>
        <div
          class="clock"
          style=${et(t)}
          @mousedown=${this.onEditorMousedown}
          @mousemove=${this.onEditorMousemove}
          @wheel=${this.onEditorWheel}>
          ${this.renderDials()}
          <div class="hand" style=${et(i)}></div>
          <span class="center"></span>
        </div>
      </div>
    `,this.shadow,{eventContext:this})}renderDials(){return this.dialTemplates||(this.dialTemplates=[0,45,90,135,180,225,270,315].map((t=>{const e=this.clockRadius-6-3,{translateX:s,translateY:i}=G({value:t,unit:"deg"},e);return tt`<span class="dial" style=${et({transform:`translate(${s}px, ${i}px) rotate(${t}deg)`})}></span>`}))),this.dialTemplates}}customElements.get("devtools-css-angle-editor")||customElements.define("devtools-css-angle-editor",st);const{render:it,html:nt}=w,ot=C.styleMap;class rt extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle={value:0,unit:"rad"}}set data(t){this.angle=t.angle,this.render()}render(){const{translateX:t,translateY:e}=G(this.angle,2.75),s={transform:`translate(${t}px, ${e}px) rotate(${this.angle.value}${this.angle.unit})`};it(nt`
      <style>
        .swatch {
          position: relative;
          display: inline-block;
          margin-bottom: -2px;
          width: 1em;
          height: 1em;
          border: 1px solid var(--selection-inactive-fg-color);
          border-radius: 1em;
          overflow: hidden;
          cursor: pointer;
          background-color: var(--toolbar-bg-color);
        }

        .mini-hand {
          position: absolute;
          margin: auto;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          height: 55%;
          width: 2px;
          background-color: var(--accent-fg-color);
          border-radius: 5px;
        }
      </style>

      <div class="swatch">
        <span class="mini-hand" style=${ot(s)}></span>
      </div>
    `,this.shadow,{eventContext:this})}}customElements.get("devtools-css-angle-swatch")||customElements.define("devtools-css-angle-swatch",rt);const{render:at,html:lt}=w,ht=C.styleMap,dt=new Set(["color","background","background-color"]);class ct extends Event{constructor(t){super("popover-toggled",{}),this.data={open:t}}}class ut extends Event{constructor(t){super("value-changed",{}),this.data={value:t}}}class pt extends Event{constructor(t){super("unit-changed",{}),this.data={value:t}}}const _t={value:0,unit:"rad"};class mt extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle=_t,this.displayedAngle=_t,this.propertyName="",this.propertyValue="",this.angleElement=null,this.swatchElement=null,this.popoverOpen=!1,this.popoverStyleTop="",this.onMinifyingAction=this.minify.bind(this),this.onAngleUpdate=this.updateAngle.bind(this)}set data(t){const e=D(t.angleText);e&&(this.angle=e,this.displayedAngle={...e},this.propertyName=t.propertyName,this.propertyValue=t.propertyValue,this.containingPane=t.containingPane,this.render())}disconnectedCallback(){this.unbindMinifyingAction()}popover(){if(!this.containingPane)return;if(this.angleElement||(this.angleElement=this.shadow.querySelector(".css-angle")),this.swatchElement||(this.swatchElement=this.shadow.querySelector("devtools-css-angle-swatch")),!this.angleElement||!this.swatchElement)return;this.dispatchEvent(new ct(!0)),this.bindMinifyingAction();const t=this.swatchElement.getBoundingClientRect().bottom;if(t){const e=this.containingPane.getBoundingClientRect().top;this.popoverStyleTop=t-e+"px"}this.popoverOpen=!0,this.render(),this.angleElement.focus()}minify(){!1!==this.popoverOpen&&(this.popoverOpen=!1,this.dispatchEvent(new ct(!1)),this.unbindMinifyingAction(),this.render())}updateProperty(t,e){this.propertyName=t,this.propertyValue=e,this.render()}updateAngle(t){this.displayedAngle=K(q(t,this.displayedAngle.unit)),this.angle=this.displayedAngle,this.dispatchEvent(new ut(`${this.angle.value}${this.angle.unit}`))}displayNextUnit(){const t=W(this.displayedAngle.unit);this.displayedAngle=K(q(this.angle,t)),this.dispatchEvent(new pt(`${this.displayedAngle.value}${this.displayedAngle.unit}`))}bindMinifyingAction(){document.addEventListener("mousedown",this.onMinifyingAction),this.containingPane&&this.containingPane.addEventListener("scroll",this.onMinifyingAction)}unbindMinifyingAction(){document.removeEventListener("mousedown",this.onMinifyingAction),this.containingPane&&this.containingPane.removeEventListener("scroll",this.onMinifyingAction)}onMiniIconClick(t){t.stopPropagation(),!t.shiftKey||this.popoverOpen?this.popoverOpen?this.minify():this.popover():this.displayNextUnit()}consume(t){t.stopPropagation()}onKeydown(t){if(this.popoverOpen)switch(t.key){case"Escape":t.stopPropagation(),this.minify(),this.blur();break;case"ArrowUp":case"ArrowDown":{const e=Z(this.angle,t);e&&this.updateAngle(e),t.preventDefault();break}}}render(){at(lt`
      <style>
        .css-angle {
          display: inline-block;
          position: relative;
          outline: none;
        }

        devtools-css-angle-swatch {
          display: inline-block;
          margin-right: 2px;
          user-select: none;
        }

        devtools-css-angle-editor {
          --dial-color: #a3a3a3;
          --border-color: var(--toolbar-bg-color);
          position: fixed;
          z-index: 2;
        }
      </style>

      <div class="css-angle" @keydown=${this.onKeydown} tabindex="-1">
        <div class="preview">
          <devtools-css-angle-swatch
            @click=${this.onMiniIconClick}
            @mousedown=${this.consume}
            @dblclick=${this.consume}
            .data=${{angle:this.angle}}>
          </devtools-css-angle-swatch><slot></slot>
        </div>
        ${this.popoverOpen?this.renderPopover():null}
      </div>
    `,this.shadow,{eventContext:this})}renderPopover(){let t="";return dt.has(this.propertyName)&&!this.propertyValue.match(/url\(.*\)/i)&&(t=this.propertyValue),lt`
    <devtools-css-angle-editor
      class="popover popover-css-angle"
      style=${ht({top:this.popoverStyleTop})}
      .data=${{angle:this.angle,onAngleUpdate:this.onAngleUpdate,background:t}}
    ></devtools-css-angle-editor>
    `}}customElements.get("devtools-css-angle")||customElements.define("devtools-css-angle",mt);var gt=Object.freeze({__proto__:null,PopoverToggledEvent:ct,ValueChangedEvent:ut,UnitChangedEvent:pt,CSSAngle:mt});class vt{constructor(t){this._isBoxShadow=t,this._inset=!1,this._offsetX=xt.zero(),this._offsetY=xt.zero(),this._blurRadius=xt.zero(),this._spreadRadius=xt.zero(),this._color=s.Color.parse("black"),this._format=[ft.OffsetX,ft.OffsetY],this._important=!1}static parseTextShadow(t){return vt._parseShadow(t,!1)}static parseBoxShadow(t){return vt._parseShadow(t,!0)}static _parseShadow(t,e){const i=[],n=I.Utils.splitStringByRegexes(t,[s.Regex,/,/g]);let o=0;for(let e=0;e<n.length;e++)if(1===n[e].regexIndex){const s=n[e];i.push(t.substring(o,s.position)),o=s.position+1}i.push(t.substring(o,t.length));const r=[];for(let t=0;t<i.length;t++){const n=new vt(e);n._format=[];let o=!0;const l=[/!important/gi,/inset/gi,s.Regex,xt.Regex],h=I.Utils.splitStringByRegexes(i[t],l);for(let t=0;t<h.length;t++){const e=h[t];if(-1===e.regexIndex){if(/\S/.test(e.value))return[];o=!0}else{if(!o)return[];if(o=!1,0===e.regexIndex)n._important=!0,n._format.push(ft.Important);else if(1===e.regexIndex)n._inset=!0,n._format.push(ft.Inset);else if(2===e.regexIndex){const t=s.Color.parse(e.value);if(!t)return[];n._color=t,n._format.push(ft.Color)}else if(3===e.regexIndex){const t=xt.parse(e.value);if(!t)return[];const s=n._format.length>0?n._format[n._format.length-1]:"";s===ft.OffsetX?(n._offsetY=t,n._format.push(ft.OffsetY)):s===ft.OffsetY?(n._blurRadius=t,n._format.push(ft.BlurRadius)):s===ft.BlurRadius?(n._spreadRadius=t,n._format.push(ft.SpreadRadius)):(n._offsetX=t,n._format.push(ft.OffsetX))}}}if(a(n,ft.OffsetX,1,1)||a(n,ft.OffsetY,1,1)||a(n,ft.Color,0,1)||a(n,ft.BlurRadius,0,1)||a(n,ft.Inset,0,e?1:0)||a(n,ft.SpreadRadius,0,e?1:0)||a(n,ft.Important,0,1))return[];r.push(n)}return r;function a(t,e,s,i){let n=0;for(let s=0;s<t._format.length;s++)t._format[s]===e&&n++;return n<s||n>i}}setInset(t){this._inset=t,-1===this._format.indexOf(ft.Inset)&&this._format.unshift(ft.Inset)}setOffsetX(t){this._offsetX=t}setOffsetY(t){this._offsetY=t}setBlurRadius(t){if(this._blurRadius=t,-1===this._format.indexOf(ft.BlurRadius)){const t=this._format.indexOf(ft.OffsetY);this._format.splice(t+1,0,ft.BlurRadius)}}setSpreadRadius(t){if(this._spreadRadius=t,-1===this._format.indexOf(ft.SpreadRadius)){this.setBlurRadius(this._blurRadius);const t=this._format.indexOf(ft.BlurRadius);this._format.splice(t+1,0,ft.SpreadRadius)}}setColor(t){this._color=t,-1===this._format.indexOf(ft.Color)&&this._format.push(ft.Color)}isBoxShadow(){return this._isBoxShadow}inset(){return this._inset}offsetX(){return this._offsetX}offsetY(){return this._offsetY}blurRadius(){return this._blurRadius}spreadRadius(){return this._spreadRadius}color(){return this._color}asCSSText(){const t=[];for(let e=0;e<this._format.length;e++){const s=this._format[e];s===ft.Inset&&this._inset?t.push("inset"):s===ft.OffsetX?t.push(this._offsetX.asCSSText()):s===ft.OffsetY?t.push(this._offsetY.asCSSText()):s===ft.BlurRadius?t.push(this._blurRadius.asCSSText()):s===ft.SpreadRadius?t.push(this._spreadRadius.asCSSText()):s===ft.Color?t.push(this._color.asString(this._color.format())):s===ft.Important&&this._important&&t.push("!important")}return t.join(" ")}}const ft={Inset:"I",OffsetX:"X",OffsetY:"Y",BlurRadius:"B",SpreadRadius:"S",Color:"C",Important:"M"};class xt{constructor(t,e){this.amount=t,this.unit=e}static parse(t){const e=new RegExp("^(?:"+xt.Regex.source+")$","i"),s=t.match(e);return s?s.length>2&&s[2]?new xt(parseFloat(s[1]),s[2]):xt.zero():null}static zero(){return new xt(0,"")}asCSSText(){return this.amount+this.unit}}xt.Regex=new RegExp("([+-]?(?:[0-9]*[.])?[0-9]+(?:[eE][+-]?[0-9]+)?)(ch|cm|em|ex|in|mm|pc|pt|px|rem|vh|vmax|vmin|vw)|[+-]?(?:0*[.])?0+(?:[eE][+-]?[0-9]+)?","gi");var St=Object.freeze({__proto__:null,CSSShadowModel:vt,_Part:ft,CSSLength:xt});class wt extends c.VBox{constructor(){super(!0),this.registerRequiredCSS("inline_editor/cssShadowEditor.css",{enableLegacyPatching:!0}),this.contentElement.tabIndex=0,this.setDefaultFocusedElement(this.contentElement),this._typeField=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field"),this._typeField.createChild("label","shadow-editor-label").textContent=t.UIString("Type"),this._outsetButton=this._typeField.createChild("button","shadow-editor-button-left"),this._outsetButton.textContent=t.UIString("Outset"),this._outsetButton.addEventListener("click",this._onButtonClick.bind(this),!1),this._insetButton=this._typeField.createChild("button","shadow-editor-button-right"),this._insetButton.textContent=t.UIString("Inset"),this._insetButton.addEventListener("click",this._onButtonClick.bind(this),!1);const e=this.contentElement.createChild("div","shadow-editor-field");this._xInput=this._createTextInput(e,t.UIString("X offset"));const s=this.contentElement.createChild("div","shadow-editor-field");this._yInput=this._createTextInput(s,t.UIString("Y offset")),this._xySlider=e.createChild("canvas","shadow-editor-2D-slider"),this._xySlider.width=88,this._xySlider.height=88,this._xySlider.tabIndex=-1,this._halfCanvasSize=44,this._innerCanvasSize=this._halfCanvasSize-6,h.installDragHandle(this._xySlider,this._dragStart.bind(this),this._dragMove.bind(this),null,"default"),this._xySlider.addEventListener("keydown",this._onCanvasArrowKey.bind(this),!1),this._xySlider.addEventListener("blur",this._onCanvasBlur.bind(this),!1);const i=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field shadow-editor-blur-field");this._blurInput=this._createTextInput(i,t.UIString("Blur")),this._blurSlider=this._createSlider(i),this._spreadField=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field"),this._spreadInput=this._createTextInput(this._spreadField,t.UIString("Spread")),this._spreadSlider=this._createSlider(this._spreadField),this._model,this._canvasOrigin}_createTextInput(t,e){const s=t.createChild("label","shadow-editor-label");s.textContent=e,s.setAttribute("for",e);const i=h.createInput("shadow-editor-text-input","text");return t.appendChild(i),i.id=e,i.addEventListener("keydown",this._handleValueModification.bind(this),!1),i.addEventListener("mousewheel",this._handleValueModification.bind(this),!1),i.addEventListener("input",this._onTextInput.bind(this),!1),i.addEventListener("blur",this._onTextBlur.bind(this),!1),i}_createSlider(t){const e=h.createSlider(0,20,-1);return e.addEventListener("input",this._onSliderInput.bind(this),!1),t.appendChild(e),e}wasShown(){this._updateUI()}setModel(t){this._model=t,this._typeField.classList.toggle("hidden",!t.isBoxShadow()),this._spreadField.classList.toggle("hidden",!t.isBoxShadow()),this._updateUI()}_updateUI(){this._updateButtons(),this._xInput.value=this._model.offsetX().asCSSText(),this._yInput.value=this._model.offsetY().asCSSText(),this._blurInput.value=this._model.blurRadius().asCSSText(),this._spreadInput.value=this._model.spreadRadius().asCSSText(),this._blurSlider.value=this._model.blurRadius().amount.toString(),this._spreadSlider.value=this._model.spreadRadius().amount.toString(),this._updateCanvas(!1)}_updateButtons(){this._insetButton.classList.toggle("enabled",this._model.inset()),this._outsetButton.classList.toggle("enabled",!this._model.inset())}_updateCanvas(t){const e=this._xySlider.getContext("2d");if(!e)throw new Error("Unable to obtain canvas context");e.clearRect(0,0,this._xySlider.width,this._xySlider.height),e.save(),e.setLineDash([1,1]),e.strokeStyle="rgba(210, 210, 210, 0.8)",e.beginPath(),e.moveTo(this._halfCanvasSize,0),e.lineTo(this._halfCanvasSize,88),e.moveTo(0,this._halfCanvasSize),e.lineTo(88,this._halfCanvasSize),e.stroke(),e.restore();const s=this._sliderThumbPosition();e.save(),e.translate(this._halfCanvasSize,this._halfCanvasSize),e.lineWidth=2,e.strokeStyle="rgba(130, 130, 130, 0.75)",e.beginPath(),e.moveTo(0,0),e.lineTo(s.x,s.y),e.stroke(),t&&(e.beginPath(),e.fillStyle="rgba(66, 133, 244, 0.4)",e.arc(s.x,s.y,8,0,2*Math.PI),e.fill()),e.beginPath(),e.fillStyle="#4285F4",e.arc(s.x,s.y,6,0,2*Math.PI),e.fill(),e.restore()}_onButtonClick(t){const e=t.currentTarget===this._insetButton;e&&this._model.inset()||!e&&!this._model.inset()||(this._model.setInset(e),this._updateButtons(),this.dispatchEventToListeners(bt.ShadowChanged,this._model))}_handleValueModification(t){const e=t.currentTarget,s=h.createReplacementString(e.value,t,(function(t,e,s){s.length||(s="px");return t+e+s}));if(!s)return;const i=xt.parse(s);i&&(t.currentTarget===this._blurInput&&i.amount<0&&(i.amount=0),e.value=i.asCSSText(),e.selectionStart=0,e.selectionEnd=e.value.length,this._onTextInput(t),t.consume(!0))}_onTextInput(t){const e=t.currentTarget;this._changedElement=e,this._changedElement.classList.remove("invalid");const s=xt.parse(e.value);!s||e===this._blurInput&&s.amount<0||(e===this._xInput?(this._model.setOffsetX(s),this._updateCanvas(!1)):e===this._yInput?(this._model.setOffsetY(s),this._updateCanvas(!1)):e===this._blurInput?(this._model.setBlurRadius(s),this._blurSlider.value=s.amount.toString()):e===this._spreadInput&&(this._model.setSpreadRadius(s),this._spreadSlider.value=s.amount.toString()),this.dispatchEventToListeners(bt.ShadowChanged,this._model))}_onTextBlur(){if(!this._changedElement)return;let t=this._changedElement.value.trim()?xt.parse(this._changedElement.value):xt.zero();if(t||(t=xt.parse(this._changedElement.value+"px")),!t)return this._changedElement.classList.add("invalid"),void(this._changedElement=null);this._changedElement===this._xInput?(this._model.setOffsetX(t),this._xInput.value=t.asCSSText(),this._updateCanvas(!1)):this._changedElement===this._yInput?(this._model.setOffsetY(t),this._yInput.value=t.asCSSText(),this._updateCanvas(!1)):this._changedElement===this._blurInput?(t.amount<0&&(t=xt.zero()),this._model.setBlurRadius(t),this._blurInput.value=t.asCSSText(),this._blurSlider.value=t.amount.toString()):this._changedElement===this._spreadInput&&(this._model.setSpreadRadius(t),this._spreadInput.value=t.asCSSText(),this._spreadSlider.value=t.amount.toString()),this._changedElement=null,this.dispatchEventToListeners(bt.ShadowChanged,this._model)}_onSliderInput(t){t.currentTarget===this._blurSlider?(this._model.setBlurRadius(new xt(Number(this._blurSlider.value),this._model.blurRadius().unit||"px")),this._blurInput.value=this._model.blurRadius().asCSSText(),this._blurInput.classList.remove("invalid")):t.currentTarget===this._spreadSlider&&(this._model.setSpreadRadius(new xt(Number(this._spreadSlider.value),this._model.spreadRadius().unit||"px")),this._spreadInput.value=this._model.spreadRadius().asCSSText(),this._spreadInput.classList.remove("invalid")),this.dispatchEventToListeners(bt.ShadowChanged,this._model)}_dragStart(t){this._xySlider.focus(),this._updateCanvas(!0),this._canvasOrigin=new d.Point(this._xySlider.totalOffsetLeft()+this._halfCanvasSize,this._xySlider.totalOffsetTop()+this._halfCanvasSize);const e=new d.Point(t.x-this._canvasOrigin.x,t.y-this._canvasOrigin.y),s=this._sliderThumbPosition();return e.distanceTo(s)>=6&&this._dragMove(t),!0}_dragMove(t){let e=new d.Point(t.x-this._canvasOrigin.x,t.y-this._canvasOrigin.y);t.shiftKey&&(e=this._snapToClosestDirection(e));const s=this._constrainPoint(e,this._innerCanvasSize),i=Math.round(s.x/this._innerCanvasSize*20),n=Math.round(s.y/this._innerCanvasSize*20);t.shiftKey?(this._model.setOffsetX(new xt(i,this._model.offsetX().unit||"px")),this._model.setOffsetY(new xt(n,this._model.offsetY().unit||"px"))):(t.altKey||this._model.setOffsetX(new xt(i,this._model.offsetX().unit||"px")),u.KeyboardShortcut.eventHasCtrlOrMeta(t)||this._model.setOffsetY(new xt(n,this._model.offsetY().unit||"px"))),this._xInput.value=this._model.offsetX().asCSSText(),this._yInput.value=this._model.offsetY().asCSSText(),this._xInput.classList.remove("invalid"),this._yInput.classList.remove("invalid"),this._updateCanvas(!0),this.dispatchEventToListeners(bt.ShadowChanged,this._model)}_onCanvasBlur(){this._updateCanvas(!1)}_onCanvasArrowKey(t){const e=t;let s=0,i=0;if("ArrowRight"===e.key?s=1:"ArrowLeft"===e.key?s=-1:"ArrowUp"===e.key?i=-1:"ArrowDown"===e.key&&(i=1),s||i){if(t.consume(!0),s){const t=this._model.offsetX(),e=r.clamp(t.amount+s,-20,20);if(e===t.amount)return;this._model.setOffsetX(new xt(e,t.unit||"px")),this._xInput.value=this._model.offsetX().asCSSText(),this._xInput.classList.remove("invalid")}if(i){const t=this._model.offsetY(),e=r.clamp(t.amount+i,-20,20);if(e===t.amount)return;this._model.setOffsetY(new xt(e,t.unit||"px")),this._yInput.value=this._model.offsetY().asCSSText(),this._yInput.classList.remove("invalid")}this._updateCanvas(!0),this.dispatchEventToListeners(bt.ShadowChanged,this._model)}}_constrainPoint(t,e){return Math.abs(t.x)<=e&&Math.abs(t.y)<=e?new d.Point(t.x,t.y):t.scale(e/Math.max(Math.abs(t.x),Math.abs(t.y)))}_snapToClosestDirection(t){let e=Number.MAX_VALUE,s=t;const i=[new d.Point(0,-1),new d.Point(1,-1),new d.Point(1,0),new d.Point(1,1)];for(const n of i){const i=t.projectOn(n),o=t.distanceTo(i);o<e&&(e=o,s=i)}return s}_sliderThumbPosition(){const t=this._model.offsetX().amount/20*this._innerCanvasSize,e=this._model.offsetY().amount/20*this._innerCanvasSize;return this._constrainPoint(new d.Point(t,e),this._innerCanvasSize)}}const bt={ShadowChanged:Symbol("ShadowChanged")};var yt=Object.freeze({__proto__:null,CSSShadowEditor:wt,Events:bt});const{render:Ct,html:It,Directives:Et}=w,Pt=e,Tt=/(var\()(\s*--[^,)]+)(.*)/;class kt extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.text="",this.computedValue=null,this.fromFallback=!1,this.onLinkClick=()=>{}}set data(t){this.text=t.text,this.computedValue=t.computedValue,this.fromFallback=t.fromFallback,this.onLinkClick=t.onLinkClick,this.render()}parseVariableFunctionParts(){const t=this.text.replace(/\s{2,}/g," ").match(Tt);return t?{pre:t[1],name:t[2],post:t[3]}:null}get variableName(){const t=this.text.match(/--[^,)]+/);return t?t[0]:""}renderLink(t){const e=this.computedValue&&!this.fromFallback,s=Et.classMap({"css-var-link":!0,undefined:!e}),i=e?Pt`Jump to definition`:Pt`${t} is not defined`,n=e?this.onLinkClick.bind(this,this.variableName.trim()):null;return It`<span class="${s}" title="${i}" @mousedown=${n} role="link" tabindex="-1">${t}</span>`}render(){const t=this.parseVariableFunctionParts();if(!t)return void Ct("",this.shadow,{eventContext:this});const e=this.renderLink(t.name);Ct(It`<style>
      .css-var-link:not(.undefined) {
        cursor: pointer;
        text-decoration: underline;
        text-underline-position: under;
      }

      .css-var-link:focus:not(:focus-visible) {
        outline: none;
      }
      </style><span title="${this.computedValue||""}">${t.pre}${e}${t.post}</span>`,this.shadow,{eventContext:this})}}customElements.get("devtools-css-var-swatch")||customElements.define("devtools-css-var-swatch",kt);var zt=Object.freeze({__proto__:null,CSSVarSwatch:kt});async function Lt(t){const e=p.Context.instance().flavor(E.DOMNode);let s;if(e&&e.parentNode&&"HTML"!==e.nodeName()){const[i]=P.TargetManager.instance().models(k.CSSOverviewModel),n=t?e.parentNode.id:e.id,o=(await i.getComputedStyleForNode(n).then(Mt)).replace(/[a-z]/g,"");s=parseFloat(o)}else s=16;return s}function Mt(t){const e=t.computedStyle;let s=6;if(e[s].name&&"font-size"!==e[s].name)for(let t=0;t<e.length;t++)if("font-size"===e[t].name){s=t;break}return e[s].value}const At={expression:"window.innerWidth",objectGroup:void 0,includeCommandLineAPI:!1,silent:!0,contextId:void 0,returnByValue:!1,generatePreview:!1,userGesture:!1,awaitPromise:!0,throwOnSideEffect:!1,timeout:void 0,disableBreaks:!0,replMode:!1,allowUnsafeEvalBlockedByCSP:!1},Bt={expression:"window.innerHeight",objectGroup:void 0,includeCommandLineAPI:!1,silent:!0,contextId:void 0,returnByValue:!1,generatePreview:!1,userGesture:!1,awaitPromise:!0,throwOnSideEffect:!1,timeout:void 0,disableBreaks:!0,replMode:!1,allowUnsafeEvalBlockedByCSP:!1};async function Ft(){const t=p.Context.instance().flavor(T.ExecutionContext);let e,s;if(t){const i=await t.evaluate(At,!1,!1),n=await t.evaluate(Bt,!1,!1);if("error"in i||"error"in n)return null;i.object&&(e=i.object.value),n.object&&(s=n.object.value)}if(void 0===e||void 0===s){const t=p.Context.instance().flavor(E.DOMNode);if(!t)return null;const i=await t.domModel().target().pageAgent().invoke_getLayoutMetrics(),n=i.visualViewport.zoom?i.visualViewport.zoom:1;s=i.visualViewport.clientHeight/n,e=i.visualViewport.clientWidth/n}return{width:e,height:s}}const Ot=new Map;async function Rt(t,e,s){let i,n;""===t&&(t="em"),""===e&&(e="em");const o=Ot.get(t),r=Ot.get(e);return o&&r?(i="em"===t||"%"===t?await o(s):await o(),n="em"===e||"%"===e?await r(s):await r(),i/n):1}Ot.set("px",(function(){return 1})),Ot.set("em",Lt),Ot.set("rem",(async function(){const t=function(t){let e=t;for(;e&&"HTML"!==e.nodeName()&&e.parentNode;)e=e.parentNode;return e}(p.Context.instance().flavor(E.DOMNode));if(!t||!t.id)return 16;const[e]=P.TargetManager.instance().models(k.CSSOverviewModel),s=(await e.getComputedStyleForNode(t.id).then(Mt)).replace(/[a-z]/g,"");return parseFloat(s)})),Ot.set("%",(async function(t){return await Lt(t)/100})),Ot.set("vh",(async function(){const t=await Ft();return t?t.height/100:1})),Ot.set("vw",(async function(){const t=await Ft();return t?t.width/100:1})),Ot.set("vmin",(async function(){const t=await Ft();if(!t)return 1;const e=t.width,s=t.height;return Math.min(e,s)/100})),Ot.set("vmax",(async function(){const t=await Ft();if(!t)return 1;const e=t.width,s=t.height;return Math.max(e,s)/100})),Ot.set("cm",(function(){return 37.795})),Ot.set("mm",(function(){return 3.7795})),Ot.set("in",(function(){return 96})),Ot.set("pt",(function(){return 4/3})),Ot.set("pc",(function(){return 16}));var Ut=Object.freeze({__proto__:null,getUnitConversionMultiplier:Rt});const Vt=new Set(["px","em","rem","%","vh","vw"]),Nt=new Set(["","px","em","%"]),$t=new Set(["em","rem","px"]),Xt=["","xx-small","x-small","smaller","small","medium","large","larger","x-large","xx-large"],Ht=["","normal"],Dt=["","lighter","normal","bold","bolder"],Yt=["","normal"],jt=["inherit","initial","unset"];Xt.push(...jt),Ht.push(...jt),Dt.push(...jt),Yt.push(...jt);const Gt=new Set(Xt),Kt=new Set(Ht),Wt=new Set(Dt),qt=new Set(Yt),Zt=new Map([["px",{min:0,max:72,step:1}],["em",{min:0,max:4.5,step:.1}],["rem",{min:0,max:4.5,step:.1}],["%",{min:0,max:450,step:1}],["vh",{min:0,max:10,step:.1}],["vw",{min:0,max:10,step:.1}],["vmin",{min:0,max:10,step:.1}],["vmax",{min:0,max:10,step:.1}],["cm",{min:0,max:2,step:.1}],["mm",{min:0,max:20,step:.1}],["in",{min:0,max:1,step:.01}],["pt",{min:0,max:54,step:1}],["pc",{min:0,max:4.5,step:.1}]]),Qt=new Map([["",{min:0,max:2,step:.1}],["em",{min:0,max:2,step:.1}],["%",{min:0,max:200,step:1}],["px",{min:0,max:32,step:1}],["rem",{min:0,max:2,step:.1}],["vh",{min:0,max:4.5,step:.1}],["vw",{min:0,max:4.5,step:.1}],["vmin",{min:0,max:4.5,step:.1}],["vmax",{min:0,max:4.5,step:.1}],["cm",{min:0,max:1,step:.1}],["mm",{min:0,max:8.5,step:.1}],["in",{min:0,max:.5,step:.1}],["pt",{min:0,max:24,step:1}],["pc",{min:0,max:2,step:.1}]]),Jt=new Map([["",{min:100,max:700,step:100}]]),te=new Map([["px",{min:-10,max:10,step:.01}],["em",{min:-.625,max:.625,step:.001}],["rem",{min:-.625,max:.625,step:.001}],["%",{min:-62.5,max:62.5,step:.1}],["vh",{min:-1.5,max:1.5,step:.01}],["vw",{min:-1.5,max:1.5,step:.01}],["vmin",{min:-1.5,max:1.5,step:.01}],["vmax",{min:-1.5,max:1.5,step:.01}],["cm",{min:-.25,max:.025,step:.001}],["mm",{min:-2.5,max:2.5,step:.01}],["in",{min:-.1,max:.1,step:.001}],["pt",{min:-7.5,max:7.5,step:.01}],["pc",{min:-.625,max:.625,step:.001}]]),ee={regex:/(^[\+\d\.]+)([a-zA-Z%]+)/,units:Vt,keyValues:Gt,rangeMap:Zt,defaultUnit:"px"},se={regex:/(^[\+\d\.]+)([a-zA-Z%]*)/,units:Nt,keyValues:Kt,rangeMap:Qt,defaultUnit:""},ie={regex:/(^[\+\d\.]+)/,units:null,keyValues:Wt,rangeMap:Jt,defaultUnit:null},ne={regex:/([\+-0-9\.]+)([a-zA-Z%]+)/,units:$t,keyValues:qt,rangeMap:te,defaultUnit:"em"},oe=["Arial","Bookman","Candara","Comic Sans MS","Courier New","Garamond","Georgia","Helvetica","Impact","Palatino","Roboto","Times New Roman","Verdana"],re=["serif","sans-serif","monspace","cursive","fantasy","system-ui","ui-serif","ui-sans-serif","ui-monospace","ui-rounded","emoji","math","fangsong"];async function ae(){const t=P.TargetManager.instance().models(k.CSSOverviewModel);if(t){const e=t[0];if(e){const{fontInfo:t}=await Promise.resolve(e.getNodeStyleStats());return Array.from(t.keys())}}return[]}function le(t){switch(t){case 1:return 0;case.1:return 1;case.01:return 2;case.001:return 3;default:return 0}}var he=Object.freeze({__proto__:null,FontPropertiesRegex:/^[^- ][a-zA-Z-]+|-?\+?(?:[0-9]+\.[0-9]+|\.[0-9]+|[0-9]+)[a-zA-Z%]{0,4}/,FontFamilyRegex:/(?:"[\w \,-]+",? ?|'[\w \,-]+',? ?|[\w \,-]+,? ?)+/,GlobalValues:jt,FontSizeStaticParams:ee,LineHeightStaticParams:se,FontWeightStaticParams:ie,LetterSpacingStaticParams:ne,SystemFonts:oe,GenericFonts:re,generateComputedFontArray:ae,getRoundingPrecision:le});class de extends c.VBox{constructor(t){super(!0),this.registerRequiredCSS("inline_editor/fontEditor.css",{enableLegacyPatching:!0}),this._selectedNode=p.Context.instance().flavor(E.DOMNode),this._propertyMap=t,this.contentElement.tabIndex=0,this.setDefaultFocusedElement(this.contentElement),this._fontSelectorSection=this.contentElement.createChild("div","font-selector-section"),this._fontSelectorSection.createChild("h2","font-section-header").textContent=l`Font Family`,this._fontSelectors=[],this._fontsList=null;const e=this._propertyMap.get("font-family");this._createFontSelectorSection(e);const s=this.contentElement.createChild("div","font-section");s.createChild("h2","font-section-header").textContent=l`CSS Properties`;const i=this._getPropertyInfo("font-size",ee.regex),n=this._getPropertyInfo("line-height",se.regex),o=this._getPropertyInfo("font-weight",ie.regex),r=this._getPropertyInfo("letter-spacing",ne.regex);new ue("font-size",l`Font Size`,s,i,ee,this._updatePropertyValue.bind(this),this._resizePopout.bind(this),!0),new ue("line-height",l`Line Height`,s,n,se,this._updatePropertyValue.bind(this),this._resizePopout.bind(this),!0),new ue("font-weight",l`Font Weight`,s,o,ie,this._updatePropertyValue.bind(this),this._resizePopout.bind(this),!1),new ue("letter-spacing",l`Spacing`,s,r,ne,this._updatePropertyValue.bind(this),this._resizePopout.bind(this),!0)}async _createFontSelectorSection(t){if(t){const e=t.split(",");if(await this._createFontSelector(e[0],!0),!jt.includes(e[0]))for(let t=1;t<e.length+1;t++)this._createFontSelector(e[t])}else this._createFontSelector("",!0);this._resizePopout()}async _createFontsList(){const t=await ae(),e=new Map,s=this._splitComputedFontArray(t);e.set("Computed Fonts",s);const i=new Map;i.set("System Fonts",oe),i.set("Generic Families",re);const n=[];return n.push(e),n.push(i),n}_splitComputedFontArray(t){const e=[];for(const s of t)if(s.includes(",")){s.split(",").forEach((t=>{-1===e.findIndex((e=>e.toLowerCase()===t.trim().toLowerCase().replace(/"/g,"'")))&&e.push(t.trim().replace(/"/g,""))}))}else-1===e.findIndex((t=>t.toLowerCase()===s.toLowerCase().replace('"',"'")))&&e.push(s.replace(/"/g,""));return e}async _createFontSelector(t,e){if(t=t?t.trim():""){const e=t.charAt(0);"'"===e?t=t.replace(/'/g,""):'"'===e&&(t=t.replace(/"/g,""))}const s=this._fontSelectorSection.createChild("div","shadow-editor-field shadow-editor-flex-field");let i;if(this._fontsList||(this._fontsList=await this._createFontsList()),e){i=l`Font Family`;const e=new Map([["Global Values",jt]]),n=[...this._fontsList];n.push(e),this._createSelector(s,i,n,t.trim())}else i=l`Fallback ${this._fontSelectors.length}`,this._createSelector(s,i,this._fontsList,t.trim())}_deleteFontSelector(t,e){let s=this._fontSelectors[t];const i=0===t;if(""===s.input.value&&!e)return void _.alert(l`There is no value to delete at index: ${t}`,this.contentElement);if(i){const e=this._fontSelectors[1];let i="";e&&(i=e.input.value,s=e);this._fontSelectors[0].input.value=i,t=1}s.input.parentNode&&(this._fontSelectorSection.removeChild(s.input.parentNode),this._fontSelectors.splice(t,1),this._updateFontSelectorList(),_.alert(l`Font Selector deleted at index: ${t}`,this.contentElement)),this._onFontSelectorChanged(),this._resizePopout();const n=i?0:t-1;this._fontSelectors[n].input.focus()}_updateFontSelectorList(){for(let t=0;t<this._fontSelectors.length;t++){const e=this._fontSelectors[t];let s;s=0===t?l`Font Family`:l`Fallback ${t}`,e.label.textContent=s,_.setAccessibleName(e.input,s),e.deleteButton.setTitle(l`Delete ${s}`),e.index=t}}_getPropertyInfo(t,e){const s=this._propertyMap.get(t);if(s){const t=s,i=t.match(e);if(i){return{value:"+"===i[1].charAt(0)?i[1].substr(1):i[1],units:i[2]?i[2]:""}}return{value:t,units:null}}return{value:null,units:null}}_createSelector(t,e,s,i){const n=this._fontSelectors.length,o=h.createSelect(e,s);o.value=i;const r=h.createLabel(e,"shadow-editor-label",o);o.addEventListener("input",this._onFontSelectorChanged.bind(this),!1),o.addEventListener("keydown",(t=>{"Enter"===t.key&&t.consume()}),!1),t.appendChild(r),t.appendChild(o);const a=new m.Toolbar("",t),d=new m.ToolbarButton(l`Delete ${e}`,"largeicon-trash-bin");a.appendToolbarItem(d);const c={label:r,input:o,deleteButton:d,index:n};d.addEventListener(m.ToolbarButton.Events.Click,(()=>{this._deleteFontSelector(c.index)})),d.element.addEventListener("keydown",(t=>{isEnterOrSpaceKey(t)&&(this._deleteFontSelector(c.index),t.consume())}),!1),this._fontSelectors.push(c)}_onFontSelectorChanged(){let t="";const e=jt.includes(this._fontSelectors[0].input.value);if(e)for(let t=1;t<this._fontSelectors.length;t++)this._deleteFontSelector(t,!0);for(const e of this._fontSelectors){const s=e.input;""!==s.value&&(""===t?t=this._fontSelectors[0].input.value:t+=", "+s.value)}""!==this._fontSelectors[this._fontSelectors.length-1].input.value&&!e&&this._fontSelectors.length<10&&(this._createFontSelector(""),this._resizePopout()),this._updatePropertyValue("font-family",t)}_updatePropertyValue(t,e){this.dispatchEventToListeners(ce.FontChanged,{propertyName:t,value:e})}_resizePopout(){this.dispatchEventToListeners(ce.FontEditorResized)}}const ce={FontChanged:Symbol("FontChanged"),FontEditorResized:Symbol("FontEditorResized")};class ue{constructor(t,e,s,i,n,o,r,a){this._showSliderMode=!0;const h=s.createChild("div","shadow-editor-field shadow-editor-flex-field");if(this._errorText=s.createChild("div","error-text"),this._errorText.textContent=l`* Please enter a valid value for ${t} text input`,this._errorText.hidden=!0,_.markAsAlert(this._errorText),this._propertyInfo=i,this._propertyName=t,this._staticParams=n,this._hasUnits=a,this._hasUnits&&this._staticParams.units&&null!==this._staticParams.defaultUnit){const t=this._staticParams.defaultUnit;this._units=null!==i.units?i.units:t,this._addedUnit=!this._staticParams.units.has(this._units)}else{if(this._hasUnits)throw new Error(l`This property is set to contain units but does not have a defined corresponding unitsArray: ${this._propertyName}`);this._units=""}this._initialRange=this._getUnitRange(),this._boundUpdateCallback=o,this._boundResizeCallback=r,this._selectedNode=p.Context.instance().flavor(E.DOMNode),this._sliderInput=this._createSliderInput(h,e),this._textBoxInput=this._createTextBoxInput(h),this._unitInput=this._createUnitInput(h),this._selectorInput=this._createSelectorInput(h),this._createTypeToggle(h),this._checkSelectorValueAndToggle(),this._applyNextInput=!1}_setInvalidTextBoxInput(t){t?this._errorText.hidden&&(this._errorText.hidden=!1,this._textBoxInput.classList.add("error-input"),this._boundResizeCallback()):this._errorText.hidden||(this._errorText.hidden=!0,this._textBoxInput.classList.remove("error-input"),this._boundResizeCallback())}_checkSelectorValueAndToggle(){return!(!this._staticParams.keyValues||null===this._propertyInfo.value||!this._staticParams.keyValues.has(this._propertyInfo.value))&&(this._toggleInputType(),!0)}_getUnitRange(){let t=0,e=100,s=1;if(null!==this._propertyInfo.value&&/\d/.test(this._propertyInfo.value))if(this._staticParams.rangeMap.get(this._units)){const i=this._staticParams.rangeMap.get(this._units);i&&(t=Math.min(i.min,parseFloat(this._propertyInfo.value)),e=Math.max(i.max,parseFloat(this._propertyInfo.value)),s=i.step)}else{const i=this._staticParams.rangeMap.get("px");i&&(t=Math.min(i.min,parseFloat(this._propertyInfo.value)),e=Math.max(i.max,parseFloat(this._propertyInfo.value)),s=i.step)}else{const i=this._staticParams.rangeMap.get(this._units);i&&(t=i.min,e=i.max,s=i.step)}return{min:t,max:e,step:s}}_createSliderInput(t,e){const s=this._initialRange.min,i=this._initialRange.max,n=this._initialRange.step,o=h.createSlider(s,i,-1);o.sliderElement.step=n.toString(),o.sliderElement.tabIndex=0;const r=h.createLabel(e,"shadow-editor-label",o);if(this._propertyInfo.value)o.value=parseFloat(this._propertyInfo.value);else{const t=(s+i)/2;o.value=t}return o.addEventListener("input",(t=>{this._onSliderInput(t,!1)})),o.addEventListener("mouseup",(t=>{this._onSliderInput(t,!0)})),o.addEventListener("keydown",(t=>{"ArrowUp"!==t.key&&"ArrowDown"!==t.key&&"ArrowLeft"!==t.key&&"ArrowRight"!==t.key||(this._applyNextInput=!0)})),t.appendChild(r),t.appendChild(o),_.setAccessibleName(o.sliderElement,l`${this._propertyName} Slider Input`),o}_createTextBoxInput(t){const e=h.createInput("shadow-editor-text-input","number");return e.step=this._initialRange.step.toString(),e.classList.add("font-editor-text-input"),null!==this._propertyInfo.value&&("+"===this._propertyInfo.value.charAt(0)&&(this._propertyInfo.value=this._propertyInfo.value.substr(1)),e.value=this._propertyInfo.value),e.step="any",e.addEventListener("input",this._onTextBoxInput.bind(this),!1),t.appendChild(e),_.setAccessibleName(e,l`${this._propertyName} Text Input`),e}_createUnitInput(t){let e;if(this._hasUnits&&this._staticParams.units){const t=this._propertyInfo.units,s=this._staticParams.units;e=h.createSelect(l`Units`,s),e.classList.add("font-editor-select"),this._addedUnit&&t&&e.add(new Option(t,t)),t&&(e.value=t),e.addEventListener("change",this._onUnitInput.bind(this),!1)}else e=h.createSelect(l`Units`,[]),e.classList.add("font-editor-select"),e.disabled=!0;return e.addEventListener("keydown",(t=>{"Enter"===t.key&&t.consume()}),!1),t.appendChild(e),_.setAccessibleName(e,l`${this._propertyName} Unit Input`),e}_createSelectorInput(t){const e=h.createSelect(l`${this._propertyName} Key Value Selector`,this._staticParams.keyValues);return e.classList.add("font-selector-input"),this._propertyInfo.value&&(e.value=this._propertyInfo.value),e.addEventListener("input",this._onSelectorInput.bind(this),!1),e.addEventListener("keydown",(t=>{"Enter"===t.key&&t.consume()}),!1),t.appendChild(e),e.hidden=!0,e}_onSelectorInput(t){if(t.currentTarget){const e=t.currentTarget.value;this._textBoxInput.value="";const s=(parseFloat(this._sliderInput.sliderElement.min)+parseFloat(this._sliderInput.sliderElement.max))/2;this._sliderInput.value=s,this._setInvalidTextBoxInput(!1),this._boundUpdateCallback(this._propertyName,e)}}_onSliderInput(t,e){const s=t.currentTarget;if(s){const t=s.value;this._textBoxInput.value=t,this._selectorInput.value="";const i=this._hasUnits?t+this._unitInput.value:t.toString();this._setInvalidTextBoxInput(!1),(e||this._applyNextInput)&&(this._boundUpdateCallback(this._propertyName,i),this._applyNextInput=!1)}}_onTextBoxInput(t){const e=t.currentTarget;if(e){const t=e.value,s=t+(""===t?"":this._unitInput.value);this._staticParams.regex.test(s)||""===t&&!e.validationMessage.length?(parseFloat(t)>parseFloat(this._sliderInput.sliderElement.max)?this._sliderInput.sliderElement.max=t:parseFloat(t)<parseFloat(this._sliderInput.sliderElement.min)&&(this._sliderInput.sliderElement.min=t),this._sliderInput.value=parseFloat(t),this._selectorInput.value="",this._setInvalidTextBoxInput(!1),this._boundUpdateCallback(this._propertyName,s)):this._setInvalidTextBoxInput(!0)}}async _onUnitInput(t){const e=t.currentTarget,s=e.hasFocus(),i=e.value;e.disabled=!0;const n=this._units,o=await Rt(n,i,"font-size"===this._propertyName);this._setInputUnits(o,i),this._textBoxInput.value&&this._boundUpdateCallback(this._propertyName,this._textBoxInput.value+i),this._units=i,e.disabled=!1,s&&e.focus()}_createTypeToggle(t){const e=t.createChild("div","spectrum-switcher");!function(t){const e=h.createSVGChild(t,"svg");e.setAttribute("height","16"),e.setAttribute("width","16");h.createSVGChild(e,"path").setAttribute("d","M5,6 L11,6 L8,2 Z M5,10 L11,10 L8,14 Z")}(e),e.tabIndex=0,self.onInvokeElement(e,this._toggleInputType.bind(this)),_.setAccessibleName(e,l`${this._propertyName} Toggle Input Type`),_.markAsButton(e)}_toggleInputType(t){t&&"Enter"===t.key&&t.consume(),this._showSliderMode?(this._sliderInput.hidden=!0,this._textBoxInput.hidden=!0,this._unitInput.hidden=!0,this._selectorInput.hidden=!1,this._showSliderMode=!1,_.alert(l`Selector Input Mode`,this._textBoxInput)):(this._sliderInput.hidden=!1,this._textBoxInput.hidden=!1,this._unitInput.hidden=!1,this._selectorInput.hidden=!0,this._showSliderMode=!0,_.alert(l`Slider Input Mode`,this._textBoxInput))}_setInputUnits(t,e){const s=this._staticParams.rangeMap.get(e);let i,n,o;s?(i=s.min,n=s.max,o=s.step):(i=0,n=100,o=1);let r=!1;const a=le(o);let l=(i+n)/2;this._textBoxInput.value&&(r=!0,l=parseFloat((parseFloat(this._textBoxInput.value)*t).toFixed(a))),this._sliderInput.sliderElement.min=Math.min(l,i).toString(),this._sliderInput.sliderElement.max=Math.max(l,n).toString(),this._sliderInput.sliderElement.step=o.toString(),this._textBoxInput.step=o.toString(),r&&(this._textBoxInput.value=l.toString()),this._sliderInput.value=l}}var pe=Object.freeze({__proto__:null,FontEditor:de,Events:ce});class _e extends HTMLSpanElement{constructor(){super();const t=g.createShadowRootWithCoreStyles(this,{cssFile:"inline_editor/bezierSwatch.css",enableLegacyPatching:!0,delegatesFocus:void 0});this._iconElement=v.Icon.create("smallicon-bezier","bezier-swatch-icon"),t.appendChild(this._iconElement),this._textElement=this.createChild("span"),t.createChild("slot")}static create(){let t=_e._constructor;return t||(t=g.registerCustomElement("span","bezier-swatch",_e),_e._constructor=t),t()}bezierText(){return this._textElement.textContent||""}setBezierText(t){this._textElement.textContent=t}hideText(t){this._textElement.hidden=t}iconElement(){return this._iconElement}}_e._constructor=null;class me extends HTMLSpanElement{constructor(){super();const t=g.createShadowRootWithCoreStyles(this,{cssFile:"inline_editor/cssShadowSwatch.css",enableLegacyPatching:!0,delegatesFocus:void 0});this._iconElement=v.Icon.create("smallicon-shadow","shadow-swatch-icon"),t.appendChild(this._iconElement),t.createChild("slot"),this._contentElement=this.createChild("span"),this._colorSwatch}static create(){let t=me._constructor;return t||(t=g.registerCustomElement("span","css-shadow-swatch",me),me._constructor=t),t()}model(){return this._model}setCSSShadow(t){this._model=t,this._contentElement.removeChildren();const e=I.Utils.splitStringByRegexes(t.asCSSText(),[/!important/g,/inset/g,s.Regex]);for(let s=0;s<e.length;s++){const i=e[s];if(2===i.regexIndex){if(!this._colorSwatch){this._colorSwatch=new N;const t=this._colorSwatch.createChild("span");this._colorSwatch.addEventListener("format-changed",(e=>{t.textContent=e.data.text}))}this._colorSwatch.renderColor(t.color());const e=this._colorSwatch.querySelector("span");e&&(e.textContent=t.color().asString()),this._contentElement.appendChild(this._colorSwatch)}else this._contentElement.appendChild(document.createTextNode(i.value))}}hideText(t){this._contentElement.hidden=t}iconElement(){return this._iconElement}colorSwatch(){return this._colorSwatch}}me._constructor=null;var ge=Object.freeze({__proto__:null,BezierSwatch:_e,CSSShadowSwatch:me});class ve extends o.ObjectWrapper{constructor(){super(),this._popover=new f.GlassPane,this._popover.registerRequiredCSS("inline_editor/swatchPopover.css",{enableLegacyPatching:!1}),this._popover.setSizeBehavior(f.SizeBehavior.MeasureContent),this._popover.setMarginBehavior(f.MarginBehavior.Arrow),this._popover.element.addEventListener("mousedown",(t=>t.consume()),!1),this._hideProxy=this.hide.bind(this,!0),this._boundOnKeyDown=this._onKeyDown.bind(this),this._boundFocusOut=this._onFocusOut.bind(this),this._isHidden=!0,this._anchorElement=null}_onFocusOut(t){const e=t.relatedTarget;!this._isHidden&&e&&this._view&&!e.isSelfOrDescendant(this._view.contentElement)&&this._hideProxy()}isShowing(){return this._popover.isShowing()}show(t,e,s){if(this._popover.isShowing()){if(this._anchorElement===e)return;this.hide(!0)}this.dispatchEventToListeners(fe.WillShowPopover),this._isHidden=!1,this._anchorElement=e,this._view=t,this._hiddenCallback=s,this.reposition(),t.focus();const i=this._popover.element.ownerDocument;i.addEventListener("mousedown",this._hideProxy,!1),i.defaultView&&i.defaultView.addEventListener("resize",this._hideProxy,!1),this._view.contentElement.addEventListener("keydown",this._boundOnKeyDown,!1)}reposition(){if(!this._isHidden&&this._view){if(this._view.contentElement.removeEventListener("focusout",this._boundFocusOut,!1),this._view.show(this._popover.contentElement),this._anchorElement){let t=this._anchorElement.boxInWindow();if(N.isColorSwatch(this._anchorElement)){const e=this._anchorElement;if(!e.anchorBox)return;t=e.anchorBox}this._popover.setContentAnchorBox(t),this._popover.show(this._anchorElement.ownerDocument)}this._view.contentElement.addEventListener("focusout",this._boundFocusOut,!1),this._focusRestorer||(this._focusRestorer=new c.WidgetFocusRestorer(this._view))}}hide(t){if(this._isHidden)return;const e=this._popover.element.ownerDocument;this._isHidden=!0,this._popover.hide(),e.removeEventListener("mousedown",this._hideProxy,!1),e.defaultView&&e.defaultView.removeEventListener("resize",this._hideProxy,!1),this._hiddenCallback&&this._hiddenCallback.call(null,Boolean(t)),this._focusRestorer&&this._focusRestorer.restore(),this._anchorElement=null,this._view&&(this._view.detach(),this._view.contentElement.removeEventListener("keydown",this._boundOnKeyDown,!1),this._view.contentElement.removeEventListener("focusout",this._boundFocusOut,!1),delete this._view)}_onKeyDown(t){const e=t;if("Enter"===e.key)return this.hide(!0),void e.consume(!0);"Escape"===e.key&&(this.hide(!1),e.consume(!0))}}const fe={WillShowPopover:Symbol("WillShowPopover")};var xe=Object.freeze({__proto__:null,SwatchPopoverHelper:ve,Events:fe});export{O as BezierEditor,M as BezierUI,gt as CSSAngle,gt as CSSAngleImpl,Q as CSSAngleUtils,yt as CSSShadowEditor,St as CSSShadowModel,zt as CSSVarSwatch,zt as CSSVarSwatchImpl,X as ColorSwatch,X as ColorSwatchImpl,pe as FontEditor,Ut as FontEditorUnitConverter,he as FontEditorUtils,xe as SwatchPopoverHelper,ge as Swatches};
