import{ObjectWrapper,Settings,Revealer,UIString,Throttler}from"../common/common.js";import{userMetrics,UserMetrics,InspectorFrontendHost,Platform}from"../host/host.js";import{Geometry,Toolbar,UIUtils,Utils,ContextMenu,Widget,ZoomManager,Tooltip,ResizerWidget,ActionRegistry,Context,DockController,RootView,SplitWidget,InspectorView,ListWidget,ARIAUtils,SettingsUI,ViewManager}from"../ui/ui.js";import{InspectorBackend}from"../protocol_client/protocol_client.js";import{NetworkManager,SDKModel,EmulationModel,ResourceTreeModel,ScreenCaptureModel,CSSModel,OverlayModel,DOMModel}from"../sdk/sdk.js";import{Runtime}from"../root/root.js";import{StringUtilities}from"../platform/platform.js";import{ThrottlingManager}from"../mobile_throttling/mobile_throttling.js";import{CSSWorkspaceBinding}from"../bindings/bindings.js";class EmulatedDevice{constructor(){this.title="",this.type=Type.Unknown,this.vertical={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.horizontal={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.deviceScaleFactor=1,this.capabilities=[Capability.Touch,Capability.Mobile],this.userAgent="",this.userAgentMetadata=null,this.modes=[],this.isDualScreen=!1,this.verticalSpanned={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this.horizontalSpanned={width:0,height:0,outlineInsets:null,outlineImage:null,hinge:null},this._show=_Show.Default,this._showByDefault=!0,this._extension=null}static fromJSONV1(e){try{function t(e,t,i,n){if("object"!=typeof e||null===e||!e.hasOwnProperty(t)){if(void 0!==n)return n;throw new Error("Emulated device is missing required property '"+t+"'")}const s=e[t];if(typeof s!==i||null===s)throw new Error("Emulated device property '"+t+"' has wrong type '"+typeof s+"'");return s}function i(e,i){const n=t(e,i,"number");if(n!==Math.abs(n))throw new Error("Emulated device value '"+i+"' must be integer");return n}function n(e){return new Geometry.Insets(i(e,"left"),i(e,"top"),i(e,"right"),i(e,"bottom"))}function s(e){const n={};if(n.r=i(e,"r"),n.r<0||n.r>255)throw new Error("color has wrong r value: "+n.r);if(n.g=i(e,"g"),n.g<0||n.g>255)throw new Error("color has wrong g value: "+n.g);if(n.b=i(e,"b"),n.b<0||n.b>255)throw new Error("color has wrong b value: "+n.b);if(n.a=t(e,"a","number"),n.a<0||n.a>1)throw new Error("color has wrong a value: "+n.a);return n}function o(e){const o={};if(o.width=i(e,"width"),o.width<0||o.width>MaxDeviceSize||o.width<MinDeviceSize)throw new Error("Emulated device has wrong width: "+o.width);if(o.height=i(e,"height"),o.height<0||o.height>MaxDeviceSize||o.height<MinDeviceSize)throw new Error("Emulated device has wrong height: "+o.height);const a=t(e.outline,"insets","object",null);if(a){if(o.outlineInsets=n(a),o.outlineInsets.left<0||o.outlineInsets.top<0)throw new Error("Emulated device has wrong outline insets");o.outlineImage=t(e.outline,"image","string")}return e.hinge&&(o.hinge=function(e){const t={};if(t.width=i(e,"width"),t.width<0||t.width>MaxDeviceSize)throw new Error("Emulated device has wrong hinge width: "+t.width);if(t.height=i(e,"height"),t.height<0||t.height>MaxDeviceSize)throw new Error("Emulated device has wrong hinge height: "+t.height);if(t.x=i(e,"x"),t.x<0||t.x>MaxDeviceSize)throw new Error("Emulated device has wrong x offset: "+t.height);if(t.y=i(e,"y"),t.x<0||t.x>MaxDeviceSize)throw new Error("Emulated device has wrong y offset: "+t.height);return e.contentColor&&(t.contentColor=s(e.contentColor)),e.outlineColor&&(t.outlineColor=s(e.outlineColor)),t}(t(e,"hinge","object",void 0))),o}const a=new EmulatedDevice;a.title=t(e,"title","string"),a.type=t(e,"type","string");const r=t(e,"user-agent","string");a.userAgent=NetworkManager.MultitargetNetworkManager.patchUserAgentWithChromeVersion(r);const l=t(e,"user-agent-metadata","object",null);l&&(void 0===l.brands&&(l.brands=NetworkManager.MultitargetNetworkManager.getChromeBrands()),void 0===l.fullVersion&&(l.fullVersion=NetworkManager.MultitargetNetworkManager.getChromeVersion())),a.userAgentMetadata=l;const c=t(e,"capabilities","object",[]);if(!Array.isArray(c))throw new Error("Emulated device capabilities must be an array");a.capabilities=[];for(let e=0;e<c.length;++e){if("string"!=typeof c[e])throw new Error("Emulated device capability must be a string");a.capabilities.push(c[e])}if(a.deviceScaleFactor=t(e.screen,"device-pixel-ratio","number"),a.deviceScaleFactor<0||a.deviceScaleFactor>100)throw new Error("Emulated device has wrong deviceScaleFactor: "+a.deviceScaleFactor);if(a.vertical=o(t(e.screen,"vertical","object")),a.horizontal=o(t(e.screen,"horizontal","object")),a.isDualScreen=t(e,"dual-screen","boolean",!1),a.isDualScreen&&(a.verticalSpanned=o(t(e.screen,"vertical-spanned","object",null)),a.horizontalSpanned=o(t(e.screen,"horizontal-spanned","object",null))),a.isDualScreen&&(!a.verticalSpanned||!a.horizontalSpanned))throw new Error("Emulated device '"+a.title+"'has dual screen without spanned orientations");const d=t(e,"modes","object",[{title:"default",orientation:"vertical"},{title:"default",orientation:"horizontal"}]);if(!Array.isArray(d))throw new Error("Emulated device modes must be an array");a.modes=[];for(let e=0;e<d.length;++e){const i={};if(i.title=t(d[e],"title","string"),i.orientation=t(d[e],"orientation","string"),i.orientation!==Vertical&&i.orientation!==Horizontal&&i.orientation!==VerticalSpanned&&i.orientation!==HorizontalSpanned)throw new Error("Emulated device mode has wrong orientation '"+i.orientation+"'");const s=a.orientationByName(i.orientation);if(i.insets=n(t(d[e],"insets","object",{left:0,top:0,right:0,bottom:0})),i.insets.top<0||i.insets.left<0||i.insets.right<0||i.insets.bottom<0||i.insets.top+i.insets.bottom>s.height||i.insets.left+i.insets.right>s.width)throw new Error("Emulated device mode '"+i.title+"'has wrong mode insets");i.image=t(d[e],"image","string",null),a.modes.push(i)}return a._showByDefault=t(e,"show-by-default","boolean",void 0),a._show=t(e,"show","string",_Show.Default),a}catch(e){return null}}static deviceComparator(e,t){const i=e._extension&&e._extension.descriptor().order||-1,n=t._extension&&t._extension.descriptor().order||-1;return i>n?1:n>i||e.title<t.title?-1:e.title>t.title?1:0}extension(){return this._extension}setExtension(e){this._extension=e}modesForOrientation(e){const t=[];for(let i=0;i<this.modes.length;i++)this.modes[i].orientation===e&&t.push(this.modes[i]);return t}getSpanPartner(e){switch(e.orientation){case Vertical:return this.modesForOrientation(VerticalSpanned)[0];case Horizontal:return this.modesForOrientation(HorizontalSpanned)[0];case VerticalSpanned:return this.modesForOrientation(Vertical)[0];default:return this.modesForOrientation(Horizontal)[0]}}getRotationPartner(e){switch(e.orientation){case HorizontalSpanned:return this.modesForOrientation(VerticalSpanned)[0];case VerticalSpanned:return this.modesForOrientation(HorizontalSpanned)[0];case Horizontal:return this.modesForOrientation(Vertical)[0];default:return this.modesForOrientation(Horizontal)[0]}}_toJSON(){const e={};e.title=this.title,e.type=this.type,e["user-agent"]=this.userAgent,e.capabilities=this.capabilities,e.screen={},e.screen["device-pixel-ratio"]=this.deviceScaleFactor,e.screen.vertical=this._orientationToJSON(this.vertical),e.screen.horizontal=this._orientationToJSON(this.horizontal),this.isDualScreen&&(e.screen["vertical-spanned"]=this._orientationToJSON(this.verticalSpanned),e.screen["horizontal-spanned"]=this._orientationToJSON(this.horizontalSpanned)),e.modes=[];for(let t=0;t<this.modes.length;++t){const i={};i.title=this.modes[t].title,i.orientation=this.modes[t].orientation,i.insets={},i.insets.left=this.modes[t].insets.left,i.insets.top=this.modes[t].insets.top,i.insets.right=this.modes[t].insets.right,i.insets.bottom=this.modes[t].insets.bottom,this.modes[t].image&&(i.image=this.modes[t].image),e.modes.push(i)}return e["show-by-default"]=this._showByDefault,e["dual-screen"]=this.isDualScreen,e.show=this._show,e}_orientationToJSON(e){const t={};return t.width=e.width,t.height=e.height,e.outlineInsets&&(t.outline={},t.outline.insets={},t.outline.insets.left=e.outlineInsets.left,t.outline.insets.top=e.outlineInsets.top,t.outline.insets.right=e.outlineInsets.right,t.outline.insets.bottom=e.outlineInsets.bottom,t.outline.image=e.outlineImage),e.hinge&&(t.hinge={},t.hinge.width=e.hinge.width,t.hinge.height=e.hinge.height,t.hinge.x=e.hinge.x,t.hinge.y=e.hinge.y,e.hinge.contentColor&&(t.hinge.contentColor={},t.hinge.contentColor.r=e.hinge.contentColor.r,t.hinge.contentColor.g=e.hinge.contentColor.g,t.hinge.contentColor.b=e.hinge.contentColor.b,t.hinge.contentColor.a=e.hinge.contentColor.a),e.hinge.outlineColor&&(t.hinge.outlineColor={},t.hinge.outlineColor.r=e.hinge.outlineColor.r,t.hinge.outlineColor.g=e.hinge.outlineColor.g,t.hinge.outlineColor.b=e.hinge.outlineColor.b,t.hinge.outlineColor.a=e.hinge.outlineColor.a)),t}modeImage(e){return e.image?this._extension?this._extension.module().substituteURL(e.image):e.image:""}outlineImage(e){const t=this.orientationByName(e.orientation);return t.outlineImage?this._extension?this._extension.module().substituteURL(t.outlineImage):t.outlineImage:""}orientationByName(e){switch(e){case VerticalSpanned:return this.verticalSpanned;case HorizontalSpanned:return this.horizontalSpanned;case Vertical:return this.vertical;default:return this.horizontal}}show(){return this._show===_Show.Default?this._showByDefault:this._show===_Show.Always}setShow(e){this._show=e?_Show.Always:_Show.Never}copyShowFrom(e){this._show=e._show}touch(){return-1!==this.capabilities.indexOf(Capability.Touch)}mobile(){return-1!==this.capabilities.indexOf(Capability.Mobile)}}const Horizontal="horizontal",Vertical="vertical",HorizontalSpanned="horizontal-spanned",VerticalSpanned="vertical-spanned",Type={Phone:"phone",Tablet:"tablet",Notebook:"notebook",Desktop:"desktop",Unknown:"unknown"},Capability={Touch:"touch",Mobile:"mobile"},_Show={Always:"Always",Default:"Default",Never:"Never"};let _instance;class EmulatedDevicesList extends ObjectWrapper.ObjectWrapper{constructor(){super(),this._standardSetting=Settings.Settings.instance().createSetting("standardEmulatedDeviceList",[]),this._standard=new Set,this._listFromJSONV1(this._standardSetting.get(),this._standard),this._updateStandardDevices(),this._customSetting=Settings.Settings.instance().createSetting("customEmulatedDeviceList",[]),this._custom=new Set,this._listFromJSONV1(this._customSetting.get(),this._custom)||this.saveCustomDevices()}static instance(){return _instance||(_instance=new EmulatedDevicesList),_instance}_updateStandardDevices(){const e=new Set,t=Runtime.Runtime.instance().extensions("emulated-device");for(const i of t){const t=EmulatedDevice.fromJSONV1(i.descriptor().device);t.setExtension(i),e.add(t)}this._copyShowValues(this._standard,e),this._standard=e,this.saveStandardDevices()}_listFromJSONV1(e,t){if(!Array.isArray(e))return!1;let i=!0;for(let n=0;n<e.length;++n){const s=EmulatedDevice.fromJSONV1(e[n]);s?(t.add(s),s.modes.length||(s.modes.push({title:"",orientation:Horizontal,insets:new Geometry.Insets(0,0,0,0),image:null}),s.modes.push({title:"",orientation:Vertical,insets:new Geometry.Insets(0,0,0,0),image:null}))):i=!1}return i}standard(){return[...this._standard]}custom(){return[...this._custom]}revealCustomSetting(){Revealer.reveal(this._customSetting)}addCustomDevice(e){this._custom.add(e),this.saveCustomDevices()}removeCustomDevice(e){this._custom.delete(e),this.saveCustomDevices()}saveCustomDevices(){const e=[];this._custom.forEach(t=>e.push(t._toJSON())),this._customSetting.set(e),this.dispatchEventToListeners(Events.CustomDevicesUpdated)}saveStandardDevices(){const e=[];this._standard.forEach(t=>e.push(t._toJSON())),this._standardSetting.set(e),this.dispatchEventToListeners(Events.StandardDevicesUpdated)}_copyShowValues(e,t){const i=new Map;for(const t of e)i.set(t.title,t);for(const e of t){const t=i.get(e.title);t&&e.copyShowFrom(t)}}}const Events={CustomDevicesUpdated:Symbol("CustomDevicesUpdated"),StandardDevicesUpdated:Symbol("StandardDevicesUpdated")};let Mode,Orientation;var EmulatedDevices=Object.freeze({__proto__:null,EmulatedDevice:EmulatedDevice,Horizontal:Horizontal,Vertical:Vertical,HorizontalSpanned:HorizontalSpanned,VerticalSpanned:VerticalSpanned,Type:Type,Capability:Capability,_Show:_Show,EmulatedDevicesList:EmulatedDevicesList,Events:Events,Mode:Mode,Orientation:Orientation});class DeviceModeModel extends ObjectWrapper.ObjectWrapper{constructor(){super(),this._screenRect=new Geometry.Rect(0,0,1,1),this._visiblePageRect=new Geometry.Rect(0,0,1,1),this._availableSize=new Geometry.Size(1,1),this._preferredSize=new Geometry.Size(1,1),this._initialized=!1,this._appliedDeviceSize=new Geometry.Size(1,1),this._appliedDeviceScaleFactor=window.devicePixelRatio,this._appliedUserAgentType=UA.Desktop,this._experimentDualScreenSupport=Root.Runtime.experiments.isEnabled("dualScreenSupport"),this._webPlatformExperimentalFeaturesEnabled=!!eval("window.getWindowSegments"),this._scaleSetting=Settings.Settings.instance().createSetting("emulation.deviceScale",1),this._scaleSetting.get()||this._scaleSetting.set(1),this._scaleSetting.addChangeListener(this._scaleSettingChanged,this),this._widthSetting=Settings.Settings.instance().createSetting("emulation.deviceWidth",400),this._widthSetting.get()<MinDeviceSize&&this._widthSetting.set(MinDeviceSize),this._widthSetting.get()>MaxDeviceSize&&this._widthSetting.set(MaxDeviceSize),this._widthSetting.addChangeListener(this._widthSettingChanged,this),this._heightSetting=Settings.Settings.instance().createSetting("emulation.deviceHeight",0),this._heightSetting.get()&&this._heightSetting.get()<MinDeviceSize&&this._heightSetting.set(MinDeviceSize),this._heightSetting.get()>MaxDeviceSize&&this._heightSetting.set(MaxDeviceSize),this._heightSetting.addChangeListener(this._heightSettingChanged,this),this._uaSetting=Settings.Settings.instance().createSetting("emulation.deviceUA",UA.Mobile),this._uaSetting.addChangeListener(this._uaSettingChanged,this),this._deviceScaleFactorSetting=Settings.Settings.instance().createSetting("emulation.deviceScaleFactor",0),this._deviceScaleFactorSetting.addChangeListener(this._deviceScaleFactorSettingChanged,this),this._deviceOutlineSetting=Settings.Settings.instance().moduleSetting("emulation.showDeviceOutline"),this._deviceOutlineSetting.addChangeListener(this._deviceOutlineSettingChanged,this),this._toolbarControlsEnabledSetting=Settings.Settings.instance().createSetting("emulation.toolbarControlsEnabled",!0,Settings.SettingStorageType.Session),this._type=Type$1.None,this._device=null,this._mode=null,this._fitScale=1,this._touchEnabled=!1,this._touchMobile=!1,this._emulationModel=null,this._onModelAvailable=null,SDKModel.TargetManager.instance().observeModels(EmulationModel.EmulationModel,this)}static widthValidator(e){let t,i=!1;return/^[\d]+$/.test(e)?e>MaxDeviceSize?t=ls`Width must be less than or equal to ${MaxDeviceSize}.`:e<MinDeviceSize?t=ls`Width must be greater than or equal to ${MinDeviceSize}.`:i=!0:t=ls`Width must be a number.`,{valid:i,errorMessage:t}}static heightValidator(e){let t,i=!1;return/^[\d]+$/.test(e)?e>MaxDeviceSize?t=ls`Height must be less than or equal to ${MaxDeviceSize}.`:e<MinDeviceSize?t=ls`Height must be greater than or equal to ${MinDeviceSize}.`:i=!0:t=ls`Height must be a number.`,{valid:i,errorMessage:t}}static scaleValidator(e){let t,i=!1;const n=Number(e.trim());return e?Number.isNaN(n)?t=ls`Device pixel ratio must be a number or blank.`:e>MaxDeviceScaleFactor?t=ls`Device pixel ratio must be less than or equal to ${MaxDeviceScaleFactor}.`:e<MinDeviceScaleFactor?t=ls`Device pixel ratio must be greater than or equal to ${MinDeviceScaleFactor}.`:i=!0:i=!0,{valid:i,errorMessage:t}}setAvailableSize(e,t){this._availableSize=e,this._preferredSize=t,this._initialized=!0,this._calculateAndEmulate(!1)}emulate(e,t,i,n){const s=this._type!==e||this._device!==t||this._mode!==i;if(this._type=e,e===Type$1.Device){if(console.assert(t&&i,"Must pass device and mode for device emulation"),this._mode=i,this._device=t,this._initialized){const e=t.orientationByName(i.orientation);this._scaleSetting.set(n||this._calculateFitScale(e.width,e.height,this._currentOutline(),this._currentInsets()))}}else this._device=null,this._mode=null;e!==Type$1.None&&userMetrics.actionTaken(UserMetrics.Action.DeviceModeEnabled),this._calculateAndEmulate(s)}setWidth(e){const t=Math.min(MaxDeviceSize,this._preferredScaledWidth());e=Math.max(Math.min(e,t),1),this._widthSetting.set(e)}setWidthAndScaleToFit(e){e=Math.max(Math.min(e,MaxDeviceSize),1),this._scaleSetting.set(this._calculateFitScale(e,this._heightSetting.get())),this._widthSetting.set(e)}setHeight(e){const t=Math.min(MaxDeviceSize,this._preferredScaledHeight());(e=Math.max(Math.min(e,t),0))===this._preferredScaledHeight()&&(e=0),this._heightSetting.set(e)}setHeightAndScaleToFit(e){e=Math.max(Math.min(e,MaxDeviceSize),0),this._scaleSetting.set(this._calculateFitScale(this._widthSetting.get(),e)),this._heightSetting.set(e)}setScale(e){this._scaleSetting.set(e)}device(){return this._device}mode(){return this._mode}type(){return this._type}screenImage(){return this._device&&this._mode?this._device.modeImage(this._mode):""}outlineImage(){return this._device&&this._mode&&this._deviceOutlineSetting.get()?this._device.outlineImage(this._mode):""}outlineRect(){return this._outlineRect}screenRect(){return this._screenRect}visiblePageRect(){return this._visiblePageRect}scale(){return this._scale}fitScale(){return this._fitScale}appliedDeviceSize(){return this._appliedDeviceSize}appliedDeviceScaleFactor(){return this._appliedDeviceScaleFactor}appliedUserAgentType(){return this._appliedUserAgentType}isFullHeight(){return!this._heightSetting.get()}_isMobile(){switch(this._type){case Type$1.Device:return this._device.mobile();case Type$1.None:return!1;case Type$1.Responsive:return this._uaSetting.get()===UA.Mobile||this._uaSetting.get()===UA.MobileNoTouch}return!1}enabledSetting(){return Settings.Settings.instance().createSetting("emulation.showDeviceMode",!1)}scaleSetting(){return this._scaleSetting}uaSetting(){return this._uaSetting}deviceScaleFactorSetting(){return this._deviceScaleFactorSetting}deviceOutlineSetting(){return this._deviceOutlineSetting}toolbarControlsEnabledSetting(){return this._toolbarControlsEnabledSetting}reset(){this._deviceScaleFactorSetting.set(0),this._scaleSetting.set(1),this.setWidth(400),this.setHeight(0),this._uaSetting.set(UA.Mobile)}modelAdded(e){if(!this._emulationModel&&e.supportsDeviceEmulation()){if(this._emulationModel=e,this._onModelAvailable){const e=this._onModelAvailable;this._onModelAvailable=null,e()}const t=e.target().model(ResourceTreeModel.ResourceTreeModel);t&&(t.addEventListener(ResourceTreeModel.Events.FrameResized,this._onFrameChange,this),t.addEventListener(ResourceTreeModel.Events.FrameNavigated,this._onFrameChange,this))}else e.emulateTouch(this._touchEnabled,this._touchMobile)}modelRemoved(e){this._emulationModel===e&&(this._emulationModel=null)}inspectedURL(){return this._emulationModel?this._emulationModel.target().inspectedURL():null}_onFrameChange(){const e=this._emulationModel?this._emulationModel.overlayModel():null;e&&this._showHingeIfApplicable(e)}_scaleSettingChanged(){this._calculateAndEmulate(!1)}_widthSettingChanged(){this._calculateAndEmulate(!1)}_heightSettingChanged(){this._calculateAndEmulate(!1)}_uaSettingChanged(){this._calculateAndEmulate(!0)}_deviceScaleFactorSettingChanged(){this._calculateAndEmulate(!1)}_deviceOutlineSettingChanged(){this._calculateAndEmulate(!1)}_preferredScaledWidth(){return Math.floor(this._preferredSize.width/(this._scaleSetting.get()||1))}_preferredScaledHeight(){return Math.floor(this._preferredSize.height/(this._scaleSetting.get()||1))}_currentOutline(){let e=new Geometry.Insets(0,0,0,0);if(this._type!==Type$1.Device)return e;const t=this._device.orientationByName(this._mode.orientation);return this._deviceOutlineSetting.get()&&(e=t.outlineInsets||e),e}_currentInsets(){return this._type!==Type$1.Device?new Geometry.Insets(0,0,0,0):this._mode.insets}_getScreenOrientationType(){switch(console.assert(this._mode,"Can only get display feature orientation when current mode is set."),this._mode.orientation){case VerticalSpanned:case Vertical:return Protocol.Emulation.ScreenOrientationType.PortraitPrimary;case HorizontalSpanned:case Horizontal:default:return Protocol.Emulation.ScreenOrientationType.LandscapePrimary}}_calculateAndEmulate(e){this._emulationModel||(this._onModelAvailable=this._calculateAndEmulate.bind(this,e));const t=this._isMobile(),i=this._emulationModel?this._emulationModel.overlayModel():null;if(i&&this._showHingeIfApplicable(i),this._type===Type$1.Device){const i=this._device.orientationByName(this._mode.orientation),n=this._currentOutline(),s=this._currentInsets();this._fitScale=this._calculateFitScale(i.width,i.height,n,s),this._appliedUserAgentType=t?this._device.touch()?UA.Mobile:UA.MobileNoTouch:this._device.touch()?UA.DesktopTouch:UA.Desktop,this._applyDeviceMetrics(new Geometry.Size(i.width,i.height),s,n,this._scaleSetting.get(),this._device.deviceScaleFactor,t,this._getScreenOrientationType(),e,this._webPlatformExperimentalFeaturesEnabled),this._applyUserAgent(this._device.userAgent,this._device.userAgentMetadata),this._applyTouch(this._device.touch(),t)}else if(this._type===Type$1.None)this._fitScale=this._calculateFitScale(this._availableSize.width,this._availableSize.height),this._appliedUserAgentType=UA.Desktop,this._applyDeviceMetrics(this._availableSize,new Geometry.Insets(0,0,0,0),new Geometry.Insets(0,0,0,0),1,0,t,null,e),this._applyUserAgent("",null),this._applyTouch(!1,!1);else if(this._type===Type$1.Responsive){let i=this._widthSetting.get();(!i||i>this._preferredScaledWidth())&&(i=this._preferredScaledWidth());let n=this._heightSetting.get();(!n||n>this._preferredScaledHeight())&&(n=this._preferredScaledHeight());const s=t?defaultMobileScaleFactor:0;this._fitScale=this._calculateFitScale(this._widthSetting.get(),this._heightSetting.get()),this._appliedUserAgentType=this._uaSetting.get(),this._applyDeviceMetrics(new Geometry.Size(i,n),new Geometry.Insets(0,0,0,0),new Geometry.Insets(0,0,0,0),this._scaleSetting.get(),this._deviceScaleFactorSetting.get()||s,t,n>=i?Protocol.Emulation.ScreenOrientationType.PortraitPrimary:Protocol.Emulation.ScreenOrientationType.LandscapePrimary,e),this._applyUserAgent(t?_defaultMobileUserAgent:"",t?_defaultMobileUserAgentMetadata:null),this._applyTouch(this._uaSetting.get()===UA.DesktopTouch||this._uaSetting.get()===UA.Mobile,this._uaSetting.get()===UA.Mobile)}i&&i.setShowViewportSizeOnResize(this._type===Type$1.None),this.dispatchEventToListeners(Events$1.Updated)}_calculateFitScale(e,t,i,n){const s=i?i.left+i.right:0,o=i?i.top+i.bottom:0,a=n?n.left+n.right:0,r=n?n.top+n.bottom:0;let l=Math.min(e?this._preferredSize.width/(e+s):1,t?this._preferredSize.height/(t+o):1);l=Math.min(Math.floor(100*l),100);let c=l;for(;c>.7*l;){let i=!0;if(e&&(i=i&&Number.isInteger((e-a)*c/100)),t&&(i=i&&Number.isInteger((t-r)*c/100)),i)return c/100;c-=1}return l/100}setSizeAndScaleToFit(e,t){this._scaleSetting.set(this._calculateFitScale(e,t)),this.setWidth(e),this.setHeight(t)}_applyUserAgent(e,t){NetworkManager.MultitargetNetworkManager.instance().setUserAgentOverride(e,t)}_applyDeviceMetrics(e,t,i,n,s,o,a,r,l=!1){e.width=Math.max(1,Math.floor(e.width)),e.height=Math.max(1,Math.floor(e.height));let c=e.width-t.left-t.right,d=e.height-t.top-t.bottom;this._emulatedPageSize=new Geometry.Size(c,d);const h=t.left,u=t.top,m=a===Protocol.Emulation.ScreenOrientationType.LandscapePrimary?90:0;if(this._appliedDeviceSize=e,this._appliedDeviceScaleFactor=s||window.devicePixelRatio,this._screenRect=new Geometry.Rect(Math.max(0,(this._availableSize.width-e.width*n)/2),i.top*n,e.width*n,e.height*n),this._outlineRect=new Geometry.Rect(this._screenRect.left-i.left*n,0,(i.left+e.width+i.right)*n,(i.top+e.height+i.bottom)*n),this._visiblePageRect=new Geometry.Rect(h*n,u*n,Math.min(c*n,this._availableSize.width-this._screenRect.left-h*n),Math.min(d*n,this._availableSize.height-this._screenRect.top-u*n)),this._scale=n,l||(1===n&&this._availableSize.width>=e.width&&this._availableSize.height>=e.height&&(c=0,d=0),this._visiblePageRect.width===c*n&&this._visiblePageRect.height===d*n&&Number.isInteger(c*n)&&Number.isInteger(d*n)&&(c=0,d=0)),this._emulationModel)if(r&&this._emulationModel.resetPageScaleFactor(),c||d||o||s||1!==n||a||l){const t={width:c,height:d,deviceScaleFactor:s,mobile:o,scale:n,screenWidth:e.width,screenHeight:e.height,positionX:h,positionY:u,dontSetVisibleSize:!0},i=this._getDisplayFeature();i&&(t.displayFeature=i),a&&(t.screenOrientation={type:a,angle:m}),this._emulationModel.emulateDevice(t)}else this._emulationModel.emulateDevice(null)}exitHingeMode(){const e=this._emulationModel?this._emulationModel.overlayModel():null;e&&e.showHingeForDualScreen(null)}webPlatformExperimentalFeaturesEnabled(){return this._webPlatformExperimentalFeaturesEnabled}shouldReportDisplayFeature(){return this._webPlatformExperimentalFeaturesEnabled&&this._experimentDualScreenSupport}async captureScreenshot(e,t){const i=this._emulationModel?this._emulationModel.target().model(ScreenCaptureModel.ScreenCaptureModel):null;if(!i)return null;const n=this._emulationModel?this._emulationModel.overlayModel():null;let s;if(n&&n.setShowViewportSizeOnResize(!1),e){const e=await i.fetchLayoutMetrics();if(!e)return null;const n=Math.min(16384/this._appliedDeviceScaleFactor,e.contentHeight);s={width:Math.floor(e.contentWidth),height:Math.floor(n),deviceScaleFactor:this._appliedDeviceScaleFactor,mobile:this._isMobile()};const o=this._getDisplayFeature();if(o&&(s.displayFeature=o),t={x:0,y:0,width:s.width,height:s.height,scale:1},this._device){const e=this._mode.orientation===Horizontal?Protocol.Emulation.ScreenOrientationType.LandscapePrimary:Protocol.Emulation.ScreenOrientationType.PortraitPrimary,t=e===Protocol.Emulation.ScreenOrientationType.LandscapePrimary?90:0;s.screenOrientation={type:e,angle:t}}await this._emulationModel.resetPageScaleFactor(),await this._emulationModel.emulateDevice(s)}const o=await i.captureScreenshot(Protocol.Page.CaptureScreenshotRequestFormat.Png,100,t);if(e){if(this._device){const e=this._device.orientationByName(this._mode.orientation);s.width=e.width,s.height=e.height;const t=this._getDisplayFeature();t&&(s.displayFeature=t)}else s.width=0,s.height=0;await this._emulationModel.emulateDevice(s)}return this._calculateAndEmulate(!1),o}_applyTouch(e,t){this._touchEnabled=e,this._touchMobile=t;for(const i of SDKModel.TargetManager.instance().models(EmulationModel.EmulationModel))i.emulateTouch(e,t)}_showHingeIfApplicable(e){const t=this._device&&this._mode?this._device.orientationByName(this._mode.orientation):null;this._experimentDualScreenSupport&&t&&t.hinge?e.showHingeForDualScreen(t.hinge):e.showHingeForDualScreen(null)}_getDisplayFeatureOrientation(){switch(console.assert(this._mode,"Can only get display feature orientation when current mode is set."),this._mode.orientation){case VerticalSpanned:case Vertical:return Protocol.Emulation.DisplayFeatureOrientation.Vertical;case HorizontalSpanned:case Horizontal:default:return Protocol.Emulation.DisplayFeatureOrientation.Horizontal}}_getDisplayFeature(){if(!this.shouldReportDisplayFeature())return null;if(!this._device||!this._mode||this._mode.orientation!==VerticalSpanned&&this._mode.orientation!==HorizontalSpanned)return null;const e=this._device.orientationByName(this._mode.orientation);if(!e||!e.hinge)return null;const t=e.hinge;return{orientation:this._getDisplayFeatureOrientation(),offset:this._mode.orientation===VerticalSpanned?t.x:t.y,maskLength:this._mode.orientation===VerticalSpanned?t.width:t.height}}}const Events$1={Updated:"Updated"},Type$1={None:"None",Responsive:"Responsive",Device:"Device"},UA={Mobile:UIString.UIString("Mobile"),MobileNoTouch:UIString.UIString("Mobile (no touch)"),Desktop:UIString.UIString("Desktop"),DesktopTouch:UIString.UIString("Desktop (touch)")},MinDeviceSize=50,MaxDeviceSize=9999,MinDeviceScaleFactor=0,MaxDeviceScaleFactor=10,MaxDeviceNameLength=50,_mobileUserAgent="Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Mobile Safari/537.36",_defaultMobileUserAgent=NetworkManager.MultitargetNetworkManager.patchUserAgentWithChromeVersion(_mobileUserAgent),_defaultMobileUserAgentMetadata={brands:NetworkManager.MultitargetNetworkManager.getChromeBrands(),fullVersion:NetworkManager.MultitargetNetworkManager.getChromeVersion(),platform:"Android",platformVersion:"6.0",architecture:"",model:"Nexus 5",mobile:!0},defaultMobileScaleFactor=2;var DeviceModeModel$1=Object.freeze({__proto__:null,DeviceModeModel:DeviceModeModel,Events:Events$1,Type:Type$1,UA:UA,MinDeviceSize:MinDeviceSize,MaxDeviceSize:MaxDeviceSize,MinDeviceScaleFactor:MinDeviceScaleFactor,MaxDeviceScaleFactor:MaxDeviceScaleFactor,MaxDeviceNameLength:MaxDeviceNameLength,_defaultMobileUserAgent:_defaultMobileUserAgent,_defaultMobileUserAgentMetadata:_defaultMobileUserAgentMetadata,defaultMobileScaleFactor:defaultMobileScaleFactor});class DeviceModeToolbar{constructor(e,t,i){this._model=e;const n=e.device();n&&this._recordDeviceChange(n,null),this._showMediaInspectorSetting=t,this._showRulersSetting=i,this._experimentDualScreenSupport=Root.Runtime.experiments.isEnabled("dualScreenSupport"),this._deviceOutlineSetting=this._model.deviceOutlineSetting(),this._showDeviceScaleFactorSetting=Settings.Settings.instance().createSetting("emulation.showDeviceScaleFactor",!1),this._showDeviceScaleFactorSetting.addChangeListener(this._updateDeviceScaleFactorVisibility,this),this._showUserAgentTypeSetting=Settings.Settings.instance().createSetting("emulation.showUserAgentType",!1),this._showUserAgentTypeSetting.addChangeListener(this._updateUserAgentTypeVisibility,this),this._autoAdjustScaleSetting=Settings.Settings.instance().createSetting("emulation.autoAdjustScale",!0),this._lastMode=new Map,this._element=document.createElement("div"),this._element.classList.add("device-mode-toolbar");const s=this._element.createChild("div","device-mode-toolbar-spacer");s.createChild("div","device-mode-toolbar-spacer");const o=new Toolbar.Toolbar("",s);o.makeWrappable(),this._fillLeftToolbar(o);const a=new Toolbar.Toolbar("",this._element);a.makeWrappable(),this._fillMainToolbar(a);const r=this._element.createChild("div","device-mode-toolbar-spacer"),l=new Toolbar.Toolbar("device-mode-toolbar-fixed-size",r);l.makeWrappable(),this._fillRightToolbar(l);const c=new Toolbar.Toolbar("device-mode-toolbar-fixed-size",r);c.makeWrappable(),this._fillModeToolbar(c),r.createChild("div","device-mode-toolbar-spacer");const d=new Toolbar.Toolbar("device-mode-toolbar-options",r);function h(){const t=e.toolbarControlsEnabledSetting().get();o.setEnabled(t),a.setEnabled(t),l.setEnabled(t),c.setEnabled(t),d.setEnabled(t)}d.makeWrappable(),this._fillOptionsToolbar(d),this._emulatedDevicesList=EmulatedDevicesList.instance(),this._emulatedDevicesList.addEventListener(Events.CustomDevicesUpdated,this._deviceListChanged,this),this._emulatedDevicesList.addEventListener(Events.StandardDevicesUpdated,this._deviceListChanged,this),this._persistenceSetting=Settings.Settings.instance().createSetting("emulation.deviceModeValue",{device:"",orientation:"",mode:""}),this._model.toolbarControlsEnabledSetting().addChangeListener(h),h()}_recordDeviceChange(e,t){e!==t&&e&&e.isDualScreen&&userMetrics.dualScreenDeviceEmulated(UserMetrics.DualScreenDeviceEmulated.DualScreenDeviceSelected)}_createEmptyToolbarElement(){const e=document.createElement("div");return e.classList.add("device-mode-empty-toolbar-element"),e}_fillLeftToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._deviceSelectItem=new Toolbar.ToolbarMenuButton(this._appendDeviceMenuItems.bind(this)),this._deviceSelectItem.setGlyph(""),this._deviceSelectItem.turnIntoSelect(),this._deviceSelectItem.setDarkText(),e.appendToolbarItem(this._deviceSelectItem)}_fillMainToolbar(e){const t=UIUtils.createInput("device-mode-size-input","text");t.maxLength=4,t.title=UIString.UIString("Width"),this._updateWidthInput=UIUtils.bindInput(t,this._applyWidth.bind(this),DeviceModeModel.widthValidator,!0),this._widthInput=t,this._widthItem=this._wrapToolbarItem(t),e.appendToolbarItem(this._widthItem);const i=document.createElement("div");i.classList.add("device-mode-x"),i.textContent="×",this._xItem=this._wrapToolbarItem(i),e.appendToolbarItem(this._xItem);const n=UIUtils.createInput("device-mode-size-input","text");n.maxLength=4,n.title=UIString.UIString("Height (leave empty for full)"),this._updateHeightInput=UIUtils.bindInput(n,this._applyHeight.bind(this),(function(e){if(!e)return{valid:!0};return DeviceModeModel.heightValidator(e)}),!0),this._heightInput=n,this._heightItem=this._wrapToolbarItem(n),e.appendToolbarItem(this._heightItem)}_applyWidth(e){const t=e?Number(e):0;this._model.setWidthAndScaleToFit(t)}_applyHeight(e){const t=e?Number(e):0;this._model.setHeightAndScaleToFit(t)}_fillRightToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._scaleItem=new Toolbar.ToolbarMenuButton(this._appendScaleMenuItems.bind(this)),this._scaleItem.setTitle(UIString.UIString("Zoom")),this._scaleItem.setGlyph(""),this._scaleItem.turnIntoSelect(),this._scaleItem.setDarkText(),e.appendToolbarItem(this._scaleItem),e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._deviceScaleItem=new Toolbar.ToolbarMenuButton(this._appendDeviceScaleMenuItems.bind(this)),this._deviceScaleItem.setVisible(this._showDeviceScaleFactorSetting.get()),this._deviceScaleItem.setTitle(UIString.UIString("Device pixel ratio")),this._deviceScaleItem.setGlyph(""),this._deviceScaleItem.turnIntoSelect(),this._deviceScaleItem.setDarkText(),e.appendToolbarItem(this._deviceScaleItem),e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._uaItem=new Toolbar.ToolbarMenuButton(this._appendUserAgentMenuItems.bind(this)),this._uaItem.setVisible(this._showUserAgentTypeSetting.get()),this._uaItem.setTitle(UIString.UIString("Device type")),this._uaItem.setGlyph(""),this._uaItem.turnIntoSelect(),this._uaItem.setDarkText(),e.appendToolbarItem(this._uaItem),this._throttlingConditionsItem=ThrottlingManager.throttlingManager().createMobileThrottlingButton(),e.appendToolbarItem(this._throttlingConditionsItem)}_fillModeToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement())),this._modeButton=new Toolbar.ToolbarButton("","largeicon-rotate-screen"),this._modeButton.addEventListener(Toolbar.ToolbarButton.Events.Click,this._modeMenuClicked,this),e.appendToolbarItem(this._modeButton),this._experimentDualScreenSupport&&(this._spanButton=new Toolbar.ToolbarButton("","largeicon-dual-screen"),this._spanButton.addEventListener(Toolbar.ToolbarButton.Events.Click,this._spanClicked,this),e.appendToolbarItem(this._spanButton),this._createExperimentalButton(e))}_createExperimentalButton(e){e.appendToolbarItem(new Toolbar.ToolbarSeparator(!0));const t=this._model.webPlatformExperimentalFeaturesEnabled()?UIString.UIString('"Experimental Web Platform Feature" flag is enabled. Click to disable it.'):UIString.UIString('"Experimental Web Platform Feature" flag is disabled. Click to enable it.');this._experimentalButton=new Toolbar.ToolbarToggle(t,"largeicon-experimental-api"),this._experimentalButton.setToggled(this._model.webPlatformExperimentalFeaturesEnabled()),this._experimentalButton.setEnabled(!0),this._experimentalButton.addEventListener(Toolbar.ToolbarButton.Events.Click,this._experimentalClicked,this),e.appendToolbarItem(this._experimentalButton)}_experimentalClicked(){InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab("chrome://flags/#enable-experimental-web-platform-features")}_fillOptionsToolbar(e){e.appendToolbarItem(this._wrapToolbarItem(this._createEmptyToolbarElement()));const t=new Toolbar.ToolbarMenuButton(this._appendOptionsMenuItems.bind(this));t.setTitle(UIString.UIString("More options")),e.appendToolbarItem(t)}_appendScaleMenuItems(e){this._model.type()===Type$1.Device&&e.footerSection().appendItem(UIString.UIString("Fit to window (%.0f%%)",100*this._model.fitScale()),this._onScaleMenuChanged.bind(this,this._model.fitScale()),!1),e.footerSection().appendCheckboxItem(ls`Auto-adjust zoom`,this._onAutoAdjustScaleChanged.bind(this),this._autoAdjustScaleSetting.get());const t=function(t,i){e.defaultSection().appendCheckboxItem(t,this._onScaleMenuChanged.bind(this,i),this._model.scaleSetting().get()===i,!1)}.bind(this);t(UIString.UIString("50%"),.5),t(UIString.UIString("75%"),.75),t(UIString.UIString("100%"),1),t(UIString.UIString("125%"),1.25),t(UIString.UIString("150%"),1.5)}_onScaleMenuChanged(e){this._model.scaleSetting().set(e)}_onAutoAdjustScaleChanged(){this._autoAdjustScaleSetting.set(!this._autoAdjustScaleSetting.get())}_appendDeviceScaleMenuItems(e){const t=this._model.deviceScaleFactorSetting(),i=this._model.uaSetting().get()===UA.Mobile||this._model.uaSetting().get()===UA.MobileNoTouch?defaultMobileScaleFactor:window.devicePixelRatio;function n(e,i,n){e.appendCheckboxItem(i,t.set.bind(t,n),t.get()===n)}n(e.headerSection(),UIString.UIString("Default: %.1f",i),0),n(e.defaultSection(),UIString.UIString("1"),1),n(e.defaultSection(),UIString.UIString("2"),2),n(e.defaultSection(),UIString.UIString("3"),3)}_appendUserAgentMenuItems(e){const t=this._model.uaSetting();function i(i,n){e.defaultSection().appendCheckboxItem(i,t.set.bind(t,n),t.get()===n)}i(UA.Mobile,UA.Mobile),i(UA.MobileNoTouch,UA.MobileNoTouch),i(UA.Desktop,UA.Desktop),i(UA.DesktopTouch,UA.DesktopTouch)}_appendOptionsMenuItems(e){const t=this._model;function i(e,i,n,s,o){void 0===o&&(o=t.type()===Type$1.None),e.appendItem(i.get()?n:s,i.set.bind(i,!i.get()),o)}i(e.headerSection(),this._deviceOutlineSetting,UIString.UIString("Hide device frame"),UIString.UIString("Show device frame"),t.type()!==Type$1.Device),i(e.headerSection(),this._showMediaInspectorSetting,UIString.UIString("Hide media queries"),UIString.UIString("Show media queries")),i(e.headerSection(),this._showRulersSetting,UIString.UIString("Hide rulers"),UIString.UIString("Show rulers")),i(e.defaultSection(),this._showDeviceScaleFactorSetting,UIString.UIString("Remove device pixel ratio"),UIString.UIString("Add device pixel ratio")),i(e.defaultSection(),this._showUserAgentTypeSetting,UIString.UIString("Remove device type"),UIString.UIString("Add device type")),e.appendItemsAtLocation("deviceModeMenu"),e.footerSection().appendItem(UIString.UIString("Reset to defaults"),this._reset.bind(this)),e.footerSection().appendItem(ls`Close DevTools`,InspectorFrontendHost.InspectorFrontendHostInstance.closeWindow.bind(InspectorFrontendHost.InspectorFrontendHostInstance))}_reset(){this._deviceOutlineSetting.set(!1),this._showDeviceScaleFactorSetting.set(!1),this._showUserAgentTypeSetting.set(!1),this._showMediaInspectorSetting.set(!1),this._showRulersSetting.set(!1),this._model.reset()}_wrapToolbarItem(e){const t=createElement("div");return Utils.createShadowRootWithCoreStyles(t,"emulation/deviceModeToolbar.css").appendChild(e),new Toolbar.ToolbarItem(t)}_emulateDevice(e){const t=this._autoAdjustScaleSetting.get()?void 0:this._model.scaleSetting().get();this._recordDeviceChange(e,this._model.device()),this._model.emulate(Type$1.Device,e,this._lastMode.get(e)||e.modes[0],t)}_switchToResponsive(){this._model.emulate(Type$1.Responsive,null,null)}_filterDevices(e){return(e=e.filter((function(e){return e.show()}))).sort(EmulatedDevice.deviceComparator),e}_standardDevices(){return this._filterDevices(this._emulatedDevicesList.standard())}_customDevices(){return this._filterDevices(this._emulatedDevicesList.custom())}_allDevices(){return this._standardDevices().concat(this._customDevices())}_appendDeviceMenuItems(e){function t(t){if(!t.length)return;const i=e.section();for(const e of t)i.appendCheckboxItem(e.title,this._emulateDevice.bind(this,e),this._model.device()===e,!1)}e.headerSection().appendCheckboxItem(UIString.UIString("Responsive"),this._switchToResponsive.bind(this),this._model.type()===Type$1.Responsive,!1),t.call(this,this._standardDevices()),t.call(this,this._customDevices()),e.footerSection().appendItem(UIString.UIString("Edit…"),this._emulatedDevicesList.revealCustomSetting.bind(this._emulatedDevicesList),!1)}_deviceListChanged(){const e=this._model.device();if(!e)return;const t=this._allDevices();-1===t.indexOf(e)&&(t.length?this._emulateDevice(t[0]):this._model.emulate(Type$1.Responsive,null,null))}_updateDeviceScaleFactorVisibility(){this._deviceScaleItem.setVisible(this._showDeviceScaleFactorSetting.get())}_updateUserAgentTypeVisibility(){this._uaItem.setVisible(this._showUserAgentTypeSetting.get())}_spanClicked(e){const t=this._model.device();if(!t.isDualScreen)return;userMetrics.dualScreenDeviceEmulated(UserMetrics.DualScreenDeviceEmulated.SpanButtonClicked);const i=this._autoAdjustScaleSetting.get()?void 0:this._model.scaleSetting().get(),n=t.getSpanPartner(this._model.mode());n&&this._model.emulate(this._model.type(),t,n,i)}_modeMenuClicked(e){const t=this._model.device(),i=this._model,n=this._autoAdjustScaleSetting;if(i.type()===Type$1.Responsive){const e=i.appliedDeviceSize();return void(n.get()?i.setSizeAndScaleToFit(e.height,e.width):(i.setWidth(e.height),i.setHeight(e.width)))}if((t.isDualScreen||2===t.modes.length)&&t.modes[0].orientation!==t.modes[1].orientation){const e=n.get()?void 0:i.scaleSetting().get();return void i.emulate(i.type(),i.device(),t.getRotationPartner(i.mode()),e)}const s=new ContextMenu.ContextMenu(e.data,!1,this._modeButton.element.totalOffsetLeft(),this._modeButton.element.totalOffsetTop()+this._modeButton.element.offsetHeight);function o(e,i){const n=t.modesForOrientation(e);if(n.length)if(1===n.length)a(n[0],i);else for(let e=0;e<n.length;e++)a(n[e],i+" – "+n[e].title)}function a(e,t){s.defaultSection().appendCheckboxItem(t,r.bind(null,e),i.mode()===e,!1)}function r(e){const t=n.get()?void 0:i.scaleSetting().get();i.emulate(i.type(),i.device(),e,t)}o(Vertical,UIString.UIString("Portrait")),o(Horizontal,UIString.UIString("Landscape")),s.show()}element(){return this._element}update(){this._model.type()!==this._cachedModelType&&(this._cachedModelType=this._model.type(),this._widthInput.disabled=this._model.type()!==Type$1.Responsive,this._heightInput.disabled=this._model.type()!==Type$1.Responsive,this._deviceScaleItem.setEnabled(this._model.type()===Type$1.Responsive),this._uaItem.setEnabled(this._model.type()===Type$1.Responsive),this._model.type()===Type$1.Responsive?(this._modeButton.setEnabled(!0),this._modeButton.setTitle(ls`Rotate`)):this._modeButton.setEnabled(!1));const e=this._model.appliedDeviceSize();this._updateHeightInput(this._model.type()===Type$1.Responsive&&this._model.isFullHeight()?"":String(e.height)),this._updateWidthInput(String(e.width)),this._heightInput.placeholder=e.height,this._model.scale()!==this._cachedScale&&(this._scaleItem.setText(UIString.UIString("%.0f%%",100*this._model.scale())),this._cachedScale=this._model.scale());const t=this._model.appliedDeviceScaleFactor();t!==this._cachedDeviceScale&&(this._deviceScaleItem.setText(UIString.UIString("DPR: %.1f",t)),this._cachedDeviceScale=t);const i=this._model.appliedUserAgentType();i!==this._cachedUaType&&(this._uaItem.setText(i),this._cachedUaType=i);let n=UIString.UIString("None");if(this._model.type()===Type$1.Responsive&&(n=UIString.UIString("Responsive")),this._model.type()===Type$1.Device&&(n=this._model.device().title),this._deviceSelectItem.setText(n),this._model.device()!==this._cachedModelDevice){const e=this._model.device();if(e){const t=e?e.modes.length:0;this._modeButton.setEnabled(t>=2),this._modeButton.setTitle(2===t?UIString.UIString("Rotate"):UIString.UIString("Screen orientation options"))}this._cachedModelDevice=e}if(this._experimentDualScreenSupport){const e=this._model.device();e&&e.isDualScreen?(this._spanButton.setEnabled(!0),this._experimentalButton.setVisible(!0)):(this._spanButton.setEnabled(!1),this._experimentalButton.setVisible(!1)),this._spanButton.setTitle(UIString.UIString("Toggle dual-screen mode"))}if(this._model.type()===Type$1.Device&&this._lastMode.set(this._model.device(),this._model.mode()),this._model.mode()!==this._cachedModelMode&&this._model.type()!==Type$1.None){this._cachedModelMode=this._model.mode();const e=this._persistenceSetting.get();this._model.device()?(e.device=this._model.device().title,e.orientation=this._model.mode()?this._model.mode().orientation:"",e.mode=this._model.mode()?this._model.mode().title:""):(e.device="",e.orientation="",e.mode=""),this._persistenceSetting.set(e)}}restore(){for(const e of this._allDevices())if(e.title===this._persistenceSetting.get().device)for(const t of e.modes)if(t.orientation===this._persistenceSetting.get().orientation&&t.title===this._persistenceSetting.get().mode)return this._lastMode.set(e,t),void this._emulateDevice(e);this._model.emulate(Type$1.Responsive,null,null)}}var DeviceModeToolbar$1=Object.freeze({__proto__:null,DeviceModeToolbar:DeviceModeToolbar});class MediaQueryInspector extends Widget.Widget{constructor(e,t){super(!0),this.registerRequiredCSS("emulation/mediaQueryInspector.css"),this.contentElement.classList.add("media-inspector-view"),this.contentElement.addEventListener("click",this._onMediaQueryClicked.bind(this),!1),this.contentElement.addEventListener("contextmenu",this._onContextMenu.bind(this),!1),this._mediaThrottler=new Throttler.Throttler(0),this._getWidthCallback=e,this._setWidthCallback=t,this._scale=1,SDKModel.TargetManager.instance().observeModels(CSSModel.CSSModel,this),ZoomManager.ZoomManager.instance().addEventListener(ZoomManager.Events.ZoomChanged,this._renderMediaQueries.bind(this),this)}modelAdded(e){this._cssModel||(this._cssModel=e,this._cssModel.addEventListener(CSSModel.Events.StyleSheetAdded,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(CSSModel.Events.StyleSheetRemoved,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(CSSModel.Events.StyleSheetChanged,this._scheduleMediaQueriesUpdate,this),this._cssModel.addEventListener(CSSModel.Events.MediaQueryResultChanged,this._scheduleMediaQueriesUpdate,this))}modelRemoved(e){e===this._cssModel&&(this._cssModel.removeEventListener(CSSModel.Events.StyleSheetAdded,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(CSSModel.Events.StyleSheetRemoved,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(CSSModel.Events.StyleSheetChanged,this._scheduleMediaQueriesUpdate,this),this._cssModel.removeEventListener(CSSModel.Events.MediaQueryResultChanged,this._scheduleMediaQueriesUpdate,this),delete this._cssModel)}setAxisTransform(e){Math.abs(this._scale-e)<1e-8||(this._scale=e,this._renderMediaQueries())}_onMediaQueryClicked(e){const t=e.target.enclosingNodeOrSelfWithClass("media-inspector-bar");if(!t)return;const i=t._model;if(i.section()===Section.Max)return void this._setWidthCallback(i.maxWidthExpression().computedLength());if(i.section()===Section.Min)return void this._setWidthCallback(i.minWidthExpression().computedLength());this._getWidthCallback()!==i.minWidthExpression().computedLength()?this._setWidthCallback(i.minWidthExpression().computedLength()):this._setWidthCallback(i.maxWidthExpression().computedLength())}_onContextMenu(e){if(!this._cssModel||!this._cssModel.isEnabled())return;const t=e.target.enclosingNodeOrSelfWithClass("media-inspector-bar");if(!t)return;const i=t._locations,n=new Map;for(let e=0;e<i.length;++e){const t=CSSWorkspaceBinding.CSSWorkspaceBinding.instance().rawLocationToUILocation(i[e]);if(!t)continue;const s=StringUtilities.sprintf("%s:%d:%d",t.uiSourceCode.url(),t.lineNumber+1,t.columnNumber+1);n.set(s,t)}const s=[...n.keys()].sort(),o=new ContextMenu.ContextMenu(e),a=o.defaultSection().appendSubMenuItem(UIString.UIString("Reveal in source code"));for(let e=0;e<s.length;++e){const t=s[e];a.defaultSection().appendItem(t,this._revealSourceLocation.bind(this,n.get(t)))}o.show()}_revealSourceLocation(e){Revealer.reveal(e)}_scheduleMediaQueriesUpdate(){this.isShowing()&&this._mediaThrottler.schedule(this._refetchMediaQueries.bind(this))}_refetchMediaQueries(){return this.isShowing()&&this._cssModel?this._cssModel.mediaQueriesPromise().then(this._rebuildMediaQueries.bind(this)):Promise.resolve()}_squashAdjacentEqual(e){const t=[];for(let i=0;i<e.length;++i){const n=t.peekLast();n&&n.equals(e[i])||t.push(e[i])}return t}_rebuildMediaQueries(e){let t=[];for(let i=0;i<e.length;++i){const n=e[i];if(n.mediaList)for(let e=0;e<n.mediaList.length;++e){const i=n.mediaList[e],s=MediaQueryUIModel.createFromMediaQuery(n,i);s&&t.push(s)}}t.sort((function(e,t){return e.compareTo(t)})),t=this._squashAdjacentEqual(t);let i=this._cachedQueryModels&&this._cachedQueryModels.length===t.length;for(let e=0;i&&e<t.length;++e)i=i&&this._cachedQueryModels[e].equals(t[e]);i||(this._cachedQueryModels=t,this._renderMediaQueries())}_renderMediaQueries(){if(!this._cachedQueryModels||!this.isShowing())return;const e=[];let t=null;for(let i=0;i<this._cachedQueryModels.length;++i){const n=this._cachedQueryModels[i];t&&t.model.dimensionsEqual(n)?t.active=t.active||n.active():(t={active:n.active(),model:n,locations:[]},e.push(t));const s=n.rawLocation();s&&t.locations.push(s)}this.contentElement.removeChildren();let i=null;for(let t=0;t<e.length;++t){t&&e[t].model.section()===e[t-1].model.section()||(i=this.contentElement.createChild("div","media-inspector-marker-container"));const n=e[t],s=this._createElementFromMediaQueryModel(n.model);s._model=n.model,s._locations=n.locations,s.classList.toggle("media-inspector-marker-inactive",!n.active),i.appendChild(s)}}_zoomFactor(){return ZoomManager.ZoomManager.instance().zoomFactor()/this._scale}wasShown(){this._scheduleMediaQueriesUpdate()}_createElementFromMediaQueryModel(e){const t=this._zoomFactor(),i=e.minWidthExpression()?e.minWidthExpression().computedLength()/t:0,n=e.maxWidthExpression()?e.maxWidthExpression().computedLength()/t:0,s=document.createElement("div");if(s.classList.add("media-inspector-bar"),e.section()===Section.Max){s.createChild("div","media-inspector-marker-spacer");const t=s.createChild("div","media-inspector-marker media-inspector-marker-max-width");t.style.width=n+"px",t.title=e.mediaText(),o(t,e.maxWidthExpression(),!1,!1),o(t,e.maxWidthExpression(),!0,!0),s.createChild("div","media-inspector-marker-spacer")}if(e.section()===Section.MinMax){s.createChild("div","media-inspector-marker-spacer");const t=s.createChild("div","media-inspector-marker media-inspector-marker-min-max-width");t.style.width=.5*(n-i)+"px",t.title=e.mediaText(),o(t,e.maxWidthExpression(),!0,!1),o(t,e.minWidthExpression(),!1,!0),s.createChild("div","media-inspector-marker-spacer").style.flex="0 0 "+i+"px";const a=s.createChild("div","media-inspector-marker media-inspector-marker-min-max-width");a.style.width=.5*(n-i)+"px",a.title=e.mediaText(),o(a,e.minWidthExpression(),!0,!1),o(a,e.maxWidthExpression(),!1,!0),s.createChild("div","media-inspector-marker-spacer")}if(e.section()===Section.Min){const t=s.createChild("div","media-inspector-marker media-inspector-marker-min-width media-inspector-marker-min-width-left");t.title=e.mediaText(),o(t,e.minWidthExpression(),!1,!1),s.createChild("div","media-inspector-marker-spacer").style.flex="0 0 "+i+"px";const n=s.createChild("div","media-inspector-marker media-inspector-marker-min-width media-inspector-marker-min-width-right");n.title=e.mediaText(),o(n,e.minWidthExpression(),!0,!0)}function o(e,t,i,n){e.createChild("div","media-inspector-marker-label-container "+(i?"media-inspector-marker-label-container-left":"media-inspector-marker-label-container-right")).createChild("span","media-inspector-marker-label "+(n?"media-inspector-label-left":"media-inspector-label-right")).textContent=t.value()+t.unit()}return s}}const Section={Max:0,MinMax:1,Min:2};class MediaQueryUIModel{constructor(e,t,i,n){this._cssMedia=e,this._minWidthExpression=t,this._maxWidthExpression=i,this._active=n,this._section=i&&!t?Section.Max:t&&i?Section.MinMax:Section.Min}static createFromMediaQuery(e,t){let i=null,n=Number.MAX_VALUE,s=null,o=Number.MIN_VALUE;const a=t.expressions();for(let e=0;e<a.length;++e){const t=a[e],r=t.feature();if(-1===r.indexOf("width"))continue;const l=t.computedLength();r.startsWith("max-")&&l<n?(i=t,n=l):r.startsWith("min-")&&l>o&&(s=t,o=l)}return o>n||!i&&!s?null:new MediaQueryUIModel(e,s,i,t.active())}equals(e){return 0===this.compareTo(e)}dimensionsEqual(e){return!(this.section()!==e.section()||this.minWidthExpression()&&this.minWidthExpression().computedLength()!==e.minWidthExpression().computedLength()||this.maxWidthExpression()&&this.maxWidthExpression().computedLength()!==e.maxWidthExpression().computedLength())}compareTo(e){if(this.section()!==e.section())return this.section()-e.section();if(this.dimensionsEqual(e)){const t=this.rawLocation(),i=e.rawLocation();return t||i?t&&!i?1:!t&&i?-1:this.active()!==e.active()?this.active()?-1:1:t.url.compareTo(i.url)||t.lineNumber-i.lineNumber||t.columnNumber-i.columnNumber:this.mediaText().compareTo(e.mediaText())}return this.section()===Section.Max?e.maxWidthExpression().computedLength()-this.maxWidthExpression().computedLength():this.section()===Section.Min?this.minWidthExpression().computedLength()-e.minWidthExpression().computedLength():this.minWidthExpression().computedLength()-e.minWidthExpression().computedLength()||e.maxWidthExpression().computedLength()-this.maxWidthExpression().computedLength()}section(){return this._section}mediaText(){return this._cssMedia.text}rawLocation(){return this._rawLocation||(this._rawLocation=this._cssMedia.rawLocation()),this._rawLocation}minWidthExpression(){return this._minWidthExpression}maxWidthExpression(){return this._maxWidthExpression}active(){return this._active}}var MediaQueryInspector$1=Object.freeze({__proto__:null,MediaQueryInspector:MediaQueryInspector,Section:Section,MediaQueryUIModel:MediaQueryUIModel});class DeviceModeView extends Widget.VBox{constructor(){super(!0),this.wrapperInstance,this.setMinimumSize(150,150),this.element.classList.add("device-mode-view"),this.registerRequiredCSS("emulation/deviceModeView.css"),Tooltip.Tooltip.addNativeOverrideContainer(this.contentElement),this._model=self.singleton(DeviceModeModel),this._model.addEventListener(Events$1.Updated,this._updateUI,this),this._mediaInspector=new MediaQueryInspector(()=>this._model.appliedDeviceSize().width,this._model.setWidth.bind(this._model)),this._showMediaInspectorSetting=Settings.Settings.instance().moduleSetting("showMediaQueryInspector"),this._showMediaInspectorSetting.addChangeListener(this._updateUI,this),this._showRulersSetting=Settings.Settings.instance().moduleSetting("emulation.showRulers"),this._showRulersSetting.addChangeListener(this._updateUI,this),this._topRuler=new Ruler(!0,this._model.setWidthAndScaleToFit.bind(this._model)),this._topRuler.element.classList.add("device-mode-ruler-top"),this._leftRuler=new Ruler(!1,this._model.setHeightAndScaleToFit.bind(this._model)),this._leftRuler.element.classList.add("device-mode-ruler-left"),this._createUI(),ZoomManager.ZoomManager.instance().addEventListener(ZoomManager.Events.ZoomChanged,this._zoomChanged,this)}_createUI(){this._toolbar=new DeviceModeToolbar(this._model,this._showMediaInspectorSetting,this._showRulersSetting),this.contentElement.appendChild(this._toolbar.element()),this._contentClip=this.contentElement.createChild("div","device-mode-content-clip vbox"),this._responsivePresetsContainer=this._contentClip.createChild("div","device-mode-presets-container"),this._populatePresetsContainer(),this._mediaInspectorContainer=this._contentClip.createChild("div","device-mode-media-container"),this._contentArea=this._contentClip.createChild("div","device-mode-content-area"),this._outlineImage=this._contentArea.createChild("img","device-mode-outline-image hidden fill"),this._outlineImage.addEventListener("load",this._onImageLoaded.bind(this,this._outlineImage,!0),!1),this._outlineImage.addEventListener("error",this._onImageLoaded.bind(this,this._outlineImage,!1),!1),this._screenArea=this._contentArea.createChild("div","device-mode-screen-area"),this._screenImage=this._screenArea.createChild("img","device-mode-screen-image hidden"),this._screenImage.addEventListener("load",this._onImageLoaded.bind(this,this._screenImage,!0),!1),this._screenImage.addEventListener("error",this._onImageLoaded.bind(this,this._screenImage,!1),!1),this._bottomRightResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-right-resizer"),this._bottomRightResizerElement.createChild("div",""),this._createResizer(this._bottomRightResizerElement,2,1),this._bottomLeftResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-left-resizer"),this._bottomLeftResizerElement.createChild("div",""),this._createResizer(this._bottomLeftResizerElement,-2,1),this._rightResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-right-resizer"),this._rightResizerElement.createChild("div",""),this._createResizer(this._rightResizerElement,2,0),this._leftResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-left-resizer"),this._leftResizerElement.createChild("div",""),this._createResizer(this._leftResizerElement,-2,0),this._bottomResizerElement=this._screenArea.createChild("div","device-mode-resizer device-mode-bottom-resizer"),this._bottomResizerElement.createChild("div",""),this._createResizer(this._bottomResizerElement,0,1),this._bottomResizerElement.addEventListener("dblclick",this._model.setHeight.bind(this._model,0),!1),this._bottomResizerElement.title=UIString.UIString("Double-click for full height"),this._pageArea=this._screenArea.createChild("div","device-mode-page-area"),this._pageArea.createChild("slot")}_populatePresetsContainer(){const e=[320,375,425,768,1024,1440,2560],t=[UIString.UIString("Mobile S"),UIString.UIString("Mobile M"),UIString.UIString("Mobile L"),UIString.UIString("Tablet"),UIString.UIString("Laptop"),UIString.UIString("Laptop L"),UIString.UIString("4K")];this._presetBlocks=[];const i=this._responsivePresetsContainer.createChild("div","device-mode-presets-container-inner");for(let s=e.length-1;s>=0;--s){const o=i.createChild("div","fill device-mode-preset-bar-outer").createChild("div","device-mode-preset-bar");o.createChild("span").textContent=t[s]+" – "+e[s]+"px",o.addEventListener("click",n.bind(this,e[s]),!1),o.__width=e[s],this._presetBlocks.push(o)}function n(e,t){this._model.emulate(Type$1.Responsive,null,null),this._model.setWidthAndScaleToFit(e),t.consume()}}_createResizer(e,t,i){const n=new ResizerWidget.ResizerWidget;n.addElement(e);let s=t?"ew-resize":"ns-resize";return t*i>0&&(s="nwse-resize"),t*i<0&&(s="nesw-resize"),n.setCursor(s),n.addEventListener(ResizerWidget.Events.ResizeStart,this._onResizeStart,this),n.addEventListener(ResizerWidget.Events.ResizeUpdate,this._onResizeUpdate.bind(this,t,i)),n.addEventListener(ResizerWidget.Events.ResizeEnd,this._onResizeEnd,this),n}_onResizeStart(e){this._slowPositionStart=null,this._resizeStart=this._model.screenRect().size()}_onResizeUpdate(e,t,i){i.data.shiftKey!==!!this._slowPositionStart&&(this._slowPositionStart=i.data.shiftKey?{x:i.data.currentX,y:i.data.currentY}:null);let n=i.data.currentX-i.data.startX,s=i.data.currentY-i.data.startY;if(this._slowPositionStart&&(n=(i.data.currentX-this._slowPositionStart.x)/10+this._slowPositionStart.x-i.data.startX,s=(i.data.currentY-this._slowPositionStart.y)/10+this._slowPositionStart.y-i.data.startY),e){const t=n*ZoomManager.ZoomManager.instance().zoomFactor();let i=this._resizeStart.width+t*e;i=Math.round(i/this._model.scale()),i>=MinDeviceSize&&i<=MaxDeviceSize&&this._model.setWidth(i)}if(t){const e=s*ZoomManager.ZoomManager.instance().zoomFactor();let i=this._resizeStart.height+e*t;i=Math.round(i/this._model.scale()),i>=MinDeviceSize&&i<=MaxDeviceSize&&this._model.setHeight(i)}}exitHingeMode(){this._model&&this._model.exitHingeMode()}_onResizeEnd(e){delete this._resizeStart,userMetrics.actionTaken(UserMetrics.Action.ResizedViewInResponsiveMode)}_updateUI(){function e(e,t){e.style.left=t.left+"px",e.style.top=t.top+"px",e.style.width=t.width+"px",e.style.height=t.height+"px"}if(!this.isShowing())return;const t=ZoomManager.ZoomManager.instance().zoomFactor();let i=!1;const n=this._showRulersSetting.get()&&this._model.type()!==Type$1.None;let s=!1,o=!1;const a=this._model.screenRect().scale(1/t);a.isEqual(this._cachedCssScreenRect)||(e(this._screenArea,a),o=!0,i=!0,this._cachedCssScreenRect=a);const r=this._model.visiblePageRect().scale(1/t);r.isEqual(this._cachedCssVisiblePageRect)||(e(this._pageArea,r),i=!0,this._cachedCssVisiblePageRect=r);const l=this._model.outlineRect().scale(1/t);l.isEqual(this._cachedOutlineRect)||(e(this._outlineImage,l),i=!0,this._cachedOutlineRect=l),this._contentClip.classList.toggle("device-mode-outline-visible",!!this._model.outlineImage());const c=this._model.type()===Type$1.Responsive;c!==this._cachedResizable&&(this._rightResizerElement.classList.toggle("hidden",!c),this._leftResizerElement.classList.toggle("hidden",!c),this._bottomResizerElement.classList.toggle("hidden",!c),this._bottomRightResizerElement.classList.toggle("hidden",!c),this._bottomLeftResizerElement.classList.toggle("hidden",!c),this._cachedResizable=c);const d=this._showMediaInspectorSetting.get()&&this._model.type()!==Type$1.None;if(d!==this._cachedMediaInspectorVisible&&(d?this._mediaInspector.show(this._mediaInspectorContainer):this._mediaInspector.detach(),s=!0,i=!0,this._cachedMediaInspectorVisible=d),n!==this._cachedShowRulers&&(this._contentClip.classList.toggle("device-mode-rulers-visible",n),n?(this._topRuler.show(this._contentArea),this._leftRuler.show(this._contentArea)):(this._topRuler.detach(),this._leftRuler.detach()),s=!0,i=!0,this._cachedShowRulers=n),this._model.scale()!==this._cachedScale){o=!0,i=!0;for(const e of this._presetBlocks)e.style.width=e.__width*this._model.scale()+"px";this._cachedScale=this._model.scale()}this._toolbar.update(),this._loadImage(this._screenImage,this._model.screenImage()),this._loadImage(this._outlineImage,this._model.outlineImage()),this._mediaInspector.setAxisTransform(this._model.scale()),i&&this.doResize(),o&&(this._topRuler.render(this._model.scale()),this._leftRuler.render(this._model.scale()),this._topRuler.element.positionAt(this._cachedCssScreenRect?this._cachedCssScreenRect.left:0,this._cachedCssScreenRect?this._cachedCssScreenRect.top:0),this._leftRuler.element.positionAt(this._cachedCssScreenRect?this._cachedCssScreenRect.left:0,this._cachedCssScreenRect?this._cachedCssScreenRect.top:0)),s&&this._contentAreaResized()}_loadImage(e,t){e.getAttribute("srcset")!==t&&(e.setAttribute("srcset",t),t||e.classList.toggle("hidden",!0))}_onImageLoaded(e,t){e.classList.toggle("hidden",!t)}setNonEmulatedAvailableSize(e){if(this._model.type()!==Type$1.None)return;const t=ZoomManager.ZoomManager.instance().zoomFactor(),i=e.getBoundingClientRect(),n=new Geometry.Size(Math.max(i.width*t,1),Math.max(i.height*t,1));this._model.setAvailableSize(n,n)}_contentAreaResized(){const e=ZoomManager.ZoomManager.instance().zoomFactor(),t=this._contentArea.getBoundingClientRect(),i=new Geometry.Size(Math.max(t.width*e,1),Math.max(t.height*e,1)),n=new Geometry.Size(Math.max((t.width-2*this._handleWidth)*e,1),Math.max((t.height-this._handleHeight)*e,1));this._model.setAvailableSize(i,n)}_measureHandles(){const e=this._rightResizerElement.classList.contains("hidden");this._rightResizerElement.classList.toggle("hidden",!1),this._bottomResizerElement.classList.toggle("hidden",!1),this._handleWidth=this._rightResizerElement.offsetWidth,this._handleHeight=this._bottomResizerElement.offsetHeight,this._rightResizerElement.classList.toggle("hidden",e),this._bottomResizerElement.classList.toggle("hidden",e)}_zoomChanged(){delete this._handleWidth,delete this._handleHeight,this.isShowing()&&(this._measureHandles(),this._contentAreaResized())}onResize(){this.isShowing()&&this._contentAreaResized()}wasShown(){this._measureHandles(),this._toolbar.restore()}willHide(){this._model.emulate(Type$1.None,null,null)}async captureScreenshot(){const e=await this._model.captureScreenshot(!1);if(null===e)return;const t=new Image;t.src="data:image/png;base64,"+e,t.onload=async()=>{const e=t.naturalWidth/this._model.screenRect().width,i=this._model.outlineRect().scale(e),n=this._model.screenRect().scale(e),s=this._model.visiblePageRect().scale(e),o=n.left+s.left-i.left,a=n.top+s.top-i.top,r=createElement("canvas");r.width=Math.floor(i.width),r.height=Math.floor(i.height);const l=r.getContext("2d");l.imageSmoothingEnabled=!1,this._model.outlineImage()&&await this._paintImage(l,this._model.outlineImage(),i.relativeTo(i)),this._model.screenImage()&&await this._paintImage(l,this._model.screenImage(),n.relativeTo(i)),l.drawImage(t,Math.floor(o),Math.floor(a)),this._saveScreenshot(r)}}async captureFullSizeScreenshot(){const e=await this._model.captureScreenshot(!0);if(null!==e)return this._saveScreenshotBase64(e)}async captureAreaScreenshot(e){const t=await this._model.captureScreenshot(!1,e);if(null!==t)return this._saveScreenshotBase64(t)}_saveScreenshotBase64(e){const t=new Image;t.src="data:image/png;base64,"+e,t.onload=()=>{const e=createElement("canvas");e.width=t.naturalWidth,e.height=t.naturalHeight;const i=e.getContext("2d");i.imageSmoothingEnabled=!1,i.drawImage(t,0,0),this._saveScreenshot(e)}}_paintImage(e,t,i){return new Promise(n=>{const s=new Image;s.crossOrigin="Anonymous",s.srcset=t,s.onerror=n,s.onload=()=>{e.drawImage(s,i.left,i.top,i.width,i.height),n()}})}_saveScreenshot(e){const t=this._model.inspectedURL();let i="";if(t){const e=StringUtilities.removeURLFragment(t);i=StringUtilities.trimURL(e)}this._model.type()===Type$1.Device&&(i+=UIString.UIString("(%s)",this._model.device().title));const n=createElement("a");n.download=i+".png",e.toBlob(e=>{n.href=URL.createObjectURL(e),n.click()})}}class Ruler extends Widget.VBox{constructor(e,t){super(),this.element.classList.add("device-mode-ruler"),this._contentElement=this.element.createChild("div","device-mode-ruler-content").createChild("div","device-mode-ruler-inner"),this._horizontal=e,this._scale=1,this._count=0,this._throttler=new Throttler.Throttler(0),this._applyCallback=t}render(e){this._scale=e,this._throttler.schedule(this._update.bind(this))}onResize(){this._throttler.schedule(this._update.bind(this))}_update(){const e=ZoomManager.ZoomManager.instance().zoomFactor(),t=this._horizontal?this._contentElement.offsetWidth:this._contentElement.offsetHeight;this._scale===this._renderedScale&&e===this._renderedZoomFactor||(this._contentElement.removeChildren(),this._count=0,this._renderedScale=this._scale,this._renderedZoomFactor=e);const i=t*e/this._scale,n=Math.ceil(i/5);let s=1;this._scale<.8&&(s=2),this._scale<.6&&(s=4),this._scale<.4&&(s=8),this._scale<.2&&(s=16),this._scale<.1&&(s=32);for(let e=n;e<this._count;e++)e%s||this._contentElement.lastChild.remove();for(let t=this._count;t<n;t++){if(t%s)continue;const i=this._contentElement.createChild("div","device-mode-ruler-marker");if(t&&(this._horizontal?i.style.left=5*t*this._scale/e+"px":i.style.top=5*t*this._scale/e+"px",!(t%20))){const e=i.createChild("div","device-mode-ruler-text");e.textContent=5*t,e.addEventListener("click",this._onMarkerClick.bind(this,5*t),!1)}t%10?t%5||i.classList.add("device-mode-ruler-marker-medium"):i.classList.add("device-mode-ruler-marker-large")}return this._count=n,Promise.resolve()}_onMarkerClick(e){this._applyCallback.call(null,e)}}var DeviceModeView$1=Object.freeze({__proto__:null,DeviceModeView:DeviceModeView,Ruler:Ruler});class DeviceModeWrapper extends Widget.VBox{constructor(e){super(),DeviceModeView.wrapperInstance=this,this._inspectedPagePlaceholder=e,this._deviceModeView=null,this._toggleDeviceModeAction=ActionRegistry.ActionRegistry.instance().action("emulation.toggle-device-mode");const t=self.singleton(DeviceModeModel);this._showDeviceModeSetting=t.enabledSetting(),this._showDeviceModeSetting.setRequiresUserAction(!!Root.Runtime.queryParam("hasOtherClients")),this._showDeviceModeSetting.addChangeListener(this._update.bind(this,!1)),SDKModel.TargetManager.instance().addModelListener(OverlayModel.OverlayModel,OverlayModel.Events.ScreenshotRequested,this._screenshotRequestedFromOverlay,this),this._update(!0)}_toggleDeviceMode(){this._showDeviceModeSetting.set(!this._showDeviceModeSetting.get())}_captureScreenshot(e,t){return this._deviceModeView||(this._deviceModeView=new DeviceModeView),this._deviceModeView.setNonEmulatedAvailableSize(this._inspectedPagePlaceholder.element),e?this._deviceModeView.captureFullSizeScreenshot():t?this._deviceModeView.captureAreaScreenshot(t):this._deviceModeView.captureScreenshot(),!0}_screenshotRequestedFromOverlay(e){const t=e.data;this._captureScreenshot(!1,t)}_update(e){if(this._toggleDeviceModeAction.setToggled(this._showDeviceModeSetting.get()),!e){const e=this._deviceModeView&&this._deviceModeView.isShowing();if(this._showDeviceModeSetting.get()===e)return}this._showDeviceModeSetting.get()?(this._deviceModeView||(this._deviceModeView=new DeviceModeView),this._deviceModeView.show(this.element),this._inspectedPagePlaceholder.clearMinimumSize(),this._inspectedPagePlaceholder.show(this._deviceModeView.element)):(this._deviceModeView&&(this._deviceModeView.exitHingeMode(),this._deviceModeView.detach()),this._inspectedPagePlaceholder.restoreMinimumSize(),this._inspectedPagePlaceholder.show(this.element))}}class ActionDelegate{handleAction(e,t){if(DeviceModeView.wrapperInstance)switch(t){case"emulation.capture-screenshot":return DeviceModeView.wrapperInstance._captureScreenshot();case"emulation.capture-node-screenshot":{const e=Context.Context.instance().flavor(DOMModel.DOMNode);if(!e)return!0;return async function(){const t=await e.resolveToObject(),i=await t.callFunction((function(){const e=this.getBoundingClientRect(),t=this.ownerDocument.documentElement.getBoundingClientRect();return JSON.stringify({x:e.left-t.left,y:e.top-t.top,width:e.width,height:e.height,scale:1})})),n=JSON.parse(i.object.value),s=await e.domModel().target().pageAgent().invoke_getLayoutMetrics({}),o=!s[InspectorBackend.ProtocolError]&&s.visualViewport.zoom||1;n.x*=o,n.y*=o,n.width*=o,n.height*=o,DeviceModeView.wrapperInstance._captureScreenshot(!1,n)}(),!0}case"emulation.capture-full-height-screenshot":return DeviceModeView.wrapperInstance._captureScreenshot(!0);case"emulation.toggle-device-mode":return DeviceModeView.wrapperInstance._toggleDeviceMode(),!0}return!1}}var DeviceModeWrapper$1=Object.freeze({__proto__:null,DeviceModeWrapper:DeviceModeWrapper,ActionDelegate:ActionDelegate});class InspectedPagePlaceholder extends Widget.Widget{constructor(){super(!0),this.registerRequiredCSS("emulation/inspectedPagePlaceholder.css"),ZoomManager.ZoomManager.instance().addEventListener(ZoomManager.Events.ZoomChanged,this.onResize,this),this.restoreMinimumSize()}onResize(){this._updateId&&this.element.window().cancelAnimationFrame(this._updateId),this._updateId=this.element.window().requestAnimationFrame(this.update.bind(this,!1))}restoreMinimumSize(){this.setMinimumSize(150,150)}clearMinimumSize(){this.setMinimumSize(1,1)}_dipPageRect(){const e=ZoomManager.ZoomManager.instance().zoomFactor(),t=this.element.getBoundingClientRect(),i=this.element.ownerDocument.body.getBoundingClientRect(),n=Math.max(t.left*e,i.left*e),s=Math.max(t.top*e,i.top*e),o=Math.min(t.bottom*e,i.bottom*e);return{x:n,y:s,width:Math.min(t.right*e,i.right*e)-n,height:o-s}}update(e){delete this._updateId;const t=this._dipPageRect(),i={x:Math.round(t.x),y:Math.round(t.y),height:Math.max(1,Math.round(t.height)),width:Math.max(1,Math.round(t.width))};e&&(--i.height,this.dispatchEventToListeners(Events$2.Update,i),++i.height),this.dispatchEventToListeners(Events$2.Update,i)}}const instance=function(){return self.singleton(InspectedPagePlaceholder)},Events$2={Update:Symbol("Update")};var InspectedPagePlaceholder$1=Object.freeze({__proto__:null,InspectedPagePlaceholder:InspectedPagePlaceholder,instance:instance,Events:Events$2});let _appInstance;class AdvancedApp{constructor(){DockController.DockController.instance().addEventListener(DockController.Events.BeforeDockSideChanged,this._openToolboxWindow,this)}static _instance(){return _appInstance||(_appInstance=new AdvancedApp),_appInstance}presentUI(e){const t=new RootView.RootView;this._rootSplitWidget=new SplitWidget.SplitWidget(!1,!0,"InspectorView.splitViewState",555,300,!0),this._rootSplitWidget.show(t.element),this._rootSplitWidget.setSidebarWidget(InspectorView.InspectorView.instance()),this._rootSplitWidget.setDefaultFocusedChild(InspectorView.InspectorView.instance()),InspectorView.InspectorView.instance().setOwnerSplit(this._rootSplitWidget),this._inspectedPagePlaceholder=instance(),this._inspectedPagePlaceholder.addEventListener(Events$2.Update,this._onSetInspectedPageBounds.bind(this),this),this._deviceModeView=new DeviceModeWrapper(this._inspectedPagePlaceholder),DockController.DockController.instance().addEventListener(DockController.Events.BeforeDockSideChanged,this._onBeforeDockSideChange,this),DockController.DockController.instance().addEventListener(DockController.Events.DockSideChanged,this._onDockSideChange,this),DockController.DockController.instance().addEventListener(DockController.Events.AfterDockSideChanged,this._onAfterDockSideChange,this),this._onDockSideChange(),console.timeStamp("AdvancedApp.attachToBody"),t.attachToDocument(e),t.focus(),this._inspectedPagePlaceholder.update()}_openToolboxWindow(e){if(e.data.to!==DockController.State.Undocked)return;if(this._toolboxWindow)return;const t=window.location.href.replace("devtools_app.html","toolbox.html");this._toolboxWindow=window.open(t,void 0)}toolboxLoaded(e){UIUtils.initializeUIUtils(e,Settings.Settings.instance().createSetting("uiTheme","default")),UIUtils.installComponentRootStyles(e.body),ContextMenu.ContextMenu.installHandler(e),Tooltip.Tooltip.installHandler(e),this._toolboxRootView=new RootView.RootView,this._toolboxRootView.attachToDocument(e),this._updateDeviceModeView()}_updateDeviceModeView(){this._isDocked()?this._rootSplitWidget.setMainWidget(this._deviceModeView):this._toolboxRootView&&this._deviceModeView.show(this._toolboxRootView.element)}_onBeforeDockSideChange(e){e.data.to===DockController.State.Undocked&&this._toolboxRootView&&(this._rootSplitWidget.hideSidebar(),this._inspectedPagePlaceholder.update()),this._changingDockSide=!0}_onDockSideChange(e){this._updateDeviceModeView();const t=e?e.data.to:DockController.DockController.instance().dockSide();t===DockController.State.Undocked?this._updateForUndocked():this._toolboxRootView&&e&&e.data.from===DockController.State.Undocked?this._rootSplitWidget.hideSidebar():this._updateForDocked(t)}_onAfterDockSideChange(e){this._changingDockSide&&(e.data.from===DockController.State.Undocked&&this._updateForDocked(e.data.to),this._changingDockSide=!1,this._inspectedPagePlaceholder.update())}_updateForDocked(e){this._rootSplitWidget.resizerElement().style.transform=e===DockController.State.DockedToRight?"translateX(2px)":e===DockController.State.DockedToLeft?"translateX(-2px)":"",this._rootSplitWidget.setVertical(e===DockController.State.DockedToRight||e===DockController.State.DockedToLeft),this._rootSplitWidget.setSecondIsSidebar(e===DockController.State.DockedToRight||e===DockController.State.DockedToBottom),this._rootSplitWidget.toggleResizer(this._rootSplitWidget.resizerElement(),!0),this._rootSplitWidget.toggleResizer(InspectorView.InspectorView.instance().topResizerElement(),e===DockController.State.DockedToBottom),this._rootSplitWidget.showBoth()}_updateForUndocked(){this._rootSplitWidget.toggleResizer(this._rootSplitWidget.resizerElement(),!1),this._rootSplitWidget.toggleResizer(InspectorView.InspectorView.instance().topResizerElement(),!1),this._rootSplitWidget.hideMain()}_isDocked(){return DockController.DockController.instance().dockSide()!==DockController.State.Undocked}_onSetInspectedPageBounds(e){if(this._changingDockSide)return;const t=this._inspectedPagePlaceholder.element.window();if(!t.innerWidth||!t.innerHeight)return;if(!this._inspectedPagePlaceholder.isShowing())return;const i=e.data;console.timeStamp("AdvancedApp.setInspectedPageBounds"),InspectorFrontendHost.InspectorFrontendHostInstance.setInspectedPageBounds(i)}}class AdvancedAppProvider{createApp(){return AdvancedApp._instance()}}var AdvancedApp$1=Object.freeze({__proto__:null,AdvancedApp:AdvancedApp,AdvancedAppProvider:AdvancedAppProvider});class DevicesSettingsTab extends Widget.VBox{constructor(){super(),this.element.classList.add("settings-tab-container"),this.element.classList.add("devices-settings-tab"),this.registerRequiredCSS("emulation/devicesSettingsTab.css");this.element.createChild("header").createChild("h1").createTextChild(ls`Emulated Devices`),this.containerElement=this.element.createChild("div","settings-container-wrapper").createChild("div","settings-tab settings-content settings-container");const e=this.containerElement.createChild("div","devices-button-row");this._addCustomButton=UIUtils.createTextButton(UIString.UIString("Add custom device..."),this._addCustomDevice.bind(this)),e.appendChild(this._addCustomButton),this._list=new ListWidget.ListWidget(this,!1),this._list.registerRequiredCSS("emulation/devicesSettingsTab.css"),this._list.element.classList.add("devices-list"),this._list.show(this.containerElement),this._muteUpdate=!1,this._emulatedDevicesList=EmulatedDevicesList.instance(),this._emulatedDevicesList.addEventListener(Events.CustomDevicesUpdated,this._devicesUpdated,this),this._emulatedDevicesList.addEventListener(Events.StandardDevicesUpdated,this._devicesUpdated,this),this.setDefaultFocusedElement(this._addCustomButton)}wasShown(){super.wasShown(),this._devicesUpdated()}_devicesUpdated(){if(this._muteUpdate)return;this._list.clear();let e=this._emulatedDevicesList.custom().slice();for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!0);this._list.appendSeparator(),e=this._emulatedDevicesList.standard().slice(),e.sort(EmulatedDevice.deviceComparator);for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!1)}_muteAndSaveDeviceList(e){this._muteUpdate=!0,e?this._emulatedDevicesList.saveCustomDevices():this._emulatedDevicesList.saveStandardDevices(),this._muteUpdate=!1}_addCustomDevice(){const e=new EmulatedDevice;e.deviceScaleFactor=0,e.horizontal.width=700,e.horizontal.height=400,e.vertical.width=400,e.vertical.height=700,this._list.addNewItem(this._emulatedDevicesList.custom().length,e)}_toNumericInputValue(e){return e?String(e):""}renderItem(e,t){const i=e,n=document.createElement("label");n.classList.add("devices-list-item");const s=n.createChild("input","devices-list-checkbox");return s.type="checkbox",s.checked=i.show(),s.addEventListener("click",function(e){const n=s.checked;i.setShow(n),this._muteAndSaveDeviceList(t),e.consume()}.bind(this),!1),n.appendChild(document.createTextNode(i.title)),n}removeItemRequested(e,t){this._emulatedDevicesList.removeCustomDevice(e)}commitEdit(e,t,i){const n=e;n.title=t.control("title").value.trim(),n.vertical.width=t.control("width").value?parseInt(t.control("width").value,10):0,n.vertical.height=t.control("height").value?parseInt(t.control("height").value,10):0,n.horizontal.width=n.vertical.height,n.horizontal.height=n.vertical.width,n.deviceScaleFactor=t.control("scale").value?parseFloat(t.control("scale").value):0,n.userAgent=t.control("user-agent").value,n.modes=[],n.modes.push({title:"",orientation:Vertical,insets:new Geometry.Insets(0,0,0,0),image:null}),n.modes.push({title:"",orientation:Horizontal,insets:new Geometry.Insets(0,0,0,0),image:null}),n.capabilities=[];const s=t.control("ua-type").value;s!==UA.Mobile&&s!==UA.MobileNoTouch||n.capabilities.push(Capability.Mobile),s!==UA.Mobile&&s!==UA.DesktopTouch||n.capabilities.push(Capability.Touch),i?this._emulatedDevicesList.addCustomDevice(n):this._emulatedDevicesList.saveCustomDevices(),this._addCustomButton.scrollIntoViewIfNeeded(),this._addCustomButton.focus()}beginEdit(e){const t=e,i=this._createEditor();let n;return i.control("title").value=t.title,i.control("width").value=this._toNumericInputValue(t.vertical.width),i.control("height").value=this._toNumericInputValue(t.vertical.height),i.control("scale").value=this._toNumericInputValue(t.deviceScaleFactor),i.control("user-agent").value=t.userAgent,n=t.mobile()?t.touch()?UA.Mobile:UA.MobileNoTouch:t.touch()?UA.DesktopTouch:UA.Desktop,i.control("ua-type").value=n,i}_createEditor(){if(this._editor)return this._editor;const e=new ListWidget.Editor;this._editor=e;const t=e.contentElement().createChild("div","devices-edit-fields");t.createChild("div","hbox").appendChild(e.createInput("title","text",ls`Device Name`,(function(e,t,i){let n,s=!1;const o=i.value.trim();o.length>=MaxDeviceNameLength?n=ls`Device name must be less than ${MaxDeviceNameLength} characters.`:0===o.length?n=ls`Device name cannot be empty.`:s=!0;return{valid:s,errorMessage:n}})));const i=t.createChild("div","hbox");i.appendChild(e.createInput("width","text",ls`Width`,(function(e,t,i){return DeviceModeModel.widthValidator(i.value)}))),i.appendChild(e.createInput("height","text",ls`Height`,(function(e,t,i){return DeviceModeModel.heightValidator(i.value)})));const n=e.createInput("scale","text",ls`Device pixel ratio`,(function(e,t,i){return DeviceModeModel.scaleValidator(i.value)}));n.classList.add("device-edit-fixed"),i.appendChild(n);const s=t.createChild("div","hbox");s.appendChild(e.createInput("user-agent","text",ls`User agent string`,()=>({valid:!0})));const o=[UA.Mobile,UA.MobileNoTouch,UA.Desktop,UA.DesktopTouch],a=e.createSelect("ua-type",o,()=>({valid:!0}),ls`User agent type`);return a.classList.add("device-edit-fixed"),s.appendChild(a),e}}var DevicesSettingsTab$1=Object.freeze({__proto__:null,DevicesSettingsTab:DevicesSettingsTab});class SensorsView extends Widget.VBox{constructor(){super(!0),this.registerRequiredCSS("emulation/sensors.css"),this.contentElement.classList.add("sensors-view"),this._LocationSetting=Settings.Settings.instance().createSetting("emulation.locationOverride",""),this._Location=EmulationModel.Location.parseSetting(this._LocationSetting.get()),this._LocationOverrideEnabled=!1,this._createLocationSection(this._Location),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._deviceOrientationSetting=Settings.Settings.instance().createSetting("emulation.deviceOrientationOverride",""),this._deviceOrientation=EmulationModel.DeviceOrientation.parseSetting(this._deviceOrientationSetting.get()),this._deviceOrientationOverrideEnabled=!1,this._createDeviceOrientationSection(),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._appendTouchControl(),this.contentElement.createChild("div").classList.add("panel-section-separator"),this._appendIdleEmulator()}static instance(){return SensorsView._instanceObject||(SensorsView._instanceObject=new SensorsView),SensorsView._instanceObject}_createLocationSection(e){const t=this.contentElement.createChild("section","sensors-group"),i=UIUtils.createLabel(ls`Location`,"sensors-group-title");t.appendChild(i);const n=t.createChild("div","geo-fields");let s=0;const o={title:UIString.UIString("No override"),location:NonPresetOptions.NoOverride};this._locationSelectElement=n.createChild("select","chrome-select"),ARIAUtils.bindLabelToControl(i,this._locationSelectElement),this._locationSelectElement.appendChild(new Option(o.title,o.location)),this._customLocationsGroup=this._locationSelectElement.createChild("optgroup"),this._customLocationsGroup.label=ls`Overrides`;const a=Settings.Settings.instance().moduleSetting("emulation.locations"),r=UIUtils.createTextButton(ls`Manage`,()=>Revealer.reveal(a));ARIAUtils.setAccessibleName(r,ls`Manage the list of locations`),n.appendChild(r);const l=()=>{this._customLocationsGroup.removeChildren();for(const[t,i]of a.get().entries())this._customLocationsGroup.appendChild(new Option(i.title,JSON.stringify(i))),e.latitude===i.lat&&e.longitude===i.long&&(s=t+1)};a.addChangeListener(l),l();const c={title:UIString.UIString("Other…"),location:NonPresetOptions.Custom};this._locationSelectElement.appendChild(new Option(c.title,c.location));const d=this._locationSelectElement.createChild("optgroup");d.label=ls`Error`,d.appendChild(new Option(ls`Location unavailable`,NonPresetOptions.Unavailable)),this._locationSelectElement.selectedIndex=s,this._locationSelectElement.addEventListener("change",this._LocationSelectChanged.bind(this)),this._fieldsetElement=n.createChild("fieldset"),this._fieldsetElement.disabled=!this._LocationOverrideEnabled,this._fieldsetElement.id="location-override-section";const h=this._fieldsetElement.createChild("div","latlong-group"),u=this._fieldsetElement.createChild("div","latlong-group"),m=this._fieldsetElement.createChild("div","latlong-group"),p=this._fieldsetElement.createChild("div","latlong-group"),_=Platform.isMac()?"⌘":"Ctrl",g=ls`Adjust with mousewheel or up/down keys. ${_}: ±10, Shift: ±1, Alt: ±0.01`;this._latitudeInput=UIUtils.createInput("","number"),h.appendChild(this._latitudeInput),this._latitudeInput.setAttribute("step","any"),this._latitudeInput.value=0,this._latitudeSetter=UIUtils.bindInput(this._latitudeInput,this._applyLocationUserInput.bind(this),EmulationModel.Location.latitudeValidator,!0,.1),this._latitudeSetter(String(e.latitude)),this._latitudeInput.title=g,h.appendChild(UIUtils.createLabel(ls`Latitude`,"latlong-title",this._latitudeInput)),this._longitudeInput=UIUtils.createInput("","number"),u.appendChild(this._longitudeInput),this._longitudeInput.setAttribute("step","any"),this._longitudeInput.value=0,this._longitudeSetter=UIUtils.bindInput(this._longitudeInput,this._applyLocationUserInput.bind(this),EmulationModel.Location.longitudeValidator,!0,.1),this._longitudeSetter(String(e.longitude)),this._longitudeInput.title=g,u.appendChild(UIUtils.createLabel(ls`Longitude`,"latlong-title",this._longitudeInput)),this._timezoneInput=UIUtils.createInput("","text"),m.appendChild(this._timezoneInput),this._timezoneInput.value="Europe/Berlin",this._timezoneSetter=UIUtils.bindInput(this._timezoneInput,this._applyLocationUserInput.bind(this),EmulationModel.Location.timezoneIdValidator,!1),this._timezoneSetter(e.timezoneId),m.appendChild(UIUtils.createLabel(ls`Timezone ID`,"timezone-title",this._timezoneInput)),this._timezoneError=m.createChild("div","timezone-error"),this._localeInput=UIUtils.createInput("","text"),p.appendChild(this._localeInput),this._localeInput.value="en-US",this._localeSetter=UIUtils.bindInput(this._localeInput,this._applyLocationUserInput.bind(this),EmulationModel.Location.localeValidator,!1),this._localeSetter(e.locale),p.appendChild(UIUtils.createLabel(ls`Locale`,"locale-title",this._localeInput)),this._localeError=p.createChild("div","locale-error")}_LocationSelectChanged(){this._fieldsetElement.disabled=!1,this._timezoneError.textContent="";const e=this._locationSelectElement.options[this._locationSelectElement.selectedIndex].value;if(e===NonPresetOptions.NoOverride)this._LocationOverrideEnabled=!1,this._clearFieldsetElementInputs(),this._fieldsetElement.disabled=!0;else if(e===NonPresetOptions.Custom){this._LocationOverrideEnabled=!0;const e=EmulationModel.Location.parseUserInput(this._latitudeInput.value.trim(),this._longitudeInput.value.trim(),this._timezoneInput.value.trim(),this._localeInput.value.trim());if(!e)return;this._Location=e}else if(e===NonPresetOptions.Unavailable)this._LocationOverrideEnabled=!0,this._Location=new EmulationModel.Location(0,0,"","",!0);else{this._LocationOverrideEnabled=!0;const t=JSON.parse(e);this._Location=new EmulationModel.Location(t.lat,t.long,t.timezoneId,t.locale,!1),this._latitudeSetter(t.lat),this._longitudeSetter(t.long),this._timezoneSetter(t.timezoneId),this._localeSetter(t.locale)}this._applyLocation(),e===NonPresetOptions.Custom&&this._latitudeInput.focus()}_applyLocationUserInput(){const e=EmulationModel.Location.parseUserInput(this._latitudeInput.value.trim(),this._longitudeInput.value.trim(),this._timezoneInput.value.trim(),this._localeInput.value.trim());e&&(this._timezoneError.textContent="",this._setSelectElementLabel(this._locationSelectElement,NonPresetOptions.Custom),this._Location=e,this._applyLocation())}_applyLocation(){this._LocationOverrideEnabled?this._LocationSetting.set(this._Location.toSetting()):this._LocationSetting.remove();for(const e of SDKModel.TargetManager.instance().models(EmulationModel.EmulationModel))e.emulateLocation(this._LocationOverrideEnabled?this._Location:null).catch(e=>{switch(e.type){case"emulation-set-timezone":this._timezoneError.textContent=e.message;break;case"emulation-set-locale":this._localeError.textContent=e.message}})}_clearFieldsetElementInputs(){this._latitudeSetter(0),this._longitudeSetter(0),this._timezoneSetter(""),this._localeSetter("")}_createDeviceOrientationSection(){const e=this.contentElement.createChild("section","sensors-group"),t=UIUtils.createLabel(ls`Orientation`,"sensors-group-title");e.appendChild(t);const i=e.createChild("div","orientation-content"),n=i.createChild("div","orientation-fields"),s={title:UIString.UIString("Off"),orientation:NonPresetOptions.NoOverride},o={title:UIString.UIString("Custom orientation"),orientation:NonPresetOptions.Custom};this._orientationSelectElement=this.contentElement.createChild("select","chrome-select"),ARIAUtils.bindLabelToControl(t,this._orientationSelectElement),this._orientationSelectElement.appendChild(new Option(s.title,s.orientation)),this._orientationSelectElement.appendChild(new Option(o.title,o.orientation));const a=PresetOrientations;for(let e=0;e<a.length;++e){const t=this._orientationSelectElement.createChild("optgroup");t.label=a[e].title;const i=a[e].value;for(let e=0;e<i.length;++e)t.appendChild(new Option(i[e].title,i[e].orientation))}this._orientationSelectElement.selectedIndex=0,n.appendChild(this._orientationSelectElement),this._orientationSelectElement.addEventListener("change",this._orientationSelectChanged.bind(this)),this._deviceOrientationFieldset=this._createDeviceOrientationOverrideElement(this._deviceOrientation),this._stageElement=i.createChild("div","orientation-stage"),this._orientationLayer=this._stageElement.createChild("div","orientation-layer"),this._boxElement=this._orientationLayer.createChild("section","orientation-box orientation-element"),this._boxElement.createChild("section","orientation-front orientation-element"),this._boxElement.createChild("section","orientation-top orientation-element"),this._boxElement.createChild("section","orientation-back orientation-element"),this._boxElement.createChild("section","orientation-left orientation-element"),this._boxElement.createChild("section","orientation-right orientation-element"),this._boxElement.createChild("section","orientation-bottom orientation-element"),UIUtils.installDragHandle(this._stageElement,this._onBoxDragStart.bind(this),e=>{this._onBoxDrag(e)},null,"-webkit-grabbing","-webkit-grab"),n.appendChild(this._deviceOrientationFieldset),this._enableOrientationFields(!0),this._setBoxOrientation(this._deviceOrientation,!1)}_enableOrientationFields(e){e?(this._deviceOrientationFieldset.disabled=!0,this._stageElement.classList.add("disabled"),this._stageElement.title=ls`Enable orientation to rotate`):(this._deviceOrientationFieldset.disabled=!1,this._stageElement.classList.remove("disabled"),this._stageElement.title=ls`Shift+drag horizontally to rotate around the y-axis`)}_orientationSelectChanged(){const e=this._orientationSelectElement.options[this._orientationSelectElement.selectedIndex].value;if(this._enableOrientationFields(!1),e===NonPresetOptions.NoOverride)this._deviceOrientationOverrideEnabled=!1,this._enableOrientationFields(!0);else if(e===NonPresetOptions.Custom)this._deviceOrientationOverrideEnabled=!0,this._alphaElement.focus();else{const t=JSON.parse(e);this._deviceOrientationOverrideEnabled=!0,this._deviceOrientation=new EmulationModel.DeviceOrientation(t[0],t[1],t[2]),this._setDeviceOrientation(this._deviceOrientation,DeviceOrientationModificationSource.SelectPreset)}}_applyDeviceOrientation(){this._deviceOrientationOverrideEnabled&&this._deviceOrientationSetting.set(this._deviceOrientation.toSetting());for(const e of SDKModel.TargetManager.instance().models(EmulationModel.EmulationModel))e.emulateDeviceOrientation(this._deviceOrientationOverrideEnabled?this._deviceOrientation:null)}_setSelectElementLabel(e,t){const i=Array.prototype.map.call(e.options,e=>e.value);e.selectedIndex=i.indexOf(t)}_applyDeviceOrientationUserInput(){this._setDeviceOrientation(EmulationModel.DeviceOrientation.parseUserInput(this._alphaElement.value.trim(),this._betaElement.value.trim(),this._gammaElement.value.trim()),DeviceOrientationModificationSource.UserInput),this._setSelectElementLabel(this._orientationSelectElement,NonPresetOptions.Custom)}_resetDeviceOrientation(){this._setDeviceOrientation(new EmulationModel.DeviceOrientation(0,90,0),DeviceOrientationModificationSource.ResetButton),this._setSelectElementLabel(this._orientationSelectElement,"[0, 90, 0]")}_setDeviceOrientation(e,t){if(!e)return;function i(e){return Math.round(1e4*e)/1e4}t!==DeviceOrientationModificationSource.UserInput&&(this._alphaSetter(i(e.alpha)),this._betaSetter(i(e.beta)),this._gammaSetter(i(e.gamma)));const n=t!==DeviceOrientationModificationSource.UserDrag;this._setBoxOrientation(e,n),this._deviceOrientation=e,this._applyDeviceOrientation(),ARIAUtils.alert(ls`Device orientation set to alpha: ${e.alpha}, beta: ${e.beta}, gamma: ${e.gamma}`,this._orientationSelectElement)}_createAxisInput(e,t,i){const n=e.createChild("div","orientation-axis-input-container");return n.appendChild(t),n.appendChild(UIUtils.createLabel(i,"",t)),t.type="number",UIUtils.bindInput(t,this._applyDeviceOrientationUserInput.bind(this),EmulationModel.DeviceOrientation.validator,!0)}_createDeviceOrientationOverrideElement(e){const t=createElement("fieldset");t.classList.add("device-orientation-override-section");const i=t.createChild("td","orientation-inputs-cell");this._alphaElement=UIUtils.createInput(),this._alphaElement.setAttribute("step","any"),this._alphaSetter=this._createAxisInput(i,this._alphaElement,UIString.UIString("α (alpha)")),this._alphaSetter(String(e.alpha)),this._betaElement=UIUtils.createInput(),this._betaElement.setAttribute("step","any"),this._betaSetter=this._createAxisInput(i,this._betaElement,UIString.UIString("β (beta)")),this._betaSetter(String(e.beta)),this._gammaElement=UIUtils.createInput(),this._gammaElement.setAttribute("step","any"),this._gammaSetter=this._createAxisInput(i,this._gammaElement,UIString.UIString("γ (gamma)")),this._gammaSetter(String(e.gamma));const n=UIUtils.createTextButton(UIString.UIString("Reset"),this._resetDeviceOrientation.bind(this),"orientation-reset-button");return ARIAUtils.setAccessibleName(n,ls`Reset device orientation`),n.setAttribute("type","reset"),i.appendChild(n),t}_setBoxOrientation(e,t){t?this._stageElement.classList.add("is-animating"):this._stageElement.classList.remove("is-animating");const i=new WebKitCSSMatrix;this._boxMatrix=i.rotate(-e.beta,e.gamma,-e.alpha);const n=new Geometry.EulerAngles(e.alpha,e.beta,e.gamma);this._orientationLayer.style.transform=n.toRotate3DString()}_onBoxDrag(e){const t=this._calculateRadiusVector(e.x,e.y);if(!t)return!0;let i,n;e.consume(!0),e.shiftKey?(i=new Geometry.Vector(0,0,-1),n=(this._mouseDownVector.x-t.x)*ShiftDragOrientationSpeed):(i=Geometry.crossProduct(this._mouseDownVector,t),n=Geometry.calculateAngle(this._mouseDownVector,t));let s=new WebKitCSSMatrix;s=s.rotate(-90,0,0).rotateAxisAngle(i.x,i.y,i.z,n).rotate(90,0,0).multiply(this._originalBoxMatrix);const o=Geometry.EulerAngles.fromRotationMatrix(s),a=new EmulationModel.DeviceOrientation(-o.alpha,-o.beta,o.gamma);return this._setDeviceOrientation(a,DeviceOrientationModificationSource.UserDrag),this._setSelectElementLabel(this._orientationSelectElement,NonPresetOptions.Custom),!1}_onBoxDragStart(e){return!!this._deviceOrientationOverrideEnabled&&(this._mouseDownVector=this._calculateRadiusVector(e.x,e.y),this._originalBoxMatrix=this._boxMatrix,!!this._mouseDownVector&&(e.consume(!0),!0))}_calculateRadiusVector(e,t){const i=this._stageElement.getBoundingClientRect(),n=Math.max(i.width,i.height)/2,s=(e-i.left-i.width/2)/n,o=(t-i.top-i.height/2)/n,a=s*s+o*o;return a>.5?new Geometry.Vector(s,o,.5/Math.sqrt(a)):new Geometry.Vector(s,o,Math.sqrt(1-a))}_appendTouchControl(){const e=this.contentElement.createChild("div","touch-section"),t=SettingsUI.createControlForSetting(Settings.Settings.instance().moduleSetting("emulation.touch"),ls`Forces touch instead of click`);t&&e.appendChild(t)}_appendIdleEmulator(){const e=this.contentElement.createChild("div","idle-section"),t=SettingsUI.createControlForSetting(Settings.Settings.instance().moduleSetting("emulation.idleDetection"),ls`Forces selected idle state emulation`);t&&e.appendChild(t)}}const DeviceOrientationModificationSource={UserInput:"userInput",UserDrag:"userDrag",ResetButton:"resetButton",SelectPreset:"selectPreset"},NonPresetOptions={NoOverride:"noOverride",Custom:"custom",Unavailable:"unavailable"},PresetOrientations=[{title:ls`Presets`,value:[{title:UIString.UIString("Portrait"),orientation:"[0, 90, 0]"},{title:UIString.UIString("Portrait upside down"),orientation:"[180, -90, 0]"},{title:UIString.UIString("Landscape left"),orientation:"[0, 90, -90]"},{title:UIString.UIString("Landscape right"),orientation:"[0, 90, 90]"},{title:UIString.UIString("Display up"),orientation:"[0, 0, 0]"},{title:UIString.UIString("Display down"),orientation:"[0, 180, 0]"}]}];class ShowActionDelegate{handleAction(e,t){return ViewManager.ViewManager.instance().showView("sensors"),!0}}const ShiftDragOrientationSpeed=16;var SensorsView$1=Object.freeze({__proto__:null,SensorsView:SensorsView,DeviceOrientationModificationSource:DeviceOrientationModificationSource,NonPresetOptions:NonPresetOptions,PresetOrientations:PresetOrientations,ShowActionDelegate:ShowActionDelegate,ShiftDragOrientationSpeed:ShiftDragOrientationSpeed});class LocationsSettingsTab extends Widget.VBox{constructor(){super(!0),this.registerRequiredCSS("emulation/locationsSettingsTab.css"),this.contentElement.createChild("div","header").textContent=UIString.UIString("Custom locations");const e=UIUtils.createTextButton(UIString.UIString("Add location…"),this._addButtonClicked.bind(this),"add-locations-button");this.contentElement.appendChild(e),this._list=new ListWidget.ListWidget(this),this._list.element.classList.add("locations-list"),this._list.registerRequiredCSS("emulation/locationsSettingsTab.css"),this._list.show(this.contentElement),this._customSetting=Settings.Settings.instance().moduleSetting("emulation.locations"),this._customSetting.addChangeListener(this._locationsUpdated,this),this.setDefaultFocusedElement(e)}wasShown(){super.wasShown(),this._locationsUpdated()}_locationsUpdated(){this._list.clear();const e=this._customSetting.get();for(let t=0;t<e.length;++t)this._list.appendItem(e[t],!0);this._list.appendSeparator()}_addButtonClicked(){this._list.addNewItem(this._customSetting.get().length,{title:"",lat:0,long:0,timezoneId:"",locale:""})}renderItem(e,t){const i=e,n=document.createElement("div");n.classList.add("locations-list-item");const s=n.createChild("div","locations-list-text locations-list-title").createChild("div","locations-list-title-text");return s.textContent=i.title,s.title=i.title,n.createChild("div","locations-list-separator"),n.createChild("div","locations-list-text").textContent=i.lat,n.createChild("div","locations-list-separator"),n.createChild("div","locations-list-text").textContent=i.long,n.createChild("div","locations-list-separator"),n.createChild("div","locations-list-text").textContent=i.timezoneId,n.createChild("div","locations-list-separator"),n.createChild("div","locations-list-text").textContent=i.locale,n}removeItemRequested(e,t){const i=this._customSetting.get();i.splice(t,1),this._customSetting.set(i)}commitEdit(e,t,i){const n=e;n.title=t.control("title").value.trim();const s=t.control("lat").value.trim();n.lat=s?parseFloat(s):0;const o=t.control("long").value.trim();n.long=o?parseFloat(o):0;const a=t.control("timezoneId").value.trim();n.timezoneId=a;const r=t.control("locale").value.trim();n.locale=r;const l=this._customSetting.get();i&&l.push(n),this._customSetting.set(l)}beginEdit(e){const t=e,i=this._createEditor();return i.control("title").value=t.title,i.control("lat").value=String(t.lat),i.control("long").value=String(t.long),i.control("timezoneId").value=t.timezoneId,i.control("locale").value=t.locale,i}_createEditor(){if(this._editor)return this._editor;const e=new ListWidget.Editor;this._editor=e;const t=e.contentElement(),i=t.createChild("div","locations-edit-row");i.createChild("div","locations-list-text locations-list-title").textContent=UIString.UIString("Location name"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=UIString.UIString("Lat"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=UIString.UIString("Long"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=UIString.UIString("Timezone ID"),i.createChild("div","locations-list-separator locations-list-separator-invisible"),i.createChild("div","locations-list-text").textContent=UIString.UIString("Locale");const n=t.createChild("div","locations-edit-row");n.createChild("div","locations-list-text locations-list-title locations-input-container").appendChild(e.createInput("title","text",ls`Location name`,(function(e,t,i){const n=i.value.trim();let s;n.length?n.length>50&&(s=ls`Location name must be less than ${50} characters`):s=ls`Location name cannot be empty`;if(s)return{valid:!1,errorMessage:s};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible");let s=n.createChild("div","locations-list-text locations-input-container");return s.appendChild(e.createInput("lat","text",ls`Latitude`,(function(e,t,i){const n=i.value.trim(),s=Number(n);if(!n)return{valid:!0};let o;Number.isNaN(s)?o=ls`Latitude must be a number`:parseFloat(n)<-90?o=ls`Latitude must be greater than or equal to ${-90}`:parseFloat(n)>90&&(o=ls`Latitude must be less than or equal to ${90}`);if(o)return{valid:!1,errorMessage:o};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),s=n.createChild("div","locations-list-text locations-list-text-longitude locations-input-container"),s.appendChild(e.createInput("long","text",ls`Longitude`,(function(e,t,i){const n=i.value.trim(),s=Number(n);if(!n)return{valid:!0};let o;Number.isNaN(s)?o=ls`Longitude must be a number`:parseFloat(n)<-180?o=ls`Longitude must be greater than or equal to ${-180}`:parseFloat(n)>180&&(o=ls`Longitude must be less than or equal to ${180}`);if(o)return{valid:!1,errorMessage:o};return{valid:!0}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),s=n.createChild("div","locations-list-text locations-input-container"),s.appendChild(e.createInput("timezoneId","text",ls`Timezone ID`,(function(e,t,i){const n=i.value.trim();if(""===n||/[a-zA-Z]/.test(n))return{valid:!0};return{valid:!1,errorMessage:ls`Timezone ID must contain alphabetic characters`}}))),n.createChild("div","locations-list-separator locations-list-separator-invisible"),s=n.createChild("div","locations-list-text locations-input-container"),s.appendChild(e.createInput("locale","text",ls`Locale`,(function(e,t,i){const n=i.value.trim();if(""===n||/[a-zA-Z]{2}/.test(n))return{valid:!0};return{valid:!1,errorMessage:ls`Locale must contain alphabetic characters`}}))),e}}let Item;var LocationsSettingsTab$1=Object.freeze({__proto__:null,LocationsSettingsTab:LocationsSettingsTab,Item:Item});export{AdvancedApp$1 as AdvancedApp,DeviceModeModel$1 as DeviceModeModel,DeviceModeToolbar$1 as DeviceModeToolbar,DeviceModeView$1 as DeviceModeView,DeviceModeWrapper$1 as DeviceModeWrapper,DevicesSettingsTab$1 as DevicesSettingsTab,EmulatedDevices,InspectedPagePlaceholder$1 as InspectedPagePlaceholder,LocationsSettingsTab$1 as LocationsSettingsTab,MediaQueryInspector$1 as MediaQueryInspector,SensorsView$1 as SensorsView};
