18 Dec 2019

#### Support dual-stack pod IPs

Native support for both IPv4 and IPv6 is known as "dual stack" and Kubernetes has alpha-level support for this in versions 1.16 and 1.17.
With this v3.11 release, Calico now supports the new Kubernetes APIs for dual stack. This allows you to use both IPv4 and IPv6 for your cluster pods. For more information on enabling
dual stack, please see the howto [documentation](https://docs.projectcalico.org/v3.11/networking/dual-stack).

 - Handle dual stack pod IPs [libcalico-go #1168](https://github.com/projectcalico/libcalico-go/pull/1168) (@neiljerram)

#### Calico for OpenStack enhancements

Calico for OpenStack now supports etcd authentication with etcd v3.3.11 and later. We previously supported etcd authentication with the user name being specified by a TLS client certificate,
but that was realized to be insecure, and etcd authentication with HTTP/JSON now requires a different approach, for which we have added support in this release.

We've also added more detailed logging in various scenarios where Calico for OpenStack components see errors in working with the etcd cluster.

 - networking-calico now supports etcd v3.3.11 with authentication enabled [networking-calico](https://github.com/openstack/networking-calico/commit/0653a420f3361abafcfa534e109c0ed0020772f4)

#### Bug fixes

 - Fix Bird adding a blackhole route to the service cluster CIDR which blocks access inside the cluster [confd #295](https://github.com/projectcalico/confd/pull/295) (@rafaelvanoni)
 - Fix typo resulting in bird6 never reloading [confd #298](https://github.com/projectcalico/confd/pull/298) (@neiljerram)
 - Fix Felix panic when there are transiently multiple workload endpoints with the same interface name. [felix #2167](https://github.com/projectcalico/felix/pull/2167) (@neiljerram)
 - Don’t remove IPv6 link-local addresses [felix #2173](https://github.com/projectcalico/felix/pull/2173) (@neiljerram)
 - Fix panic when performing flannel to Calico migration [kube-controllers #432](https://github.com/projectcalico/kube-controllers/pull/432) (@song-jiang)
 - Fix issue where IPAM block affinity was not properly calculated [libcalico-go #1152](https://github.com/projectcalico/libcalico-go/pull/1152) (@beautytiger)
 - Fix that namespaced network sets were not selected by namespaceSelectors [libcalico-go #1158](https://github.com/projectcalico/libcalico-go/pull/1158) (@robbrockbank)

#### Other changes

 - Don't block if we fail to monitor services for advertisement [confd #289](https://github.com/projectcalico/confd/pull/289) (@f41gh7)
 - Adding -bird-live/-bird6-live option to check for bird, bird6 and conf as part of the liveness probe. [node #369](https://github.com/projectcalico/node/pull/369) (@asincu)
 - Bird has been updated to address CVE-2019-16159 [node #359](https://github.com/projectcalico/node/pull/359) (@neiljerram)
 - calico/node now updates CNI kubeconfig when credentials change [node #344](https://github.com/projectcalico/node/pull/344) (@caseydavenport)
 - Add profiles to networkset for label inheritance [felix #2171](https://github.com/projectcalico/felix/pull/2171) (@robbrockbank)
 - Added backoff to the shutdown functionality when BPF dataplane doesnt seem to be working properly [felix #2165](https://github.com/projectcalico/felix/pull/2165) (@jayunit100)
 - Combine together ports of the same protocol to reduce number of iptables rules [libcalico-go #1135](https://github.com/projectcalico/libcalico-go/pull/1135) (@jackkleeman)
 - Fix validation of namespaceSelector field [libcalico-go #1175](https://github.com/projectcalico/libcalico-go/pull/1175) (@LittleBoy18)
 - Update to go-yaml v2.2.5 [libcalico-go #1162](https://github.com/projectcalico/libcalico-go/pull/1162) (@tmjd)
 - Switch amd64 node base image to ubi-minimal [node #362](https://github.com/projectcalico/node/pull/362) (@lmm)
 - Switch amd64 pod2daemon base image to ubi-minimal [pod2daemon #30](https://github.com/projectcalico/pod2daemon/pull/30) (@lmm)
 - Switch amd64 cni-plugin base image to ubi-minimal [cni-plugin #801](https://github.com/projectcalico/cni-plugin/pull/801) (@lmm)
 - Switch amd64 kube-controller base image to use ubi-minimal [kube-controllers #431](https://github.com/projectcalico/kube-controllers/pull/431) (@lmm)
