---
title: Getting Involved
canonical_url: 'https://docs.projectcalico.org/v3.5/reference/involved'
---

Calico is an open source project, and we'd love you to get involved.
Whether that might be by reading and participating on our slack,
or by diving into the code to propose enhancements or integrate with
other systems. To see the options for getting involved with Calico the
project, please take a look at the following.

## Join us on Slack

Our [public slack](https://slack.projectcalico.org) is the quickest way to get
in touch for help debugging any issues with Calico.

## Read the Source, Luke!

All of Calico's code is on [GitHub](https://github.com/projectcalico).  The following
list contains the most commonly encountered repositories:

Repository                                                              | Description
------------------------------------------------------------------------|----------------------------
[Calico](https://github.com/projectcalico/calico)                       | Calico release artifacts and documentation
[calicoctl](https://github.com/projectcalico/calicoctl)                 | calicoctl CLI tool
[cni-plugin](https://github.com/projectcalico/cni-plugin)               | Calico CNI plugin
[felix](https://github.com/projectcalico/felix)                         | felix policy enforcement agent
[kube-controllers](https://github.com/projectcalico/kube-controllers)   | Kubernetes controllers
[libcalico-go](https://github.com/projectcalico/libcalico-go)           | Golang Calico library
[libnetwork-plugin](https://github.com/projectcalico/libnetwork-plugin) | Calico libnetwork plugin for Docker

## Contributing

Calico follows the "Fork & Pull" model of collaborative development,
with changes being offered to the main Calico codebase via pull
requests. So you can contribute a fix, change, or enhancement by forking
one of our repositories and making a GitHub pull request. If you're
interested in doing that:

-   Thanks!
-   See the [GitHub docs](https://help.github.com/articles/using-pull-requests) for how
    to create a pull request.
-   Check the contribution guidelines at the root of each repo for more details.
