05 May 2025

## New features and enhancements

### Introducing Calico Whisker (tech preview)

This release includes Calico Whisker, a new observability tool that helps you see and understand your network activity.
Whisker is a web console that provides a user-friendly interface for viewing flow logs.

Backed by the new flow logs API, this console displays a stream of aggregated connection data that you can use to monitor and troubleshoot your network.

### Flow logs API (tech preview)

The flow logs API, which backs the Calico Whisker web console, is a gRPC API that provides aggregated network traffic data, including policy enforcement details and statistics like packet and byte counts.
You can use the API directly through your own applications or scripts.

### Staged network policies

You can now use staged network policies to test network policies before applying them to your production environment.
To do this, create a `StagedNetworkPolicy` (or `StagedGlobalNetworkPolicy` or `StagedKubernetesNetworkPolicy`) resource with the policy specifications you want to test.
Next, open a flow log in Whisker to see how the policy would have affected your network traffic, had it been enforced.
When you're happy with the results, you can apply the policy with the appropriate non-staged resource name.

### Calico Ingress Gateway (tech-preview)

Calico now includes the ability to deploy Calico Ingress Gateway which is an Enterprise hardened, 100% upstream distribution of Envoy Gateway.
Envoy Gateway is an implementation of the Kubernetes Gateway API with several extensions that provide advanced security and traffic management features.

### IPAM for load balancers

Calico now extends its IPAM capabilities to support service LoadBalancer IP allocation, providing a centralized, automated approach to managing LoadBalancer IPs within Kubernetes clusters.

### Improvements to host endpoint protection

You are now able to create and manage custom host endpoints for nodes, based on user-specified templates.
Previously, host endpoints applied to all node interfaces, regardless of need.
Now, you can choose exactly which interfaces are protected by Calico policy.
These templates can be used with automatic host endpoint creation.

### Quality of Service controls

You can now configure Quality of Service (QoS) controls for Calico workloads by using Kubernetes pod annotations.
These controls allow you to limit ingress and egress bandwidth, packet rate, and the maximum number of established connections for individual pods.
This helps prevent resource overuse by specific workloads and ensures fair network resource allocation across your cluster.
This feature is currently supported only in iptables and nftables modes.

### BGP Peering for nested KubeVirt clusters

Configure direct BGP peering between your Calico parent cluster and nested Kubernetes clusters running within KubeVirt VMs.
This extends layer 3 network reachability from nested pods to your physical infrastructure, avoiding network overlays and associated overhead.
Setup involves standard Calico BGP resources (BGPPeer, BGPFilter) for eBGP peering and requires KubeVirt's bridged networking mode.

### Default tier policy naming changes

In previous versions, there were inconsistencies in how default tier policies were named and managed, particularly affecting users using CI/CD tools.

Starting with version 3.30.0, we have addressed these inconsistencies.
Users can now create policies in the default tier with or without the `default.` prefix.
However, policies must be managed using the exact name they were created with.
The API server will now consistently return the policy name as it was originally created (with or without the prefix).
If you upgraded from a previous version of Calico, all policies in the default tier will be treated as if they were created with the `default.` prefix.
This change ensures compatibility with CI/CD tools like ArgoCD.

### OpenStack Caracal support

This release adds support for OpenStack Caracal.

#### Bug fixes
- Fix spammy logs when handling endpoint status creation events. [calico 10327](https://github.com/projectcalico/calico/pull/10327) (@song-jiang)
- Change OpenShift manifests order to fix an error when creating HCP clusters. [calico 10254](https://github.com/projectcalico/calico/pull/10254) (@coutinhop)
- Fix potential nil pointer access in confd [calico 10177](https://github.com/projectcalico/calico/pull/10177) (@fasaxc)
- Fix up various spammy warning logs. [calico 10176](https://github.com/projectcalico/calico/pull/10176) (@fasaxc)
- Fix that BPF-based conntrack cleaner would expire DSR entries too soon due to missing type check. [calico 9957](https://github.com/projectcalico/calico/pull/9957) (@fasaxc)
- Fix missing RBAC permissions for kube-controller-manager to access tiers in manifest installs, which was preventing proper resource garbage collection. [calico 9879](https://github.com/projectcalico/calico/pull/9879) (@caseydavenport)
- Fixed tiers RBAC for calicoctl when it runs as a k8s pod. [calico 9822](https://github.com/projectcalico/calico/pull/9822) (@lucastigera)
- Rev bpftool to v7.5.0.  Should fix issues with listing programs when there are non-Calico programs present that bpftool doesn't understand. [calico 9806](https://github.com/projectcalico/calico/pull/9806) (@fasaxc)
- Fix: Map OpenStack-derived policy to the "default" tier, not "ossg". [calico 9777](https://github.com/projectcalico/calico/pull/9777) (@nelljerram)
- Fix that netlink list operations could fail with "device or resource busy" errors when under load resulting in Felix restarting. [calico 9769](https://github.com/projectcalico/calico/pull/9769) (@fasaxc)
- Fix incorrect comment for TCPResetSeen. [calico 9759](https://github.com/projectcalico/calico/pull/9759) (@ioworker0)
- The default value of endpointStatusPathPrefix in FelixConfiguration is /var/run/calico. Felix writes endpoint status files by default unless explicitly disabled by setting endpointStatusPathPrefix to an empty value. [calico 9721](https://github.com/projectcalico/calico/pull/9721) (@song-jiang)
- Fix route programming for VXLAN tunnel IPs assigned from a /32 or /128 IPAM block. [calico 9698](https://github.com/projectcalico/calico/pull/9698) (@caseydavenport)
- Fix spammy Tier already exists message from kube-controllers. [calico 9670](https://github.com/projectcalico/calico/pull/9670) (@fasaxc)
- Fix that nodes with borrowed VXLAN tunnel addresses were not reachable by pods. [calico 9662](https://github.com/projectcalico/calico/pull/9662) (@caseydavenport)
- Fix nftables mode for arm64 including wrong libnftnl version [calico 9657](https://github.com/projectcalico/calico/pull/9657) (@caseydavenport)
- Policies part of the default tier can be managed only with the original name they were created with. Policies are no longer able to be managed interchangeably with or without the default. tier prefix [calico 9615](https://github.com/projectcalico/calico/pull/9615) (@MichalFupso)
- Fixed file handle leak in felix, caused by failing to close netlink handles. [calico 9609](https://github.com/projectcalico/calico/pull/9609) (@sridhartigera)
- Fix that libcalico-go would not always fill in the revision when listing certain resources (or single instances of certain resources).  This could result in missed watch events in components such as Typha. [calico 9599](https://github.com/projectcalico/calico/pull/9599) (@fasaxc)
- Fix that non-amd64 builds of node-driver-registrar contained x86 binaries. [calico 9594](https://github.com/projectcalico/calico/pull/9594) (@caseydavenport)
- Fix that in-use VXLAN ARP entries could be repeatedly cleaned up and then re-added if they shared a MAC address with an stale entry that was supposed to be cleaned up. [calico 9576](https://github.com/projectcalico/calico/pull/9576) (@fasaxc)
- Felix: fix that a map used to cache loaded datastore keys would always use RAM proportional to the total number of keys rather than shrinking when no longer needed. [calico 9526](https://github.com/projectcalico/calico/pull/9526) (@fasaxc)
- Fix that the new tiers resource was omitted from etcd->Kubernetes migration. [calico 9493](https://github.com/projectcalico/calico/pull/9493) (@fasaxc)
- Fix a panic in Felix when accessing a nil address in flushing host addresses, i.e. flushHostIPUpdates function. [calico 9466](https://github.com/projectcalico/calico/pull/9466) (@cyclinder)
- Helm: Fix that uninstall Job had duplicate k8s-app labels [calico 9438](https://github.com/projectcalico/calico/pull/9438) (@caseydavenport)
- Fix that single-IP entries on BGPConfiguration serviceExternalIPs were not advertised according to external traffic policy. [calico 9422](https://github.com/projectcalico/calico/pull/9422) (@tanujd11)
- Fix missing routes when vxlan mode is cross-subnet and the environment is purely V6 (no V4 host addresses) [calico 9416](https://github.com/projectcalico/calico/pull/9416) (@tomastigera)
- Fix spurious warning about unexpected inserted rules. [calico 9393](https://github.com/projectcalico/calico/pull/9393) (@fasaxc)
- Fixed memory leak in BPF endpoint manager. [calico 9307](https://github.com/projectcalico/calico/pull/9307) (@sridhartigera)
- Helm: Fix OpenShift provider case sensitivity [calico 9305](https://github.com/projectcalico/calico/pull/9305) (@unai-ttxu)
- Fix a bug where pods with flexvol/nodeagent volumes would get stuck in the Terminating phase, if, during termination, their node rebooted. [calico 9279](https://github.com/projectcalico/calico/pull/9279) (@aaaaaaaalex)
- fix image in flannel migration manifest [calico 9263](https://github.com/projectcalico/calico/pull/9263) (@radTuti)
- Fix spammy logs when handling endpoint status creation events. [calico 10327](https://github.com/projectcalico/calico/pull/10327) (@song-jiang)
- Change OpenShift manifests order to fix an error when creating HCP clusters. [calico 10254](https://github.com/projectcalico/calico/pull/10254) (@coutinhop)
- Fix potential nil pointer access in confd [calico 10177](https://github.com/projectcalico/calico/pull/10177) (@fasaxc)
- Fix up various spammy warning logs. [calico 10176](https://github.com/projectcalico/calico/pull/10176) (@fasaxc)
- Fix that BPF-based conntrack cleaner would expire DSR entries too soon due to missing type check. [calico 9957](https://github.com/projectcalico/calico/pull/9957) (@fasaxc)
- Fix missing RBAC permissions for kube-controller-manager to access tiers in manifest installs, which was preventing proper resource garbage collection. [calico 9879](https://github.com/projectcalico/calico/pull/9879) (@caseydavenport)
- Fixed tiers RBAC for calicoctl when it runs as a k8s pod. [calico 9822](https://github.com/projectcalico/calico/pull/9822) (@lucastigera)
- Rev bpftool to v7.5.0.  Should fix issues with listing programs when there are non-Calico programs present that bpftool doesn't understand. [calico 9806](https://github.com/projectcalico/calico/pull/9806) (@fasaxc)
- Fix: Map OpenStack-derived policy to the "default" tier, not "ossg". [calico 9777](https://github.com/projectcalico/calico/pull/9777) (@nelljerram)
- Fix that netlink list operations could fail with "device or resource busy" errors when under load resulting in Felix restarting. [calico 9769](https://github.com/projectcalico/calico/pull/9769) (@fasaxc)
- Fix incorrect comment for TCPResetSeen. [calico 9759](https://github.com/projectcalico/calico/pull/9759) (@ioworker0)
- The default value of endpointStatusPathPrefix in FelixConfiguration is /var/run/calico. Felix writes endpoint status files by default unless explicitly disabled by setting endpointStatusPathPrefix to an empty value. [calico 9721](https://github.com/projectcalico/calico/pull/9721) (@song-jiang)
- Fix route programming for VXLAN tunnel IPs assigned from a /32 or /128 IPAM block. [calico 9698](https://github.com/projectcalico/calico/pull/9698) (@caseydavenport)
- Fix spammy Tier already exists message from kube-controllers. [calico 9670](https://github.com/projectcalico/calico/pull/9670) (@fasaxc)
- Fix that nodes with borrowed VXLAN tunnel addresses were not reachable by pods. [calico 9662](https://github.com/projectcalico/calico/pull/9662) (@caseydavenport)
- Fix nftables mode for arm64 including wrong libnftnl version [calico 9657](https://github.com/projectcalico/calico/pull/9657) (@caseydavenport)
- Policies part of the default tier can be managed only with the original name they were created with. Policies are no longer able to be managed interchangeably with or without the default. tier prefix [calico 9615](https://github.com/projectcalico/calico/pull/9615) (@MichalFupso)
- Fixed file handle leak in felix, caused by failing to close netlink handles. [calico 9609](https://github.com/projectcalico/calico/pull/9609) (@sridhartigera)
- Fix that libcalico-go would not always fill in the revision when listing certain resources (or single instances of certain resources).  This could result in missed watch events in components such as Typha. [calico 9599](https://github.com/projectcalico/calico/pull/9599) (@fasaxc)
- Fix that non-amd64 builds of node-driver-registrar contained x86 binaries. [calico 9594](https://github.com/projectcalico/calico/pull/9594) (@caseydavenport)
- Fix that in-use VXLAN ARP entries could be repeatedly cleaned up and then re-added if they shared a MAC address with an stale entry that was supposed to be cleaned up. [calico 9576](https://github.com/projectcalico/calico/pull/9576) (@fasaxc)
- Felix: fix that a map used to cache loaded datastore keys would always use RAM proportional to the total number of keys rather than shrinking when no longer needed. [calico 9526](https://github.com/projectcalico/calico/pull/9526) (@fasaxc)
- Fix that the new tiers resource was omitted from etcd->Kubernetes migration. [calico 9493](https://github.com/projectcalico/calico/pull/9493) (@fasaxc)
- Fix a panic in Felix when accessing a nil address in flushing host addresses, i.e. flushHostIPUpdates function. [calico 9466](https://github.com/projectcalico/calico/pull/9466) (@cyclinder)
- Helm: Fix that uninstall Job had duplicate k8s-app labels [calico 9438](https://github.com/projectcalico/calico/pull/9438) (@caseydavenport)
- Fix that single-IP entries on BGPConfiguration serviceExternalIPs were not advertised according to external traffic policy. [calico 9422](https://github.com/projectcalico/calico/pull/9422) (@tanujd11)
- Fix missing routes when vxlan mode is cross-subnet and the environment is purely V6 (no V4 host addresses) [calico 9416](https://github.com/projectcalico/calico/pull/9416) (@tomastigera)
- Fix spurious warning about unexpected inserted rules. [calico 9393](https://github.com/projectcalico/calico/pull/9393) (@fasaxc)
- Fixed memory leak in BPF endpoint manager. [calico 9307](https://github.com/projectcalico/calico/pull/9307) (@sridhartigera)
- Helm: Fix OpenShift provider case sensitivity [calico 9305](https://github.com/projectcalico/calico/pull/9305) (@unai-ttxu)
- Fix a bug where pods with flexvol/nodeagent volumes would get stuck in the Terminating phase, if, during termination, their node rebooted. [calico 9279](https://github.com/projectcalico/calico/pull/9279) (@aaaaaaaalex)
- fix image in flannel migration manifest [calico 9263](https://github.com/projectcalico/calico/pull/9263) (@radTuti)

#### eBPF-related changes

- ebpf: Fix configuring arp entries for bpf NAT devices for systemd >= 242 [calico 10209](https://github.com/projectcalico/calico/pull/10209) (@sridhartigera)
- ebpf: Fixed a bug where BPF programs were being re-attached to network interfaces unnecessarily, even when the host IP address had not changed. [calico 10163](https://github.com/projectcalico/calico/pull/10163) (@sridhartigera)
- ebpf: fix cleanup of UDP service entries when a service gets (re)created [calico 10098](https://github.com/projectcalico/calico/pull/10098) (@tomastigera)
- ebpf: Fix dropping packets from workloads to host interfaces not managed by calico. [calico 10085](https://github.com/projectcalico/calico/pull/10085) (@sridhartigera)
- ebpf: treat conns with both FINs as finished in flowlogs, do not wait until conntrack is to be removed. [calico 9838](https://github.com/projectcalico/calico/pull/9838) (@tomastigera)
- ebpf: fix icmp error delivery to host networked pods [calico 9747](https://github.com/projectcalico/calico/pull/9747) (@tomastigera)
- ebpf: conntrack table doubles in size if it is running out of space [calico 9732](https://github.com/projectcalico/calico/pull/9732) (@tomastigera)
- ebpf: adjust the default value to the value from the actual map when dumping the conntrack map in calico-bpf [calico 9704](https://github.com/projectcalico/calico/pull/9704) (@ioworker0)
- ebpf: conntrack more resistant to spurious RSTs [calico 9692](https://github.com/projectcalico/calico/pull/9692) (@tomastigera)
- ebpf: conntrack timers are configurable, closed TCP connections are closed now by default after /proc/sys/net/netfilter/nf_conntrack_tcp_timeout_time_wait seconds (120 by default) up from 30s. [calico 9607](https://github.com/projectcalico/calico/pull/9607) (@tomastigera)
- ebpf: additional conntrack counters [calico 9590](https://github.com/projectcalico/calico/pull/9590) (@tomastigera)
- ebpf: fixed routing from outside the cluster in EKS with aws-cni [calico 9569](https://github.com/projectcalico/calico/pull/9569) (@tomastigera)
- ebpf: end-2-end latency measurement within tc programs [calico 9545](https://github.com/projectcalico/calico/pull/9545) (@tomastigera)
- ebpf: improved autodetection of device hierarchy like bonds and vlans. tc is attached to the root and xdp to the leaves. [calico 9498](https://github.com/projectcalico/calico/pull/9498) (@sridhartigera)
- ebpf: fall back to non-CO-RE if CO-RE object does not load [calico 9456](https://github.com/projectcalico/calico/pull/9456) (@tomastigera)
- ebpf: support for log action in policy rules [calico 9452](https://github.com/projectcalico/calico/pull/9452) (@tomastigera)
- ebpf: calico special interfaces excluded from dataIfaceRegex [calico 9451](https://github.com/projectcalico/calico/pull/9451) (@tomastigera)
- ebpf: Fix that we'd fail to clear mark bits after applying do-not-track policy.  Use dedicated mark for XDP bypass traffic. [calico 9392](https://github.com/projectcalico/calico/pull/9392) (@fasaxc)
- ebpf: real IPs in bpf debug output with co-re enabled kernels [calico 9378](https://github.com/projectcalico/calico/pull/9378) (@tomastigera)
- ebpf: disable conntrack bypass by default (not needed for kernels 5.9+), exclude link-local from the bypass [calico 9159](https://github.com/projectcalico/calico/pull/9159) (@tomastigera)
- ebpf: Fix configuring arp entries for bpf NAT devices for systemd >= 242 [calico 10209](https://github.com/projectcalico/calico/pull/10209) (@sridhartigera)
- eBPF: Fixed a bug where BPF programs were being re-attached to network interfaces unnecessarily, even when the host IP address had not changed. [calico 10163](https://github.com/projectcalico/calico/pull/10163) (@sridhartigera)
- ebpf: fix cleanup of UDP service entries when a service gets (re)created [calico 10098](https://github.com/projectcalico/calico/pull/10098) (@tomastigera)
- ebpf: Fix dropping packets from workloads to host interfaces not managed by calico. [calico 10085](https://github.com/projectcalico/calico/pull/10085) (@sridhartigera)
- ebpf: treat conns with both FINs as finished in flowlogs, do not wait until conntrack is to be removed. [calico 9838](https://github.com/projectcalico/calico/pull/9838) (@tomastigera)
- ebpf: fix icmp error delivery to host networked pods [calico 9747](https://github.com/projectcalico/calico/pull/9747) (@tomastigera)
- ebpf: conntrack table doubles in size if it is running out of space [calico 9732](https://github.com/projectcalico/calico/pull/9732) (@tomastigera)
- ebpf: adjust the default value to the value from the actual map when dumping the conntrack map in calico-bpf [calico 9704](https://github.com/projectcalico/calico/pull/9704) (@ioworker0)
- ebpf: conntrack more resistant to spurious RSTs [calico 9692](https://github.com/projectcalico/calico/pull/9692) (@tomastigera)
- ebpf: conntrack timers are configurable, closed TCP connections are closed now by default after /proc/sys/net/netfilter/nf_conntrack_tcp_timeout_time_wait seconds (120 by default) up from 30s. [calico 9607](https://github.com/projectcalico/calico/pull/9607) (@tomastigera)
- ebpf: additional conntrack counters [calico 9590](https://github.com/projectcalico/calico/pull/9590) (@tomastigera)
- ebpf: fixed routing from outside the cluster in EKS with aws-cni [calico 9569](https://github.com/projectcalico/calico/pull/9569) (@tomastigera)
- ebpf: end-2-end latency measurement within tc programs [calico 9545](https://github.com/projectcalico/calico/pull/9545) (@tomastigera)
- ebpf: improved autodetection of device hierarchy like bonds and vlans. tc is attached to the root and xdp to the leaves. [calico 9498](https://github.com/projectcalico/calico/pull/9498) (@sridhartigera)
- ebpf: fall back to non-CO-RE if CO-RE object does not load [calico 9456](https://github.com/projectcalico/calico/pull/9456) (@tomastigera)
- ebpf: support for log action in policy rules [calico 9452](https://github.com/projectcalico/calico/pull/9452) (@tomastigera)
- ebpf: calico special interfaces excluded from dataIfaceRegex [calico 9451](https://github.com/projectcalico/calico/pull/9451) (@tomastigera)
- ebpf: Fix that we'd fail to clear mark bits after applying do-not-track policy.  Use dedicated mark for XDP bypass traffic. [calico 9392](https://github.com/projectcalico/calico/pull/9392) (@fasaxc)
- ebpf: real IPs in bpf debug output with co-re enabled kernels [calico 9378](https://github.com/projectcalico/calico/pull/9378) (@tomastigera)
- ebpf: (on kernels that support it) conntrack expiry scanning is now done from a dedicated BPF program rather than from userspace. This is more efficient and reduces the possibility of races with the dataplane programs. [calico 9356](https://github.com/projectcalico/calico/pull/9356) (@fasaxc)
- ebpf: disable conntrack bypass by default (not needed for kernels 5.9+), exclude link-local from the bypass [calico 9159](https://github.com/projectcalico/calico/pull/9159) (@tomastigera)

#### Other changes

- Resolved an issue preventing the program from launching on the s390x architecture. [calico 10206](https://github.com/projectcalico/calico/pull/10206) (@hjiawei)
- New manifests to install Calico with the eBPF dataplane in an OpenShift cluster. [calico 10108](https://github.com/projectcalico/calico/pull/10108) (@lucastigera)
- Reduce logging-related allocations in hot path.  Reduces garbage collection overheads. [calico 9990](https://github.com/projectcalico/calico/pull/9990) (@fasaxc)
- Add packet number of connections limiting QoS control to workloads. [calico 9989](https://github.com/projectcalico/calico/pull/9989) (@coutinhop)
- Add packet rate limiting QoS control to workloads. [calico 9947](https://github.com/projectcalico/calico/pull/9947) (@coutinhop)
- Add helm values.yaml config option for operator management of CRDs (default: true) [calico 9937](https://github.com/projectcalico/calico/pull/9937) (@caseydavenport)
- Updates the AutoHEP Kube-Controller to allow creation of multiple custom HostEndpoints per Node [calico 9901](https://github.com/projectcalico/calico/pull/9901) (@MichalFupso)
- Whisker observability UI is enabled by default in the helm chart and Tigera operator custom-resources.yaml. [calico 9894](https://github.com/projectcalico/calico/pull/9894) (@caseydavenport)
- Optimization: avoid listing all IPPools for simple IPAM assignments. [calico 9891](https://github.com/projectcalico/calico/pull/9891) (@gojoy)
- Calico is now built with Go 1.24 against Kubernetes v1.32. [calico 9890](https://github.com/projectcalico/calico/pull/9890) (@hjiawei)
- Add bandwidth limiting QoS control to workloads. [calico 9881](https://github.com/projectcalico/calico/pull/9881) (@coutinhop)
- Support nested BGP peering with calico-nodes running in local KubeVirt VMs. [calico 9875](https://github.com/projectcalico/calico/pull/9875) (@song-jiang)
- Added support for configuring `MaxBlocksPerHost` via `calicoctl ipam configure --maxblockhost`. This allows operators to limit the number of IP blocks assigned to a host. [calico 9842](https://github.com/projectcalico/calico/pull/9842) (@phantooom)
- Wireguard: Defer setting NAPI threading until after adding first peer.  Kernel disallows the setting until then. [calico 9815](https://github.com/projectcalico/calico/pull/9815) (@fasaxc)
- Calico for OpenStack now supports some Neutron QoS policy fields: the "max_kbps" and "max_burst_kbps" fields of bandwidth limit rules, and the "max_kpps" field of packet rate limit rules.  There are also new driver settings (cluster-wide) for imposing a maximum number of egress connections per Neutron port, and similarly for ingress connections. [calico 9811](https://github.com/projectcalico/calico/pull/9811) (@nelljerram)
- Adding support for staged policies, by introducing **stagedglobalnetworkpolicy**, **stagednetworkpolicy**, and **stagedkubernetesnetworkpolicy** CRDs. [calico 9746](https://github.com/projectcalico/calico/pull/9746) (@mazdakn)
- Adding flow log to Felix for collecting observability data from each Calico node and sending to `calico/goldmane` [calico 9737](https://github.com/projectcalico/calico/pull/9737) (@mazdakn)
- Introduces `calico/goldmane`, a new component for aggregating observability data across nodes. [calico 9708](https://github.com/projectcalico/calico/pull/9708) (@caseydavenport)
- Ensure existing CNI config file has correct permissions on upgrade [calico 9656](https://github.com/projectcalico/calico/pull/9656) (@kashifest)
- Improve CPU efficiency of IP address garbage collection controller [calico 9654](https://github.com/projectcalico/calico/pull/9654) (@caseydavenport)
- Calico is now built with Go 1.23.4 against Kubernetes v1.31.4. [calico 9608](https://github.com/projectcalico/calico/pull/9608) (@hjiawei)
- Unify all logging to logrus for consistency in logging across all components which also enables controlling what is logged via only one parameter `LOG_LEVEL` [calico 9600](https://github.com/projectcalico/calico/pull/9600) (@ti-afra)
- Calico now takes advantage of "watch bookmarks" when watching Kubernetes resources.  This prevents "resource version too old" errors, which result in unnecessary resyncs (which delay updates and increase API server CPU load). [calico 9593](https://github.com/projectcalico/calico/pull/9593) (@fasaxc)
- Enhance conntrack map flexibility with CPU-based scaling. [calico 9581](https://github.com/projectcalico/calico/pull/9581) (@ioworker0)
- Improve performance of selector parsing and validation. [calico 9564](https://github.com/projectcalico/calico/pull/9564) (@fasaxc)
- Support for a new cni.projectcalico.org/ipFamilies annotation to configure which IP families to use on a per-pod or per-Namespace basis. [calico 9544](https://github.com/projectcalico/calico/pull/9544) (@renyunkang)
- Configurable CNI token refresh duration [calico 9539](https://github.com/projectcalico/calico/pull/9539) (@huutomerkki)
- In nftables dataplane, use human readable policy chain names where possible. [calico 9528](https://github.com/projectcalico/calico/pull/9528) (@caseydavenport)
- To reduce manifest size, tigera-operator.yaml no longer includes CustomResourceDefinitions. Instead, the tigera-operator pod will deploy these resources on startup. [calico 9518](https://github.com/projectcalico/calico/pull/9518) (@caseydavenport)
- Felix now compresses network policies and namespaces in memory, reducing RAM usage in clusters with many policies/namespaces that are not active on a given node. [calico 9514](https://github.com/projectcalico/calico/pull/9514) (@fasaxc)
- Reduce get/update node API calls in allocate-tunnel-addrs. [calico 9506](https://github.com/projectcalico/calico/pull/9506) (@liuxu623)
- Add permission to Calico API server to create tier resources. [calico 9482](https://github.com/projectcalico/calico/pull/9482) (@sebhoss)
- Add support for Kubernetes BaselineAdminNetworkPolicy. https://network-policy-api.sigs.k8s.io/api-overview/ [calico 9464](https://github.com/projectcalico/calico/pull/9464) (@fasaxc)
- Do not fail data store initialisation when unauthorised error happen while creating default and adminnetworkpolicy tiers. Those tiers eventually get created by another component. [calico 9446](https://github.com/projectcalico/calico/pull/9446) (@mazdakn)
- Tweak bounds checking in Felix parameter conversion to avoid false positives in static analysis. [calico 9382](https://github.com/projectcalico/calico/pull/9382) (@fasaxc)
- The `felix_iptables_rules` Prometheus metric now only counts rules within referenced Iptables chains, no longer counts candidate rules. [calico 9374](https://github.com/projectcalico/calico/pull/9374) (@aaaaaaaalex)
- Calico is now built with Go 1.23.2 against Kubernetes v1.30.5. [calico 9335](https://github.com/projectcalico/calico/pull/9335) (@hjiawei)
- Add tooling to auto-generate Felix configuration documentation.  Improve CRD documentation and validation. [calico 9325](https://github.com/projectcalico/calico/pull/9325) (@fasaxc)
- New Felix config param IPForwarding allows for preventing Felix from enabling IP forwarding on systems that are only using Calico for host protection (and hence don't need to forward traffic to workloads). [calico 9313](https://github.com/projectcalico/calico/pull/9313) (@fasaxc)
- Automate embedding of CRDs in `calicoctl datastore migrate import`; removes a manual step that could be forgotten. [calico 9297](https://github.com/projectcalico/calico/pull/9297) (@fasaxc)
- Added support for calicoctl version --client [calico 9291](https://github.com/projectcalico/calico/pull/9291) (@cyclinder)
- Update Calico's OpenStack integration code to work with the OpenStack Caracal release, and also with Ubuntu Jammy. [calico 9278](https://github.com/projectcalico/calico/pull/9278) (@nelljerram)
- Add support for AdminNetworkPolicy egress network CIDRs. [calico 9276](https://github.com/projectcalico/calico/pull/9276) (@mazdakn)
- Calico is now built with Go 1.23.2 against Kubernetes v1.29.9. [calico 9270](https://github.com/projectcalico/calico/pull/9270) (@hjiawei)
- Add setting to enable wireguard NAPI threading [calico 9260](https://github.com/projectcalico/calico/pull/9260) (@jrcichra)
- Allow users to specify the default action in a tier. [calico 9232](https://github.com/projectcalico/calico/pull/9232) (@mazdakn)
- Add LoadBalancer kube-controller to allow for Service LoadBalancer IPAM [calico 9221](https://github.com/projectcalico/calico/pull/9221) (@MichalFupso)
- Use restricted pod security standard on calico-apiserver namespace in manifests for OCP [calico 9217](https://github.com/projectcalico/calico/pull/9217) (@mihivagyok)
- Add a label to Workload endpoints for the name of the network of the related port. Useful for cases where there are many different OpenStack deployments with the same network name. No impact requiring code changes. [calico 9129](https://github.com/projectcalico/calico/pull/9129) (@trev97)
- Adjust CNI config file permissions to satisfy CIS benchmark expectations. [calico 8991](https://github.com/projectcalico/calico/pull/8991) (@missa-wndrvr)
- Calico now reconciles its VXLAN tunnel interface MAC address if it changes. [calico 8924](https://github.com/projectcalico/calico/pull/8924) (@MageekChiu)
- Support for using named ports in NetworkPolicy when exposed via an initContainer. [calico 8885](https://github.com/projectcalico/calico/pull/8885) (@george-angel)
