// Copyright (c) 2022 Tigera, Inc. All rights reserved.

// Code generated by lister-gen. DO NOT EDIT.

package v3

import (
	v3 "github.com/projectcalico/api/pkg/apis/projectcalico/v3"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// NetworkSetLister helps list NetworkSets.
// All objects returned here must be treated as read-only.
type NetworkSetLister interface {
	// List lists all NetworkSets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v3.NetworkSet, err error)
	// NetworkSets returns an object that can list and get NetworkSets.
	NetworkSets(namespace string) NetworkSetNamespaceLister
	NetworkSetListerExpansion
}

// networkSetLister implements the NetworkSetLister interface.
type networkSetLister struct {
	indexer cache.Indexer
}

// NewNetworkSetLister returns a new NetworkSetLister.
func NewNetworkSetLister(indexer cache.Indexer) NetworkSetLister {
	return &networkSetLister{indexer: indexer}
}

// List lists all NetworkSets in the indexer.
func (s *networkSetLister) List(selector labels.Selector) (ret []*v3.NetworkSet, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.NetworkSet))
	})
	return ret, err
}

// NetworkSets returns an object that can list and get NetworkSets.
func (s *networkSetLister) NetworkSets(namespace string) NetworkSetNamespaceLister {
	return networkSetNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// NetworkSetNamespaceLister helps list and get NetworkSets.
// All objects returned here must be treated as read-only.
type NetworkSetNamespaceLister interface {
	// List lists all NetworkSets in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v3.NetworkSet, err error)
	// Get retrieves the NetworkSet from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v3.NetworkSet, error)
	NetworkSetNamespaceListerExpansion
}

// networkSetNamespaceLister implements the NetworkSetNamespaceLister
// interface.
type networkSetNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all NetworkSets in the indexer for a given namespace.
func (s networkSetNamespaceLister) List(selector labels.Selector) (ret []*v3.NetworkSet, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.NetworkSet))
	})
	return ret, err
}

// Get retrieves the NetworkSet from the indexer for a given namespace and name.
func (s networkSetNamespaceLister) Get(name string) (*v3.NetworkSet, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v3.Resource("networkset"), name)
	}
	return obj.(*v3.NetworkSet), nil
}
