// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package internal // import "go.opentelemetry.io/collector/pdata/internal/cmd/pdatagen/internal"

var commonFile = &File{
	Name: "common",
	imports: []string{
		`otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"`,
	},
	testImports: []string{
		`"testing"`,
		``,
		`"github.com/stretchr/testify/assert"`,
		``,
		`otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"`,
	},
	structs: []baseStruct{
		scope,
		attributeValueSlice,
	},
}

var scope = &messageValueStruct{
	structName:     "InstrumentationScope",
	description:    "// Scope is a message representing the instrumentation library information.",
	originFullName: "otlpcommon.InstrumentationScope",
	fields: []baseField{
		nameField,
		&primitiveField{
			fieldName:       "Version",
			originFieldName: "Version",
			returnType:      "string",
			defaultVal:      `""`,
			testVal:         `"test_version"`,
		},
	},
}

// This will not be generated by this class.
// Defined here just to be available as returned message for the fields.
var mapStruct = &sliceOfPtrs{
	structName: "Map",
	element:    attributeKeyValue,
}

var attributeKeyValue = &messageValueStruct{}

var scopeField = &messageValueField{
	fieldName:       "Scope",
	originFieldName: "Scope",
	returnMessage:   scope,
}

var startTimeField = &primitiveTypedField{
	fieldName:       "StartTimestamp",
	originFieldName: "StartTimeUnixNano",
	returnType:      "Timestamp",
	rawType:         "uint64",
	defaultVal:      "Timestamp(0)",
	testVal:         "Timestamp(1234567890)",
}

var timeField = &primitiveTypedField{
	fieldName:       "Timestamp",
	originFieldName: "TimeUnixNano",
	returnType:      "Timestamp",
	rawType:         "uint64",
	defaultVal:      "Timestamp(0)",
	testVal:         "Timestamp(1234567890)",
}

var endTimeField = &primitiveTypedField{
	fieldName:       "EndTimestamp",
	originFieldName: "EndTimeUnixNano",
	returnType:      "Timestamp",
	rawType:         "uint64",
	defaultVal:      "Timestamp(0)",
	testVal:         "Timestamp(1234567890)",
}

var attributes = &sliceField{
	fieldName:       "Attributes",
	originFieldName: "Attributes",
	returnSlice:     mapStruct,
}

var nameField = &primitiveField{
	fieldName:       "Name",
	originFieldName: "Name",
	returnType:      "string",
	defaultVal:      `""`,
	testVal:         `"test_name"`,
}

var anyValue = &messageValueStruct{
	structName:     "Value",
	originFullName: "otlpcommon.AnyValue",
}

var attributeValueSlice = &sliceOfValues{
	structName: "Slice",
	element:    anyValue,
}

var schemaURLField = &primitiveField{
	fieldName:       "SchemaUrl",
	originFieldName: "SchemaUrl",
	returnType:      "string",
	defaultVal:      `""`,
	testVal:         `"https://opentelemetry.io/schemas/1.5.0"`,
}
