// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolStack = sync.Pool{
		New: func() any {
			return &otlpprofiles.Stack{}
		},
	}
)

func NewOrigStack() *otlpprofiles.Stack {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Stack{}
	}
	return protoPoolStack.Get().(*otlpprofiles.Stack)
}

func DeleteOrigStack(orig *otlpprofiles.Stack, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolStack.Put(orig)
	}
}

func CopyOrigStack(dest, src *otlpprofiles.Stack) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.LocationIndices = CopyOrigInt32Slice(dest.LocationIndices, src.LocationIndices)
}

func GenTestOrigStack() *otlpprofiles.Stack {
	orig := NewOrigStack()
	orig.LocationIndices = GenerateOrigTestInt32Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigStack(orig *otlpprofiles.Stack, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.LocationIndices) > 0 {
		dest.WriteObjectField("locationIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.LocationIndices[0])
		for i := 1; i < len(orig.LocationIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.LocationIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigStack unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigStack(orig *otlpprofiles.Stack, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "locationIndices", "location_indices":
			for iter.ReadArray() {
				orig.LocationIndices = append(orig.LocationIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigStack(orig *otlpprofiles.Stack) int {
	var n int
	var l int
	_ = l
	if len(orig.LocationIndices) > 0 {
		l = 0
		for _, e := range orig.LocationIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigStack(orig *otlpprofiles.Stack, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.LocationIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigStack(orig *otlpprofiles.Stack, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {
		case 1:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.LocationIndices = append(orig.LocationIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field LocationIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.LocationIndices = append(orig.LocationIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field LocationIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
