// Copyright 2017-2021 Authors of Cilium
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"
	"time"

	v2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumExternalWorkloadsGetter has a method to return a CiliumExternalWorkloadInterface.
// A group's client should implement this interface.
type CiliumExternalWorkloadsGetter interface {
	CiliumExternalWorkloads() CiliumExternalWorkloadInterface
}

// CiliumExternalWorkloadInterface has methods to work with CiliumExternalWorkload resources.
type CiliumExternalWorkloadInterface interface {
	Create(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.CreateOptions) (*v2.CiliumExternalWorkload, error)
	Update(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (*v2.CiliumExternalWorkload, error)
	UpdateStatus(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (*v2.CiliumExternalWorkload, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.CiliumExternalWorkload, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.CiliumExternalWorkloadList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumExternalWorkload, err error)
	CiliumExternalWorkloadExpansion
}

// ciliumExternalWorkloads implements CiliumExternalWorkloadInterface
type ciliumExternalWorkloads struct {
	client rest.Interface
}

// newCiliumExternalWorkloads returns a CiliumExternalWorkloads
func newCiliumExternalWorkloads(c *CiliumV2Client) *ciliumExternalWorkloads {
	return &ciliumExternalWorkloads{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumExternalWorkload, and returns the corresponding ciliumExternalWorkload object, and an error if there is any.
func (c *ciliumExternalWorkloads) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.CiliumExternalWorkload, err error) {
	result = &v2.CiliumExternalWorkload{}
	err = c.client.Get().
		Resource("ciliumexternalworkloads").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumExternalWorkloads that match those selectors.
func (c *ciliumExternalWorkloads) List(ctx context.Context, opts v1.ListOptions) (result *v2.CiliumExternalWorkloadList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2.CiliumExternalWorkloadList{}
	err = c.client.Get().
		Resource("ciliumexternalworkloads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumExternalWorkloads.
func (c *ciliumExternalWorkloads) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumexternalworkloads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumExternalWorkload and creates it.  Returns the server's representation of the ciliumExternalWorkload, and an error, if there is any.
func (c *ciliumExternalWorkloads) Create(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.CreateOptions) (result *v2.CiliumExternalWorkload, err error) {
	result = &v2.CiliumExternalWorkload{}
	err = c.client.Post().
		Resource("ciliumexternalworkloads").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumExternalWorkload).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumExternalWorkload and updates it. Returns the server's representation of the ciliumExternalWorkload, and an error, if there is any.
func (c *ciliumExternalWorkloads) Update(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (result *v2.CiliumExternalWorkload, err error) {
	result = &v2.CiliumExternalWorkload{}
	err = c.client.Put().
		Resource("ciliumexternalworkloads").
		Name(ciliumExternalWorkload.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumExternalWorkload).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ciliumExternalWorkloads) UpdateStatus(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (result *v2.CiliumExternalWorkload, err error) {
	result = &v2.CiliumExternalWorkload{}
	err = c.client.Put().
		Resource("ciliumexternalworkloads").
		Name(ciliumExternalWorkload.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumExternalWorkload).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumExternalWorkload and deletes it. Returns an error if one occurs.
func (c *ciliumExternalWorkloads) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumexternalworkloads").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumExternalWorkloads) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumexternalworkloads").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumExternalWorkload.
func (c *ciliumExternalWorkloads) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumExternalWorkload, err error) {
	result = &v2.CiliumExternalWorkload{}
	err = c.client.Patch(pt).
		Resource("ciliumexternalworkloads").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
