/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta2 "k8s.io/api/apps/v1beta2"
	appsv1beta2 "k8s.io/client-go/applyconfigurations/apps/v1beta2"
	gentype "k8s.io/client-go/gentype"
	typedappsv1beta2 "k8s.io/client-go/kubernetes/typed/apps/v1beta2"
)

// fakeDeployments implements DeploymentInterface
type fakeDeployments struct {
	*gentype.FakeClientWithListAndApply[*v1beta2.Deployment, *v1beta2.DeploymentList, *appsv1beta2.DeploymentApplyConfiguration]
	Fake *FakeAppsV1beta2
}

func newFakeDeployments(fake *FakeAppsV1beta2, namespace string) typedappsv1beta2.DeploymentInterface {
	return &fakeDeployments{
		gentype.NewFakeClientWithListAndApply[*v1beta2.Deployment, *v1beta2.DeploymentList, *appsv1beta2.DeploymentApplyConfiguration](
			fake.Fake,
			namespace,
			v1beta2.SchemeGroupVersion.WithResource("deployments"),
			v1beta2.SchemeGroupVersion.WithKind("Deployment"),
			func() *v1beta2.Deployment { return &v1beta2.Deployment{} },
			func() *v1beta2.DeploymentList { return &v1beta2.DeploymentList{} },
			func(dst, src *v1beta2.DeploymentList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta2.DeploymentList) []*v1beta2.Deployment { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta2.DeploymentList, items []*v1beta2.Deployment) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
