// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"

	v2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CiliumIdentitiesGetter has a method to return a CiliumIdentityInterface.
// A group's client should implement this interface.
type CiliumIdentitiesGetter interface {
	CiliumIdentities() CiliumIdentityInterface
}

// CiliumIdentityInterface has methods to work with CiliumIdentity resources.
type CiliumIdentityInterface interface {
	Create(ctx context.Context, ciliumIdentity *v2.CiliumIdentity, opts v1.CreateOptions) (*v2.CiliumIdentity, error)
	Update(ctx context.Context, ciliumIdentity *v2.CiliumIdentity, opts v1.UpdateOptions) (*v2.CiliumIdentity, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.CiliumIdentity, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.CiliumIdentityList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumIdentity, err error)
	CiliumIdentityExpansion
}

// ciliumIdentities implements CiliumIdentityInterface
type ciliumIdentities struct {
	*gentype.ClientWithList[*v2.CiliumIdentity, *v2.CiliumIdentityList]
}

// newCiliumIdentities returns a CiliumIdentities
func newCiliumIdentities(c *CiliumV2Client) *ciliumIdentities {
	return &ciliumIdentities{
		gentype.NewClientWithList[*v2.CiliumIdentity, *v2.CiliumIdentityList](
			"ciliumidentities",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v2.CiliumIdentity { return &v2.CiliumIdentity{} },
			func() *v2.CiliumIdentityList { return &v2.CiliumIdentityList{} }),
	}
}
