# v2.0 to 2.1

## Upgraded Kustomize Version

Note that bundled Kustomize has been upgraded to v4.2.0. Some of the flags are changed in Kustomize V4. 
For example flag name `load_restrictor` is changed in Kustomize v4+. It is changed from `--load_restrictor=none` to `--load-restrictor LoadRestrictionsNone`. 

## Replacing `--app-resync` flag with `timeout.reconciliation` setting

The`--app-resync` flag allows controlling how frequently Argo CD application controller checks resolve the target
application revision of each application. In order to allow caching resolved revision per repository as opposed to per
application, the `--app-resync` flag has been deprecated. Please use `timeout.reconciliation` setting in `argocd-cm` ConfigMap instead. The value of `timeout.reconciliation` is a [duration string](https://pkg.go.dev/time#ParseDuration) e.g `60s`, `1m` or `1h`.
See example in [argocd-cm.yaml](../argocd-cm.yaml).

From here on you can follow the [regular upgrade process](./overview.md).

## Replacing `repositories` and `repository.credentials` with Secrets

The configuration of repositories and repository credential templates via the `argocd-cm` has been deprecated.
Repositories and repository credentials are now discovered via Secrets that are labeled with `argocd.argoproj.io/secret-type=repository`
or `argocd.argoproj.io/secret-type=repo-creds` respectively. See the examples in [argocd-repositories.yaml](../argocd-repositories.yaml)
and [argocd-repo-creds.yaml](../argocd-repo-creds.yaml).

## The `argocd-util` CLI commands merged into `argocd admin` 

The `argocd-util` CLI commands are available under `argocd admin` and the `argocd-util` binary is no longer available.

## Replace runtime system user while [BYOI](../custom_tools.md#byoi-build-your-own-image)

Runtime system user should to be changed from `argocd` to `999`, as shown below.

```dockerfile
FROM argoproj/argocd:latest

# Switch to root for the ability to perform install
USER root

# Something custom here
RUN apt-get update

# Switch back to non-root user

# deprecated: USER argocd
USER 999
```
