# v2.7 to 2.8

## Support dropped for argocd-cm plugins

Config Management Plugins installed via the argocd-cm ConfigMap will not work starting with v2.8.

See the [migration guide](https://argo-cd.readthedocs.io/en/stable/operator-manual/config-management-plugins/#migrating-from-argocd-cm-plugins)
to upgrade your plugin.

## Tini as entrypoint

With the 2.8 release `entrypoint.sh` will be removed from the containers,
because starting with 2.7, the implicit entrypoint is set to `tini` in the
`Dockerfile` explicitly, and the kubernetes manifests has been updated to use
it. Simply updating the containers without updating the deployment manifests
will result in pod startup failures, as the old manifests are relying on
`entrypoint.sh` instead of `tini`. Please make sure the manifests are updated
properly before moving to 2.8.

## Filtering applied to cluster `List` API endpoint

Prior to `v2.8`, the `List` endpoint on the `ClusterService` did **not** filter
clusters when responding, despite accepting query parameters. This bug has
been addressed, and query parameters are now taken into account to filter the
resulting list of clusters.

## Configure RBAC to account for new actions

2.8 introduces three new actions:
* Create a Job from a CronJob
* Create a Workflow from a CronWorkflow
* Create a Workflow from a WorkflowTemplate

When you upgrade to 2.8, RBAC policies with `applications` in the *resource*
field and `*` or `action/*` in the action field, it will automatically grant the
ability to use these new actions.

If you would like to avoid granting these new permissions, you can update your RBAC policies to be more specific.

### Example

Old:

```csv
p, role:action-runner, applications, actions/, *, allow
```

New:

```csv
p, role:action-runner, applications, action/argoproj.io/Rollout/abort, *, allow
p, role:action-runner, applications, action/argoproj.io/Rollout/promote-full, *, allow
p, role:action-runner, applications, action/argoproj.io/Rollout/retry, *, allow
p, role:action-runner, applications, action/argoproj.io/Rollout/resume, *, allow
p, role:action-runner, applications, action/argoproj.io/Rollout/restart, *, allow
p, role:action-runner, applications, action/argoproj.io/AnalysisRun/terminate, *, allow
p, role:action-runner, applications, action/apps/DaemonSet/restart, *, allow
p, role:action-runner, applications, action/apps/StatefulSet/restart, *, allow
p, role:action-runner, applications, action/apps/Deployment/pause, *, allow
p, role:action-runner, applications, action/apps/Deployment/resume, *, allow
p, role:action-runner, applications, action/apps/Deployment/restart, *, allow

# If you don't want to grant the new permissions, don't include the following lines
p, role:action-runner, applications, action/argoproj.io/WorkflowTemplate/create-workflow, *, allow
p, role:action-runner, applications, action/argoproj.io/CronWorkflow/create-workflow, *, allow
p, role:action-runner, applications, action/batch/CronJob/create-job, *, allow
```

## Change default file open mode

In version 2.7, the CMP plugin was changed to open Git/Helm files with all executable bits set (unless `preserveFileMode` was specified).  
Version 2.8 removes the executable bits in cases where they are not necessary.
