# v2.9 to 2.10

## `managedNamespaceMetadata` no longer preserves client-side-applied labels or annotations

Argo CD 2.10 upgraded kubectl from 1.24 to 1.26. This upgrade introduced a change where client-side-applied labels and
annotations are no longer preserved when using a server-side kubectl apply. This change affects the
`managedNamespaceMetadata` field of the `Application` CRD. Previously, labels and annotations applied via a client-side
apply would be preserved when `managedNamespaceMetadata` was enabled. Now, those existing labels and annotation will be
removed.

To avoid unexpected behavior, follow the [client-side to server-side resource upgrade guide](https://kubernetes.io/docs/reference/using-api/server-side-apply/#upgrading-from-client-side-apply-to-server-side-apply)
before enabling `managedNamespaceMetadata` on an existing namespace.

## Upgraded Helm Version

Note that bundled Helm version has been upgraded from 3.13.2 to 3.14.3.

## Egress NetworkPolicy for `argocd-redis` and `argocd-redis-ha-haproxy`

Starting with Argo CD 2.10.11, the NetworkPolicy for the `argocd-redis` and `argocd-redis-ha-haproxy` dropped Egress restrictions. This change was made
to allow access to the Kubernetes API to create a secret to secure Redis access.

To retain similar networking restrictions as before 2.10.11, you can add an Egress rule to allow access only to the
Kubernetes API and access needed by Redis itself. The Egress rule for Kubernetes access will depend entirely on your
Kubernetes setup. The access for Redis itself can be allowed by adding the following to the
`argocd-redis-network-policy` NetworkPolicy:

```diff
kind: NetworkPolicy
apiVersion: networking.k8s.io/v1
metadata:
  name: argocd-redis-network-policy
spec:
  policyTypes:
  - Ingress
+  - Egress
+  egress:
+  - ports:
+    - port: 53
+      protocol: UDP
+    - port: 53
+      protocol: TCP
```

```diff
kind: NetworkPolicy
apiVersion: networking.k8s.io/v1
metadata:
  name: argocd-redis-ha-haproxy
spec:
  policyTypes:
  - Ingress
+  - Egress
+  egress:
+  - ports:
+    - port: 6379
+      protocol: TCP
+    - port: 26379
+      protocol: TCP
+    to:
+    - podSelector:
+        matchLabels:
+          app.kubernetes.io/name: argocd-redis-ha
+  - ports:
+    - port: 53
+      protocol: UDP
+    - port: 53
+      protocol: TCP
```