/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import jakarta.validation.Valid;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.bval.jsr.util.AnnotationProxyBuilder;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.reflection.Reflection;

class AnnotationProxy
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Annotation> annotationType;
    private final SortedMap<String, Object> values;

    <A extends Annotation> AnnotationProxy(AnnotationProxyBuilder<A> descriptor) {
        this.annotationType = descriptor.getType();
        this.values = new TreeMap<String, Object>();
        int processedValuesFromDescriptor = 0;
        for (Method m : descriptor.getMethods()) {
            if (descriptor.contains(m.getName())) {
                this.values.put(m.getName(), descriptor.getValue(m.getName()));
                ++processedValuesFromDescriptor;
                continue;
            }
            if (m.getDefaultValue() == null) {
                Exceptions.raise(IllegalArgumentException::new, "No value provided for %s", m.getName());
            }
            this.values.put(m.getName(), m.getDefaultValue());
        }
        Exceptions.raiseUnless(processedValuesFromDescriptor == descriptor.size() || Valid.class.equals(this.annotationType), IllegalArgumentException::new, "Trying to instantiate %s with unknown parameters.", f -> f.args(this.annotationType.getName()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value = this.values.get(method.getName());
        if (value != null) {
            return value;
        }
        if (method.getName().equals("equals")) {
            return this.equalTo(args[0]);
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        return this.values.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), StringUtils.valueOf(e.getValue()))).collect(Collectors.joining(", ", String.format("@%s(", this.annotationType().getName()), ")"));
    }

    @Override
    public int hashCode() {
        return this.values.entrySet().stream().mapToInt(e -> 127 * ((String)e.getKey()).hashCode() ^ ObjectUtils.hashCode(e.getValue())).sum();
    }

    private boolean equalTo(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Annotation) {
            Annotation other = (Annotation)obj;
            return other.annotationType().equals(this.annotationType) && this.values.entrySet().stream().allMatch(e -> this.memberEquals(other, (String)e.getKey(), e.getValue()));
        }
        return false;
    }

    private boolean memberEquals(Annotation other, String name, Object value) {
        Object otherValue;
        Method member = Reflection.getDeclaredMethod(this.annotationType, name, new Class[0]);
        try {
            otherValue = member.invoke((Object)other, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        Exceptions.raiseIf(otherValue == null || !otherValue.getClass().equals(value.getClass()), IllegalStateException::new, "Unexpected value %s for member %s of %s", otherValue, name, other);
        if (value instanceof Object[]) {
            return Arrays.equals((Object[])value, (Object[])otherValue);
        }
        if (value instanceof byte[]) {
            return Arrays.equals((byte[])value, (byte[])otherValue);
        }
        if (value instanceof short[]) {
            return Arrays.equals((short[])value, (short[])otherValue);
        }
        if (value instanceof int[]) {
            return Arrays.equals((int[])value, (int[])otherValue);
        }
        if (value instanceof char[]) {
            return Arrays.equals((char[])value, (char[])otherValue);
        }
        if (value instanceof long[]) {
            return Arrays.equals((long[])value, (long[])otherValue);
        }
        if (value instanceof float[]) {
            return Arrays.equals((float[])value, (float[])otherValue);
        }
        if (value instanceof double[]) {
            return Arrays.equals((double[])value, (double[])otherValue);
        }
        if (value instanceof boolean[]) {
            return Arrays.equals((boolean[])value, (boolean[])otherValue);
        }
        return value.equals(otherValue);
    }
}

