/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public final class Methods {
    public static boolean isGetter(Method m) {
        if (Modifier.isStatic(m.getModifiers()) || m.getParameterCount() > 0) {
            return false;
        }
        if (Boolean.TYPE.equals(m.getReturnType()) && m.getName().length() > 2 && m.getName().startsWith("is")) {
            return true;
        }
        return !Void.TYPE.equals(m.getReturnType()) && m.getName().length() > 3 && m.getName().startsWith("get");
    }

    public static boolean isGetter(String methodName) {
        Validate.notNull(methodName);
        int len = methodName.length();
        return len > 2 && methodName.startsWith("is") || len > 3 && methodName.startsWith("get");
    }

    public static String propertyName(Method getter) {
        Validate.isTrue(Methods.isGetter(getter), "%s is not a getter", getter);
        return Methods.propertyName(getter.getName());
    }

    public static String propertyName(String methodName) {
        Validate.isTrue(Methods.isGetter(methodName), "%s does not represent a property getter", methodName);
        String suffix = methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3);
        return Introspector.decapitalize(suffix);
    }

    public static Method getter(Class<?> clazz, String property) {
        return Reflection.find(clazz, t -> Stream.of(Reflection.getDeclaredMethods(t)).filter(Methods::isGetter).filter(m -> property.equals(Methods.propertyName(m))).findFirst().orElse(null));
    }

    private Methods() {
    }
}

