/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.NotP;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryIo;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.BigDecimalSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.BigIntegerSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.BindingSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.BulkSetSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ByteBufferSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ByteCodeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CharSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ClassSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.DateSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.DurationSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.EdgeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.EnumSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.GraphSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.InetAddressSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.InstantSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.LambdaSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ListSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.LocalDateSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.LocalDateTimeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.LocalTimeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.MapEntrySerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.MapSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.MetricsSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.MonthDaySerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.OffsetDateTimeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.OffsetTimeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.PSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.PathSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.PeriodSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.PropertySerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SetSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SingleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.StringSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TransformSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TraversalExplanationSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TraversalMetricsSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TraversalStrategySerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TraverserSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TreeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.UUIDSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.VertexPropertySerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.VertexSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.YearMonthSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ZoneOffsetSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.ZonedDateTimeSerializer;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.javatuples.Pair;

public class TypeSerializerRegistry {
    private static final RegistryEntry[] defaultEntries = new RegistryEntry[]{new RegistryEntry<Integer>(Integer.class, SingleTypeSerializer.IntSerializer), new RegistryEntry<Long>(Long.class, SingleTypeSerializer.LongSerializer), new RegistryEntry<String>(String.class, new StringSerializer()), new RegistryEntry<Date>(Date.class, DateSerializer.DateSerializer), new RegistryEntry<Timestamp>(Timestamp.class, DateSerializer.TimestampSerializer), new RegistryEntry<Class>(Class.class, new ClassSerializer()), new RegistryEntry<Double>(Double.class, SingleTypeSerializer.DoubleSerializer), new RegistryEntry<Float>(Float.class, SingleTypeSerializer.FloatSerializer), new RegistryEntry<List>(List.class, new ListSerializer()), new RegistryEntry<Map>(Map.class, new MapSerializer()), new RegistryEntry<Set>(Set.class, new SetSerializer()), new RegistryEntry<UUID>(UUID.class, new UUIDSerializer()), new RegistryEntry<Edge>(Edge.class, new EdgeSerializer()), new RegistryEntry<Path>(Path.class, new PathSerializer()), new RegistryEntry<VertexProperty>(VertexProperty.class, new VertexPropertySerializer()), new RegistryEntry<Property>(Property.class, new PropertySerializer()), new RegistryEntry<Graph>(Graph.class, new GraphSerializer()), new RegistryEntry<Vertex>(Vertex.class, new VertexSerializer()), new RegistryEntry<SackFunctions.Barrier>(SackFunctions.Barrier.class, EnumSerializer.BarrierSerializer), new RegistryEntry<Bytecode.Binding>(Bytecode.Binding.class, new BindingSerializer()), new RegistryEntry<Bytecode>(Bytecode.class, new ByteCodeSerializer()), new RegistryEntry<VertexProperty.Cardinality>(VertexProperty.Cardinality.class, EnumSerializer.CardinalitySerializer), new RegistryEntry<Column>(Column.class, EnumSerializer.ColumnSerializer), new RegistryEntry<Direction>(Direction.class, EnumSerializer.DirectionSerializer), new RegistryEntry<DT>(DT.class, EnumSerializer.DTSerializer), new RegistryEntry<GType>(GType.class, EnumSerializer.GTypeSerializer), new RegistryEntry<Merge>(Merge.class, EnumSerializer.MergeSerializer), new RegistryEntry<Operator>(Operator.class, EnumSerializer.OperatorSerializer), new RegistryEntry<Order>(Order.class, EnumSerializer.OrderSerializer), new RegistryEntry<Pick>(Pick.class, EnumSerializer.PickSerializer), new RegistryEntry<Pop>(Pop.class, EnumSerializer.PopSerializer), new RegistryEntry<Lambda>(Lambda.class, new LambdaSerializer()), new RegistryEntry<P>(P.class, new PSerializer<P>(DataType.P, P.class)), new RegistryEntry<AndP>(AndP.class, new PSerializer<AndP>(DataType.P, AndP.class)), new RegistryEntry<OrP>(OrP.class, new PSerializer<OrP>(DataType.P, OrP.class)), new RegistryEntry<NotP>(NotP.class, new PSerializer<NotP>(DataType.P, NotP.class)), new RegistryEntry<TextP>(TextP.class, new PSerializer<TextP>(DataType.TEXTP, TextP.class)), new RegistryEntry<Scope>(Scope.class, EnumSerializer.ScopeSerializer), new RegistryEntry<T>(T.class, EnumSerializer.TSerializer), new RegistryEntry<Traverser>(Traverser.class, new TraverserSerializer()), new RegistryEntry<Merge>(Merge.class, EnumSerializer.MergeSerializer), new RegistryEntry<BigDecimal>(BigDecimal.class, new BigDecimalSerializer()), new RegistryEntry<BigInteger>(BigInteger.class, new BigIntegerSerializer()), new RegistryEntry<Byte>(Byte.class, SingleTypeSerializer.ByteSerializer), new RegistryEntry<ByteBuffer>(ByteBuffer.class, new ByteBufferSerializer()), new RegistryEntry<Short>(Short.class, SingleTypeSerializer.ShortSerializer), new RegistryEntry<Boolean>(Boolean.class, SingleTypeSerializer.BooleanSerializer), new RegistryEntry<TraversalStrategy>(TraversalStrategy.class, new TraversalStrategySerializer()), new RegistryEntry<BulkSet>(BulkSet.class, new BulkSetSerializer()), new RegistryEntry<Tree>(Tree.class, new TreeSerializer()), new RegistryEntry<Metrics>(Metrics.class, new MetricsSerializer()), new RegistryEntry<TraversalMetrics>(TraversalMetrics.class, new TraversalMetricsSerializer()), new RegistryEntry<Map.Entry>(Map.Entry.class, new MapEntrySerializer()), new RegistryEntry<TraversalExplanation>(TraversalExplanation.class, new TraversalExplanationSerializer()), new RegistryEntry<Character>(Character.class, new CharSerializer()), new RegistryEntry<Duration>(Duration.class, new DurationSerializer()), new RegistryEntry<InetAddress>(InetAddress.class, new InetAddressSerializer()), new RegistryEntry<Inet4Address>(Inet4Address.class, new InetAddressSerializer()), new RegistryEntry<Inet6Address>(Inet6Address.class, new InetAddressSerializer()), new RegistryEntry<Instant>(Instant.class, new InstantSerializer()), new RegistryEntry<LocalDate>(LocalDate.class, new LocalDateSerializer()), new RegistryEntry<LocalTime>(LocalTime.class, new LocalTimeSerializer()), new RegistryEntry<LocalDateTime>(LocalDateTime.class, new LocalDateTimeSerializer()), new RegistryEntry<MonthDay>(MonthDay.class, new MonthDaySerializer()), new RegistryEntry<OffsetDateTime>(OffsetDateTime.class, new OffsetDateTimeSerializer()), new RegistryEntry<OffsetTime>(OffsetTime.class, new OffsetTimeSerializer()), new RegistryEntry<Period>(Period.class, new PeriodSerializer()), new RegistryEntry<Year>(Year.class, SingleTypeSerializer.YearSerializer), new RegistryEntry<YearMonth>(YearMonth.class, new YearMonthSerializer()), new RegistryEntry<ZonedDateTime>(ZonedDateTime.class, new ZonedDateTimeSerializer()), new RegistryEntry<ZoneOffset>(ZoneOffset.class, new ZoneOffsetSerializer())};
    public static final TypeSerializerRegistry INSTANCE = TypeSerializerRegistry.build().create();
    private final Map<Class<?>, TypeSerializer<?>> serializers = new HashMap();
    private final Map<Class<?>, TypeSerializer<?>> serializersByInterface = new LinkedHashMap();
    private final Map<DataType, TypeSerializer<?>> serializersByDataType = new HashMap();
    private final Map<String, CustomTypeSerializer> serializersByCustomTypeName = new HashMap<String, CustomTypeSerializer>();
    private Function<Class<?>, TypeSerializer<?>> fallbackResolver;
    private final ConcurrentHashMap<Class<?>, TypeSerializer<?>> serializersByImplementation = new ConcurrentHashMap();

    public static Builder build() {
        return new Builder();
    }

    private TypeSerializerRegistry(Collection<RegistryEntry> entries, Function<Class<?>, TypeSerializer<?>> fallbackResolver) {
        HashSet providedTypes = new HashSet(entries.size());
        for (RegistryEntry entry : entries) {
            this.put(entry);
            providedTypes.add(entry.type);
        }
        Arrays.stream(defaultEntries).filter(e -> !providedTypes.contains(e.type)).forEach(this::put);
        this.fallbackResolver = fallbackResolver;
    }

    private void put(RegistryEntry entry) {
        Class type = entry.getType();
        TypeSerializer serializer = entry.getTypeSerializer();
        if (type == null) {
            throw new NullPointerException("Type can not be null");
        }
        if (serializer == null) {
            throw new NullPointerException("Serializer instance can not be null");
        }
        if (serializer.getDataType() == null && !(serializer instanceof TransformSerializer)) {
            throw new NullPointerException("Serializer data type can not be null");
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            this.serializers.put(type, serializer);
        } else {
            this.serializersByInterface.put(type, serializer);
        }
        if (serializer.getDataType() == DataType.CUSTOM) {
            this.serializersByCustomTypeName.put(entry.getCustomTypeName(), (CustomTypeSerializer)serializer);
        } else if (serializer.getDataType() != null) {
            this.serializersByDataType.put(serializer.getDataType(), serializer);
        }
    }

    public <DT> TypeSerializer<DT> getSerializer(Class<DT> type) throws IOException {
        TypeSerializer<?> serializer = this.serializers.get(type);
        if (null == serializer) {
            serializer = this.serializersByImplementation.get(type);
        }
        if (serializer != null) {
            return serializer;
        }
        if (Enum.class.isAssignableFrom(type)) {
            serializer = this.serializers.get(type.getSuperclass());
        }
        if (null == serializer) {
            for (Map.Entry<Class<?>, TypeSerializer<?>> entry : this.serializersByInterface.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                serializer = entry.getValue();
                break;
            }
        }
        if (null == serializer && this.fallbackResolver != null) {
            serializer = this.fallbackResolver.apply(type);
        }
        TypeSerializerRegistry.validateInstance(serializer, type.getTypeName());
        this.serializersByImplementation.put(type, serializer);
        return serializer;
    }

    public <DT> TypeSerializer<DT> getSerializer(DataType dataType) throws IOException {
        if (dataType == DataType.CUSTOM) {
            throw new IllegalArgumentException("Custom type serializers can not be retrieved using this method");
        }
        return TypeSerializerRegistry.validateInstance(this.serializersByDataType.get((Object)dataType), dataType.toString());
    }

    public <DT> CustomTypeSerializer<DT> getSerializerForCustomType(String name) throws IOException {
        CustomTypeSerializer serializer = this.serializersByCustomTypeName.get(name);
        if (serializer == null) {
            throw new IOException(String.format("Serializer for custom type '%s' not found", name));
        }
        return serializer;
    }

    private static TypeSerializer validateInstance(TypeSerializer serializer, String typeName) throws IOException {
        if (serializer == null) {
            throw new IOException(String.format("Serializer for type %s not found", typeName));
        }
        return serializer;
    }

    private static class RegistryEntry<DT> {
        private final Class<DT> type;
        private final TypeSerializer<DT> typeSerializer;

        private RegistryEntry(Class<DT> type, TypeSerializer<DT> typeSerializer) {
            this.type = type;
            this.typeSerializer = typeSerializer;
        }

        public Class<DT> getType() {
            return this.type;
        }

        public DataType getDataType() {
            return this.typeSerializer.getDataType();
        }

        public String getCustomTypeName() {
            if (this.getDataType() != DataType.CUSTOM) {
                return null;
            }
            CustomTypeSerializer customTypeSerializer = (CustomTypeSerializer)this.typeSerializer;
            return customTypeSerializer.getTypeName();
        }

        public TypeSerializer<DT> getTypeSerializer() {
            return this.typeSerializer;
        }
    }

    public static class Builder {
        private final List<RegistryEntry> list = new LinkedList<RegistryEntry>();
        private Function<Class<?>, TypeSerializer<?>> fallbackResolver;

        public <DT> Builder add(Class<DT> type, TypeSerializer<DT> serializer) {
            if (serializer.getDataType() == DataType.CUSTOM) {
                throw new IllegalArgumentException("DataType can not be CUSTOM, use addCustomType() method instead");
            }
            if (serializer.getDataType() == DataType.UNSPECIFIED_NULL) {
                throw new IllegalArgumentException("Adding a serializer for a UNSPECIFIED_NULL is not permitted");
            }
            if (serializer instanceof CustomTypeSerializer) {
                throw new IllegalArgumentException("CustomTypeSerializer implementations are reserved for customtypes");
            }
            this.list.add(new RegistryEntry<DT>(type, serializer));
            return this;
        }

        public <DT> Builder addCustomType(Class<DT> type, CustomTypeSerializer<DT> serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer can not be null");
            }
            if (serializer.getDataType() != DataType.CUSTOM) {
                throw new IllegalArgumentException("Custom serializer must use CUSTOM data type");
            }
            if (serializer.getTypeName() == null) {
                throw new NullPointerException("serializer custom type name can not be null");
            }
            this.list.add(new RegistryEntry<DT>(type, serializer));
            return this;
        }

        public Builder withFallbackResolver(Function<Class<?>, TypeSerializer<?>> fallbackResolver) {
            this.fallbackResolver = fallbackResolver;
            return this;
        }

        public Builder addRegistry(IoRegistry registry) {
            if (null == registry) {
                throw new IllegalArgumentException("The registry cannot be null");
            }
            List<Pair<Class, CustomTypeSerializer>> classSerializers = registry.find(GraphBinaryIo.class, CustomTypeSerializer.class);
            for (Pair<Class, CustomTypeSerializer> cs : classSerializers) {
                this.addCustomType((Class)cs.getValue0(), (CustomTypeSerializer)cs.getValue1());
            }
            return this;
        }

        public TypeSerializerRegistry create() {
            return new TypeSerializerRegistry(this.list, this.fallbackResolver);
        }
    }
}

