/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.GType;

public final class NumberHelper {
    static final NumberHelper BYTE_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.asByte(a.byteValue() + b.byteValue()), (a, b) -> NumberHelper.asByte(a.byteValue() - b.byteValue()), (a, b) -> NumberHelper.asByte(a.byteValue() * b.byteValue()), (a, b) -> {
        if (a.byteValue() == -128 && b.byteValue() == -1) {
            throw new ArithmeticException("byte overflow");
        }
        return (byte)(a.byteValue() / b.byteValue());
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                byte y;
                byte x = a.byteValue();
                return x <= (y = b.byteValue()) ? x : y;
            }
            return a.byteValue();
        }
        return b.byteValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                byte y;
                byte x = a.byteValue();
                return x >= (y = b.byteValue()) ? x : y;
            }
            return a.byteValue();
        }
        return b.byteValue();
    }, (a, b) -> Byte.compare(a.byteValue(), b.byteValue()));
    static final NumberHelper SHORT_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.asShort(a.shortValue() + b.shortValue()), (a, b) -> NumberHelper.asShort(a.shortValue() - b.shortValue()), (a, b) -> NumberHelper.asShort(a.shortValue() * b.shortValue()), (a, b) -> {
        if (a.shortValue() == Short.MIN_VALUE && b.shortValue() == -1) {
            throw new ArithmeticException("short overflow");
        }
        return (short)(a.shortValue() / b.shortValue());
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                short y;
                short x = a.shortValue();
                return x <= (y = b.shortValue()) ? x : y;
            }
            return a.shortValue();
        }
        return b.shortValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                short y;
                short x = a.shortValue();
                return x >= (y = b.shortValue()) ? x : y;
            }
            return a.shortValue();
        }
        return b.shortValue();
    }, (a, b) -> Short.compare(a.shortValue(), b.shortValue()));
    static final NumberHelper INTEGER_NUMBER_HELPER = new NumberHelper((a, b) -> Math.addExact(a.intValue(), b.intValue()), (a, b) -> Math.subtractExact(a.intValue(), b.intValue()), (a, b) -> Math.multiplyExact(a.intValue(), b.intValue()), (a, b) -> {
        if (a.intValue() == Integer.MIN_VALUE && b.intValue() == -1) {
            throw new ArithmeticException("integer overflow");
        }
        return a.intValue() / b.intValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                int y;
                int x = a.intValue();
                return x <= (y = b.intValue()) ? x : y;
            }
            return a.intValue();
        }
        return b.intValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                int y;
                int x = a.intValue();
                return x >= (y = b.intValue()) ? x : y;
            }
            return a.intValue();
        }
        return b.intValue();
    }, (a, b) -> Integer.compare(a.intValue(), b.intValue()));
    static final NumberHelper LONG_NUMBER_HELPER = new NumberHelper((a, b) -> Math.addExact(a.longValue(), b.longValue()), (a, b) -> Math.subtractExact(a.longValue(), b.longValue()), (a, b) -> Math.multiplyExact(a.longValue(), b.longValue()), (a, b) -> {
        if (a.longValue() == Long.MIN_VALUE && b.longValue() == -1L) {
            throw new ArithmeticException("long overflow");
        }
        return a.longValue() / b.longValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                long y;
                long x = a.longValue();
                return x <= (y = b.longValue()) ? x : y;
            }
            return a.longValue();
        }
        return b.longValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                long y;
                long x = a.longValue();
                return x >= (y = b.longValue()) ? x : y;
            }
            return a.longValue();
        }
        return b.longValue();
    }, (a, b) -> Long.compare(a.longValue(), b.longValue()));
    static final NumberHelper BIG_INTEGER_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.bigIntegerValue(a).add(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).subtract(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).multiply(NumberHelper.bigIntegerValue(b)), (a, b) -> NumberHelper.bigIntegerValue(a).divide(NumberHelper.bigIntegerValue(b)), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigInteger y;
                BigInteger x = NumberHelper.bigIntegerValue(a);
                return x.compareTo(y = NumberHelper.bigIntegerValue(b)) <= 0 ? x : y;
            }
            return NumberHelper.bigIntegerValue(a);
        }
        return NumberHelper.bigIntegerValue(b);
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigInteger y;
                BigInteger x = NumberHelper.bigIntegerValue(a);
                return x.compareTo(y = NumberHelper.bigIntegerValue(b)) >= 0 ? x : y;
            }
            return NumberHelper.bigIntegerValue(a);
        }
        return NumberHelper.bigIntegerValue(b);
    }, (a, b) -> NumberHelper.bigIntegerValue(a).compareTo(NumberHelper.bigIntegerValue(b)));
    static final NumberHelper FLOAT_NUMBER_HELPER = new NumberHelper((a, b) -> Float.valueOf(a.floatValue() + b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() - b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue()), (a, b) -> Float.valueOf(a.floatValue() / b.floatValue()), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                float y;
                float x = a.floatValue();
                return Float.valueOf(x <= (y = b.floatValue()) ? x : y);
            }
            return Float.valueOf(a.floatValue());
        }
        return Float.valueOf(b.floatValue());
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                float y;
                float x = a.floatValue();
                return Float.valueOf(x >= (y = b.floatValue()) ? x : y);
            }
            return Float.valueOf(a.floatValue());
        }
        return Float.valueOf(b.floatValue());
    }, (a, b) -> Float.compare(a.floatValue(), b.floatValue()));
    static final NumberHelper DOUBLE_NUMBER_HELPER = new NumberHelper((a, b) -> a.doubleValue() + b.doubleValue(), (a, b) -> a.doubleValue() - b.doubleValue(), (a, b) -> a.doubleValue() * b.doubleValue(), (a, b) -> a.doubleValue() / b.doubleValue(), (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                double y;
                double x = a.doubleValue();
                return x <= (y = b.doubleValue()) ? x : y;
            }
            return a.doubleValue();
        }
        return b.doubleValue();
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                double y;
                double x = a.doubleValue();
                return x >= (y = b.doubleValue()) ? x : y;
            }
            return a.doubleValue();
        }
        return b.doubleValue();
    }, (a, b) -> Double.compare(a.doubleValue(), b.doubleValue()));
    static final NumberHelper BIG_DECIMAL_NUMBER_HELPER = new NumberHelper((a, b) -> NumberHelper.bigDecimalValue(a).add(NumberHelper.bigDecimalValue(b)), (a, b) -> NumberHelper.bigDecimalValue(a).subtract(NumberHelper.bigDecimalValue(b)), (a, b) -> NumberHelper.bigDecimalValue(a).multiply(NumberHelper.bigDecimalValue(b)), (a, b) -> {
        BigDecimal ba = NumberHelper.bigDecimalValue(a);
        BigDecimal bb = NumberHelper.bigDecimalValue(b);
        try {
            return ba.divide(bb);
        }
        catch (ArithmeticException ignored) {
            int precision = Math.max(ba.precision(), bb.precision()) + 10;
            BigDecimal result = ba.divide(bb, new MathContext(precision));
            int scale = Math.max(Math.max(ba.scale(), bb.scale()), 10);
            if (result.scale() > scale) {
                result = result.setScale(scale, 4);
            }
            return result;
        }
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigDecimal y;
                BigDecimal x = NumberHelper.bigDecimalValue(a);
                return x.compareTo(y = NumberHelper.bigDecimalValue(b)) <= 0 ? x : y;
            }
            return NumberHelper.bigDecimalValue(a);
        }
        return NumberHelper.bigDecimalValue(b);
    }, (a, b) -> {
        if (NumberHelper.isNumber(a)) {
            if (NumberHelper.isNumber(b)) {
                BigDecimal y;
                BigDecimal x = NumberHelper.bigDecimalValue(a);
                return x.compareTo(y = NumberHelper.bigDecimalValue(b)) >= 0 ? x : y;
            }
            return NumberHelper.bigDecimalValue(a);
        }
        return NumberHelper.bigDecimalValue(b);
    }, (a, b) -> {
        if (a instanceof Float && ((Float)a).floatValue() == Float.POSITIVE_INFINITY) {
            return 1;
        }
        if (a instanceof Float && ((Float)a).floatValue() == Float.NEGATIVE_INFINITY) {
            return -1;
        }
        if (b instanceof Float && ((Float)b).floatValue() == Float.POSITIVE_INFINITY) {
            return -1;
        }
        if (b instanceof Float && ((Float)b).floatValue() == Float.NEGATIVE_INFINITY) {
            return 1;
        }
        if (a instanceof Double && (Double)a == Double.POSITIVE_INFINITY) {
            return 1;
        }
        if (a instanceof Double && (Double)a == Double.NEGATIVE_INFINITY) {
            return -1;
        }
        if (b instanceof Double && (Double)b == Double.POSITIVE_INFINITY) {
            return -1;
        }
        if (b instanceof Double && (Double)b == Double.NEGATIVE_INFINITY) {
            return 1;
        }
        return NumberHelper.bigDecimalValue(a).compareTo(NumberHelper.bigDecimalValue(b));
    });
    public final BiFunction<Number, Number, Number> add;
    public final BiFunction<Number, Number, Number> sub;
    public final BiFunction<Number, Number, Number> mul;
    public final BiFunction<Number, Number, Number> div;
    public final BiFunction<Number, Number, Number> min;
    public final BiFunction<Number, Number, Number> max;
    public final BiFunction<Number, Number, Integer> cmp;

    private static byte asByte(int arg) {
        if (arg > 127 || arg < -128) {
            throw new ArithmeticException("byte overflow");
        }
        return (byte)arg;
    }

    private static short asShort(int arg) {
        if (arg > Short.MAX_VALUE || arg < Short.MIN_VALUE) {
            throw new ArithmeticException("short overflow");
        }
        return (short)arg;
    }

    private NumberHelper(BiFunction<Number, Number, Number> add, BiFunction<Number, Number, Number> sub, BiFunction<Number, Number, Number> mul, BiFunction<Number, Number, Number> div, BiFunction<Number, Number, Number> min, BiFunction<Number, Number, Number> max, BiFunction<Number, Number, Integer> cmp) {
        this.add = add;
        this.sub = sub;
        this.mul = mul;
        this.div = div;
        this.min = min;
        this.max = max;
        this.cmp = cmp;
    }

    static NumberInfo getHighestCommonNumberInfo(boolean forceFloatingPoint, Number ... numbers) {
        int bits = 8;
        boolean fp = forceFloatingPoint;
        for (Number number : numbers) {
            Class<?> clazz;
            if (!NumberHelper.isNumber(number) || (clazz = number.getClass()).equals(Byte.class)) continue;
            if (clazz.equals(Short.class)) {
                bits = Math.max(bits, 16);
                continue;
            }
            if (clazz.equals(Integer.class)) {
                bits = Math.max(bits, 32);
                continue;
            }
            if (clazz.equals(Long.class)) {
                bits = Math.max(bits, 64);
                continue;
            }
            if (clazz.equals(BigInteger.class)) {
                bits = 128;
                continue;
            }
            if (clazz.equals(Float.class)) {
                bits = Math.max(bits, 32);
                fp = true;
                continue;
            }
            if (clazz.equals(Double.class)) {
                bits = Math.max(bits, 64);
                fp = true;
                continue;
            }
            bits = 128;
            fp = true;
            break;
        }
        return new NumberInfo(bits, fp);
    }

    public static Class<? extends Number> getHighestCommonNumberClass(Number ... numbers) {
        return NumberHelper.getHighestCommonNumberClass(false, numbers);
    }

    public static Class<? extends Number> getHighestCommonNumberClass(boolean forceFloatingPoint, Number ... numbers) {
        NumberInfo numberInfo = NumberHelper.getHighestCommonNumberInfo(forceFloatingPoint, numbers);
        return NumberHelper.determineNumberClass(numberInfo.getBits(), numberInfo.getFp());
    }

    private static Number mathOperationWithPromote(Function<NumberHelper, BiFunction<Number, Number, Number>> mathFunction, boolean forceFloatingPoint, Number a, Number b) {
        if (null == a || null == b) {
            return a;
        }
        NumberInfo numberInfo = NumberHelper.getHighestCommonNumberInfo(forceFloatingPoint, a, b);
        Number result = 0;
        while (true) {
            try {
                Class<? extends Number> clazz = NumberHelper.determineNumberClass(numberInfo.getBits(), numberInfo.getFp());
                NumberHelper helper = NumberHelper.getHelper(clazz);
                result = mathFunction.apply(helper).apply(a, b);
                if (result instanceof BigInteger || result instanceof BigDecimal) {
                    return result;
                }
                if (Double.isInfinite(result.doubleValue())) {
                    throw new ArithmeticException("Floating point overflow detected");
                }
                return result;
            }
            catch (ArithmeticException exception) {
                if (!numberInfo.getFp() && numberInfo.getBits() >= 64) {
                    throw exception;
                }
                if (numberInfo.getFp() && numberInfo.getBits() >= 64) {
                    return result;
                }
                numberInfo.promoteBits();
                continue;
            }
            break;
        }
    }

    public static Number add(Number a, Number b) {
        return NumberHelper.mathOperationWithPromote(numberHelper -> numberHelper.add, false, a, b);
    }

    public static Number sub(Number a, Number b) {
        return NumberHelper.mathOperationWithPromote(numberHelper -> numberHelper.sub, false, a, b);
    }

    public static Number mul(Number a, Number b) {
        return NumberHelper.mathOperationWithPromote(numberHelper -> numberHelper.mul, false, a, b);
    }

    public static Number div(Number a, Number b) {
        return NumberHelper.mathOperationWithPromote(numberHelper -> numberHelper.div, false, a, b);
    }

    public static Number div(Number a, Number b, boolean forceFloatingPoint) {
        return NumberHelper.mathOperationWithPromote(numberHelper -> numberHelper.div, forceFloatingPoint, a, b);
    }

    public static Number min(Number a, Number b) {
        if (a == null || b == null) {
            return a == null ? (Number)b : (Number)a;
        }
        if (NumberHelper.eitherAreNaN(a, b)) {
            return NumberHelper.isNaN(a) ? (Number)b : (Number)a;
        }
        Class<? extends Number> clazz = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz).min.apply(a, b);
    }

    public static Comparable min(Comparable a, Comparable b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (NumberHelper.eitherAreNaN(a, b)) {
            return NumberHelper.isNaN(a) ? b : a;
        }
        if (a instanceof Number && b instanceof Number) {
            Number an = (Number)((Object)a);
            Number bn = (Number)((Object)b);
            Class<? extends Number> clazz = NumberHelper.getHighestCommonNumberClass(an, bn);
            return (Comparable)((Object)NumberHelper.getHelper(clazz).min.apply(an, bn));
        }
        return a.compareTo(b) < 0 ? a : b;
    }

    public static Number max(Number a, Number b) {
        if (a == null || b == null) {
            return a == null ? (Number)b : (Number)a;
        }
        if (NumberHelper.eitherAreNaN(a, b)) {
            return NumberHelper.isNaN(a) ? (Number)b : (Number)a;
        }
        Class<? extends Number> clazz = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz).max.apply(a, b);
    }

    public static Comparable max(Comparable a, Comparable b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (NumberHelper.eitherAreNaN(a, b)) {
            return NumberHelper.isNaN(a) ? b : a;
        }
        if (a instanceof Number && b instanceof Number) {
            Number an = (Number)((Object)a);
            Number bn = (Number)((Object)b);
            Class<? extends Number> clazz = NumberHelper.getHighestCommonNumberClass(an, bn);
            return (Comparable)((Object)NumberHelper.getHelper(clazz).max.apply(an, bn));
        }
        return a.compareTo(b) > 0 ? a : b;
    }

    public static Integer compare(Number a, Number b) {
        if (a == null || b == null) {
            return a == b ? 0 : (a == null ? -1 : 1);
        }
        if (NumberHelper.eitherAreNaN(a, b)) {
            return NumberHelper.bothAreNaN(a, b) ? 0 : (NumberHelper.isNaN(a) ? 1 : -1);
        }
        Class<? extends Number> clazz = NumberHelper.getHighestCommonNumberClass(a, b);
        return NumberHelper.getHelper(clazz).cmp.apply(a, b);
    }

    public static Number coerceTo(Number a, Class<? extends Number> clazz) {
        try {
            return NumberHelper.performConversion(a, clazz);
        }
        catch (ArithmeticException e) {
            return a;
        }
    }

    public static Number castTo(Number a, GType typeToken) {
        Class<?> clazz = typeToken.getType();
        return NumberHelper.performConversion(a, clazz);
    }

    public static Number castTo(Number a, Class<? extends Number> clazz) {
        return NumberHelper.performConversion(a, clazz);
    }

    private static Number performConversion(Number a, Class<? extends Number> clazz) {
        if (a.getClass().equals(clazz)) {
            return a;
        }
        if (clazz.equals(Integer.class)) {
            Long val = NumberHelper.longValue(a, clazz);
            if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                return a.intValue();
            }
        } else {
            if (clazz.equals(Long.class)) {
                return NumberHelper.longValue(a, clazz);
            }
            if (clazz.equals(Float.class)) {
                if (NumberHelper.isInfinityOrNaN(a)) {
                    return Float.valueOf(a.floatValue());
                }
                if (a.doubleValue() >= -3.4028234663852886E38 && a.doubleValue() <= 3.4028234663852886E38) {
                    return Float.valueOf(a.floatValue());
                }
            } else if (clazz.equals(Double.class)) {
                if (NumberHelper.isInfinityOrNaN(a)) {
                    return a.doubleValue();
                }
                if (!Double.isInfinite(a.doubleValue())) {
                    return a.getClass().equals(Float.class) ? Double.parseDouble(a.toString()) : a.doubleValue();
                }
            } else if (clazz.equals(Byte.class)) {
                Long val = NumberHelper.longValue(a, clazz);
                if (val >= -128L && val <= 127L) {
                    return a.byteValue();
                }
            } else if (clazz.equals(Short.class)) {
                Long val = NumberHelper.longValue(a, clazz);
                if (val >= -32768L && val <= 32767L) {
                    return a.shortValue();
                }
            } else {
                if (clazz.equals(BigInteger.class)) {
                    return NumberHelper.bigIntegerValue(a);
                }
                if (clazz.equals(BigDecimal.class)) {
                    return NumberHelper.bigDecimalValue(a);
                }
                throw new IllegalArgumentException("Unsupported numeric type: " + clazz);
            }
        }
        throw new ArithmeticException(String.format("Can't convert number of type %s to %s due to overflow.", a.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    private static Long longValue(Number num, Class<? extends Number> targetClass) {
        if (Double.isNaN(num.doubleValue())) {
            throw new ArithmeticException(String.format("Can't convert NaN to %s.", targetClass.getSimpleName()));
        }
        if (Double.isInfinite(num.doubleValue())) {
            throw new ArithmeticException(String.format("Can't convert floating point infinity to %s.", targetClass.getSimpleName()));
        }
        String msgOverflow = String.format("Can't convert number of type %s to %s due to overflow.", num.getClass().getSimpleName(), targetClass.getSimpleName());
        if (num.getClass().equals(Double.class) || num.getClass().equals(Float.class)) {
            double value = num.doubleValue();
            if (value > 9.223372036854776E18) {
                throw new ArithmeticException(msgOverflow);
            }
            if (value < -9.223372036854776E18) {
                throw new ArithmeticException(String.format("Can't convert number of type %s to %s due to underflow.", num.getClass().getSimpleName(), targetClass.getSimpleName()));
            }
        }
        try {
            if (num.getClass().equals(BigDecimal.class)) {
                BigDecimal truncated = ((BigDecimal)num).setScale(0, RoundingMode.DOWN);
                return truncated.longValueExact();
            }
            return num.getClass().equals(BigInteger.class) ? ((BigInteger)num).longValueExact() : num.longValue();
        }
        catch (ArithmeticException ae) {
            throw new ArithmeticException(msgOverflow);
        }
    }

    private static boolean isInfinityOrNaN(Number num) {
        return !num.getClass().equals(BigDecimal.class) && !num.getClass().equals(BigInteger.class) && (Double.isInfinite(num.doubleValue()) || Double.isNaN(num.doubleValue()));
    }

    private static NumberHelper getHelper(Class<? extends Number> clazz) {
        if (clazz.equals(Byte.class)) {
            return BYTE_NUMBER_HELPER;
        }
        if (clazz.equals(Short.class)) {
            return SHORT_NUMBER_HELPER;
        }
        if (clazz.equals(Integer.class)) {
            return INTEGER_NUMBER_HELPER;
        }
        if (clazz.equals(Long.class)) {
            return LONG_NUMBER_HELPER;
        }
        if (clazz.equals(BigInteger.class)) {
            return BIG_INTEGER_NUMBER_HELPER;
        }
        if (clazz.equals(Float.class)) {
            return FLOAT_NUMBER_HELPER;
        }
        if (clazz.equals(Double.class)) {
            return DOUBLE_NUMBER_HELPER;
        }
        if (clazz.equals(BigDecimal.class)) {
            return BIG_DECIMAL_NUMBER_HELPER;
        }
        throw new IllegalArgumentException("Unsupported numeric type: " + clazz);
    }

    private static BigInteger bigIntegerValue(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue()).toBigInteger();
        }
        return BigInteger.valueOf(number.longValue());
    }

    private static BigDecimal bigDecimalValue(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Float) {
            return new BigDecimal(number.toString());
        }
        return number instanceof Double ? BigDecimal.valueOf(number.doubleValue()) : BigDecimal.valueOf(number.longValue());
    }

    private static Class<? extends Number> determineNumberClass(int bits, boolean floatingPoint) {
        if (floatingPoint) {
            if (bits <= 32) {
                return Float.class;
            }
            if (bits <= 64) {
                return Double.class;
            }
            return BigDecimal.class;
        }
        if (bits <= 8) {
            return Byte.class;
        }
        if (bits <= 16) {
            return Short.class;
        }
        if (bits <= 32) {
            return Integer.class;
        }
        if (bits <= 64) {
            return Long.class;
        }
        return BigInteger.class;
    }

    private static boolean isNumber(Number number) {
        return number != null && !NumberHelper.isNaN(number);
    }

    public static boolean isNaN(Object object) {
        return object instanceof Float && Float.isNaN(((Float)object).floatValue()) || object instanceof Double && Double.isNaN((Double)object);
    }

    public static boolean eitherAreNaN(Object first, Object second) {
        return NumberHelper.isNaN(first) || NumberHelper.isNaN(second);
    }

    public static boolean bothAreNaN(Object first, Object second) {
        return NumberHelper.isNaN(first) && NumberHelper.isNaN(second);
    }

    public static boolean isPositiveInfinity(Object value) {
        return value instanceof Float && Float.POSITIVE_INFINITY == ((Float)value).floatValue() || value instanceof Double && Double.POSITIVE_INFINITY == (Double)value;
    }

    public static boolean isNegativeInfinity(Object value) {
        return value instanceof Float && Float.NEGATIVE_INFINITY == ((Float)value).floatValue() || value instanceof Double && Double.NEGATIVE_INFINITY == (Double)value;
    }

    static final class NumberInfo {
        private int bits;
        private final boolean fp;

        public int getBits() {
            return this.bits;
        }

        public boolean getFp() {
            return this.fp;
        }

        public void promoteBits() {
            this.bits <<= 1;
        }

        NumberInfo(int bits, boolean fp) {
            this.bits = bits;
            this.fp = fp;
        }
    }
}

