/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.lambda;

import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.AbstractLambdaTraversal;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class CardinalityValueTraversal
extends AbstractLambdaTraversal {
    private final VertexProperty.Cardinality cardinality;
    private final Object value;
    private final Bytecode bytecode;

    public CardinalityValueTraversal(VertexProperty.Cardinality cardinality, Object value) {
        this.cardinality = cardinality;
        this.value = value;
        this.bytecode = new Bytecode(CardinalityValueTraversal.class.getSimpleName(), cardinality.name(), value);
    }

    public static CardinalityValueTraversal from(Bytecode.Instruction inst) {
        return new CardinalityValueTraversal(VertexProperty.Cardinality.valueOf(inst.getArguments()[0].toString()), inst.getArguments()[1]);
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public VertexProperty.Cardinality getCardinality() {
        return this.cardinality;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "[" + this.cardinality + ", " + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CardinalityValueTraversal)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CardinalityValueTraversal that = (CardinalityValueTraversal)o;
        if (this.cardinality != that.cardinality) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cardinality.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

