/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;

public abstract class ConnectiveP<V>
extends P<V> {
    protected List<P<V>> predicates = new ArrayList<P<V>>();

    public ConnectiveP(List<P<V>> predicates) {
        super(null, null);
        if (predicates.size() < 2) {
            throw new IllegalArgumentException("The provided " + this.getClass().getSimpleName() + " array must have at least two arguments: " + predicates.size());
        }
    }

    public List<P<V>> getPredicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    @Override
    public P<V> negate() {
        ArrayList<P<V>> negated = new ArrayList<P<V>>();
        for (P<V> predicate : this.predicates) {
            negated.add((P<V>)predicate.negate());
        }
        this.predicates = negated;
        return this;
    }

    protected P<V> negate(ConnectiveP<V> p) {
        ArrayList<P<V>> negated = new ArrayList<P<V>>();
        for (P<V> predicate : this.predicates) {
            negated.add((P<V>)predicate.negate());
        }
        p.predicates = negated;
        return p;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int i = 0;
        for (P<V> p : this.predicates) {
            result ^= Integer.rotateLeft(p.hashCode(), i++);
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            List<P<V>> otherPredicates = ((ConnectiveP)other).predicates;
            if (this.predicates.size() == otherPredicates.size()) {
                for (int i = 0; i < this.predicates.size(); ++i) {
                    if (this.predicates.get(i).equals(otherPredicates.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ConnectiveP<V> clone() {
        ConnectiveP clone = (ConnectiveP)super.clone();
        clone.predicates = new ArrayList<P<V>>();
        for (P<V> p : this.predicates) {
            clone.predicates.add((P<V>)p.clone());
        }
        return clone;
    }

    @Override
    public P<V> and(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be and'd together");
        }
        return new AndP(Arrays.asList(this, (P)predicate));
    }

    @Override
    public P<V> or(Predicate<? super V> predicate) {
        if (!(predicate instanceof P)) {
            throw new IllegalArgumentException("Only P predicates can be or'd together");
        }
        return new OrP(Arrays.asList(this, (P)predicate));
    }
}

