/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import jdk.javadoc.doclet.DocletEnvironment;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Events;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.javadoc.ClassDescriptionSource;
import org.apache.tapestry5.javadoc.ParameterDescription;

public class ClassDescription {
    public final DocletEnvironment env;
    public final TypeElement classDoc;
    public final Map<String, ParameterDescription> parameters = CollectionFactory.newCaseInsensitiveMap();
    public final Map<String, String> events = CollectionFactory.newCaseInsensitiveMap();

    public ClassDescription(DocletEnvironment env) {
        this.env = env;
        this.classDoc = null;
    }

    public ClassDescription(TypeElement classDoc, ClassDescriptionSource source, DocletEnvironment env) {
        this.classDoc = classDoc;
        this.env = env;
        this.loadEvents();
        this.loadParameters(source);
        TypeMirror parentDoc = classDoc.getSuperclass();
        if (parentDoc != null && !StringUtils.equals((String)Object.class.getName(), (String)classDoc.toString())) {
            String className = parentDoc.accept(new SimpleTypeVisitor9<String, Object>(){

                @Override
                public String visitDeclared(DeclaredType t, Object o) {
                    return t.asElement().asType().toString();
                }
            }, null);
            ClassDescription parentDescription = source.getDescription(className);
            ClassDescription.mergeInto(this.events, parentDescription.events);
            ClassDescription.mergeInto(this.parameters, parentDescription.parameters);
        }
    }

    private void loadEvents() {
        AnnotationMirror eventsAnnotation = ClassDescription.getAnnotation(this.classDoc, Events.class);
        if (eventsAnnotation == null) {
            return;
        }
        AnnotationValue annotationValue = eventsAnnotation.getElementValues().values().iterator().next();
        annotationValue.accept(new SimpleAnnotationValueVisitor9<Void, Void>(){

            @Override
            public Void visitArray(List<? extends AnnotationValue> values, Void aVoid) {
                for (AnnotationValue annotationValue : values) {
                    String event = (String)annotationValue.getValue();
                    int ws = event.indexOf(32);
                    String name = ws < 0 ? event : event.substring(0, ws);
                    String description = ws < 0 ? "" : event.substring(ws + 1).trim();
                    ClassDescription.this.events.put(name, description);
                }
                return null;
            }
        }, null);
    }

    private static <K, V> void mergeInto(Map<K, V> target, Map<K, V> source) {
        for (K key : source.keySet()) {
            if (target.containsKey(key)) continue;
            V value = source.get(key);
            target.put(key, value);
        }
    }

    private void loadParameters(ClassDescriptionSource source) {
        for (VariableElement fd : ElementFilter.fieldsIn(this.classDoc.getEnclosedElements())) {
            String names;
            if (fd.getModifiers().contains((Object)Modifier.STATIC) || !fd.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            Map<String, String> values = ClassDescription.getAnnotationValues(fd, Parameter.class);
            if (values != null) {
                String name = values.get("name");
                if (name == null) {
                    name = fd.getSimpleName().toString().replaceAll("^[$_]*", "");
                }
                ParameterDescription pd = new ParameterDescription(fd, name, fd.asType().toString(), ClassDescription.get(values, "value", ""), ClassDescription.get(values, "defaultPrefix", "prop"), ClassDescription.getBoolean(values, "required", false), ClassDescription.getBoolean(values, "allowNull", true), ClassDescription.getBoolean(values, "cache", true), this.getSinceTagValue(fd), this.env.getElementUtils().isDeprecated(fd), e -> this.env.getDocTrees().getDocCommentTree(e));
                this.parameters.put(name, pd);
                continue;
            }
            values = ClassDescription.getAnnotationValues(fd, Component.class);
            if (values == null || InternalUtils.isBlank((String)(names = ClassDescription.get(values, "publishParameters", "")))) continue;
            for (String name : names.split("\\s*,\\s*")) {
                ParameterDescription pd = this.getPublishedParameterDescription(source, fd, name);
                this.parameters.put(name, pd);
            }
        }
    }

    private ParameterDescription getPublishedParameterDescription(ClassDescriptionSource source, VariableElement fd, String name) {
        String currentClassName = fd.asType().toString();
        while (true) {
            ClassDescription componentCD = source.getDescription(currentClassName);
            if (componentCD.classDoc == null) {
                throw new IllegalArgumentException(String.format("Published parameter '%s' from %s not found.", name, fd.getSimpleName()));
            }
            if (componentCD.parameters.containsKey(name)) {
                return componentCD.parameters.get(name);
            }
            currentClassName = componentCD.classDoc.getSuperclass().toString();
        }
    }

    private String getSinceTagValue(Element doc) {
        DocCommentTree tree = this.env.getDocTrees().getDocCommentTree(doc);
        if (tree == null) {
            return "";
        }
        Iterator<? extends DocTree> iterator = tree.getBlockTags().iterator();
        if (iterator.hasNext()) {
            DocTree tag = iterator.next();
            return tag.accept(new SimpleDocTreeVisitor<String, Void>(""){

                @Override
                public String visitSince(SinceTree node, Void aVoid) {
                    return node.getBody().toString();
                }
            }, null);
        }
        return "";
    }

    private static boolean getBoolean(Map<String, String> map, String key, boolean defaultValue) {
        if (map.containsKey(key)) {
            return Boolean.parseBoolean(map.get(key));
        }
        return defaultValue;
    }

    private static String get(Map<String, String> map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    private static AnnotationMirror getAnnotation(Element source, Class annotationType) {
        String name = annotationType.getName();
        for (AnnotationMirror annotationMirror : source.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Map<String, String> getAnnotationValues(Element source, Class annotationType) {
        AnnotationMirror annotation = ClassDescription.getAnnotation(source, annotationType);
        if (annotation == null) {
            return null;
        }
        Map result = CollectionFactory.newMap();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> pair : annotation.getElementValues().entrySet()) {
            result.put(pair.getKey().getSimpleName().toString(), pair.getValue().getValue().toString());
        }
        return result;
    }
}

